/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.panel;

import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.layout.VerticalFlowLayout;
import de.oliver_matuschin.ttd.application.TaskTillDawnApplicationContext;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import de.oliver_matuschin.ttd.scheduler.task.trigger.ApplicationStartedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.GraphicsDevicesAddedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.GraphicsDevicesChangedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.GraphicsDevicesRemovedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.ScreenAboutToSleepTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.ScreenAwokeTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.SystemAwokeTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.SystemLockedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.SystemUnlockedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.TaskExecutionCanceledTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.TaskExecutionStartedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.TaskExecutionStoppedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.TaskTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.UserSessionActivatedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.UserSessionDeactivatedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.VolumesMountedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.VolumesUnmountedTrigger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TriggerConfigurationPanel {
    private JCheckBox onTriggeredByOtherTaskButton;
    private JCheckBox onApplicationStartupButton;
    private JCheckBox onTaskExecutionStartedButton;
    private JCheckBox onTaskExecutionCanceledButton;
    private JCheckBox onTaskExecutionStoppedButton;
    private JCheckBox onSystemWakeButton;
    private JCheckBox onUserSessionDeactivatedButton;
    private JCheckBox onUserSessionActivatedButton;
    private JCheckBox onScreenSleepButton;
    private JCheckBox onScreenWakeButton;
    private JCheckBox onSystemLockedButton;
    private JCheckBox onSystemUnlockedButton;
    private JCheckBox onVolumeMountedButton;
    private JCheckBox onVolumeUnmountedButton;
    private JCheckBox onGraphicsDevicesAddedButton;
    private JCheckBox onGraphicsDevicesChangedButton;
    private JCheckBox onGraphicsDevicesRemovedButton;
    private JPanel mainPanel;
    private TaskTillDawnApplicationContext applicationContext;
    private Task task;

    public TriggerConfigurationPanel(TaskTillDawnApplicationContext taskTillDawnApplicationContext, Task task) {
        this.applicationContext = taskTillDawnApplicationContext;
        this.task = task;
        this.initUI();
    }

    public boolean validate() {
        return true;
    }

    public boolean isOnApplicationStartupSelected() {
        return this.onApplicationStartupButton != null && this.onApplicationStartupButton.isSelected();
    }

    public boolean isOnTriggeredByOtherTaskSelected() {
        return this.onTriggeredByOtherTaskButton != null && this.onTriggeredByOtherTaskButton.isSelected();
    }

    public boolean isOnTaskExecutionStartedSelected() {
        return this.onTaskExecutionStartedButton != null && this.onTaskExecutionStartedButton.isSelected();
    }

    public boolean isOnTaskExecutionCanceledSelected() {
        return this.onTaskExecutionCanceledButton != null && this.onTaskExecutionCanceledButton.isSelected();
    }

    public boolean isOnTaskExecutionStoppedSelected() {
        return this.onTaskExecutionStoppedButton != null && this.onTaskExecutionStoppedButton.isSelected();
    }

    public boolean isOnSystemWakeSelected() {
        return this.onSystemWakeButton != null && this.onSystemWakeButton.isSelected();
    }

    public boolean isOnUserSessionDeactivatedSelected() {
        return this.onUserSessionDeactivatedButton != null && this.onUserSessionDeactivatedButton.isSelected();
    }

    public boolean isOnUserSessionActivatedSelected() {
        return this.onUserSessionActivatedButton != null && this.onUserSessionActivatedButton.isSelected();
    }

    public boolean isOnScreenSleepSelected() {
        return this.onScreenSleepButton != null && this.onScreenSleepButton.isSelected();
    }

    public boolean isOnScreenWakeSelected() {
        return this.onScreenWakeButton != null && this.onScreenWakeButton.isSelected();
    }

    public boolean isOnSystemLockedSelected() {
        return this.onSystemLockedButton != null && this.onSystemLockedButton.isSelected();
    }

    public boolean isOnSystemUnlockedSelected() {
        return this.onSystemUnlockedButton != null && this.onSystemUnlockedButton.isSelected();
    }

    public boolean isOnVolumeMountedSelected() {
        return this.onVolumeMountedButton != null && this.onVolumeMountedButton.isSelected();
    }

    public boolean isOnVolumeUnmountedSelected() {
        return this.onVolumeUnmountedButton != null && this.onVolumeUnmountedButton.isSelected();
    }

    public boolean isOnGraphicsDevicesAddedSelected() {
        return this.onGraphicsDevicesAddedButton != null && this.onGraphicsDevicesAddedButton.isSelected();
    }

    public boolean isOnGraphicsDevicesChangedSelected() {
        return this.onGraphicsDevicesChangedButton != null && this.onGraphicsDevicesChangedButton.isSelected();
    }

    public boolean isOnGraphicsDevicesRemovedSelected() {
        return this.onGraphicsDevicesRemovedButton != null && this.onGraphicsDevicesRemovedButton.isSelected();
    }

    public Component getComponent() {
        return this.mainPanel;
    }

    private void initUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setOpaque(false);
        this.addTriggerOptions();
    }

    private String getLocalizedString(String string) {
        return this.applicationContext.getLocalizationProvider().getLocalizedString(string);
    }

    private AbstractSchedule getScheduleForType(Class<? extends AbstractSchedule> clazz) {
        for (AbstractSchedule abstractSchedule : this.task.getSchedules()) {
            if (abstractSchedule.getClass() != clazz) continue;
            return abstractSchedule;
        }
        return null;
    }

    private void addTriggerOptions() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        ApplicationStartedTrigger applicationStartedTrigger = (ApplicationStartedTrigger)this.getScheduleForType(ApplicationStartedTrigger.class);
        TaskTrigger taskTrigger = (TaskTrigger)this.getScheduleForType(TaskTrigger.class);
        TaskExecutionStartedTrigger taskExecutionStartedTrigger = (TaskExecutionStartedTrigger)this.getScheduleForType(TaskExecutionStartedTrigger.class);
        TaskExecutionCanceledTrigger taskExecutionCanceledTrigger = (TaskExecutionCanceledTrigger)this.getScheduleForType(TaskExecutionCanceledTrigger.class);
        TaskExecutionStoppedTrigger taskExecutionStoppedTrigger = (TaskExecutionStoppedTrigger)this.getScheduleForType(TaskExecutionStoppedTrigger.class);
        SystemAwokeTrigger systemAwokeTrigger = (SystemAwokeTrigger)this.getScheduleForType(SystemAwokeTrigger.class);
        UserSessionDeactivatedTrigger userSessionDeactivatedTrigger = (UserSessionDeactivatedTrigger)this.getScheduleForType(UserSessionDeactivatedTrigger.class);
        UserSessionActivatedTrigger userSessionActivatedTrigger = (UserSessionActivatedTrigger)this.getScheduleForType(UserSessionActivatedTrigger.class);
        ScreenAboutToSleepTrigger screenAboutToSleepTrigger = (ScreenAboutToSleepTrigger)this.getScheduleForType(ScreenAboutToSleepTrigger.class);
        ScreenAwokeTrigger screenAwokeTrigger = (ScreenAwokeTrigger)this.getScheduleForType(ScreenAwokeTrigger.class);
        SystemLockedTrigger systemLockedTrigger = (SystemLockedTrigger)this.getScheduleForType(SystemLockedTrigger.class);
        SystemUnlockedTrigger systemUnlockedTrigger = (SystemUnlockedTrigger)this.getScheduleForType(SystemUnlockedTrigger.class);
        VolumesMountedTrigger volumesMountedTrigger = (VolumesMountedTrigger)this.getScheduleForType(VolumesMountedTrigger.class);
        VolumesUnmountedTrigger volumesUnmountedTrigger = (VolumesUnmountedTrigger)this.getScheduleForType(VolumesUnmountedTrigger.class);
        GraphicsDevicesAddedTrigger graphicsDevicesAddedTrigger = (GraphicsDevicesAddedTrigger)this.getScheduleForType(GraphicsDevicesAddedTrigger.class);
        GraphicsDevicesChangedTrigger graphicsDevicesChangedTrigger = (GraphicsDevicesChangedTrigger)this.getScheduleForType(GraphicsDevicesChangedTrigger.class);
        GraphicsDevicesRemovedTrigger graphicsDevicesRemovedTrigger = (GraphicsDevicesRemovedTrigger)this.getScheduleForType(GraphicsDevicesRemovedTrigger.class);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(this.getLocalizedString("window.TaskConfigurationFrame.message.triggerConfiguration"));
        jTextArea.setHighlighter(null);
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setFont(this.applicationContext.getUIManager().getFont(UIManager.FontSize.DEFAULT));
        jTextArea.setBorder(BorderFactory.createEmptyBorder(this.applicationContext.getUIManager().getPixelsForDots(10), this.applicationContext.getUIManager().getPixelsForDots(25), this.applicationContext.getUIManager().getPixelsForDots(15), this.applicationContext.getUIManager().getPixelsForDots(25)));
        this.mainPanel.add((Component)jTextArea, "North");
        JPanel jPanel6 = new JPanel((LayoutManager)new VerticalFlowLayout());
        jPanel6.setOpaque(false);
        jPanel6.setBorder(BorderFactory.createEmptyBorder(this.applicationContext.getUIManager().getPixelsForDots(0), this.applicationContext.getUIManager().getPixelsForDots(20), this.applicationContext.getUIManager().getPixelsForDots(0), this.applicationContext.getUIManager().getPixelsForDots(20)));
        ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(ApplicationStartedTrigger.class)) {
            jPanel5 = new JPanel(new FlowLayout(3));
            jPanel5.setOpaque(false);
            this.onApplicationStartupButton = new JCheckBox(this.getLocalizedString("trigger.ApplicationStartedTrigger.title"));
            this.onApplicationStartupButton.setOpaque(false);
            this.onApplicationStartupButton.setSelected(applicationStartedTrigger != null);
            jPanel5.add(this.onApplicationStartupButton);
            arrayList.add(jPanel5);
        }
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(SystemAwokeTrigger.class)) {
            jPanel5 = new JPanel(new FlowLayout(3));
            jPanel5.setOpaque(false);
            this.onSystemWakeButton = new JCheckBox(this.getLocalizedString("trigger.SystemAwokeTrigger.title"));
            this.onSystemWakeButton.setOpaque(false);
            this.onSystemWakeButton.setSelected(systemAwokeTrigger != null);
            jPanel5.add(this.onSystemWakeButton);
            arrayList.add(jPanel5);
        }
        jPanel5 = this.createGroupPanel(this.getLocalizedString("panel.TriggerConfigurationPanel.group.system"), ImageBuilder.buildFor((String)"/resources/images/triggerGroups/trigger_group_system.png"), arrayList);
        jPanel6.add(jPanel5);
        arrayList.clear();
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(ScreenAwokeTrigger.class)) {
            jPanel4 = new JPanel(new FlowLayout(3));
            jPanel4.setOpaque(false);
            this.onScreenWakeButton = new JCheckBox(this.getLocalizedString("trigger.ScreenAwokeTrigger.title"));
            this.onScreenWakeButton.setOpaque(false);
            this.onScreenWakeButton.setSelected(screenAwokeTrigger != null);
            jPanel4.add(this.onScreenWakeButton);
            arrayList.add(jPanel4);
        }
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(ScreenAboutToSleepTrigger.class)) {
            jPanel4 = new JPanel(new FlowLayout(3));
            jPanel4.setOpaque(false);
            this.onScreenSleepButton = new JCheckBox(this.getLocalizedString("trigger.ScreenAboutToSleepTrigger.title"));
            this.onScreenSleepButton.setOpaque(false);
            this.onScreenSleepButton.setSelected(screenAboutToSleepTrigger != null);
            jPanel4.add(this.onScreenSleepButton);
            arrayList.add(jPanel4);
        }
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(GraphicsDevicesAddedTrigger.class)) {
            jPanel4 = new JPanel(new FlowLayout(3));
            jPanel4.setOpaque(false);
            this.onGraphicsDevicesAddedButton = new JCheckBox(this.getLocalizedString("trigger.GraphicsDevicesAddedTrigger.title"));
            this.onGraphicsDevicesAddedButton.setOpaque(false);
            this.onGraphicsDevicesAddedButton.setSelected(graphicsDevicesAddedTrigger != null);
            jPanel4.add(this.onGraphicsDevicesAddedButton);
            arrayList.add(jPanel4);
        }
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(GraphicsDevicesChangedTrigger.class)) {
            jPanel4 = new JPanel(new FlowLayout(3));
            jPanel4.setOpaque(false);
            this.onGraphicsDevicesChangedButton = new JCheckBox(this.getLocalizedString("trigger.GraphicsDevicesChangedTrigger.title"));
            this.onGraphicsDevicesChangedButton.setOpaque(false);
            this.onGraphicsDevicesChangedButton.setSelected(graphicsDevicesChangedTrigger != null);
            jPanel4.add(this.onGraphicsDevicesChangedButton);
            arrayList.add(jPanel4);
        }
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(GraphicsDevicesRemovedTrigger.class)) {
            jPanel4 = new JPanel(new FlowLayout(3));
            jPanel4.setOpaque(false);
            this.onGraphicsDevicesRemovedButton = new JCheckBox(this.getLocalizedString("trigger.GraphicsDevicesRemovedTrigger.title"));
            this.onGraphicsDevicesRemovedButton.setOpaque(false);
            this.onGraphicsDevicesRemovedButton.setSelected(graphicsDevicesRemovedTrigger != null);
            jPanel4.add(this.onGraphicsDevicesRemovedButton);
            arrayList.add(jPanel4);
        }
        jPanel4 = this.createGroupPanel(this.getLocalizedString("panel.TriggerConfigurationPanel.group.screens"), ImageBuilder.buildFor((String)"/resources/images/triggerGroups/trigger_group_screens.png"), arrayList);
        jPanel6.add(jPanel4);
        arrayList.clear();
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(VolumesMountedTrigger.class)) {
            jPanel3 = new JPanel(new FlowLayout(3));
            jPanel3.setOpaque(false);
            this.onVolumeMountedButton = new JCheckBox(this.getLocalizedString("trigger.VolumesMountedTrigger.title"));
            this.onVolumeMountedButton.setOpaque(false);
            this.onVolumeMountedButton.setSelected(volumesMountedTrigger != null);
            jPanel3.add(this.onVolumeMountedButton);
            arrayList.add(jPanel3);
        }
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(VolumesUnmountedTrigger.class)) {
            jPanel3 = new JPanel(new FlowLayout(3));
            jPanel3.setOpaque(false);
            this.onVolumeUnmountedButton = new JCheckBox(this.getLocalizedString("trigger.VolumesUnmountedTrigger.title"));
            this.onVolumeUnmountedButton.setOpaque(false);
            this.onVolumeUnmountedButton.setSelected(volumesUnmountedTrigger != null);
            jPanel3.add(this.onVolumeUnmountedButton);
            arrayList.add(jPanel3);
        }
        jPanel3 = this.createGroupPanel(this.getLocalizedString("panel.TriggerConfigurationPanel.group.volumesAndDrives"), ImageBuilder.buildFor((String)"/resources/images/triggerGroups/trigger_group_volumes_and_drives.png"), arrayList);
        jPanel6.add(jPanel3);
        arrayList.clear();
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(TaskTrigger.class)) {
            jPanel2 = new JPanel(new FlowLayout(3));
            jPanel2.setOpaque(false);
            this.onTriggeredByOtherTaskButton = new JCheckBox(this.getLocalizedString("trigger.TaskTrigger.title"));
            this.onTriggeredByOtherTaskButton.setOpaque(false);
            this.onTriggeredByOtherTaskButton.setSelected(taskTrigger != null);
            jPanel2.add(this.onTriggeredByOtherTaskButton);
            arrayList.add(jPanel2);
        }
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(TaskExecutionStartedTrigger.class)) {
            jPanel2 = new JPanel(new FlowLayout(3));
            jPanel2.setOpaque(false);
            this.onTaskExecutionStartedButton = new JCheckBox(this.getLocalizedString("trigger.TaskExecutionStartedTrigger.title"));
            this.onTaskExecutionStartedButton.setOpaque(false);
            this.onTaskExecutionStartedButton.setSelected(taskExecutionStartedTrigger != null);
            jPanel2.add(this.onTaskExecutionStartedButton);
            arrayList.add(jPanel2);
        }
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(TaskExecutionCanceledTrigger.class)) {
            jPanel2 = new JPanel(new FlowLayout(3));
            jPanel2.setOpaque(false);
            this.onTaskExecutionCanceledButton = new JCheckBox(this.getLocalizedString("trigger.TaskExecutionCanceledTrigger.title"));
            this.onTaskExecutionCanceledButton.setOpaque(false);
            this.onTaskExecutionCanceledButton.setSelected(taskExecutionCanceledTrigger != null);
            jPanel2.add(this.onTaskExecutionCanceledButton);
            arrayList.add(jPanel2);
        }
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(TaskExecutionStoppedTrigger.class)) {
            jPanel2 = new JPanel(new FlowLayout(3));
            jPanel2.setOpaque(false);
            this.onTaskExecutionStoppedButton = new JCheckBox(this.getLocalizedString("trigger.TaskExecutionStoppedTrigger.title"));
            this.onTaskExecutionStoppedButton.setOpaque(false);
            this.onTaskExecutionStoppedButton.setSelected(taskExecutionStoppedTrigger != null);
            jPanel2.add(this.onTaskExecutionStoppedButton);
            arrayList.add(jPanel2);
        }
        jPanel2 = this.createGroupPanel(this.getLocalizedString("panel.TriggerConfigurationPanel.group.tasks"), ImageBuilder.buildFor((String)"/resources/images/triggerGroups/trigger_group_tasks.png"), arrayList);
        jPanel6.add(jPanel2);
        arrayList.clear();
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(UserSessionDeactivatedTrigger.class)) {
            jPanel = new JPanel(new FlowLayout(3));
            jPanel.setOpaque(false);
            this.onUserSessionDeactivatedButton = new JCheckBox(this.getLocalizedString("trigger.UserSessionDeactivatedTrigger.title"));
            this.onUserSessionDeactivatedButton.setOpaque(false);
            this.onUserSessionDeactivatedButton.setSelected(userSessionDeactivatedTrigger != null);
            jPanel.add(this.onUserSessionDeactivatedButton);
            arrayList.add(jPanel);
        }
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(UserSessionActivatedTrigger.class)) {
            jPanel = new JPanel(new FlowLayout(3));
            jPanel.setOpaque(false);
            this.onUserSessionActivatedButton = new JCheckBox(this.getLocalizedString("trigger.UserSessionActivatedTrigger.title"));
            this.onUserSessionActivatedButton.setOpaque(false);
            this.onUserSessionActivatedButton.setSelected(userSessionActivatedTrigger != null);
            jPanel.add(this.onUserSessionActivatedButton);
            arrayList.add(jPanel);
        }
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(SystemLockedTrigger.class)) {
            jPanel = new JPanel(new FlowLayout(3));
            jPanel.setOpaque(false);
            this.onSystemLockedButton = new JCheckBox(this.getLocalizedString("trigger.SystemLockedTrigger.title"));
            this.onSystemLockedButton.setOpaque(false);
            this.onSystemLockedButton.setSelected(systemLockedTrigger != null);
            jPanel.add(this.onSystemLockedButton);
            arrayList.add(jPanel);
        }
        if (this.applicationContext.getTriggerEventManager().canHandleEvent(SystemUnlockedTrigger.class)) {
            jPanel = new JPanel(new FlowLayout(3));
            jPanel.setOpaque(false);
            this.onSystemUnlockedButton = new JCheckBox(this.getLocalizedString("trigger.SystemUnlockedTrigger.title"));
            this.onSystemUnlockedButton.setOpaque(false);
            this.onSystemUnlockedButton.setSelected(systemUnlockedTrigger != null);
            jPanel.add(this.onSystemUnlockedButton);
            arrayList.add(jPanel);
        }
        jPanel = this.createGroupPanel(this.getLocalizedString("panel.TriggerConfigurationPanel.group.sessions"), ImageBuilder.buildFor((String)"/resources/images/triggerGroups/trigger_group_sessions.png"), arrayList);
        jPanel6.add(jPanel);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setBorder(null);
        jScrollPane.getViewport().add(jPanel6);
        jScrollPane.getViewport().addChangeListener(changeEvent -> {
            if (jScrollPane.getVerticalScrollBar().isVisible()) {
                if (jScrollPane.getVerticalScrollBar().getValue() <= 2) {
                    jScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
                } else if (jScrollPane.getVerticalScrollBar().getValue() >= jScrollPane.getVerticalScrollBar().getMaximum() - jScrollPane.getVerticalScrollBar().getModel().getExtent() - 2) {
                    jScrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
                } else {
                    jScrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.LIGHT_GRAY));
                }
            } else if (jScrollPane.getBorder() != null) {
                jScrollPane.setBorder(null);
            }
        });
        this.mainPanel.add((Component)jScrollPane, "Center");
    }

    private JPanel createGroupPanel(String string, Icon icon, List<JPanel> list) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(this.applicationContext.getUIManager().getPixelsForDots(0), this.applicationContext.getUIManager().getPixelsForDots(0), this.applicationContext.getUIManager().getPixelsForDots(20), this.applicationContext.getUIManager().getPixelsForDots(0)));
        JLabel jLabel = new JLabel(string);
        jLabel.setIcon(icon);
        jLabel.setBorder(BorderFactory.createEmptyBorder(this.applicationContext.getUIManager().getPixelsForDots(5), this.applicationContext.getUIManager().getPixelsForDots(5), this.applicationContext.getUIManager().getPixelsForDots(10), this.applicationContext.getUIManager().getPixelsForDots(5)));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setOpaque(true);
        jPanel.add((Component)jPanel2, "Center");
        for (JPanel jPanel3 : list) {
            jPanel2.add(jPanel3);
        }
        return jPanel;
    }
}

