/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.panel;

import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.ui.dialog.JExtendedDialog;
import de.oliver_matuschin.base.ui.layout.VerticalFlowLayout;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;

public class TaskMetadataConfigurationPanel {
    private JTextField taskNameTextField;
    private JTextPane taskDescriptionTextPane;
    private JCheckBox taskEnabledButton;
    private JCheckBox limitTaskExecutionsButton;
    private JCheckBox disableNotificationsButton;
    private JTextField maximumExecutionCountTextField;
    private JRadioButton deleteAfterMaxExecButton;
    private JRadioButton disableAfterMaxExecButton;
    private ApplicationContext<?> applicationContext;
    private Task task;
    private TaskMetadata taskMetadata;
    private JPanel mainPanel;
    private JPanel contentPanel;
    private JFrame parent;
    private boolean editMode;
    private KeyListener keyListener;

    public TaskMetadataConfigurationPanel(JFrame jFrame, boolean bl, ApplicationContext<?> applicationContext, Task task, TaskMetadata taskMetadata) {
        this.parent = jFrame;
        this.editMode = bl;
        this.applicationContext = applicationContext;
        this.task = task;
        this.taskMetadata = taskMetadata;
        this.initUI();
        this.addActionListeners();
        this.checkFormularFields();
    }

    public void setEditMode(boolean bl) {
        if (this.editMode != bl) {
            if (bl) {
                this.taskNameTextField.addKeyListener(this.keyListener);
            } else {
                this.taskNameTextField.removeKeyListener(this.keyListener);
            }
        }
    }

    public boolean validate(TaskMetadata taskMetadata) {
        if (this.taskNameTextField.getText().trim().equals("")) {
            JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.error"), (Object)this.getLocalizedString("window.TaskConfigurationFrame.message.pleaseSpecifyANameForTheTask"), 0);
            jExtendedDialog.showDialog((Component)this.parent);
            this.taskNameTextField.requestFocus();
            return false;
        }
        if (this.limitTaskExecutionsButton.isSelected()) {
            try {
                if (new BigInteger(this.maximumExecutionCountTextField.getText()).compareTo(BigInteger.ZERO) <= 0) {
                    JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.error"), (Object)this.getLocalizedString("window.TaskConfigurationFrame.message.specifiedMaximumExecutionCountMustBeLargerThanZero"), 0);
                    jExtendedDialog.showDialog((Component)this.parent);
                    this.maximumExecutionCountTextField.requestFocus();
                    return false;
                }
                if (taskMetadata != null && taskMetadata.getSuccessfulExecutionCount().compareTo(new BigInteger(this.maximumExecutionCountTextField.getText())) >= 0) {
                    JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.error"), (Object)this.getLocalizedString("window.TaskConfigurationFrame.message.specifiedMaximumExecutionCountTooLow", String.valueOf(taskMetadata.getSuccessfulExecutionCount().add(BigInteger.ONE))), 0);
                    jExtendedDialog.showDialog((Component)this.parent);
                    this.maximumExecutionCountTextField.requestFocus();
                    return false;
                }
            }
            catch (Exception exception) {
                JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.error"), (Object)this.getLocalizedString("window.TaskConfigurationFrame.message.maximumExecutionCountMustBeANumberLargerThanZero"), 0);
                jExtendedDialog.showDialog((Component)this.parent);
                this.maximumExecutionCountTextField.requestFocus();
                return false;
            }
        }
        return true;
    }

    public String getTaskName() {
        return this.taskNameTextField.getText().trim();
    }

    public String getTaskDescription() {
        return this.taskDescriptionTextPane.getText().trim();
    }

    public boolean isTaskEnabled() {
        return this.taskEnabledButton.isSelected();
    }

    public boolean isNotificationsDisabled() {
        return this.disableNotificationsButton.isSelected();
    }

    public BigInteger getMaximumExecutionCount() {
        if (this.limitTaskExecutionsButton.isSelected()) {
            return new BigInteger(this.maximumExecutionCountTextField.getText());
        }
        return BigInteger.ZERO;
    }

    public boolean isDeleteAfterMaximumExecutionsReached() {
        if (this.limitTaskExecutionsButton.isSelected()) {
            return this.deleteAfterMaxExecButton.isSelected();
        }
        return false;
    }

    public Component getComponent() {
        return this.mainPanel;
    }

    public void setTaskNameFocused() {
        this.taskNameTextField.requestFocus();
    }

    private void initUI() {
        this.mainPanel = new JPanel(new FlowLayout(3));
        this.mainPanel.setOpaque(false);
        this.contentPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.contentPanel.setOpaque(false);
        this.addTaskNameInput();
        this.addTaskDescriptionInput();
        this.addTaskEnabledCheckbox();
        this.addTaskRemovalOptions();
        this.addNotificationOptions();
        this.mainPanel.add(this.contentPanel);
    }

    private void addActionListeners() {
        this.parent.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                TaskMetadataConfigurationPanel.this.setTaskNameFocused();
            }
        });
        this.keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                this.updateTitle();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                this.updateTitle();
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                this.updateTitle();
            }

            private void updateTitle() {
                TaskMetadataConfigurationPanel.this.parent.setTitle(TaskMetadataConfigurationPanel.this.getLocalizedString("window.TaskConfigurationFrame.title.edit", new Object[]{TaskMetadataConfigurationPanel.this.taskNameTextField.getText()}));
            }
        };
        if (this.editMode) {
            this.taskNameTextField.addKeyListener(this.keyListener);
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskMetadataConfigurationPanel.this.checkFormularFields();
            }
        };
        this.limitTaskExecutionsButton.addActionListener(actionListener);
        this.deleteAfterMaxExecButton.addActionListener(actionListener);
    }

    private void checkFormularFields() {
        if (this.limitTaskExecutionsButton.isSelected()) {
            this.deleteAfterMaxExecButton.setEnabled(true);
            this.disableAfterMaxExecButton.setEnabled(true);
            this.maximumExecutionCountTextField.setEnabled(true);
        } else {
            this.deleteAfterMaxExecButton.setEnabled(false);
            this.disableAfterMaxExecButton.setEnabled(false);
            this.maximumExecutionCountTextField.setEnabled(false);
        }
    }

    private String getLocalizedString(String string) {
        return this.applicationContext.getLocalizationProvider().getLocalizedString(string);
    }

    private String getLocalizedString(String string, Object ... objectArray) {
        return this.applicationContext.getLocalizationProvider().getLocalizedString(string, objectArray);
    }

    private void addTaskNameInput() {
        this.taskNameTextField = new JTextField(this.task.getName());
        this.taskNameTextField.setPreferredSize(new Dimension(this.applicationContext.getUIManager().getPixelsForDots(600), (int)this.taskNameTextField.getPreferredSize().getHeight()));
        this.contentPanel.add(new JLabel(this.applicationContext.getLocalizationProvider().getLocalizedString("window.TaskConfigurationFrame.label.taskName")));
        if (this.applicationContext.getApplication().getPlatform() == Platform.MACOS) {
            JPanel jPanel = new JPanel(new FlowLayout(3));
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(this.taskNameTextField);
            this.contentPanel.add(jPanel);
        } else {
            this.contentPanel.add(this.taskNameTextField);
        }
    }

    private void addTaskDescriptionInput() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        JTextField jTextField = new JTextField("");
        this.taskDescriptionTextPane = new JTextPane();
        this.taskDescriptionTextPane.setFont(jTextField.getFont());
        this.taskDescriptionTextPane.setText(this.task.getDescription());
        jScrollPane.getViewport().add(this.taskDescriptionTextPane);
        this.contentPanel.add(new JLabel(this.applicationContext.getLocalizationProvider().getLocalizedString("window.TaskConfigurationFrame.label.taskDescription")));
        if (this.applicationContext.getApplication().getPlatform() == Platform.MACOS) {
            this.taskDescriptionTextPane.setMargin(new Insets(jTextField.getInsets().top / 2 - 1, jTextField.getInsets().left / 2 - 1, jTextField.getInsets().bottom / 2 - -1, jTextField.getInsets().right / 2 - 1));
            jScrollPane.setPreferredSize(new Dimension(this.applicationContext.getUIManager().getPixelsForDots(594), this.applicationContext.getUIManager().getPixelsForDots(100)));
            JPanel jPanel = new JPanel(new FlowLayout(3));
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
            jPanel.add(jScrollPane);
            this.contentPanel.add(jPanel);
        } else {
            this.taskDescriptionTextPane.setMargin(jTextField.getInsets());
            jScrollPane.setPreferredSize(new Dimension(this.applicationContext.getUIManager().getPixelsForDots(600), this.applicationContext.getUIManager().getPixelsForDots(100)));
            this.contentPanel.add(jScrollPane);
        }
    }

    private void addTaskEnabledCheckbox() {
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.setOpaque(false);
        this.taskEnabledButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.taskEnabled"));
        this.taskEnabledButton.setOpaque(false);
        this.taskEnabledButton.setSelected(this.taskMetadata != null && this.taskMetadata.isTaskEnabled());
        jPanel.add(this.taskEnabledButton);
        this.contentPanel.add(jPanel);
    }

    private void addTaskRemovalOptions() {
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.setOpaque(false);
        this.limitTaskExecutionsButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.limitTaskExecution"));
        this.limitTaskExecutionsButton.setOpaque(false);
        this.limitTaskExecutionsButton.setSelected(this.task.getMaximumExecutionCount().compareTo(BigInteger.ZERO) > 0);
        jPanel.add(this.limitTaskExecutionsButton);
        this.maximumExecutionCountTextField = new JTextField(String.valueOf(this.task.getMaximumExecutionCount().compareTo(BigInteger.ZERO) > 0 ? this.task.getMaximumExecutionCount() : this.taskMetadata.getSuccessfulExecutionCount().add(BigInteger.ONE)));
        jPanel.add(this.maximumExecutionCountTextField);
        this.maximumExecutionCountTextField.setBackground(Color.WHITE);
        this.maximumExecutionCountTextField.setPreferredSize(new Dimension(this.applicationContext.getUIManager().getPixelsForDots(50), (int)this.maximumExecutionCountTextField.getPreferredSize().getHeight()));
        this.deleteAfterMaxExecButton = new JRadioButton(this.getLocalizedString("window.TaskConfigurationFrame.button.deleteWhenMaximumSuccessfulExecutionsReached"));
        this.deleteAfterMaxExecButton.setOpaque(false);
        this.disableAfterMaxExecButton = new JRadioButton(this.getLocalizedString("window.TaskConfigurationFrame.button.disableWhenMaximumSuccessfulExecutionsReached"));
        this.disableAfterMaxExecButton.setOpaque(false);
        if (this.limitTaskExecutionsButton.isSelected()) {
            this.deleteAfterMaxExecButton.setSelected(this.task.isDeleteAfterMaximumExecutionsReached());
            this.disableAfterMaxExecButton.setSelected(!this.task.isDeleteAfterMaximumExecutionsReached());
        } else {
            this.disableAfterMaxExecButton.setSelected(true);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.deleteAfterMaxExecButton);
        buttonGroup.add(this.disableAfterMaxExecButton);
        Insets insets = UIManager.getInsets("RadioButton.margin");
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this.deleteAfterMaxExecButton.setMargin(new Insets(insets2.top, 30, insets2.bottom, insets2.right));
        this.disableAfterMaxExecButton.setMargin(new Insets(insets2.top, 30, insets2.bottom, insets2.right));
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.setOpaque(false);
        JPanel jPanel3 = new JPanel(new FlowLayout(3));
        jPanel3.setOpaque(false);
        jPanel2.add(this.deleteAfterMaxExecButton);
        jPanel3.add(this.disableAfterMaxExecButton);
        this.contentPanel.add(jPanel);
        this.contentPanel.add(jPanel2);
        this.contentPanel.add(jPanel3);
    }

    private void addNotificationOptions() {
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.setOpaque(false);
        this.disableNotificationsButton = new JCheckBox(this.getLocalizedString("panel.TaskMetadataConfigurationPanel.button.disableNotifications"));
        this.disableNotificationsButton.setOpaque(false);
        this.disableNotificationsButton.setSelected(this.taskMetadata != null && this.taskMetadata.isNotificationsDisabled());
        jPanel.add(this.disableNotificationsButton);
        this.contentPanel.add(jPanel);
    }
}

