/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.panel;

import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.ui.dialog.JExtendedDialog;
import de.oliver_matuschin.base.ui.layout.VerticalFlowLayout;
import de.oliver_matuschin.base.util.UIUtil;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractRestrictedTimeSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.IntervalSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.TimeSchedule;
import de.oliver_matuschin.ttd.util.ui.JPanelUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;

public class ScheduleConfigurationPanel {
    private JRadioButton intervalButton;
    private JRadioButton timeButton;
    private JRadioButton taskManualExecutionButton;
    private JCheckBox intervalLimitationButton;
    private JCheckBox scheduleValidFromButton;
    private JCheckBox scheduleValidUntilButton;
    private JTextField taskIntervalTextField;
    private JLabel taskIntervalBetween1Label;
    private JLabel taskIntervalBetween2Label;
    private JLabel taskIntervalBetween3Label;
    private JLabel dayOfMonthLabel;
    private JComboBox<String> intervalFactorComboBox;
    private JComboBox<String> timeFrameDayOfMonthComboBox;
    private JCheckBox mondayButton;
    private JCheckBox tuesdayButton;
    private JCheckBox wednesdayButton;
    private JCheckBox thursdayButton;
    private JCheckBox fridayButton;
    private JCheckBox saturdayButton;
    private JCheckBox sundayButton;
    private JCheckBox skipIfMissedButton;
    private JCheckBox executionTimeFrameButton;
    private JRadioButton timeFrameWeekdaysButton;
    private JRadioButton timeFrameDayOfMonthButton;
    private JSpinner taskTimeSpinner;
    private JSpinner taskIntervalBetweenStartSpinner;
    private JSpinner taskIntervalBetweenEndSpinner;
    private JSpinner scheduleValidFromSpinner;
    private JSpinner scheduleValidUntilSpinner;
    private JPanel mainPanel;
    private JFrame parent;
    private ApplicationContext<?> applicationContext;
    private Task task;

    public ScheduleConfigurationPanel(JFrame jFrame, ApplicationContext<?> applicationContext, Task task) {
        this.parent = jFrame;
        this.applicationContext = applicationContext;
        this.task = task;
        this.initUI();
        this.addActionListeners();
        this.checkFormularFields();
    }

    public boolean validate() {
        Date date;
        Date date2;
        if (this.isIntervalScheduleSelected()) {
            try {
                int n = Integer.valueOf(this.taskIntervalTextField.getText());
                if (n < 1) {
                    JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.error"), (Object)this.getLocalizedString("window.TaskConfigurationFrame.message.intervalMustBeLargerThanZero"), 0);
                    jExtendedDialog.showDialog((Component)this.parent);
                    this.taskIntervalTextField.requestFocus();
                    return false;
                }
                if (this.executionTimeFrameButton.isSelected() && (n *= this.getIntervalFactor()) > 86340) {
                    JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.error"), (Object)this.getLocalizedString("window.TaskConfigurationFrame.message.intervalNotPossibleWithTimeFrame"), 0);
                    jExtendedDialog.showDialog((Component)this.parent);
                    return false;
                }
            }
            catch (Exception exception) {
                JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.error"), (Object)this.getLocalizedString("window.TaskConfigurationFrame.message.wrongIntervalFormat"), 0);
                jExtendedDialog.showDialog((Component)this.parent);
                this.taskIntervalTextField.requestFocus();
                return false;
            }
        }
        if (this.scheduleValidFromButton.isEnabled() && this.scheduleValidFromButton.isSelected() && this.scheduleValidUntilButton.isEnabled() && this.scheduleValidUntilButton.isSelected() && ((date2 = this.getScheduleValidFrom()).after(date = this.getScheduleValidUntil()) || date2.equals(date))) {
            JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.error"), (Object)this.getLocalizedString("window.TaskConfigurationFrame.message.fromMustBeBeforeUntil"), 0);
            jExtendedDialog.showDialog((Component)this.parent);
            return false;
        }
        return true;
    }

    public boolean isIntervalScheduleSelected() {
        return this.intervalButton.isSelected();
    }

    public boolean isTimeScheduleSelected() {
        return this.timeButton.isSelected();
    }

    public boolean isSkipIfMissedSelected() {
        return this.skipIfMissedButton.isSelected();
    }

    public Date getScheduleValidFrom() {
        if (this.scheduleValidFromButton.isSelected()) {
            try {
                this.scheduleValidFromSpinner.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return (Date)this.scheduleValidFromSpinner.getValue();
        }
        return null;
    }

    public Date getScheduleValidUntil() {
        if (this.scheduleValidUntilButton.isSelected()) {
            try {
                this.scheduleValidUntilSpinner.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return (Date)this.scheduleValidUntilSpinner.getValue();
        }
        return null;
    }

    public Date getIntervalLimitationStart() {
        if (this.intervalButton.isSelected() && this.intervalLimitationButton.isSelected()) {
            try {
                this.taskIntervalBetweenStartSpinner.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return (Date)this.taskIntervalBetweenStartSpinner.getValue();
        }
        return null;
    }

    public Date getIntervalLimitationEnd() {
        if (this.intervalButton.isSelected() && this.intervalLimitationButton.isSelected()) {
            try {
                this.taskIntervalBetweenEndSpinner.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return (Date)this.taskIntervalBetweenEndSpinner.getValue();
        }
        return null;
    }

    public int getIntervalInSeconds() {
        int n = Integer.valueOf(this.taskIntervalTextField.getText());
        return n *= this.getIntervalFactor();
    }

    public Date getSpecifiedTime() {
        try {
            this.taskTimeSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return (Date)this.taskTimeSpinner.getValue();
    }

    public int getDayOfMonth() {
        if (this.executionTimeFrameButton.isSelected() && this.timeFrameDayOfMonthButton.isSelected()) {
            return this.timeFrameDayOfMonthComboBox.getSelectedIndex() + 1;
        }
        return 0;
    }

    public int getWeekdays() {
        if (this.executionTimeFrameButton.isSelected()) {
            int n = 0;
            if (this.mondayButton.isSelected()) {
                ++n;
            }
            if (this.tuesdayButton.isSelected()) {
                n += 2;
            }
            if (this.wednesdayButton.isSelected()) {
                n += 4;
            }
            if (this.thursdayButton.isSelected()) {
                n += 8;
            }
            if (this.fridayButton.isSelected()) {
                n += 16;
            }
            if (this.saturdayButton.isSelected()) {
                n += 32;
            }
            if (this.sundayButton.isSelected()) {
                n += 64;
            }
            return n;
        }
        return 127;
    }

    public int getIntervalFactor() {
        switch (this.intervalFactorComboBox.getSelectedIndex()) {
            case 1: {
                return 60;
            }
            case 2: {
                return 3600;
            }
            case 3: {
                return 86400;
            }
        }
        return 1;
    }

    public Component getComponent() {
        return this.mainPanel;
    }

    private void initUI() {
        this.mainPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.mainPanel.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.addExecuteManuallyCheckbox(buttonGroup);
        this.addEmptyPanel();
        this.addTaskIntervalInput(buttonGroup);
        this.addEmptyPanel();
        this.addSpecifyTimeInput(buttonGroup);
        this.addEmptyPanel();
        this.mainPanel.add(new JSeparator());
        this.addEmptyPanel();
        this.addScheduleValidityPeriodOptions();
        this.addTaskSkipIfMissedOption();
        this.addTimeFrameOptions();
    }

    private void addActionListeners() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleConfigurationPanel.this.checkFormularFields();
            }
        };
        this.intervalButton.addActionListener(actionListener);
        this.intervalLimitationButton.addActionListener(actionListener);
        this.timeButton.addActionListener(actionListener);
        this.taskManualExecutionButton.addActionListener(actionListener);
        this.scheduleValidFromButton.addActionListener(actionListener);
        this.scheduleValidUntilButton.addActionListener(actionListener);
        this.executionTimeFrameButton.addActionListener(actionListener);
        this.timeFrameWeekdaysButton.addActionListener(actionListener);
        this.timeFrameDayOfMonthButton.addActionListener(actionListener);
    }

    private void checkFormularFields() {
        if (this.intervalButton.isSelected()) {
            this.taskIntervalTextField.setEnabled(true);
            this.intervalFactorComboBox.setEnabled(true);
            this.taskIntervalBetween1Label.setEnabled(true);
            this.taskIntervalBetween2Label.setEnabled(true);
            this.taskIntervalBetween3Label.setEnabled(true);
            this.intervalLimitationButton.setEnabled(true);
            this.taskIntervalBetweenStartSpinner.setEnabled(this.intervalLimitationButton.isSelected());
            this.taskIntervalBetweenEndSpinner.setEnabled(this.intervalLimitationButton.isSelected());
        } else {
            this.taskIntervalTextField.setEnabled(false);
            this.intervalFactorComboBox.setEnabled(false);
            this.intervalLimitationButton.setEnabled(false);
            this.taskIntervalBetween1Label.setEnabled(false);
            this.taskIntervalBetween2Label.setEnabled(false);
            this.taskIntervalBetween3Label.setEnabled(false);
            this.taskIntervalBetweenStartSpinner.setEnabled(false);
            this.taskIntervalBetweenEndSpinner.setEnabled(false);
        }
        if (this.timeButton.isSelected()) {
            this.taskTimeSpinner.setEnabled(true);
        } else {
            this.taskTimeSpinner.setEnabled(false);
        }
        boolean bl = false;
        if (this.taskManualExecutionButton.isSelected()) {
            this.executionTimeFrameButton.setEnabled(false);
            this.skipIfMissedButton.setEnabled(false);
        } else {
            this.executionTimeFrameButton.setEnabled(true);
            this.skipIfMissedButton.setEnabled(true);
        }
        if (this.executionTimeFrameButton.isSelected() && !this.taskManualExecutionButton.isSelected()) {
            this.timeFrameWeekdaysButton.setEnabled(true);
            this.timeFrameDayOfMonthButton.setEnabled(true);
            this.dayOfMonthLabel.setEnabled(true);
            if (this.timeFrameWeekdaysButton.isSelected()) {
                bl = true;
                this.timeFrameDayOfMonthComboBox.setEnabled(false);
            } else if (this.executionTimeFrameButton.isSelected()) {
                this.timeFrameDayOfMonthComboBox.setEnabled(true);
            }
        } else {
            this.timeFrameWeekdaysButton.setEnabled(false);
            this.timeFrameDayOfMonthButton.setEnabled(false);
            this.timeFrameDayOfMonthComboBox.setEnabled(false);
            this.dayOfMonthLabel.setEnabled(false);
        }
        if (bl) {
            this.mondayButton.setEnabled(true);
            this.tuesdayButton.setEnabled(true);
            this.wednesdayButton.setEnabled(true);
            this.thursdayButton.setEnabled(true);
            this.fridayButton.setEnabled(true);
            this.saturdayButton.setEnabled(true);
            this.sundayButton.setEnabled(true);
        } else {
            this.mondayButton.setEnabled(false);
            this.tuesdayButton.setEnabled(false);
            this.wednesdayButton.setEnabled(false);
            this.thursdayButton.setEnabled(false);
            this.fridayButton.setEnabled(false);
            this.saturdayButton.setEnabled(false);
            this.sundayButton.setEnabled(false);
        }
        this.scheduleValidFromButton.setEnabled(!this.taskManualExecutionButton.isSelected());
        this.scheduleValidUntilButton.setEnabled(!this.taskManualExecutionButton.isSelected());
        this.scheduleValidFromSpinner.setEnabled(this.scheduleValidFromButton.isEnabled() && this.scheduleValidFromButton.isSelected());
        this.scheduleValidUntilSpinner.setEnabled(this.scheduleValidUntilButton.isEnabled() && this.scheduleValidUntilButton.isSelected());
    }

    private String getLocalizedString(String string) {
        return this.applicationContext.getLocalizationProvider().getLocalizedString(string);
    }

    private AbstractSchedule getScheduleForType(Class<? extends AbstractSchedule> clazz) {
        for (AbstractSchedule abstractSchedule : this.task.getSchedules()) {
            if (abstractSchedule.getClass() != clazz) continue;
            return abstractSchedule;
        }
        return null;
    }

    private void addEmptyPanel() {
        JLabel jLabel = new JLabel(" ");
        jLabel.setOpaque(false);
        this.mainPanel.add(jLabel);
    }

    private void addExecuteManuallyCheckbox(ButtonGroup buttonGroup) {
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.setOpaque(false);
        this.taskManualExecutionButton = new JRadioButton(this.getLocalizedString("window.TaskConfigurationFrame.button.executeManually"));
        this.taskManualExecutionButton.setOpaque(false);
        buttonGroup.add(this.taskManualExecutionButton);
        if (this.getScheduleForType(TimeSchedule.class) == null && this.getScheduleForType(IntervalSchedule.class) == null) {
            this.taskManualExecutionButton.setSelected(true);
        }
        jPanel.add(this.taskManualExecutionButton);
        this.mainPanel.add(jPanel);
    }

    private void addTaskIntervalInput(ButtonGroup buttonGroup) {
        Object object;
        boolean bl = false;
        int n = 300;
        boolean bl2 = false;
        Date date = null;
        Date date2 = null;
        AbstractSchedule abstractSchedule = this.getScheduleForType(IntervalSchedule.class);
        if (abstractSchedule != null) {
            object = (IntervalSchedule)abstractSchedule;
            n = ((IntervalSchedule)object).getIntervalInSeconds();
            boolean bl3 = bl2 = ((IntervalSchedule)object).getIntervalStart() != null && ((IntervalSchedule)object).getIntervalEnd() != null;
            if (((IntervalSchedule)object).getIntervalStart() != null) {
                date = ((IntervalSchedule)object).getIntervalStart();
            }
            if (((IntervalSchedule)object).getIntervalEnd() != null) {
                date2 = ((IntervalSchedule)object).getIntervalEnd();
            }
            bl = true;
        }
        if (date == null) {
            date = new Date();
        }
        if (date2 == null) {
            object = Calendar.getInstance();
            ((Calendar)object).setTime(date);
            ((Calendar)object).add(11, 1);
            date2 = ((Calendar)object).getTime();
        }
        object = new JPanel(new FlowLayout(3));
        ((JComponent)object).setOpaque(false);
        this.intervalFactorComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        this.intervalFactorComboBox.setModel(defaultComboBoxModel);
        defaultComboBoxModel.addElement(this.getLocalizedString("common.timeunit.seconds"));
        defaultComboBoxModel.addElement(this.getLocalizedString("common.timeunit.minutes"));
        defaultComboBoxModel.addElement(this.getLocalizedString("common.timeunit.hours"));
        defaultComboBoxModel.addElement(this.getLocalizedString("common.timeunit.days"));
        this.intervalFactorComboBox.setSelectedIndex(0);
        if (n != 0) {
            if (n % 86400 == 0) {
                n /= 86400;
                this.intervalFactorComboBox.setSelectedIndex(3);
            } else if (n % 3600 == 0) {
                n /= 3600;
                this.intervalFactorComboBox.setSelectedIndex(2);
            } else if (n % 60 == 0) {
                n /= 60;
                this.intervalFactorComboBox.setSelectedIndex(1);
            }
        }
        this.intervalButton = new JRadioButton(this.getLocalizedString("window.TaskConfigurationFrame.button.intervalExecution"));
        this.intervalButton.setOpaque(false);
        this.intervalButton.setSelected(bl);
        buttonGroup.add(this.intervalButton);
        this.taskIntervalTextField = new JTextField(String.valueOf(n));
        this.taskIntervalTextField.setBackground(Color.WHITE);
        this.taskIntervalTextField.setPreferredSize(new Dimension(this.applicationContext.getUIManager().getPixelsForDots(50), (int)this.taskIntervalTextField.getPreferredSize().getHeight()));
        ((Container)object).add(this.intervalButton);
        ((Container)object).add(this.taskIntervalTextField);
        ((Container)object).add(this.intervalFactorComboBox);
        this.mainPanel.add((Component)object);
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.setOpaque(false);
        Insets insets = UIManager.getInsets("RadioButton.margin");
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this.intervalLimitationButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.intervalBetween"));
        this.intervalLimitationButton.setOpaque(false);
        this.intervalLimitationButton.setMargin(new Insets(insets2.top, 30, insets2.bottom, insets2.right));
        this.taskIntervalBetween1Label = new JLabel(this.getLocalizedString("window.TaskConfigurationFrame.label.intervalBetween1"));
        this.taskIntervalBetween2Label = new JLabel(this.getLocalizedString("window.TaskConfigurationFrame.label.intervalBetween2"));
        this.taskIntervalBetween3Label = new JLabel(this.getLocalizedString("window.TaskConfigurationFrame.label.intervalBetween3"));
        this.taskIntervalBetweenStartSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.taskIntervalBetweenStartSpinner, "HH:mm");
        this.taskIntervalBetweenStartSpinner.setEditor(dateEditor);
        this.taskIntervalBetweenStartSpinner.setPreferredSize(new Dimension(this.applicationContext.getUIManager().getPixelsForDots(70), (int)this.taskIntervalBetweenStartSpinner.getPreferredSize().getHeight()));
        UIUtil.makeComponentTransparent((Component)this.taskIntervalBetweenStartSpinner);
        this.taskIntervalBetweenEndSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor dateEditor2 = new JSpinner.DateEditor(this.taskIntervalBetweenEndSpinner, "HH:mm");
        this.taskIntervalBetweenEndSpinner.setEditor(dateEditor2);
        this.taskIntervalBetweenEndSpinner.setPreferredSize(new Dimension(this.applicationContext.getUIManager().getPixelsForDots(70), (int)this.taskIntervalBetweenEndSpinner.getPreferredSize().getHeight()));
        UIUtil.makeComponentTransparent((Component)this.taskIntervalBetweenEndSpinner);
        jPanel.add(this.intervalLimitationButton);
        jPanel.add(this.taskIntervalBetween1Label);
        jPanel.add(this.taskIntervalBetweenStartSpinner);
        jPanel.add(this.taskIntervalBetween2Label);
        jPanel.add(this.taskIntervalBetweenEndSpinner);
        jPanel.add(this.taskIntervalBetween3Label);
        this.intervalLimitationButton.setSelected(bl2);
        this.taskIntervalBetweenStartSpinner.setValue(date);
        this.taskIntervalBetweenEndSpinner.setValue(date2);
        this.mainPanel.add(jPanel);
        this.mainPanel.add(jPanel2);
    }

    private void addSpecifyTimeInput(ButtonGroup buttonGroup) {
        Object object;
        boolean bl = false;
        Date date = new Date();
        AbstractSchedule abstractSchedule = this.getScheduleForType(TimeSchedule.class);
        if (abstractSchedule != null) {
            object = (TimeSchedule)abstractSchedule;
            if (((TimeSchedule)object).getSpecifiedTime() != null) {
                date = ((TimeSchedule)object).getSpecifiedTime();
            }
            bl = true;
        }
        object = new JPanel(new FlowLayout(3));
        ((JComponent)object).setOpaque(false);
        this.timeButton = new JRadioButton(this.getLocalizedString("window.TaskConfigurationFrame.button.executeAtSpecifiedTime") + " ");
        this.timeButton.setOpaque(false);
        this.timeButton.setSelected(bl);
        buttonGroup.add(this.timeButton);
        ((Container)object).add(this.timeButton);
        this.taskTimeSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.taskTimeSpinner, "HH:mm:ss");
        this.taskTimeSpinner.setEditor(dateEditor);
        this.taskTimeSpinner.setValue(date);
        this.taskTimeSpinner.setPreferredSize(new Dimension(this.applicationContext.getUIManager().getPixelsForDots(90), (int)this.taskTimeSpinner.getPreferredSize().getHeight()));
        UIUtil.makeComponentTransparent((Component)this.taskTimeSpinner);
        ((Container)object).add(this.taskTimeSpinner);
        this.mainPanel.add((Component)object);
    }

    private void addScheduleValidityPeriodOptions() {
        AbstractSchedule abstractSchedule = this.getScheduleForType(TimeSchedule.class);
        AbstractSchedule abstractSchedule2 = this.getScheduleForType(IntervalSchedule.class);
        Date date = null;
        Date date2 = null;
        if (abstractSchedule != null) {
            date = abstractSchedule.getValidFrom();
            date2 = abstractSchedule.getValidUntil();
        } else if (abstractSchedule2 != null) {
            date = abstractSchedule2.getValidFrom();
            date2 = abstractSchedule2.getValidUntil();
        }
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        this.scheduleValidFromButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.scheduleValidFrom"));
        this.scheduleValidFromButton.setOpaque(false);
        this.scheduleValidFromButton.setSelected(date != null);
        this.scheduleValidFromButton.setEnabled(!this.taskManualExecutionButton.isSelected());
        this.scheduleValidUntilButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.scheduleValidUntil"));
        this.scheduleValidUntilButton.setOpaque(false);
        this.scheduleValidUntilButton.setSelected(date2 != null);
        this.scheduleValidUntilButton.setEnabled(!this.taskManualExecutionButton.isSelected());
        this.scheduleValidFromSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.scheduleValidFromSpinner, ((SimpleDateFormat)dateFormat).toPattern() + " HH:mm:ss");
        this.scheduleValidFromSpinner.setEditor(dateEditor);
        this.scheduleValidFromSpinner.setPreferredSize(new Dimension(this.applicationContext.getUIManager().getPixelsForDots(170), (int)this.scheduleValidFromSpinner.getPreferredSize().getHeight()));
        if (date != null) {
            this.scheduleValidFromSpinner.setValue(date);
        }
        UIUtil.makeComponentTransparent((Component)this.scheduleValidFromSpinner);
        this.scheduleValidUntilSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor dateEditor2 = new JSpinner.DateEditor(this.scheduleValidUntilSpinner, ((SimpleDateFormat)dateFormat).toPattern() + " HH:mm:ss");
        this.scheduleValidUntilSpinner.setEditor(dateEditor2);
        this.scheduleValidUntilSpinner.setPreferredSize(new Dimension(this.applicationContext.getUIManager().getPixelsForDots(170), (int)this.scheduleValidUntilSpinner.getPreferredSize().getHeight()));
        if (date2 != null) {
            this.scheduleValidUntilSpinner.setValue(date2);
        }
        UIUtil.makeComponentTransparent((Component)this.scheduleValidUntilSpinner);
        this.scheduleValidFromSpinner.setEnabled(this.scheduleValidFromButton.isSelected());
        this.scheduleValidUntilSpinner.setEnabled(this.scheduleValidUntilButton.isSelected());
        this.mainPanel.add(JPanelUtil.createWithComponents(this.scheduleValidFromButton, this.scheduleValidFromSpinner));
        this.mainPanel.add(JPanelUtil.createWithComponents(this.scheduleValidUntilButton, this.scheduleValidUntilSpinner));
    }

    private void addTaskSkipIfMissedOption() {
        boolean bl = true;
        AbstractSchedule abstractSchedule = this.getScheduleForType(TimeSchedule.class);
        AbstractSchedule abstractSchedule2 = this.getScheduleForType(IntervalSchedule.class);
        AbstractRestrictedTimeSchedule abstractRestrictedTimeSchedule = null;
        if (abstractSchedule != null) {
            abstractRestrictedTimeSchedule = (AbstractRestrictedTimeSchedule)abstractSchedule;
        } else if (abstractSchedule2 != null) {
            abstractRestrictedTimeSchedule = (AbstractRestrictedTimeSchedule)abstractSchedule2;
        }
        if (abstractRestrictedTimeSchedule != null) {
            bl = abstractRestrictedTimeSchedule.isSkipIfMissed();
        }
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.setOpaque(false);
        this.skipIfMissedButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.skipIfMissed"));
        this.skipIfMissedButton.setOpaque(false);
        this.skipIfMissedButton.setSelected(bl);
        jPanel.add(this.skipIfMissedButton);
        this.mainPanel.add(jPanel);
    }

    private void addTimeFrameOptions() {
        int n;
        boolean bl = false;
        int n2 = 127;
        int n3 = 0;
        AbstractSchedule abstractSchedule = this.getScheduleForType(TimeSchedule.class);
        AbstractSchedule abstractSchedule2 = this.getScheduleForType(IntervalSchedule.class);
        AbstractRestrictedTimeSchedule abstractRestrictedTimeSchedule = null;
        if (abstractSchedule != null) {
            abstractRestrictedTimeSchedule = (AbstractRestrictedTimeSchedule)abstractSchedule;
        } else if (abstractSchedule2 != null) {
            abstractRestrictedTimeSchedule = (AbstractRestrictedTimeSchedule)abstractSchedule2;
        }
        if (abstractRestrictedTimeSchedule != null) {
            bl = abstractRestrictedTimeSchedule.getWeekdays() < 127 || abstractRestrictedTimeSchedule.getDayOfMonth() != 0;
            n2 = abstractRestrictedTimeSchedule.getWeekdays();
            n3 = abstractRestrictedTimeSchedule.getDayOfMonth();
        }
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.setOpaque(false);
        this.executionTimeFrameButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.onlyExecuteOn") + "...");
        this.executionTimeFrameButton.setOpaque(false);
        this.executionTimeFrameButton.setSelected(bl);
        jPanel.add(this.executionTimeFrameButton);
        this.mainPanel.add(jPanel);
        this.timeFrameWeekdaysButton = new JRadioButton(this.getLocalizedString("window.TaskConfigurationFrame.button.specificDays") + ":");
        this.timeFrameWeekdaysButton.setOpaque(false);
        this.timeFrameDayOfMonthButton = new JRadioButton(this.getLocalizedString("window.TaskConfigurationFrame.button.everyXthDay"));
        this.timeFrameDayOfMonthButton.setOpaque(false);
        if (n3 != 0) {
            this.timeFrameDayOfMonthButton.setSelected(true);
        } else {
            this.timeFrameWeekdaysButton.setSelected(true);
        }
        Insets insets = UIManager.getInsets("RadioButton.margin");
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this.timeFrameWeekdaysButton.setMargin(new Insets(insets2.top, 30, insets2.bottom, insets2.right));
        this.timeFrameDayOfMonthButton.setMargin(new Insets(insets2.top, 30, insets2.bottom, insets2.right));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.timeFrameDayOfMonthButton);
        buttonGroup.add(this.timeFrameWeekdaysButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.setOpaque(false);
        jPanel2.add(this.timeFrameWeekdaysButton);
        this.mondayButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.monday"));
        jPanel2.add(this.mondayButton);
        this.tuesdayButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.tuesday"));
        jPanel2.add(this.tuesdayButton);
        this.wednesdayButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.wednesday"));
        jPanel2.add(this.wednesdayButton);
        this.thursdayButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.thursday"));
        jPanel2.add(this.thursdayButton);
        this.fridayButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.friday"));
        jPanel2.add(this.fridayButton);
        this.saturdayButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.saturday"));
        jPanel2.add(this.saturdayButton);
        this.sundayButton = new JCheckBox(this.getLocalizedString("window.TaskConfigurationFrame.button.sunday"));
        jPanel2.add(this.sundayButton);
        this.mondayButton.setOpaque(false);
        this.tuesdayButton.setOpaque(false);
        this.wednesdayButton.setOpaque(false);
        this.thursdayButton.setOpaque(false);
        this.fridayButton.setOpaque(false);
        this.saturdayButton.setOpaque(false);
        this.sundayButton.setOpaque(false);
        this.mondayButton.setSelected((n2 & 1) > 0);
        this.tuesdayButton.setSelected((n2 & 2) > 0);
        this.wednesdayButton.setSelected((n2 & 4) > 0);
        this.thursdayButton.setSelected((n2 & 8) > 0);
        this.fridayButton.setSelected((n2 & 0x10) > 0);
        this.saturdayButton.setSelected((n2 & 0x20) > 0);
        this.sundayButton.setSelected((n2 & 0x40) > 0);
        JPanel jPanel3 = new JPanel(new FlowLayout(3));
        jPanel3.setOpaque(false);
        this.timeFrameDayOfMonthComboBox = new JComboBox();
        jPanel3.add(this.timeFrameDayOfMonthButton);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        this.timeFrameDayOfMonthComboBox.setModel(defaultComboBoxModel);
        for (n = 1; n < 32; ++n) {
            defaultComboBoxModel.addElement(this.getLocalizedString("window.TaskConfigurationFrame.label.dayOfMonth." + n + (n % 10 == 1 && n != 11 ? "st" : (n % 10 == 2 && n != 12 ? "nd" : (n % 10 == 3 && n != 13 ? "rd" : "th")))));
        }
        defaultComboBoxModel.addElement(this.getLocalizedString("window.TaskConfigurationFrame.label.dayOfMonth.last"));
        n = n3 - 1;
        if (n < 0 || n > 31) {
            n = 31;
        }
        this.timeFrameDayOfMonthComboBox.setSelectedIndex(n);
        jPanel3.add(this.timeFrameDayOfMonthComboBox);
        this.dayOfMonthLabel = new JLabel(this.getLocalizedString("window.TaskConfigurationFrame.label.XthDayOfTheMonth"));
        jPanel3.add(this.dayOfMonthLabel);
        this.mainPanel.add(jPanel2);
        this.mainPanel.add(jPanel3);
    }
}

