/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.panel;

import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.event.JExtendedMouseAdapter;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.layout.VerticalFlowLayout;
import de.oliver_matuschin.ttd.application.TaskTillDawnApplication;
import de.oliver_matuschin.ttd.manager.ActionPackPluginManager;
import de.oliver_matuschin.ttd.plugin.action.Action;
import de.oliver_matuschin.ttd.plugin.action.annotation.ActionMetadata;
import de.oliver_matuschin.ttd.plugin.system.Platform;
import de.oliver_matuschin.ttd.ui.type.TypeInformationProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ActionMetadataPanel
extends JPanel {
    private TypeInformationProvider typeInformationProvider;
    private ApplicationContext<? extends TaskTillDawnApplication> applicationContext;
    private JLabel actionTitleLabel;
    private JTextArea actionDescriptionTextArea;
    private JPanel actionMetadataPanel;
    private JPanel innerPanel;
    private ImageIcon lightBulbImage = ImageBuilder.buildFor((String)"/resources/images/actions/lightbulb.png");
    private ImageIcon defaultActionImage = ImageBuilder.buildFor((String)"/resources/images/actions/action_default.png");

    public ActionMetadataPanel(ApplicationContext<? extends TaskTillDawnApplication> applicationContext, TypeInformationProvider typeInformationProvider) {
        this.applicationContext = applicationContext;
        this.typeInformationProvider = typeInformationProvider;
        this.initUI();
    }

    private void initUI() {
        UIManager uIManager = this.applicationContext.getUIManager();
        this.innerPanel = new JPanel(new BorderLayout());
        this.innerPanel.setBackground(Color.WHITE);
        this.innerPanel.setBorder(null);
        this.actionTitleLabel = new JLabel();
        this.actionTitleLabel.setOpaque(false);
        this.actionTitleLabel.setFont(uIManager.getFont(UIManager.FontSize.DEFAULT, 1));
        this.actionTitleLabel.setBorder(BorderFactory.createEmptyBorder(uIManager.getPixelsForDots(10), uIManager.getPixelsForDots(10), uIManager.getPixelsForDots(10), uIManager.getPixelsForDots(10)));
        this.innerPanel.add((Component)this.actionTitleLabel, "North");
        this.actionDescriptionTextArea = new JTextArea();
        this.actionDescriptionTextArea.setOpaque(true);
        this.actionDescriptionTextArea.setBackground(Color.WHITE);
        this.actionDescriptionTextArea.setBorder(BorderFactory.createEmptyBorder(0, uIManager.getPixelsForDots(10), 0, uIManager.getPixelsForDots(10)));
        this.actionDescriptionTextArea.setEditable(false);
        this.actionDescriptionTextArea.setLineWrap(true);
        this.actionDescriptionTextArea.setWrapStyleWord(true);
        this.actionDescriptionTextArea.setFont(uIManager.getFont(UIManager.FontSize.MEDIUM));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(null);
        jScrollPane.getViewport().add(this.actionDescriptionTextArea);
        this.innerPanel.add((Component)jScrollPane, "Center");
        this.actionMetadataPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.actionMetadataPanel.setOpaque(false);
        this.actionMetadataPanel.setBorder(BorderFactory.createEmptyBorder(uIManager.getPixelsForDots(10), 0, uIManager.getPixelsForDots(10), 0));
        this.innerPanel.add((Component)this.actionMetadataPanel, "South");
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setBorder(null);
        this.setMinimumSize(new Dimension(1, uIManager.getPixelsForDots(200)));
        this.setPreferredSize(new Dimension(1, uIManager.getPixelsForDots(200)));
        this.add((Component)this.innerPanel, "Center");
        jScrollPane.getViewport().addChangeListener(changeEvent -> {
            if (jScrollPane.getVerticalScrollBar().isVisible()) {
                if (jScrollPane.getBorder() == null) {
                    jScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
                }
            } else if (jScrollPane.getBorder() != null) {
                jScrollPane.setBorder(null);
            }
        });
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.innerPanel.setPreferredSize(dimension);
        super.setPreferredSize(dimension);
    }

    @Override
    public void setSize(int n, int n2) {
        this.innerPanel.setSize(n, n2);
        super.setSize(n, n2);
    }

    @Override
    public void setSize(Dimension dimension) {
        this.innerPanel.setSize(dimension);
        super.setSize(dimension);
    }

    private String getLocalizedString(String string) {
        return this.applicationContext.getLocalizationProvider().getLocalizedString(string);
    }

    public void displayActionMetadata(Class<? extends Action<?, ?, ?>> clazz) {
        Object object;
        ActionPackPluginManager actionPackPluginManager = ((TaskTillDawnApplication)this.applicationContext.getApplication()).getActionPackPluginManager();
        this.actionTitleLabel.setText(actionPackPluginManager.getLocalizedStringForActionClass(clazz, "title", "No title available"));
        ImageIcon imageIcon = actionPackPluginManager.getIconForActionClass(clazz);
        if (imageIcon != null) {
            this.actionTitleLabel.setIcon(imageIcon);
        } else {
            this.actionTitleLabel.setIcon(this.defaultActionImage);
        }
        this.actionDescriptionTextArea.setText(actionPackPluginManager.getLocalizedStringForActionClass(clazz, "description", "No description available"));
        this.actionDescriptionTextArea.setCaretPosition(0);
        this.actionMetadataPanel.removeAll();
        Type[] typeArray = actionPackPluginManager.getInputOutputTypesForActionClass(clazz);
        if (!typeArray[0].getTypeName().equals(Void.class.getTypeName())) {
            object = null;
            if (object == null) {
                object = actionPackPluginManager.getLocalizedStringForActionClass(clazz, "input1", null);
            }
            if (object == null) {
                object = actionPackPluginManager.getLocalizedStringForActionClass(clazz, "input", null);
            }
            if (object == null) {
                object = this.typeInformationProvider.getLocalizedTypeName(typeArray[0]);
            }
            this.addMetadata(this.getLocalizedString("panel.ActionConfigurationPanel.label.input"), (String)object, this.typeInformationProvider.getIconForType(typeArray[0]));
        }
        if (!typeArray[1].getTypeName().equals(Void.class.getTypeName())) {
            object = null;
            if (object == null) {
                object = actionPackPluginManager.getLocalizedStringForActionClass(clazz, "input2", null);
            }
            if (object == null) {
                object = actionPackPluginManager.getLocalizedStringForActionClass(clazz, "input", null);
            }
            if (object == null) {
                object = this.typeInformationProvider.getLocalizedTypeName(typeArray[1]);
            }
            this.addMetadata(this.getLocalizedString("panel.ActionConfigurationPanel.label.input"), (String)object, this.typeInformationProvider.getIconForType(typeArray[1]));
        }
        if (!typeArray[2].getTypeName().equals(Void.class.getTypeName())) {
            object = null;
            object = null;
            if (object == null) {
                object = actionPackPluginManager.getLocalizedStringForActionClass(clazz, "output", null);
            }
            if (object == null) {
                object = this.typeInformationProvider.getLocalizedTypeName(typeArray[2]);
            }
            this.addMetadata(this.getLocalizedString("panel.ActionConfigurationPanel.label.output"), (String)object, this.typeInformationProvider.getIconForType(typeArray[2]));
        }
        object = clazz.getAnnotation(ActionMetadata.class);
        StringBuilder stringBuilder = new StringBuilder();
        for (Platform platform : object.platforms()) {
            if (platform.equals((Object)Platform.MACOS)) {
                stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append("macOS");
                continue;
            }
            if (!platform.equals((Object)Platform.WINDOWS)) continue;
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append("Windows");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(this.getLocalizedString("panel.ActionConfigurationPanel.label.anyPlatform"));
        }
        this.addMetadata(this.getLocalizedString("panel.ActionConfigurationPanel.label.platforms"), stringBuilder.toString(), null, false, false);
        if (object.version() > 0.0f) {
            this.addMetadata(this.getLocalizedString("panel.ActionConfigurationPanel.label.version"), String.valueOf(object.version()), null, false, false);
        }
        if (!object.copyright().trim().equals("")) {
            String string = object.copyright().replaceAll("\\(c\\)", "\u00a9");
            this.addMetadata(this.getLocalizedString("panel.ActionConfigurationPanel.label.copyright"), string, null, false, false);
        }
        if (!object.website().trim().equals("")) {
            this.addMetadata(this.getLocalizedString("panel.ActionConfigurationPanel.label.website"), object.website(), null, true, false);
        }
        this.actionMetadataPanel.revalidate();
    }

    public void displayGettingStartedInformation() {
        this.actionTitleLabel.setText(this.getLocalizedString("panel.ActionConfigurationPanel.label.gettingStarted"));
        this.actionTitleLabel.setIcon(this.lightBulbImage);
        this.actionDescriptionTextArea.setText(this.getLocalizedString("panel.ActionConfigurationPanel.message.gettingStarted"));
        this.actionDescriptionTextArea.setCaretPosition(0);
        this.actionMetadataPanel.removeAll();
    }

    private void addMetadata(String string, String string2, ImageIcon imageIcon) {
        this.addMetadata(string, string2, imageIcon, false, true);
    }

    private void addMetadata(String string, final String string2, ImageIcon imageIcon, boolean bl, boolean bl2) {
        UIManager uIManager = this.applicationContext.getUIManager();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(null);
        JLabel jLabel = new JLabel(string + ": ", 4);
        jLabel.setOpaque(false);
        jLabel.setPreferredSize(new Dimension(uIManager.getPixelsForDots(100), jLabel.getPreferredSize().height));
        jLabel.setFont(uIManager.getFont(UIManager.FontSize.SMALL, 1));
        if (!bl2) {
            jLabel.setForeground(Color.GRAY);
        }
        jPanel.add((Component)jLabel, "West");
        jLabel = !bl ? new JLabel(string2) : new JLabel("<html><body><a href=\"" + string2 + "\">" + string2 + "</a></body></html>");
        jLabel.setIcon(imageIcon);
        jLabel.setOpaque(false);
        jLabel.setFont(uIManager.getFont(UIManager.FontSize.SMALL));
        if (!bl2) {
            jLabel.setForeground(Color.GRAY);
        }
        if (bl) {
            jLabel.setCursor(new Cursor(12));
            jLabel.addMouseListener((MouseListener)new JExtendedMouseAdapter(this.applicationContext.getPlatform()){

                public void mouseClicked(MouseEvent mouseEvent) {
                    try {
                        Desktop.getDesktop().browse(new URI(string2));
                    }
                    catch (IOException | URISyntaxException exception) {
                        // empty catch block
                    }
                }
            });
        }
        jPanel.add((Component)jLabel, "Center");
        this.actionMetadataPanel.add(jPanel);
    }
}

