/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.panel;

import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.dialog.JExtendedDialog;
import de.oliver_matuschin.base.ui.dialog.JExtendedOpenDialog;
import de.oliver_matuschin.base.ui.dialog.JExtendedSaveDialog;
import de.oliver_matuschin.base.ui.event.JExtendedMouseAdapter;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.layout.LinearLayout;
import de.oliver_matuschin.base.ui.layout.VerticalFlowLayout;
import de.oliver_matuschin.base.ui.list.JExtendedList;
import de.oliver_matuschin.base.ui.splitpane.JExtendedSplitPane;
import de.oliver_matuschin.base.ui.table.JExtendedTable;
import de.oliver_matuschin.ttd.action.UnknownAction;
import de.oliver_matuschin.ttd.application.TaskTillDawnApplication;
import de.oliver_matuschin.ttd.application.TaskTillDawnApplicationContext;
import de.oliver_matuschin.ttd.collect.ImmutableArrayList;
import de.oliver_matuschin.ttd.constant.TaskTillDawnConstants;
import de.oliver_matuschin.ttd.group.listener.TaskGroupEventListener;
import de.oliver_matuschin.ttd.manager.ActionPackPluginManager;
import de.oliver_matuschin.ttd.manager.exception.UnknownActionConfiguratorException;
import de.oliver_matuschin.ttd.manager.exception.UnknownActionException;
import de.oliver_matuschin.ttd.manager.exception.UnknownTypeConverterException;
import de.oliver_matuschin.ttd.plugin.action.Action;
import de.oliver_matuschin.ttd.plugin.action.annotation.ActionMetadata;
import de.oliver_matuschin.ttd.plugin.configurator.context.ConfiguratorContext;
import de.oliver_matuschin.ttd.plugin.converter.TypeConverter;
import de.oliver_matuschin.ttd.plugin.system.Platform;
import de.oliver_matuschin.ttd.plugin.ui.UIManager;
import de.oliver_matuschin.ttd.plugin.ui.comboBox.GroupSelectionComboBoxWrapper;
import de.oliver_matuschin.ttd.plugin.ui.comboBox.LabelSelectionComboBoxWrapper;
import de.oliver_matuschin.ttd.plugin.ui.comboBox.TaskSelectionComboBoxWrapper;
import de.oliver_matuschin.ttd.plugin.ui.configurator.ActionConfigurator;
import de.oliver_matuschin.ttd.plugin.ui.textPane.VariableTextPaneWrapper;
import de.oliver_matuschin.ttd.plugin.ui.toolbox.UIToolbox;
import de.oliver_matuschin.ttd.repository.listener.TaskRepositoryEventListener;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.action.Action;
import de.oliver_matuschin.ttd.ui.button.PopupButton;
import de.oliver_matuschin.ttd.ui.cellEditor.ConfiguratorTableCellEditor;
import de.oliver_matuschin.ttd.ui.comboBox.AbstractLabelSelectionComboBox;
import de.oliver_matuschin.ttd.ui.comboBox.GroupSelectionComboBox;
import de.oliver_matuschin.ttd.ui.comboBox.TaskSelectionComboBox;
import de.oliver_matuschin.ttd.ui.configuration.ConfigurationEventListener;
import de.oliver_matuschin.ttd.ui.configurator.UnknownActionConfigurator;
import de.oliver_matuschin.ttd.ui.model.ActionConfiguratorContainer;
import de.oliver_matuschin.ttd.ui.panel.ActionMetadataPanel;
import de.oliver_matuschin.ttd.ui.renderer.AbstractListCellRenderer;
import de.oliver_matuschin.ttd.ui.textPane.VariableTextPane;
import de.oliver_matuschin.ttd.ui.type.TypeInformationProvider;
import de.oliver_matuschin.util.TypeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ActionConfigurationPanel {
    private JList<String> categoryList;
    private JList<Class<ActionConfigurator>> configuratorList;
    private JTable configuratorTable;
    private DefaultListModel<String> categoryListModel;
    private DefaultListModel<Class<ActionConfigurator>> configuratorListModel;
    private DefaultTableModel configuratorTableModel;
    private JExtendedSplitPane splitPane;
    private JExtendedSplitPane configuratorSelectionSplitPane;
    private JExtendedSplitPane topBottomSplitPane;
    private JTextField filterTextField;
    private JButton clearFilterButton;
    private JPanel filterTextFieldPanel;
    private JPanel mainPanel;
    private ActionMetadataPanel actionMetadataPanel;
    private List<Action.ActionVariable> variables;
    private ImageIcon defaultActionImage = ImageBuilder.buildFor((String)"/resources/images/actions/action_default.png");
    private JFrame parent;
    private TaskTillDawnApplicationContext applicationContext;
    private ActionPackPluginManager actionPackPluginManager;
    private Task task;
    private List<String> cachedLabels;
    private volatile boolean forceUIUpdate;
    private List<TaskGroupEventListener> taskGroupEventListeners;
    private List<TaskRepositoryEventListener> taskRepositoryEventListeners;
    private ExecutorService validationExecutor;
    private EventListenerList listeners;
    private TypeInformationProvider typeInformationProvider = new TypeInformationProvider(){

        private boolean isList(Type type) {
            return "java.util.List".equals(this.getMainType(type));
        }

        private boolean isGeneric(Type type) {
            return type.getTypeName().indexOf("<") != -1 && type.getTypeName().indexOf(">") != -1;
        }

        private String getInnerType(Type type) {
            String string = type.getTypeName();
            if (this.isGeneric(type)) {
                return string.substring(string.indexOf("<") + 1, string.lastIndexOf(">"));
            }
            return null;
        }

        private String getMainType(Type type) {
            String string = type.getTypeName();
            if (this.isGeneric(type)) {
                return string.substring(0, string.indexOf("<"));
            }
            return string;
        }

        @Override
        public String getLocalizedTypeName(Type type) {
            String string = this.getInnerType(type);
            if (string == null) {
                string = this.getMainType(type);
            }
            if (string.equals("de.oliver_matuschin.ttd.plugin.task.Task")) {
                if (this.isList(type)) {
                    return ActionConfigurationPanel.this.getLocalizedString("type.taskList");
                }
                return ActionConfigurationPanel.this.getLocalizedString("type.task");
            }
            if (string.equals("java.io.File")) {
                if (this.isList(type)) {
                    return ActionConfigurationPanel.this.getLocalizedString("type.fileList");
                }
                return ActionConfigurationPanel.this.getLocalizedString("type.file");
            }
            if (string.equals("java.lang.String")) {
                if (this.isList(type)) {
                    return ActionConfigurationPanel.this.getLocalizedString("type.stringList");
                }
                return ActionConfigurationPanel.this.getLocalizedString("type.string");
            }
            if (string.equals("java.util.Date")) {
                if (this.isList(type)) {
                    return ActionConfigurationPanel.this.getLocalizedString("type.dateList");
                }
                return ActionConfigurationPanel.this.getLocalizedString("type.date");
            }
            if (string.equals("java.lang.Integer") || string.equals("java.lang.Long") || string.equals("java.math.BigInteger")) {
                if (this.isList(type)) {
                    return ActionConfigurationPanel.this.getLocalizedString("type.numberList");
                }
                return ActionConfigurationPanel.this.getLocalizedString("type.number");
            }
            if (string.equals("java.lang.Float") || string.equals("java.lang.Double") || string.equals("java.math.BigDecimal")) {
                if (this.isList(type)) {
                    return ActionConfigurationPanel.this.getLocalizedString("type.numberList");
                }
                return ActionConfigurationPanel.this.getLocalizedString("type.decimalNumber");
            }
            if (string.equals("java.lang.Object")) {
                if (this.isList(type)) {
                    return ActionConfigurationPanel.this.getLocalizedString("type.objectList");
                }
                return ActionConfigurationPanel.this.getLocalizedString("type.object");
            }
            return type.getTypeName();
        }

        @Override
        public ImageIcon getIconForType(Type type) {
            String string = this.getInnerType(type);
            if (string == null) {
                string = this.getMainType(type);
            }
            if (this.isList(type)) {
                if (string.equals("java.lang.String")) {
                    return ImageBuilder.buildFor((String)"/resources/images/dataTypes/strings.png");
                }
                if (string.equals("java.io.File")) {
                    return ImageBuilder.buildFor((String)"/resources/images/dataTypes/files.png");
                }
                if (string.equals("de.oliver_matuschin.ttd.plugin.task.Task")) {
                    return ImageBuilder.buildFor((String)"/resources/images/dataTypes/tasks.png");
                }
                if (string.equals("java.util.Date")) {
                    return ImageBuilder.buildFor((String)"/resources/images/dataTypes/dates.png");
                }
                if (string.equals("java.math.BigInteger")) {
                    return ImageBuilder.buildFor((String)"/resources/images/dataTypes/numbers.png");
                }
                return ImageBuilder.buildFor((String)"/resources/images/dataTypes/objects.png");
            }
            if (string.equals("java.lang.String")) {
                return ImageBuilder.buildFor((String)"/resources/images/dataTypes/string.png");
            }
            if (string.equals("java.io.File")) {
                return ImageBuilder.buildFor((String)"/resources/images/dataTypes/file.png");
            }
            if (string.equals("de.oliver_matuschin.ttd.plugin.task.Task")) {
                return ImageBuilder.buildFor((String)"/resources/images/dataTypes/task.png");
            }
            if (string.equals("java.util.Date")) {
                return ImageBuilder.buildFor((String)"/resources/images/dataTypes/date.png");
            }
            if (string.equals("java.math.BigInteger")) {
                return ImageBuilder.buildFor((String)"/resources/images/dataTypes/number.png");
            }
            return ImageBuilder.buildFor((String)"/resources/images/dataTypes/object.png");
        }
    };

    public ActionConfigurationPanel(JFrame jFrame, TaskTillDawnApplicationContext taskTillDawnApplicationContext, Task task) {
        this.parent = jFrame;
        this.applicationContext = taskTillDawnApplicationContext;
        this.actionPackPluginManager = taskTillDawnApplicationContext.getActionPackPluginManager();
        this.task = task;
        this.cachedLabels = new ArrayList<String>();
        this.variables = new ArrayList<Action.ActionVariable>();
        this.taskGroupEventListeners = new ArrayList<TaskGroupEventListener>();
        this.taskRepositoryEventListeners = new ArrayList<TaskRepositoryEventListener>();
        this.listeners = new EventListenerList();
        this.initUI();
        this.validationExecutor = Executors.newFixedThreadPool(1);
        this.setupValidator();
    }

    public boolean validate() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<ActionConfiguratorContainer> list = this.getActionConfiguratorContainers();
        for (ActionConfiguratorContainer actionConfiguratorContainer : list) {
            Object object;
            ActionConfigurator actionConfigurator = actionConfiguratorContainer.getActionConfigurator();
            if (actionConfigurator.getClass().getCanonicalName().equals("de.oliver_matuschin.ttd.plugin.defaultActions.ui.configurator.LabelActionConfigurator")) {
                object = (String)actionConfigurator.getConfiguration().get("label");
                if (object == null) {
                    object = "";
                }
                if (arrayList.contains(object = ((String)object).trim())) {
                    JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.error"), (Object)this.getLocalizedString("panel.ActionConfigurationPanel.message.duplicateLabels", object), 0);
                    jExtendedDialog.showDialog((Component)this.parent);
                    return false;
                }
                if (((String)object).trim().equals("")) {
                    JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.error"), (Object)this.getLocalizedString("panel.ActionConfigurationPanel.message.emptyLabel"), 0);
                    jExtendedDialog.showDialog((Component)this.parent);
                    return false;
                }
                arrayList.add(object);
            }
            if ((object = actionConfigurator.getValidationErrors()) == null || object.size() <= 0) continue;
            JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.error"), (Object)this.getLocalizedString("panel.ActionConfigurationPanel.message.configureActions"), 0);
            jExtendedDialog.showDialog((Component)this.parent);
            return false;
        }
        return true;
    }

    public void dispose() {
        for (TaskGroupEventListener eventListener : this.taskGroupEventListeners) {
            this.applicationContext.getApplication().getTaskGroupManager().removeTaskGroupEventListener(eventListener);
        }
        for (TaskRepositoryEventListener taskRepositoryEventListener : this.taskRepositoryEventListeners) {
            this.applicationContext.getApplication().getTaskRepository().removeTaskRepositoryEventListener(taskRepositoryEventListener);
        }
        this.getApplication().getPreferences().putInt("workflowDividerLocation", (int)((float)this.splitPane.getDividerLocation() / this.getUIManager().getDPIMultiplier()));
        this.getApplication().getPreferences().putInt("configuratorListDividerLocation", (int)((float)this.configuratorSelectionSplitPane.getDividerLocation() / this.getUIManager().getDPIMultiplier()));
        this.getApplication().getPreferences().putInt("metadataDividerLocation", (int)((float)this.topBottomSplitPane.getDividerLocation() / this.getUIManager().getDPIMultiplier()));
        this.validationExecutor.shutdownNow();
        try {
            this.validationExecutor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public List<ActionConfiguratorContainer> getActionConfiguratorContainers() {
        ArrayList<ActionConfiguratorContainer> arrayList = new ArrayList<ActionConfiguratorContainer>();
        int n = this.configuratorTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add((ActionConfiguratorContainer)this.configuratorTableModel.getValueAt(i, 0));
        }
        return arrayList;
    }

    public Component getComponent() {
        return this.mainPanel;
    }

    public void handlePrint(String string) throws PrinterException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this.configuratorTable.getPrintable(JTable.PrintMode.FIT_WIDTH, null, null), this.getApplication().getPageFormat());
        printerJob.setJobName(this.getApplication().getApplicationName() + " - " + string);
        if (printerJob.printDialog()) {
            printerJob.print();
        }
    }

    private void initUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setOpaque(false);
        this.mainPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        this.splitPane = new JExtendedSplitPane();
        this.splitPane.setDividerColor(Color.LIGHT_GRAY);
        this.splitPane.setDividerLocation((int)((float)this.getApplication().getPreferences().getInt("workflowDividerLocation", (int)this.getUIManager().getPixelsForDots(400.0f / this.getUIManager().getDPIMultiplier())) * this.getUIManager().getDPIMultiplier()));
        this.splitPane.setBorder(null);
        this.splitPane.setBackground(Color.WHITE);
        this.mainPanel.add((Component)this.splitPane, "Center");
        this.configuratorTableModel = new DefaultTableModel(0, 1);
        this.configuratorTable = new JExtendedTable((TableModel)this.configuratorTableModel, this.getLocalizedString("panel.ActionConfigurationPanel.label.dragActionsHere"), TaskTillDawnConstants.BRIGHT_AND_SHINY);
        this.configuratorTable.putClientProperty("terminateEditOnFocusLost", true);
        this.configuratorTable.setDefaultRenderer(Object.class, new ConfiguratorTableCellEditor(this.parent, this.applicationContext, this.actionPackPluginManager, this.typeInformationProvider, this.variables));
        this.configuratorTable.setDefaultEditor(Object.class, new ConfiguratorTableCellEditor(this.parent, this.applicationContext, this.actionPackPluginManager, this.typeInformationProvider, this.variables));
        this.configuratorTable.setFillsViewportHeight(true);
        this.configuratorTable.setTableHeader(null);
        this.configuratorTable.setBorder(null);
        this.configuratorTable.setShowGrid(false);
        this.configuratorTable.setCellSelectionEnabled(false);
        this.configuratorTable.setSelectionMode(0);
        this.configuratorTable.setAutoscrolls(false);
        this.configuratorTable.getColumnModel().getColumn(0).setMinWidth(this.getUIManager().getPixelsForDots(500));
        this.configuratorTable.setToolTipText(null);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(null);
        jScrollPane.getViewport().add(this.configuratorTable);
        this.splitPane.setRightComponent((Component)jScrollPane);
        this.categoryListModel = new DefaultListModel();
        this.categoryList = new JExtendedList(this.categoryListModel);
        this.categoryList.setBorder(null);
        this.categoryList.setSelectionMode(0);
        this.categoryList.setCellRenderer((ListCellRenderer<String>)new AbstractListCellRenderer<String>(this.getUIManager(), UIManager.FontSize.MEDIUM){
            private ImageIcon libraryIcon;
            {
                this.libraryIcon = ImageBuilder.buildFor((String)"/resources/library_icon.png");
            }

            @Override
            protected String getDisplayableString(String string, int n) {
                return string;
            }

            @Override
            protected ImageIcon getIconForValue(String string, int n, boolean bl) {
                if (n == 0) {
                    return this.libraryIcon;
                }
                return null;
            }
        });
        this.configuratorListModel = new DefaultListModel();
        this.configuratorList = new JExtendedList(this.configuratorListModel);
        this.configuratorList.setBorder(null);
        this.configuratorList.setSelectionMode(0);
        this.configuratorList.setCellRenderer((ListCellRenderer<Class<ActionConfigurator>>)new AbstractListCellRenderer<Class<? extends ActionConfigurator>>(this.getUIManager(), UIManager.FontSize.MEDIUM){

            @Override
            protected String getDisplayableString(Class<? extends ActionConfigurator> clazz, int n) {
                try {
                    return ActionConfigurationPanel.this.actionPackPluginManager.getLocalizedStringForActionClass(ActionConfigurationPanel.this.actionPackPluginManager.getActionClassForConfiguratorClass(clazz), "title", "");
                }
                catch (UnknownActionException unknownActionException) {
                    return "";
                }
            }

            @Override
            protected ImageIcon getIconForValue(Class<? extends ActionConfigurator> clazz, int n, boolean bl) {
                try {
                    ImageIcon imageIcon = ActionConfigurationPanel.this.actionPackPluginManager.getIconForActionClass(ActionConfigurationPanel.this.actionPackPluginManager.getActionClassForConfiguratorClass(clazz));
                    if (imageIcon != null) {
                        return imageIcon;
                    }
                }
                catch (UnknownActionException unknownActionException) {
                    // empty catch block
                }
                return ActionConfigurationPanel.this.defaultActionImage;
            }
        });
        this.buildCategoriesList();
        this.configuratorSelectionSplitPane = new JExtendedSplitPane();
        this.configuratorSelectionSplitPane.setBorder(null);
        this.configuratorSelectionSplitPane.setDividerColor(Color.LIGHT_GRAY);
        this.configuratorSelectionSplitPane.setDividerLocation((int)((float)this.getApplication().getPreferences().getInt("configuratorListDividerLocation", (int)this.getUIManager().getPixelsForDots(150.0f / this.getUIManager().getDPIMultiplier())) * this.getUIManager().getDPIMultiplier()));
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setBorder(null);
        jScrollPane2.getViewport().add(this.categoryList);
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.setBorder(null);
        jScrollPane3.getViewport().add(this.configuratorList);
        this.configuratorSelectionSplitPane.setLeftComponent((Component)jScrollPane2);
        this.configuratorSelectionSplitPane.setRightComponent((Component)jScrollPane3);
        JPanel jPanel = new JPanel(new FlowLayout(4)){

            @Override
            public void paint(Graphics graphics) {
                if (graphics instanceof Graphics2D) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, TaskTillDawnConstants.BRIGHTER_AND_SHINY, 0.0f, this.getHeight(), TaskTillDawnConstants.BRIGHT_AND_SHINY);
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                super.paint(graphics);
            }
        };
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        jPanel.setMinimumSize(new Dimension(this.getUIManager().getPixelsForDots(300), 1));
        this.filterTextField = new JTextField();
        this.filterTextField.setBorder(null);
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        jLabel.setBorder(null);
        jLabel.setIcon(ImageBuilder.buildFor((String)"/resources/images/misc/magnifier.png"));
        this.clearFilterButton = new JButton();
        this.clearFilterButton.setFocusPainted(false);
        this.clearFilterButton.setContentAreaFilled(false);
        this.clearFilterButton.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(5), this.getUIManager().getPixelsForDots(5), this.getUIManager().getPixelsForDots(5), this.getUIManager().getPixelsForDots(5)));
        this.clearFilterButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_clear.png"));
        this.clearFilterButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_clear_pressed.png"));
        this.clearFilterButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_clear_disabled.png"));
        this.clearFilterButton.setVisible(false);
        this.filterTextFieldPanel = new JPanel(new BorderLayout());
        this.filterTextFieldPanel.setBackground(Color.WHITE);
        this.filterTextFieldPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.filterTextFieldPanel.add((Component)jLabel, "West");
        this.filterTextFieldPanel.add((Component)this.filterTextField, "Center");
        this.filterTextFieldPanel.add((Component)this.clearFilterButton, "East");
        this.filterTextFieldPanel.setPreferredSize(new Dimension(this.splitPane.getDividerLocation() - this.configuratorSelectionSplitPane.getDividerLocation() - 10, this.getUIManager().getPixelsForDots(22)));
        jPanel.add(this.filterTextFieldPanel);
        this.actionMetadataPanel = new ActionMetadataPanel(this.applicationContext, this.typeInformationProvider);
        this.topBottomSplitPane = new JExtendedSplitPane();
        this.topBottomSplitPane.setDividerColor(Color.LIGHT_GRAY);
        this.topBottomSplitPane.setBorder(null);
        this.topBottomSplitPane.setBackground(Color.WHITE);
        this.topBottomSplitPane.setOrientation(0);
        this.topBottomSplitPane.setResizeWeight(1.0);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.configuratorSelectionSplitPane, "Center");
        this.topBottomSplitPane.setTopComponent((Component)jPanel2);
        this.topBottomSplitPane.setBottomComponent((Component)this.actionMetadataPanel);
        if (this.getApplication().getPreferences().getInt("metadataDividerLocation", 0) > 0) {
            this.topBottomSplitPane.setDividerLocation((int)((float)this.getApplication().getPreferences().getInt("metadataDividerLocation", 0) * this.getUIManager().getDPIMultiplier()));
        }
        this.splitPane.setLeftComponent((Component)this.topBottomSplitPane);
        ImmutableArrayList<de.oliver_matuschin.ttd.scheduler.task.action.Action> immutableArrayList = this.task.getActions().get("Start");
        if (immutableArrayList != null) {
            for (de.oliver_matuschin.ttd.scheduler.task.action.Action action : immutableArrayList) {
                if (!action.getType().equals("de.oliver_matuschin.ttd.plugin.defaultActions.action.LabelAction")) continue;
                this.cachedLabels.add(action.getLabel());
            }
            for (de.oliver_matuschin.ttd.scheduler.task.action.Action action : immutableArrayList) {
                Object object;
                HashMap<String, Object> hashMap;
                ActionConfigurator actionConfigurator;
                Class clazz;
                Class clazz2 = null;
                try {
                    clazz2 = this.actionPackPluginManager.getActionClassForName(action.getType());
                }
                catch (UnknownActionException unknownActionException) {
                    clazz2 = UnknownAction.class;
                }
                try {
                    clazz = this.actionPackPluginManager.getConfiguratorClassForActionClass(clazz2);
                }
                catch (UnknownActionConfiguratorException unknownActionConfiguratorException) {
                    clazz = UnknownActionConfigurator.class;
                }
                if ((actionConfigurator = this.newActionConfiguratorInstance(clazz)) == null) continue;
                Map<Object, Object> map = hashMap = action.getConfiguration() != null ? action.getConfiguration().asMap() : new HashMap();
                if (actionConfigurator.getClass().getCanonicalName().equals("de.oliver_matuschin.ttd.plugin.defaultActions.ui.configurator.LabelActionConfigurator")) {
                    object = action.getLabel();
                    if (object == null) {
                        object = "";
                    }
                    object = ((String)object).trim();
                    hashMap.put("label", object);
                }
                actionConfigurator.setConfiguration(hashMap);
                object = new ActionConfiguratorContainer(actionConfigurator, action.getInput1(), action.getInput2(), action.getOutput());
                if (action.getInput1() != null && !this.variableExists(action.getInput1())) {
                    this.variables.add(action.getInput1());
                }
                if (action.getInput2() != null && !this.variableExists(action.getInput2())) {
                    this.variables.add(action.getInput2());
                }
                if (action.getOutput() != null && !this.variableExists(action.getOutput())) {
                    this.variables.add(action.getOutput());
                }
                this.configuratorTableModel.addRow(new ActionConfiguratorContainer[]{object});
            }
            this.updateRowHeights(this.configuratorTable);
        }
        this.cachedLabels = null;
        this.removeUnusedVariables();
        this.addTransferHandlers();
        this.addListeners();
        this.categoryList.setSelectedIndex(0);
        this.actionMetadataPanel.displayGettingStartedInformation();
    }

    private boolean variableExists(Action.ActionVariable actionVariable) {
        for (Action.ActionVariable actionVariable2 : this.variables) {
            if (!actionVariable2.getName().equals(actionVariable.getName())) continue;
            return true;
        }
        return false;
    }

    private void setupValidator() {
        this.validationExecutor.submit(new Runnable(){
            private List<ActionConfigurator> validConfigurators = new ArrayList<ActionConfigurator>();
            private Map<ActionConfigurator, List<String>> configurationErrors = new HashMap<ActionConfigurator, List<String>>();
            private boolean refreshed = false;

            private boolean errorsChanged(List<String> list, List<String> list2) {
                if (list == null && list2 != null || list2 == null && list != null) {
                    return true;
                }
                if (list != null && list2 != null) {
                    return !list.containsAll(list2) || !list2.containsAll(list);
                }
                return false;
            }

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int n = -1;
                            if (ActionConfigurationPanel.this.configuratorTable.isEditing()) {
                                n = ActionConfigurationPanel.this.configuratorTable.getEditingRow();
                            }
                            int n2 = ActionConfigurationPanel.this.configuratorTable.getRowCount();
                            for (int i = 0; i < n2; ++i) {
                                ActionConfigurator actionConfigurator = ((ActionConfiguratorContainer)ActionConfigurationPanel.this.configuratorTable.getValueAt(i, 0)).getActionConfigurator();
                                if (actionConfigurator == null) continue;
                                boolean bl = ActionConfigurationPanel.this.forceUIUpdate;
                                List<String> list = actionConfigurator.getValidationErrors();
                                if ((list == null || list.isEmpty()) && !validConfigurators.contains(actionConfigurator)) {
                                    configurationErrors.remove(actionConfigurator);
                                    validConfigurators.add(actionConfigurator);
                                    bl = true;
                                } else if (list != null && !list.isEmpty()) {
                                    List<String> list2 = actionConfigurator.getValidationErrors();
                                    if (this.errorsChanged((List)configurationErrors.get(actionConfigurator), list2)) {
                                        configurationErrors.put(actionConfigurator, list2);
                                        validConfigurators.remove(actionConfigurator);
                                        bl = true;
                                    }
                                }
                                if (!bl) continue;
                                refreshed = true;
                                if (i == n) {
                                    Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                                    if (component instanceof JComboBox && ((JComboBox)component).isPopupVisible()) continue;
                                    ActionConfigurationPanel.this.configuratorTable.getCellEditor().stopCellEditing();
                                    ActionConfigurationPanel.this.configuratorTable.editCellAt(i, 0);
                                    if (component == null) continue;
                                    Component component2 = ActionConfigurationPanel.this.configuratorTable.getEditorComponent();
                                    ActionConfigurationPanel.this.setFocused(component2, component);
                                    continue;
                                }
                                ((DefaultTableModel)ActionConfigurationPanel.this.configuratorTable.getModel()).fireTableRowsUpdated(i, i);
                            }
                            ActionConfigurationPanel.this.forceUIUpdate = false;
                            if (refreshed && !ActionConfigurationPanel.this.configuratorTable.isEditing()) {
                                refreshed = false;
                                ActionConfigurationPanel.this.updateRowHeights(ActionConfigurationPanel.this.configuratorTable);
                            }
                        }
                    });
                    try {
                        for (int i = 0; i < 10 && !ActionConfigurationPanel.this.forceUIUpdate; ++i) {
                            Thread.sleep(70L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        });
    }

    private boolean setFocused(Component component, Component component2) {
        if (component == component2) {
            component.requestFocus();
            return true;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (!this.setFocused(container.getComponent(i), component2)) continue;
                return true;
            }
        }
        return false;
    }

    private void buildCategoriesList() {
        this.categoryListModel.addElement(this.getLocalizedString("panel.ActionConfigurationPanel.categories.library"));
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Class<ActionConfigurator>> list = this.actionPackPluginManager.listConfiguratorClasses();
        for (Class<ActionConfigurator> object : list) {
            Class<Action<?, ?, ?>> clazz;
            try {
                clazz = this.actionPackPluginManager.getActionClassForConfiguratorClass(object);
            }
            catch (UnknownActionException unknownActionException) {
                continue;
            }
            Set<String> set = this.determineCategoryNames(clazz);
            for (String string : set) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            this.categoryListModel.addElement(string);
        }
    }

    private Set<String> determineCategoryNames(Class<? extends Action<?, ?, ?>> clazz) {
        HashSet<String> hashSet = new HashSet<String>();
        ActionMetadata actionMetadata = clazz.getAnnotation(ActionMetadata.class);
        if (actionMetadata != null) {
            String[] stringArray;
            Field[] fieldArray = ActionMetadata.StandardCategory.class.getDeclaredFields();
            for (String string : stringArray = actionMetadata.categories()) {
                if ("".equals(string)) continue;
                boolean bl = false;
                for (Field field : fieldArray) {
                    try {
                        if (!field.get(ActionMetadata.StandardCategory.class).equals(string)) continue;
                        hashSet.add(this.getLocalizedString("panel.ActionConfigurationPanel.categories." + string));
                        bl = true;
                        break;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                }
                if (bl) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private TaskTillDawnApplication getApplication() {
        return this.applicationContext.getApplication();
    }

    private de.oliver_matuschin.base.ui.UIManager getUIManager() {
        return this.applicationContext.getApplication().getUIManager();
    }

    private String getLocalizedString(String string) {
        return this.applicationContext.getLocalizationProvider().getLocalizedString(string);
    }

    private String getLocalizedString(String string, Object ... objectArray) {
        return this.applicationContext.getLocalizationProvider().getLocalizedString(string, objectArray);
    }

    private void clearFilter() {
        this.filterTextField.setText("");
        this.updateConfiguratorsList();
        this.filterTextField.requestFocus();
        if (this.clearFilterButton.isVisible()) {
            this.clearFilterButton.setVisible(false);
        }
    }

    private void addListeners() {
        this.filterTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 || ActionConfigurationPanel.this.filterTextField.getText().trim().equals("")) {
                    ActionConfigurationPanel.this.clearFilter();
                } else {
                    if (!ActionConfigurationPanel.this.clearFilterButton.isVisible()) {
                        ActionConfigurationPanel.this.clearFilterButton.setVisible(true);
                    }
                    ActionConfigurationPanel.this.updateConfiguratorsList();
                }
            }
        });
        this.clearFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionConfigurationPanel.this.clearFilter();
            }
        });
        this.categoryList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ActionConfigurationPanel.this.updateConfiguratorsList();
            }
        });
        this.configuratorList.addMouseListener((MouseListener)new JExtendedMouseAdapter(this.applicationContext.getPlatform()){

            public void mouseClicked(MouseEvent mouseEvent) {
                Class clazz;
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 0 && mouseEvent.getClickCount() % 2 == 0 && (clazz = (Class)ActionConfigurationPanel.this.configuratorList.getSelectedValue()) != null) {
                    ActionConfigurator actionConfigurator = ActionConfigurationPanel.this.newActionConfiguratorInstance(clazz);
                    ActionConfigurationPanel.this.addNewActionConfigurator(ActionConfigurationPanel.this.configuratorTableModel.getRowCount(), actionConfigurator);
                    actionConfigurator.setConfiguration(actionConfigurator.getConfiguration());
                    ActionConfigurationPanel.this.updateRowHeights(ActionConfigurationPanel.this.configuratorTable);
                    int n = ActionConfigurationPanel.this.configuratorTable.getRowCount() - 1;
                    ActionConfigurationPanel.this.configuratorTable.getSelectionModel().setSelectionInterval(n, n);
                    ActionConfigurationPanel.this.configuratorTable.scrollRectToVisible(new Rectangle(ActionConfigurationPanel.this.configuratorTable.getCellRect(n, 0, true)));
                }
            }
        });
        this.configuratorList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Class clazz = (Class)ActionConfigurationPanel.this.configuratorList.getSelectedValue();
                if (clazz != null) {
                    try {
                        ActionConfigurationPanel.this.actionMetadataPanel.displayActionMetadata(ActionConfigurationPanel.this.actionPackPluginManager.getActionClassForConfiguratorClass(clazz));
                        return;
                    }
                    catch (UnknownActionException unknownActionException) {
                        // empty catch block
                    }
                }
                ActionConfigurationPanel.this.actionMetadataPanel.displayGettingStartedInformation();
            }
        });
        this.splitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("dividerLocation")) {
                    ActionConfigurationPanel.this.actionMetadataPanel.setSize(new Dimension(ActionConfigurationPanel.this.splitPane.getDividerLocation(), ((ActionConfigurationPanel)ActionConfigurationPanel.this).actionMetadataPanel.getSize().height));
                    ActionConfigurationPanel.this.filterTextFieldPanel.setPreferredSize(new Dimension(ActionConfigurationPanel.this.splitPane.getDividerLocation() - ActionConfigurationPanel.this.configuratorSelectionSplitPane.getDividerLocation() - 10, ActionConfigurationPanel.this.getUIManager().getPixelsForDots(22)));
                }
            }
        });
        this.configuratorSelectionSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("dividerLocation")) {
                    ActionConfigurationPanel.this.filterTextFieldPanel.setPreferredSize(new Dimension(ActionConfigurationPanel.this.splitPane.getDividerLocation() - ActionConfigurationPanel.this.configuratorSelectionSplitPane.getDividerLocation() - 10, ActionConfigurationPanel.this.getUIManager().getPixelsForDots(22)));
                    ActionConfigurationPanel.this.filterTextFieldPanel.revalidate();
                }
            }
        });
        this.configuratorTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == -1) {
                    ActionConfigurationPanel.this.fireLabelsUpdated();
                }
            }
        });
        this.configuratorTable.getDefaultEditor(Object.class).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                ConfiguratorTableCellEditor configuratorTableCellEditor;
                ActionConfiguratorContainer actionConfiguratorContainer;
                Object object = changeEvent.getSource();
                if (object instanceof ConfiguratorTableCellEditor && (actionConfiguratorContainer = (ActionConfiguratorContainer)(configuratorTableCellEditor = (ConfiguratorTableCellEditor)object).getCellEditorValue()) != null && actionConfiguratorContainer.getActionConfigurator().getClass().getCanonicalName().equals("de.oliver_matuschin.ttd.plugin.defaultActions.ui.configurator.LabelActionConfigurator")) {
                    ActionConfigurationPanel.this.fireLabelsUpdated();
                }
                ActionConfigurationPanel.this.updateRowHeights(ActionConfigurationPanel.this.configuratorTable);
                ActionConfigurationPanel.this.removeUnusedVariables();
            }

            @Override
            public void editingCanceled(ChangeEvent changeEvent) {
                ActionConfigurationPanel.this.updateRowHeights(ActionConfigurationPanel.this.configuratorTable);
            }
        });
    }

    private boolean filterActionClass(Class<Action<?, ?, ?>> clazz) {
        if (!this.filterTextField.getText().trim().equals("")) {
            return this.actionPackPluginManager.getLocalizedStringForActionClass(clazz, "title", "").toLowerCase().indexOf(this.filterTextField.getText().trim().toLowerCase()) == -1;
        }
        return false;
    }

    private void updateConfiguratorsList() {
        Class<Action<?, ?, ?>> clazz;
        Class<ActionConfigurator> clazz2;
        Object object2;
        int n = this.categoryList.getSelectedIndex();
        if (n < 0) {
            this.categoryList.setSelectedIndex(0);
            return;
        }
        this.configuratorListModel.clear();
        ArrayList<Class<ActionConfigurator>> arrayList = new ArrayList<Class<ActionConfigurator>>();
        if (n > 0) {
            object2 = this.actionPackPluginManager.listConfiguratorClasses();
            Iterator<Class<ActionConfigurator>> object3 = object2.iterator();
            while (object3.hasNext()) {
                clazz2 = object3.next();
                try {
                    clazz = this.actionPackPluginManager.getActionClassForConfiguratorClass(clazz2);
                }
                catch (UnknownActionException unknownActionException) {
                    continue;
                }
                if (this.filterActionClass(clazz) || !this.determineCategoryNames(clazz).contains(this.categoryList.getSelectedValue())) continue;
                arrayList.add(clazz2);
            }
        } else {
            object2 = this.actionPackPluginManager.listConfiguratorClasses();
            Iterator<Class<ActionConfigurator>> iterator = object2.iterator();
            while (iterator.hasNext()) {
                clazz2 = iterator.next();
                try {
                    clazz = this.actionPackPluginManager.getActionClassForConfiguratorClass(clazz2);
                }
                catch (UnknownActionException unknownActionException) {
                    continue;
                }
                if (this.filterActionClass(clazz) || this.determineCategoryNames(clazz).isEmpty()) continue;
                arrayList.add(clazz2);
            }
        }
        Collections.sort(arrayList, new Comparator<Class<ActionConfigurator>>(){

            @Override
            public int compare(Class<ActionConfigurator> clazz, Class<ActionConfigurator> clazz2) {
                try {
                    Class<Action<?, ?, ?>> clazz3 = ActionConfigurationPanel.this.actionPackPluginManager.getActionClassForConfiguratorClass(clazz);
                    Class<Action<?, ?, ?>> clazz4 = ActionConfigurationPanel.this.actionPackPluginManager.getActionClassForConfiguratorClass(clazz2);
                    return ActionConfigurationPanel.this.actionPackPluginManager.getLocalizedStringForActionClass(clazz3, "title", "").compareTo(ActionConfigurationPanel.this.actionPackPluginManager.getLocalizedStringForActionClass(clazz4, "title", ""));
                }
                catch (UnknownActionException unknownActionException) {
                    return 0;
                }
            }
        });
        for (Class clazz3 : arrayList) {
            this.configuratorListModel.addElement(clazz3);
        }
    }

    private void removeUnusedVariables() {
        Iterator<Action.ActionVariable> iterator = this.variables.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().getName();
            boolean bl = false;
            int n = this.configuratorTableModel.getRowCount();
            block1: for (int i = 0; i < n; ++i) {
                ActionConfiguratorContainer actionConfiguratorContainer = (ActionConfiguratorContainer)this.configuratorTableModel.getValueAt(i, 0);
                if (actionConfiguratorContainer == null) continue;
                if (actionConfiguratorContainer.getInput1() != null && string.equals(actionConfiguratorContainer.getInput1().getName()) || actionConfiguratorContainer.getInput2() != null && string.equals(actionConfiguratorContainer.getInput2().getName()) || actionConfiguratorContainer.getOutput() != null && string.equals(actionConfiguratorContainer.getOutput().getName())) {
                    bl = true;
                    break;
                }
                List<VariableTextPaneWrapper> list = actionConfiguratorContainer.getActionConfigurator().getConfiguratorContext().getRegisteredVariableTextPaneWrappers();
                for (VariableTextPaneWrapper variableTextPaneWrapper : list) {
                    List<Action.ActionVariable> list2 = ((VariableTextPane)variableTextPaneWrapper.getComponent()).getUsedActionVariables();
                    for (Action.ActionVariable actionVariable : list2) {
                        if (!actionVariable.getName().equals(string)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    continue block1;
                }
            }
            if (bl) continue;
            iterator.remove();
        }
    }

    private void updateRowHeights(JTable jTable) {
        if (jTable.isEditing()) {
            jTable.getCellEditor().stopCellEditing();
        }
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            int n = jTable.getRowHeight();
            for (int j = 0; j < jTable.getColumnCount(); ++j) {
                Component component = jTable.prepareRenderer(jTable.getCellRenderer(i, j), i, j);
                if (component == null) continue;
                n = Math.max(n, component.getPreferredSize().height);
            }
            jTable.setRowHeight(i, n);
        }
    }

    private void addNewActionConfigurator(int n, ActionConfigurator actionConfigurator) {
        int n2;
        Class<Action<?, ?, ?>> clazz;
        try {
            clazz = this.actionPackPluginManager.getActionClassForConfiguratorClass(actionConfigurator.getClass());
        }
        catch (UnknownActionException unknownActionException) {
            return;
        }
        Type[] typeArray = this.actionPackPluginManager.getInputOutputTypesForActionClass(clazz);
        ActionMetadata actionMetadata = clazz.getAnnotation(ActionMetadata.class);
        boolean bl = actionMetadata.strictInput();
        Action.ActionVariable actionVariable = null;
        Action.ActionVariable actionVariable2 = null;
        Action.ActionVariable actionVariable3 = null;
        String string = this.actionPackPluginManager.getLocalizedStringForActionClass(clazz, "output", null);
        if (string != null) {
            boolean bl2 = false;
            n2 = 0;
            for (Action.ActionVariable object : this.variables) {
                if (!object.getName().equals(string)) continue;
                bl2 = true;
                if (!object.getType().equals(typeArray[2].getTypeName())) break;
                n2 = 1;
                break;
            }
            if (!bl2 || n2 != 0) {
                actionVariable3 = new Action.ActionVariable(string, typeArray[2].getTypeName());
                if (!bl2) {
                    this.variables.add(actionVariable3);
                }
            }
        }
        if (n > 0) {
            try {
                TypeConverter typeConverter = this.actionPackPluginManager.getTypeConverterForName("de.oliver_matuschin.ttd.plugin.defaultActions.converter.SingleObjectToListConverter");
                block5: for (n2 = 0; n2 < 2; ++n2) {
                    for (int i = n - 1; i >= 0; --i) {
                        ActionConfiguratorContainer actionConfiguratorContainer = (ActionConfiguratorContainer)this.configuratorTableModel.getValueAt(i, 0);
                        if (actionConfiguratorContainer == null || actionConfiguratorContainer.getOutput() == null) continue;
                        if (n2 == 0 && actionVariable == null && actionConfiguratorContainer.getOutput().getType().equals(typeArray[n2].getTypeName()) && (actionVariable2 == null || !actionVariable2.getName().equals(actionConfiguratorContainer.getOutput().getName()))) {
                            actionVariable = new Action.ConvertibleVariable(actionConfiguratorContainer.getOutput().getName(), actionConfiguratorContainer.getOutput().getType());
                        } else if (!(n2 != 0 || actionVariable != null || bl || !typeConverter.supports(TypeUtil.getTypeFromString((String)actionConfiguratorContainer.getOutput().getType()), typeArray[n2]) || actionVariable2 != null && actionVariable2.getName().equals(actionConfiguratorContainer.getOutput().getName()))) {
                            actionVariable = new Action.ConvertibleVariable(actionConfiguratorContainer.getOutput().getName(), actionConfiguratorContainer.getOutput().getType(), typeConverter.getClass().getCanonicalName(), null);
                        } else if (n2 == 1 && actionVariable2 == null && actionConfiguratorContainer.getOutput().getType().equals(typeArray[n2].getTypeName()) && (actionVariable == null || !actionVariable.getName().equals(actionConfiguratorContainer.getOutput().getName()))) {
                            actionVariable2 = new Action.ConvertibleVariable(actionConfiguratorContainer.getOutput().getName(), actionConfiguratorContainer.getOutput().getType());
                        } else if (!(n2 != 1 || actionVariable2 != null || bl || !typeConverter.supports(TypeUtil.getTypeFromString((String)actionConfiguratorContainer.getOutput().getType()), typeArray[n2]) || actionVariable != null && actionVariable.getName().equals(actionConfiguratorContainer.getOutput().getName()))) {
                            actionVariable2 = new Action.ConvertibleVariable(actionConfiguratorContainer.getOutput().getName(), actionConfiguratorContainer.getOutput().getType(), typeConverter.getClass().getCanonicalName(), null);
                        }
                        if (n2 == 0 && actionVariable != null || n2 == 1 && actionVariable2 != null) continue block5;
                    }
                }
            }
            catch (UnknownTypeConverterException unknownTypeConverterException) {
                // empty catch block
            }
        }
        ActionConfiguratorContainer actionConfiguratorContainer = new ActionConfiguratorContainer(actionConfigurator, (Action.ConvertibleVariable)actionVariable, (Action.ConvertibleVariable)actionVariable2, actionVariable3);
        this.configuratorTableModel.insertRow(n, new ActionConfiguratorContainer[]{actionConfiguratorContainer});
        if (actionConfigurator.getClass().getCanonicalName().equals("de.oliver_matuschin.ttd.plugin.defaultActions.ui.configurator.LabelActionConfigurator")) {
            this.fireLabelsUpdated();
        }
    }

    private void addTransferHandlers() {
        this.configuratorList.setDragEnabled(true);
        this.configuratorList.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                return false;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                return false;
            }

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 1;
            }

            @Override
            protected Transferable createTransferable(JComponent jComponent) {
                JList jList = (JList)jComponent;
                Class clazz = (Class)jList.getSelectedValue();
                ActionConfigurator actionConfigurator = ActionConfigurationPanel.this.newActionConfiguratorInstance(clazz);
                return new TransferableConfiguratorContainer(new ActionConfiguratorContainer(actionConfigurator));
            }
        });
        this.configuratorTable.setDragEnabled(true);
        this.configuratorTable.setDropMode(DropMode.INSERT);
        try {
            this.configuratorTable.setTransferHandler(new TransferHandler(){
                final ConfiguratorFlavor configuratorContainerFlavor = new ConfiguratorFlavor();

                @Override
                public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                    JTable.DropLocation dropLocation;
                    if (transferSupport.getDropLocation() instanceof JTable.DropLocation && (dropLocation = (JTable.DropLocation)transferSupport.getDropLocation()).isInsertColumn()) {
                        return false;
                    }
                    return transferSupport.isDataFlavorSupported(this.configuratorContainerFlavor);
                }

                @Override
                public boolean importData(TransferHandler.TransferSupport transferSupport) {
                    if (!transferSupport.isDrop()) {
                        return false;
                    }
                    if (!transferSupport.isDataFlavorSupported(this.configuratorContainerFlavor)) {
                        return false;
                    }
                    return this.moveConfigurators(transferSupport);
                }

                private int indexOf(DefaultTableModel defaultTableModel, ActionConfiguratorContainer actionConfiguratorContainer) {
                    int n = defaultTableModel.getRowCount();
                    for (int i = 0; i < n; ++i) {
                        if (defaultTableModel.getValueAt(i, 0) != actionConfiguratorContainer) continue;
                        return i;
                    }
                    return -1;
                }

                private boolean moveConfigurators(TransferHandler.TransferSupport transferSupport) {
                    if (ActionConfigurationPanel.this.configuratorTable.isEditing()) {
                        ActionConfigurationPanel.this.configuratorTable.getCellEditor().stopCellEditing();
                    }
                    Transferable transferable = transferSupport.getTransferable();
                    try {
                        ActionConfiguratorContainer actionConfiguratorContainer = (ActionConfiguratorContainer)transferable.getTransferData(this.configuratorContainerFlavor);
                        JTable.DropLocation dropLocation = (JTable.DropLocation)transferSupport.getDropLocation();
                        int n = dropLocation.getRow();
                        int n2 = this.indexOf(ActionConfigurationPanel.this.configuratorTableModel, actionConfiguratorContainer);
                        if (n2 > -1 && n > n2) {
                            --n;
                        }
                        if (n2 == -1) {
                            Map<String, Object> map = actionConfiguratorContainer.getActionConfigurator().getConfiguration();
                            ActionConfigurator actionConfigurator = ActionConfigurationPanel.this.newActionConfiguratorInstance(actionConfiguratorContainer.getActionConfigurator().getClass());
                            if (map != null) {
                                actionConfigurator.setConfiguration(new HashMap<String, Object>(map));
                            }
                            ActionConfigurationPanel.this.addNewActionConfigurator(n, actionConfigurator);
                        } else {
                            ActionConfigurationPanel.this.configuratorTableModel.moveRow(n2, n2, n);
                        }
                        ActionConfigurationPanel.this.configuratorTable.setRowSelectionInterval(n, n);
                        ActionConfigurationPanel.this.updateRowHeights(ActionConfigurationPanel.this.configuratorTable);
                        return true;
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        unsupportedFlavorException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return false;
                }

                @Override
                public int getSourceActions(JComponent jComponent) {
                    if (ActionConfigurationPanel.this.configuratorTableModel.getRowCount() < 1) {
                        return 0;
                    }
                    return 2;
                }

                @Override
                protected Transferable createTransferable(JComponent jComponent) {
                    JTable jTable = (JTable)jComponent;
                    return new TransferableConfiguratorContainer((ActionConfiguratorContainer)jTable.getValueAt(jTable.getSelectedRow(), 0));
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private ActionConfigurator newActionConfiguratorInstance(Class<? extends ActionConfigurator> clazz) {
        ActionConfigurator actionConfigurator = null;
        try {
            Constructor<? extends ActionConfigurator> constructor = clazz.getConstructor(ConfiguratorContext.class);
            actionConfigurator = constructor.newInstance(this.newConfiguratorContext());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return this.newActionConfiguratorInstance(UnknownActionConfigurator.class);
        }
        return actionConfigurator;
    }

    private void fireLabelsUpdated() {
        ConfigurationEventListener[] configurationEventListenerArray;
        for (ConfigurationEventListener configurationEventListener : configurationEventListenerArray = (ConfigurationEventListener[])this.listeners.getListeners(ConfigurationEventListener.class)) {
            configurationEventListener.labelsUpdated();
        }
    }

    private void addConfigurationEventListener(ConfigurationEventListener configurationEventListener) {
        this.listeners.add(ConfigurationEventListener.class, configurationEventListener);
    }

    private List<String> getLabels() {
        if (this.cachedLabels != null) {
            return this.cachedLabels;
        }
        int n = this.configuratorTableModel.getRowCount();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String string;
            if (!((ActionConfiguratorContainer)this.configuratorTableModel.getValueAt(i, 0)).getActionConfigurator().getClass().getCanonicalName().equals("de.oliver_matuschin.ttd.plugin.defaultActions.ui.configurator.LabelActionConfigurator") || (string = (String)((ActionConfiguratorContainer)this.configuratorTable.getValueAt(i, 0)).getActionConfigurator().getConfiguration().get("label")) == null || arrayList.contains(string = string.trim())) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private ConfiguratorContext newConfiguratorContext() {
        return new ConfiguratorContext(){
            private List<VariableTextPaneWrapper> variableTextPaneWrappers = new ArrayList<VariableTextPaneWrapper>();

            @Override
            public List<VariableTextPaneWrapper> getRegisteredVariableTextPaneWrappers() {
                return new ArrayList<VariableTextPaneWrapper>(this.variableTextPaneWrappers);
            }

            @Override
            public Object get(String string) {
                return null;
            }

            @Override
            public Platform getPlatform() {
                switch (ActionConfigurationPanel.this.getApplication().getPlatform()) {
                    case LINUX: {
                        return Platform.LINUX;
                    }
                    case MACOS: {
                        return Platform.MACOS;
                    }
                    case WINDOWS: {
                        return Platform.WINDOWS;
                    }
                }
                return Platform.ANY;
            }

            @Override
            public UIToolbox getUIToolbox() {
                return new UIToolbox(){

                    @Override
                    public File showSaveDialog(String string, int n) {
                        JExtendedSaveDialog jExtendedSaveDialog;
                        File file;
                        String string2 = ActionConfigurationPanel.this.getApplication().getPreferences().get("configurator_last_directory." + n, null);
                        if (string2 != null && !new File(string2).exists()) {
                            string2 = null;
                        }
                        if ((file = (jExtendedSaveDialog = new JExtendedSaveDialog(string)).showSaveDialog((Component)ActionConfigurationPanel.this.parent, string2)) != null && file.getParent() != null) {
                            ActionConfigurationPanel.this.getApplication().getPreferences().put("configurator_last_directory." + n, file.getParent());
                        }
                        return file;
                    }

                    @Override
                    public File[] showOpenDialog(String string, int n, boolean bl) {
                        String string2 = ActionConfigurationPanel.this.getApplication().getPreferences().get("configurator_last_directory." + n, null);
                        if (string2 != null && !new File(string2).exists()) {
                            string2 = null;
                        }
                        JExtendedOpenDialog jExtendedOpenDialog = new JExtendedOpenDialog(string);
                        jExtendedOpenDialog.setFileSelectionMode(n);
                        File[] fileArray = jExtendedOpenDialog.showOpenDialog((Component)ActionConfigurationPanel.this.parent, string2, bl);
                        if (fileArray != null && fileArray.length > 0 && fileArray[0].getParent() != null) {
                            if (fileArray[0].isDirectory()) {
                                ActionConfigurationPanel.this.getApplication().getPreferences().put("configurator_last_directory." + n, fileArray[0].getPath());
                            } else {
                                ActionConfigurationPanel.this.getApplication().getPreferences().put("configurator_last_directory." + n, fileArray[0].getParent());
                            }
                        }
                        return fileArray;
                    }

                    @Override
                    public LayoutManager newVerticalFlowLayout() {
                        return new VerticalFlowLayout();
                    }

                    @Override
                    public LayoutManager newVerticalFlowLayout(int n) {
                        return new VerticalFlowLayout(n);
                    }

                    @Override
                    public LayoutManager newVerticalFlowLayout(int n, boolean bl) {
                        return new VerticalFlowLayout(n, bl);
                    }

                    @Override
                    public LayoutManager newVerticalFlowLayout(boolean bl) {
                        return new VerticalFlowLayout(bl);
                    }

                    @Override
                    public LayoutManager newLinearLayout() {
                        return new LinearLayout(3);
                    }

                    @Override
                    public LayoutManager newLinearLayout(int n, int n2) {
                        return new LinearLayout(3, n, n2);
                    }

                    @Override
                    public TaskSelectionComboBoxWrapper newTaskSelectionComboBox(boolean bl) {
                        final TaskSelectionComboBox taskSelectionComboBox = new TaskSelectionComboBox(ActionConfigurationPanel.this.applicationContext.getLocalizationProvider(), ActionConfigurationPanel.this.applicationContext.getApplication().getTaskGroupManager(), ActionConfigurationPanel.this.applicationContext.getApplication().getTaskRepository());
                        ArrayList<Task> arrayList = new ArrayList<Task>();
                        arrayList.add(ActionConfigurationPanel.this.task);
                        taskSelectionComboBox.setIgnoredTasks(arrayList);
                        taskSelectionComboBox.setOnlyExecutableTasks(bl);
                        ActionConfigurationPanel.this.applicationContext.getApplication().getTaskGroupManager().addTaskGroupEventListener(taskSelectionComboBox);
                        ActionConfigurationPanel.this.applicationContext.getApplication().getTaskRepository().addTaskRepositoryEventListener(taskSelectionComboBox);
                        ActionConfigurationPanel.this.taskGroupEventListeners.add(taskSelectionComboBox);
                        ActionConfigurationPanel.this.taskRepositoryEventListeners.add(taskSelectionComboBox);
                        return new TaskSelectionComboBoxWrapper(){

                            @Override
                            public JComponent getComponent() {
                                return taskSelectionComboBox;
                            }

                            @Override
                            public String getSelectedTaskId() {
                                return taskSelectionComboBox.getSelectedTaskId();
                            }

                            @Override
                            public void setSelectedTaskId(String string) {
                                taskSelectionComboBox.setSelectedTaskId(string);
                            }

                            @Override
                            public void setEnabled(boolean bl) {
                                taskSelectionComboBox.setEnabled(bl);
                            }
                        };
                    }

                    @Override
                    public GroupSelectionComboBoxWrapper newGroupSelectionComboBox() {
                        final GroupSelectionComboBox groupSelectionComboBox = new GroupSelectionComboBox(ActionConfigurationPanel.this.applicationContext.getLocalizationProvider(), ActionConfigurationPanel.this.applicationContext.getApplication().getTaskGroupManager());
                        ActionConfigurationPanel.this.applicationContext.getApplication().getTaskGroupManager().addTaskGroupEventListener(groupSelectionComboBox);
                        ActionConfigurationPanel.this.taskGroupEventListeners.add(groupSelectionComboBox);
                        return new GroupSelectionComboBoxWrapper(){

                            @Override
                            public JComponent getComponent() {
                                return groupSelectionComboBox;
                            }

                            @Override
                            public String getSelectedGroup() {
                                return groupSelectionComboBox.getSelectedGroup();
                            }

                            @Override
                            public void setSelectedGroup(String string) {
                                groupSelectionComboBox.setSelectedGroup(string);
                            }

                            @Override
                            public void setEnabled(boolean bl) {
                                groupSelectionComboBox.setEnabled(bl);
                            }
                        };
                    }

                    @Override
                    public LabelSelectionComboBoxWrapper newLabelSelectionComboBox() {
                        final AbstractLabelSelectionComboBox abstractLabelSelectionComboBox = new AbstractLabelSelectionComboBox(ActionConfigurationPanel.this.applicationContext.getLocalizationProvider()){

                            @Override
                            protected List<String> getLabels() {
                                return ActionConfigurationPanel.this.getLabels();
                            }
                        };
                        ActionConfigurationPanel.this.addConfigurationEventListener(abstractLabelSelectionComboBox);
                        return new LabelSelectionComboBoxWrapper(){

                            @Override
                            public JComponent getComponent() {
                                return abstractLabelSelectionComboBox;
                            }

                            @Override
                            public String getSelectedLabel() {
                                return abstractLabelSelectionComboBox.getSelectedLabel();
                            }

                            @Override
                            public void setSelectedLabel(String string) {
                                abstractLabelSelectionComboBox.setSelectedLabel(string);
                            }

                            @Override
                            public void setEnabled(boolean bl) {
                                abstractLabelSelectionComboBox.setEnabled(bl);
                            }
                        };
                    }

                    @Override
                    public VariableTextPaneWrapper newVariableTextPane(boolean bl) {
                        return this.newVariableTextPane(null, bl);
                    }

                    @Override
                    public VariableTextPaneWrapper newVariableTextPane(String string, boolean bl) {
                        return this.newVariableTextPane(string, bl, true);
                    }

                    @Override
                    public VariableTextPaneWrapper newVariableTextPane(String string, boolean bl, boolean bl2) {
                        return this.newVariableTextPane(string, bl, bl2, true);
                    }

                    @Override
                    public VariableTextPaneWrapper newVariableTextPane(String string, boolean bl, boolean bl2, boolean bl3) {
                        final VariableTextPane variableTextPane = new VariableTextPane(string, bl, bl2, bl3, ActionConfigurationPanel.this.applicationContext.getLocalizationProvider(), ActionConfigurationPanel.this.getUIManager(), ActionConfigurationPanel.this.typeInformationProvider, ActionConfigurationPanel.this.actionPackPluginManager, ActionConfigurationPanel.this.variables);
                        VariableTextPaneWrapper variableTextPaneWrapper = new VariableTextPaneWrapper(){

                            @Override
                            public JComponent getComponent() {
                                return variableTextPane;
                            }

                            @Override
                            public String getText() {
                                return variableTextPane.getText();
                            }

                            @Override
                            public void setText(String string) {
                                if (string != null) {
                                    variableTextPane.setText(string);
                                } else {
                                    variableTextPane.setText("");
                                }
                            }

                            @Override
                            public void setEnabled(boolean bl) {
                                variableTextPane.setEnabled(bl);
                            }

                            @Override
                            public void setForeground(Color color) {
                                variableTextPane.setForeground(color);
                            }

                            @Override
                            public Color getForeground() {
                                return variableTextPane.getForeground();
                            }

                            @Override
                            public void dispose() {
                                variableTextPaneWrappers.remove(this);
                            }

                            @Override
                            public void addKeyListener(KeyListener keyListener) {
                                variableTextPane.addKeyListener(keyListener);
                            }
                        };
                        variableTextPaneWrappers.add(variableTextPaneWrapper);
                        return variableTextPaneWrapper;
                    }

                    @Override
                    public JPanel newJPanelWithComponents(JComponent ... jComponentArray) {
                        JPanel jPanel = new JPanel();
                        jPanel.setOpaque(false);
                        Border border = null;
                        border = this.getPlatform() == Platform.MACOS ? BorderFactory.createEmptyBorder(0, 5, 0, 5) : BorderFactory.createEmptyBorder(0, 5, ActionConfigurationPanel.this.getUIManager().getPixelsForDots(5), 5);
                        if (jComponentArray.length == 1) {
                            jPanel.setLayout(new BorderLayout(10, 0));
                            jPanel.setBorder(border);
                            jPanel.add((Component)jComponentArray[0], "Center");
                        } else if (jComponentArray.length == 2 && jComponentArray[0] instanceof JLabel && (jComponentArray[1] instanceof JPanel || jComponentArray[1] instanceof JTextField)) {
                            jPanel.setLayout(new BorderLayout(10, 0));
                            jPanel.setBorder(border);
                            jComponentArray[0].setPreferredSize(new Dimension(ActionConfigurationPanel.this.getUIManager().getPixelsForDots(110), jComponentArray[0].getPreferredSize().height));
                            jComponentArray[0].setBorder(border);
                            jPanel.add((Component)jComponentArray[0], "West");
                            jPanel.add((Component)jComponentArray[1], "Center");
                        } else if (jComponentArray.length == 3 && jComponentArray[0] instanceof JLabel && jComponentArray[1] instanceof JButton) {
                            jPanel.setLayout(new BorderLayout(10, 0));
                            jPanel.setBorder(border);
                            jComponentArray[0].setPreferredSize(new Dimension(ActionConfigurationPanel.this.getUIManager().getPixelsForDots(110), jComponentArray[0].getPreferredSize().height));
                            jComponentArray[0].setBorder(border);
                            jPanel.add((Component)jComponentArray[0], "West");
                            JPanel jPanel2 = new JPanel(new BorderLayout(5, 0));
                            jPanel2.setOpaque(false);
                            JPanel jPanel3 = new JPanel((LayoutManager)new VerticalFlowLayout());
                            jPanel3.setOpaque(false);
                            jPanel3.add(jComponentArray[2]);
                            jPanel2.add((Component)jComponentArray[1], "West");
                            jPanel2.add((Component)jPanel3, "Center");
                            jPanel.add((Component)jPanel2, "Center");
                        } else {
                            jPanel.setLayout((LayoutManager)new LinearLayout(3, 5, 0));
                            jPanel.setBorder(border);
                            boolean bl = true;
                            for (JComponent jComponent : jComponentArray) {
                                if (bl) {
                                    bl = false;
                                    if (jComponent instanceof JLabel && jComponentArray.length > 1) {
                                        ((Component)jComponent).setPreferredSize(new Dimension(ActionConfigurationPanel.this.getUIManager().getPixelsForDots(110), ((Component)jComponent).getPreferredSize().height));
                                    }
                                }
                                jPanel.add(jComponent);
                            }
                        }
                        return jPanel;
                    }

                    @Override
                    public float getDPIMultiplier() {
                        return ActionConfigurationPanel.this.getUIManager().getDPIMultiplier();
                    }

                    @Override
                    public ImageIcon getImageFromResource(Class<?> clazz, String string) {
                        if (clazz != null && string != null) {
                            return ImageBuilder.buildFor(clazz, (String)string);
                        }
                        return null;
                    }

                    @Override
                    public JButton newPopupButton(String string, JPopupMenu jPopupMenu) {
                        PopupButton popupButton = new PopupButton(string);
                        popupButton.setPopupMenu(jPopupMenu);
                        return popupButton;
                    }
                };
            }

            @Override
            public UIManager getUIManager() {
                return new UIManager(){

                    @Override
                    public void forceUIUpdate() {
                        ActionConfigurationPanel.this.forceUIUpdate = true;
                    }
                };
            }
        };
    }

    private static class ConfiguratorFlavor
    extends DataFlavor {
        public ConfiguratorFlavor() throws ClassNotFoundException {
            super("application/x-java-jvm-local-objectref; class=de.oliver_matuschin.ttd.ui.model.ActionConfiguratorContainer");
        }
    }

    private static class TransferableConfiguratorContainer
    implements Transferable {
        private ActionConfiguratorContainer configuratorContainer;

        public TransferableConfiguratorContainer(ActionConfiguratorContainer actionConfiguratorContainer) {
            this.configuratorContainer = actionConfiguratorContainer;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.configuratorContainer;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            try {
                return new DataFlavor[]{new ConfiguratorFlavor()};
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                return null;
            }
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return false;
        }
    }
}

