/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.model;

import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.action.Action;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import de.oliver_matuschin.ttd.ui.model.TaskContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;

public class TaskListModel
extends AbstractListModel<TaskContainer> {
    protected List<TaskContainer> taskContainers = new ArrayList<TaskContainer>();

    public void clear() {
        int n = this.taskContainers.size();
        if (n > 0) {
            this.taskContainers.clear();
            this.fireContentsChanged(this, 0, n - 1);
        }
    }

    @Override
    public TaskContainer getElementAt(int n) {
        if (n < this.taskContainers.size()) {
            return this.taskContainers.get(n);
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.taskContainers.size();
    }

    public void addTask(Task task, TaskMetadata taskMetadata, List<ScheduleMetadata> list, AbstractSchedule abstractSchedule, Action action, String string, Collection<AbstractSchedule> collection) {
        this.insertTaskAt(task, taskMetadata, list, abstractSchedule, action, string, collection, this.taskContainers.size());
    }

    public void updateTask(Task task, TaskMetadata taskMetadata, List<ScheduleMetadata> list, AbstractSchedule abstractSchedule, Action action, String string, Collection<AbstractSchedule> collection) {
        int n = this.indexOf(task.getId());
        if (n != -1) {
            this.taskContainers.set(n, new TaskContainer(task, taskMetadata, list, abstractSchedule, action, string, collection));
            this.fireContentsChanged(this, n, n);
        }
    }

    public boolean removeTask(String string) {
        int n = this.indexOf(string);
        if (n != -1 && this.taskContainers.remove(n) != null) {
            int n2 = this.taskContainers.size() - 1;
            if (n2 < 0) {
                n2 = 0;
            }
            this.fireContentsChanged(this, n, n2);
            return true;
        }
        return false;
    }

    public int indexOf(String string) {
        int n = this.taskContainers.size();
        for (int i = 0; i < n; ++i) {
            if (!this.taskContainers.get(i).getTask().getId().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void insertTaskAt(Task task, TaskMetadata taskMetadata, List<ScheduleMetadata> list, AbstractSchedule abstractSchedule, Action action, String string, Collection<AbstractSchedule> collection, int n) {
        if (n < this.getSize() + 1) {
            this.taskContainers.add(n, new TaskContainer(task, taskMetadata, list, abstractSchedule, action, string, collection));
            this.fireContentsChanged(this, n, n);
        }
    }
}

