/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.imaging;

import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.Timer;

public class AnimatedImage
extends ImageIcon {
    private ImageIcon[] animationIcons;
    private Timer animationTimer;
    private int currentImage = 0;

    public AnimatedImage(String ... stringArray) {
        this.animationIcons = new ImageIcon[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.animationIcons[i] = ImageBuilder.buildFor((String)stringArray[i]);
        }
        this.updateTimer();
    }

    private void updateTimer() {
        if (this.animationTimer == null) {
            this.animationTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AnimatedImage.this.currentImage++;
                    if (AnimatedImage.this.currentImage >= AnimatedImage.this.animationIcons.length) {
                        AnimatedImage.this.currentImage = 0;
                    }
                    if (AnimatedImage.this.getImageObserver() != null) {
                        AnimatedImage.this.getImageObserver().imageUpdate(AnimatedImage.this.getImage(), 32, 0, 0, AnimatedImage.this.getIconWidth(), AnimatedImage.this.getIconHeight());
                    }
                }
            });
        }
    }

    public void startAnimation() {
        if (!this.animationTimer.isRunning()) {
            this.animationTimer.start();
        }
    }

    public void stopAnimation() {
        if (this.animationTimer.isRunning()) {
            this.animationTimer.stop();
        }
    }

    private ImageIcon getCurrentImage() {
        return this.animationIcons[this.currentImage];
    }

    @Override
    public Image getImage() {
        return this.getCurrentImage().getImage();
    }

    @Override
    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.getCurrentImage().paintIcon(component, graphics, n, n2);
    }

    @Override
    public int getIconWidth() {
        return this.getCurrentImage().getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getCurrentImage().getIconHeight();
    }
}

