/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.frame;

import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.dialog.JExtendedDialog;
import de.oliver_matuschin.base.ui.event.JExtendedMouseAdapter;
import de.oliver_matuschin.base.ui.frame.AbstractApplicationWindow;
import de.oliver_matuschin.base.ui.frame.MenuContainer;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.list.JExtendedList;
import de.oliver_matuschin.base.ui.splitpane.JExtendedSplitPane;
import de.oliver_matuschin.base.util.UIUtil;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.ttd.application.TaskTillDawnApplicationContext;
import de.oliver_matuschin.ttd.collect.ImmutableArrayList;
import de.oliver_matuschin.ttd.collect.ImmutableHashMap;
import de.oliver_matuschin.ttd.constant.TaskTillDawnConstants;
import de.oliver_matuschin.ttd.group.TaskGroupManager;
import de.oliver_matuschin.ttd.group.exception.NameTooLongException;
import de.oliver_matuschin.ttd.group.listener.TaskGroupEventListener;
import de.oliver_matuschin.ttd.repository.TaskRepository;
import de.oliver_matuschin.ttd.repository.listener.TaskRepositoryEventListener;
import de.oliver_matuschin.ttd.scheduler.TaskScheduler;
import de.oliver_matuschin.ttd.scheduler.listener.TaskEventListener;
import de.oliver_matuschin.ttd.scheduler.listener.TaskSchedulerEventListener;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.action.Action;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.IntervalSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.ManualSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.TimeSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.UnknownSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import de.oliver_matuschin.ttd.scheduler.task.trigger.Trigger;
import de.oliver_matuschin.ttd.ui.frame.GroupListFrame;
import de.oliver_matuschin.ttd.ui.frame.TaskConfigurationFrame;
import de.oliver_matuschin.ttd.ui.model.TaskContainer;
import de.oliver_matuschin.ttd.ui.model.TaskListModel;
import de.oliver_matuschin.ttd.ui.renderer.GroupListCellRenderer;
import de.oliver_matuschin.ttd.ui.renderer.TaskListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TaskListFrame
extends AbstractApplicationWindow<TaskTillDawnApplicationContext> {
    private final Logger logger = Logger.getLogger(TaskListFrame.class.getName());
    private JButton runButton;
    private JButton stopButton;
    private JButton addButton;
    private JButton editButton;
    private JButton duplicateButton;
    private JButton viewLogButton;
    private JButton removeButton;
    private JButton donateButton;
    private JButton addGroupButton;
    private JButton editGroupButton;
    private JButton openInWindowButton;
    private JButton removeGroupButton;
    private JList<String> groupList;
    private JExtendedList<TaskContainer> taskList;
    protected JScrollPane taskScrollPane;
    private final TaskScheduler scheduler;
    private final TaskRepository repository;
    private final TaskGroupManager taskGroupManager;
    private JExtendedSplitPane splitPane;
    private DefaultListModel<String> groupListModel;
    private TaskListModel taskListModel;
    private String selectedGroup = "All tasks";
    private int viewOptions;
    private boolean showSidebar;
    private JPopupMenu taskPopupMenu;
    private JMenuItem runMenuItem;
    private JMenuItem stopMenuItem;
    private JMenuItem addMenuItem;
    private JMenuItem editMenuItem;
    private JMenuItem duplicateMenuItem;
    private JMenuItem viewLogMenuItem;
    private JMenuItem resetCountersMenuItem;
    private JMenuItem disableMenuItem;
    private JMenuItem enableMenuItem;
    private JMenuItem removeMenuItem;
    private JMenuItem exportMenuItem;
    private JMenuItem exportSelectedMenuItem;
    private JMenuItem importMenuItem;
    private JMenu viewOptionsMenu;
    private JMenu exportMenu;
    private JMenu importMenu;
    private JMenuItem viewAllMenuItem;
    private JMenuItem viewNoneMenuItem;
    private JCheckBoxMenuItem showLargeSymbolsMenuItem;
    private JCheckBoxMenuItem showDescriptionMenuItem;
    private JCheckBoxMenuItem showExecutionCountMenuItem;
    private JCheckBoxMenuItem showMaximumExecutionCountMenuItem;
    private JCheckBoxMenuItem showSchedulesMenuItem;
    private JCheckBoxMenuItem showTriggersMenuItem;
    private JCheckBoxMenuItem showSidebarMenuItem;
    private JLabel bottomBarStatusLabel;
    private TaskEventListener taskEventListener = new TaskEventListener(){

        @Override
        public void executionStarted(String string, String string2) {
            this.updateModel(string);
        }

        @Override
        public void executionCanceled(String string, String string2, ScheduleMetadata.ResultType resultType, ScheduleMetadata.ResultReason resultReason, String string3) {
        }

        @Override
        public void executionEnded(String string, String string2) {
            this.updateModel(string);
        }

        @Override
        public void actionStarted(String string, Action action) {
            this.updateModel(string);
        }

        @Override
        public void statusTextUpdated(String string, Action action, String string2) {
            this.updateModel(string);
        }

        @Override
        public void actionStopped(String string, Action action) {
            this.updateModel(string);
        }

        @Override
        public void scheduleRecalculationStarted(String string, String string2) {
            this.updateModel(string);
        }

        @Override
        public void scheduleMissed(String string, String string2, Date date) {
        }

        @Override
        public void scheduleRecalculationStopped(String string, String string2) {
            this.updateModel(string);
        }

        private void updateModel(final String string) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskMetadata taskMetadata;
                    Task task = TaskListFrame.this.repository.getTask(string);
                    if (TaskListFrame.this.taskListModel.indexOf(string) != -1 && task != null && (taskMetadata = TaskListFrame.this.repository.getTaskMetadata(string)) != null) {
                        TaskListFrame.this.taskListModel.updateTask(task, taskMetadata, TaskListFrame.this.repository.listScheduleMetadata(string), TaskListFrame.this.scheduler.getCurrentSchedule(string), TaskListFrame.this.scheduler.getCurrentAction(string), TaskListFrame.this.scheduler.getCurrentStatusText(string), TaskListFrame.this.getRecalculateSchedules(task));
                        TaskListFrame.this.validateButtonsAndMenus();
                        TaskListFrame.this.updateBottomBar();
                    }
                }
            });
        }
    };
    private TaskRepositoryEventListener taskRepositoryEventListener = new TaskRepositoryEventListener(){

        @Override
        public void taskUpdated(Task task) {
            this.updateModel(task);
        }

        @Override
        public void taskMetadataUpdated(Task task, TaskMetadata taskMetadata) {
            this.updateModel(task);
        }

        @Override
        public void scheduleMetadataUpdated(Task task, ScheduleMetadata scheduleMetadata) {
            this.updateModel(task);
        }

        @Override
        public void taskAdded(Task task) {
        }

        @Override
        public void taskRemoved(Task task) {
        }

        private void updateModel(final Task task) {
            final TaskMetadata taskMetadata = TaskListFrame.this.repository.getTaskMetadata(task.getId());
            if (taskMetadata != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (TaskListFrame.this.taskListModel.indexOf(task.getId()) != -1) {
                            TaskListFrame.this.taskListModel.updateTask(task, taskMetadata, TaskListFrame.this.repository.listScheduleMetadata(task.getId()), TaskListFrame.this.scheduler.getCurrentSchedule(task.getId()), TaskListFrame.this.scheduler.getCurrentAction(task.getId()), TaskListFrame.this.scheduler.getCurrentStatusText(task.getId()), TaskListFrame.this.getRecalculateSchedules(task));
                            TaskListFrame.this.validateButtonsAndMenus();
                        }
                    }
                });
            }
        }
    };
    private TaskSchedulerEventListener taskSchedulerListener = new TaskSchedulerEventListener(){

        @Override
        public void schedulingPaused() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskListFrame.this.updateBottomBar();
                    TaskListFrame.this.validateButtonsAndMenus();
                }
            });
        }

        @Override
        public void schedulingResumed() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskListFrame.this.updateBottomBar();
                    TaskListFrame.this.validateButtonsAndMenus();
                }
            });
        }
    };
    private TaskGroupEventListener taskGroupEventListener = new TaskGroupEventListener(){

        private void restoreSelectedTasks(List<Task> list) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
            for (Task task : list) {
                int n = TaskListFrame.this.taskListModel.indexOf(task.getId());
                if (n == -1) continue;
                arrayList.add(n);
            }
            Object object = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                object[i] = (Integer)arrayList.get(i);
            }
            TaskListFrame.this.taskList.setSelectedIndices((int[])object);
        }

        @Override
        public void taskAdded(final String string, final String string2, final int n) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskMetadata taskMetadata;
                    Task task;
                    if (string.equals(TaskListFrame.this.getSelectedGroup()) && (task = TaskListFrame.this.repository.getTask(string2)) != null && (taskMetadata = TaskListFrame.this.repository.getTaskMetadata(task.getId())) != null) {
                        List list = TaskListFrame.this.getSelectedTasks();
                        int n2 = n;
                        if (n > TaskListFrame.this.taskListModel.getSize()) {
                            n2 = TaskListFrame.this.taskListModel.getSize();
                        } else if (n < 0) {
                            n2 = 0;
                        }
                        TaskListFrame.this.taskListModel.insertTaskAt(task, taskMetadata, TaskListFrame.this.repository.listScheduleMetadata(string2), TaskListFrame.this.scheduler.getCurrentSchedule(string2), TaskListFrame.this.scheduler.getCurrentAction(string2), TaskListFrame.this.scheduler.getCurrentStatusText(string2), TaskListFrame.this.getRecalculateSchedules(task), n2);
                        this.restoreSelectedTasks(list);
                        TaskListFrame.this.updateBottomBar();
                    }
                }
            });
        }

        @Override
        public void taskMoved(final String string, final String string2, int n, final int n2) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskMetadata taskMetadata;
                    Task task;
                    if (string.equals(TaskListFrame.this.getSelectedGroup()) && (task = TaskListFrame.this.repository.getTask(string2)) != null && (taskMetadata = TaskListFrame.this.repository.getTaskMetadata(task.getId())) != null) {
                        int n;
                        List list = TaskListFrame.this.getSelectedTasks();
                        int n22 = n2;
                        if (n2 > TaskListFrame.this.taskListModel.getSize()) {
                            n22 = TaskListFrame.this.taskListModel.getSize();
                        } else if (n2 < 0) {
                            n22 = 0;
                        }
                        if (n22 > TaskListFrame.this.taskListModel.indexOf(string2)) {
                            --n22;
                        }
                        if ((n = TaskListFrame.this.taskListModel.indexOf(string2)) != -1) {
                            TaskListFrame.this.taskListModel.removeTask(string2);
                            TaskListFrame.this.taskListModel.insertTaskAt(task, taskMetadata, TaskListFrame.this.repository.listScheduleMetadata(string2), TaskListFrame.this.scheduler.getCurrentSchedule(string2), TaskListFrame.this.scheduler.getCurrentAction(string2), TaskListFrame.this.scheduler.getCurrentStatusText(string2), TaskListFrame.this.getRecalculateSchedules(task), n22);
                        }
                        this.restoreSelectedTasks(list);
                        TaskListFrame.this.updateBottomBar();
                        TaskListFrame.this.validateButtonsAndMenus();
                    }
                }
            });
        }

        @Override
        public void taskRemoved(final String string, final String string2, int n) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (string.equals(TaskListFrame.this.getSelectedGroup())) {
                        List list = TaskListFrame.this.getSelectedTasks();
                        TaskListFrame.this.taskListModel.removeTask(string2);
                        this.restoreSelectedTasks(list);
                        TaskListFrame.this.updateBottomBar();
                        TaskListFrame.this.validateButtonsAndMenus();
                    }
                }
            });
        }

        @Override
        public void groupAdded(final String string, final int n) {
            if (!TaskListFrame.this.isGroupWindow()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string2 = TaskListFrame.this.getSelectedGroup();
                        int n2 = n;
                        if (n2 > TaskListFrame.this.groupListModel.size()) {
                            n2 = TaskListFrame.this.groupListModel.size();
                        } else if (n2 < 0) {
                            n2 = 0;
                        }
                        TaskListFrame.this.groupListModel.add(n2, string);
                        if (string2 != null) {
                            TaskListFrame.this.groupList.setSelectedIndex(TaskListFrame.this.groupListModel.indexOf(string2));
                        } else {
                            TaskListFrame.this.groupList.setSelectedIndex(TaskListFrame.this.groupListModel.indexOf("All tasks"));
                        }
                    }
                });
            }
        }

        @Override
        public void groupMoved(final String string, int n, final int n2) {
            if (!TaskListFrame.this.isGroupWindow()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = n2;
                        if (n > TaskListFrame.this.groupListModel.size()) {
                            n = TaskListFrame.this.groupListModel.size();
                        } else if (n < 0) {
                            n = 0;
                        }
                        if (n > TaskListFrame.this.groupListModel.indexOf(string)) {
                            --n;
                        }
                        TaskListFrame.this.groupListModel.removeElement(string);
                        TaskListFrame.this.groupListModel.add(n, string);
                        TaskListFrame.this.groupList.setSelectedIndex(n);
                    }
                });
            }
        }

        @Override
        public void groupRemoved(final String string, int n) {
            if (!TaskListFrame.this.isGroupWindow()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string2 = TaskListFrame.this.getSelectedGroup();
                        TaskListFrame.this.groupListModel.removeElement(string);
                        if (string2 != null && !string2.equals(string)) {
                            TaskListFrame.this.groupList.setSelectedIndex(TaskListFrame.this.groupListModel.indexOf(string2));
                        } else {
                            TaskListFrame.this.groupList.setSelectedIndex(TaskListFrame.this.groupListModel.indexOf("All tasks"));
                        }
                    }
                });
            }
        }
    };

    public TaskListFrame(TaskTillDawnApplicationContext taskTillDawnApplicationContext) {
        this(taskTillDawnApplicationContext, null);
    }

    protected TaskListFrame(TaskTillDawnApplicationContext taskTillDawnApplicationContext, String string) {
        super((ApplicationContext)taskTillDawnApplicationContext);
        this.setDefaultCloseOperation(2);
        this.setWindowCanFullScreen(true);
        this.scheduler = taskTillDawnApplicationContext.getApplication().getTaskScheduler();
        this.repository = taskTillDawnApplicationContext.getApplication().getTaskRepository();
        this.taskGroupManager = taskTillDawnApplicationContext.getApplication().getTaskGroupManager();
        if (string != null) {
            this.selectedGroup = string;
        } else if (!this.isGroupWindow()) {
            this.selectedGroup = this.getApplication().getPreferences().get("taskListSelectedGroup", "All tasks");
        }
        if (!taskTillDawnApplicationContext.getApplication().getTaskGroupManager().listGroups().contains(this.selectedGroup)) {
            this.selectedGroup = "All tasks";
        }
        this.viewOptions = !this.isGroupWindow() ? this.getApplication().getPreferences().getInt("group_viewOptions.All tasks", 59) : this.getApplication().getPreferences().getInt("group_viewOptions." + this.getSelectedGroup(), 59);
        this.showSidebar = this.getApplication().getPreferences().getBoolean("showSidebar", true);
        this.initUI();
    }

    private void initUI() {
        Object object;
        this.setMinimumSize(new Dimension(600, 250));
        this.setPreferredSize(new Dimension(800, 550));
        this.setSize(new Dimension(800, 550));
        this.setLayout(new BorderLayout());
        this.taskListModel = new TaskListModel();
        this.taskList = new JExtendedList((ListModel)this.taskListModel);
        this.taskScrollPane = new JScrollPane();
        this.taskScrollPane.setBorder(null);
        this.taskScrollPane.getViewport().add((Component)this.taskList);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(null);
        this.splitPane = new JExtendedSplitPane();
        this.splitPane.setDividerColor(Color.LIGHT_GRAY);
        if (this.getApplication().getPlatform() == Platform.MACOS) {
            this.splitPane.setDividerColor(TaskTillDawnConstants.SIDEBAR_COLOR_MAC);
        }
        this.splitPane.setDividerLocation((int)((float)this.getApplication().getPreferences().getInt("taskListDividerLocation", (int)this.getUIManager().getPixelsForDots(170.0f / this.getUIManager().getDPIMultiplier())) * this.getUIManager().getDPIMultiplier()));
        this.splitPane.setBorder(null);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(null);
        jPanel.setOpaque(true);
        jPanel.add((Component)jScrollPane, "Center");
        this.addGroupButton = new JButton();
        this.addGroupButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_add.png"));
        this.addGroupButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_add_pressed.png"));
        this.addGroupButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_add_disabled.png"));
        this.addGroupButton.setToolTipText(this.getLocalizedString("window.TaskListFrame.button.addGroup"));
        this.editGroupButton = new JButton();
        this.editGroupButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_edit.png"));
        this.editGroupButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_edit_pressed.png"));
        this.editGroupButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_edit_disabled.png"));
        this.editGroupButton.setToolTipText(this.getLocalizedString("window.TaskListFrame.button.editGroup"));
        this.openInWindowButton = new JButton();
        this.openInWindowButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_window.png"));
        this.openInWindowButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_window_pressed.png"));
        this.openInWindowButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_window_disabled.png"));
        this.openInWindowButton.setToolTipText(this.getLocalizedString("window.TaskListFrame.button.openInWindow"));
        this.removeGroupButton = new JButton();
        this.removeGroupButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_remove.png"));
        this.removeGroupButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_remove_pressed.png"));
        this.removeGroupButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/small_action_remove_disabled.png"));
        this.removeGroupButton.setToolTipText(this.getLocalizedString("window.TaskListFrame.button.removeGroup"));
        JToolBar jToolBar = UIUtil.createMiniToolbar((Component[])new Component[]{this.addGroupButton, this.editGroupButton, this.openInWindowButton, null, this.removeGroupButton});
        if (this.getApplication().getPlatform() == Platform.MACOS) {
            jToolBar.setBackground(TaskTillDawnConstants.SIDEBAR_COLOR_MAC);
        }
        jPanel.add((Component)jToolBar, "South");
        this.splitPane.setLeftComponent((Component)jPanel);
        this.splitPane.setRightComponent((Component)this.taskScrollPane);
        this.groupListModel = new DefaultListModel();
        this.groupList = new JExtendedList(this.groupListModel);
        jScrollPane.getViewport().add((Component)this.groupList);
        this.groupList.setBorder(null);
        this.groupList.setSelectionMode(0);
        this.groupList.setBackground(Color.WHITE);
        if (this.getApplication().getPlatform() == Platform.MACOS) {
            this.groupList.setBackground(TaskTillDawnConstants.SIDEBAR_COLOR_MAC);
        }
        this.groupList.setCellRenderer(new GroupListCellRenderer(this.getApplicationContext()));
        if (this.isGroupWindow()) {
            object = this.getSelectedGroup();
            if ("Last import".equals(object)) {
                object = this.getLocalizedString("application.importTaskGroup");
            }
            this.setTitle(this.getLocalizedString("window.TaskListFrame.label.group", new Object[]{object}));
            this.add(this.taskScrollPane, "Center");
        } else {
            this.setTitle(this.getLocalizedString("window.TaskListFrame.title"));
            if (this.showSidebar) {
                this.add((Component)this.splitPane, "Center");
            } else {
                this.add(this.taskScrollPane);
            }
        }
        this.taskList.setCellRenderer((ListCellRenderer)new TaskListCellRenderer(((TaskTillDawnApplicationContext)this.getApplicationContext()).getActionPackPluginManager(), (LocalizationProvider)this.getApplication(), this.getUIManager(), this.viewOptions));
        this.runButton = new JButton(this.getLocalizedString("window.TaskListFrame.button.runSelectedTasks"));
        this.runButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_run.png"));
        this.runButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_run_pressed.png"));
        this.runButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_run_disabled.png"));
        this.stopButton = new JButton(this.getLocalizedString("window.TaskListFrame.button.stopSelectedTasks"));
        this.stopButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_stop.png"));
        this.stopButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_stop_pressed.png"));
        this.stopButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_stop_disabled.png"));
        this.addButton = new JButton(this.getLocalizedString("window.TaskListFrame.button.addTask"));
        this.addButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_add.png"));
        this.addButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_add_pressed.png"));
        this.addButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_add_disabled.png"));
        this.editButton = new JButton(this.getLocalizedString("window.TaskListFrame.button.editSelectedTasks"));
        this.editButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_edit.png"));
        this.editButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_edit_pressed.png"));
        this.editButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_edit_disabled.png"));
        this.duplicateButton = new JButton(this.getLocalizedString("window.TaskListFrame.button.duplicateSelectedTasks"));
        this.duplicateButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_duplicate.png"));
        this.duplicateButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_duplicate_pressed.png"));
        this.duplicateButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_duplicate_disabled.png"));
        this.viewLogButton = new JButton(this.getLocalizedString("window.TaskListFrame.button.viewLog"));
        this.viewLogButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_view_log.png"));
        this.viewLogButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_view_log_pressed.png"));
        this.viewLogButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_view_log_disabled.png"));
        this.removeButton = new JButton(this.getLocalizedString("window.TaskListFrame.button.removeSelectedTasks"));
        this.removeButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_remove.png"));
        this.removeButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_remove_pressed.png"));
        this.removeButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_remove_disabled.png"));
        this.donateButton = new JButton(this.getLocalizedString("window.TaskListFrame.button.donate"));
        this.donateButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_donate.png"));
        this.donateButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_donate_pressed.png"));
        this.donateButton.setDisabledIcon(ImageBuilder.buildFor((String)"/resources/images/buttons/action_donate_disabled.png"));
        if (this.isGroupWindow() && this.getSelectedGroup().equals("Last import")) {
            UIUtil.addToolBar((AbstractApplicationWindow)this, (Component[])new Component[]{this.runButton, this.stopButton, null, this.editButton, this.viewLogButton, Box.createHorizontalGlue(), this.donateButton});
        } else {
            UIUtil.addToolBar((AbstractApplicationWindow)this, (Component[])new Component[]{this.runButton, this.stopButton, null, this.addButton, this.editButton, this.duplicateButton, this.viewLogButton, null, this.removeButton, Box.createHorizontalGlue(), this.donateButton});
        }
        if (this.getApplication().getPlatform() != Platform.MACOS) {
            this.runButton.setToolTipText(this.getLocalizedString("window.TaskListFrame.button.runSelectedTasks.tooltip"));
            this.stopButton.setToolTipText(this.getLocalizedString("window.TaskListFrame.button.stopSelectedTasks.tooltip"));
            this.addButton.setToolTipText(this.getLocalizedString("window.TaskListFrame.button.addTask.tooltip"));
            this.editButton.setToolTipText(this.getLocalizedString("window.TaskListFrame.button.editSelectedTasks.tooltip"));
            this.duplicateButton.setToolTipText(this.getLocalizedString("window.TaskListFrame.button.duplicateSelectedTasks.tooltip"));
            this.viewLogButton.setToolTipText(this.getLocalizedString("window.TaskListFrame.button.viewLog.tooltip"));
            this.removeButton.setToolTipText(this.getLocalizedString("window.TaskListFrame.button.removeSelectedTasks.tooltip"));
            this.donateButton.setToolTipText(this.getLocalizedString("window.TaskListFrame.button.donate.tooltip"));
        }
        this.bottomBarStatusLabel = new JLabel("");
        this.bottomBarStatusLabel.setFont(this.getUIManager().getFont(UIManager.FontSize.SMALL));
        this.initPopupMenu();
        object = new JPanel();
        this.enableMouseDragging((Component)object);
        ((JComponent)object).setBorder(BorderFactory.createMatteBorder(this.getUIManager().getPixelsForDots(1), 0, 0, 0, Color.LIGHT_GRAY));
        ((Container)object).add(this.bottomBarStatusLabel);
        this.add((Component)object, "South");
        this.addListeners();
        this.addTransferHandlers();
        List<String> list = this.taskGroupManager.listGroups();
        for (String string : list) {
            this.groupListModel.addElement(string);
            if (!string.equals(this.getSelectedGroup())) continue;
            this.groupList.setSelectedIndex(this.groupListModel.indexOf(string));
        }
        this.groupSelectionChanged(this.getSelectedGroup(), true, false);
        this.updateBottomBar();
        this.validateButtonsAndMenus();
    }

    private void initPopupMenu() {
        this.taskPopupMenu = new JPopupMenu();
        this.runMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.runSelectedTasks"));
        this.stopMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.stopSelectedTasks"));
        this.addMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.addTask"));
        this.editMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.editSelectedTasks"));
        this.duplicateMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.duplicateSelectedTasks"));
        this.viewLogMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.viewLog"));
        this.resetCountersMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.resetCounters"));
        this.removeMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.removeSelectedTasks"));
        this.disableMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.disableSelectedTasks"));
        this.enableMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.enableSelectedTasks"));
        this.exportMenu = new JMenu(this.getLocalizedString("window.TaskListFrame.popupmenu.export"));
        this.exportMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.export.archive"));
        this.exportSelectedMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.export.archiveSelected"));
        this.importMenu = new JMenu(this.getLocalizedString("window.TaskListFrame.popupmenu.import"));
        this.importMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.import.archive"));
        this.viewOptionsMenu = new JMenu(this.getLocalizedString("window.TaskListFrame.popupmenu.viewOptions"));
        this.viewAllMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.viewOptions.all"));
        this.viewNoneMenuItem = new JMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.viewOptions.none"));
        this.showLargeSymbolsMenuItem = new JCheckBoxMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.viewOptions.largeSymbols"));
        this.showDescriptionMenuItem = new JCheckBoxMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.viewOptions.showDescription"));
        this.showExecutionCountMenuItem = new JCheckBoxMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.viewOptions.showExecutionCount"));
        this.showMaximumExecutionCountMenuItem = new JCheckBoxMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.viewOptions.showMaximumExecutionCount"));
        this.showSchedulesMenuItem = new JCheckBoxMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.viewOptions.showSchedules"));
        this.showTriggersMenuItem = new JCheckBoxMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.viewOptions.showTriggers"));
        this.showSidebarMenuItem = new JCheckBoxMenuItem(this.getLocalizedString("window.TaskListFrame.popupmenu.viewOptions.showSidebar"));
        if (this.isGroupWindow() && this.getSelectedGroup().equals("Last import")) {
            this.taskPopupMenu.add(this.runMenuItem);
            this.taskPopupMenu.add(this.stopMenuItem);
            this.taskPopupMenu.addSeparator();
            this.taskPopupMenu.add(this.editMenuItem);
            this.taskPopupMenu.add(this.viewLogMenuItem);
            this.taskPopupMenu.addSeparator();
            this.taskPopupMenu.add(this.resetCountersMenuItem);
            this.taskPopupMenu.addSeparator();
            this.taskPopupMenu.add(this.enableMenuItem);
            this.taskPopupMenu.add(this.disableMenuItem);
            this.taskPopupMenu.addSeparator();
            this.taskPopupMenu.add(this.viewOptionsMenu);
            this.taskPopupMenu.addSeparator();
            this.taskPopupMenu.add(this.importMenu);
            this.taskPopupMenu.add(this.exportMenu);
        } else {
            this.taskPopupMenu.add(this.runMenuItem);
            this.taskPopupMenu.add(this.stopMenuItem);
            this.taskPopupMenu.addSeparator();
            this.taskPopupMenu.add(this.addMenuItem);
            this.taskPopupMenu.addSeparator();
            this.taskPopupMenu.add(this.editMenuItem);
            this.taskPopupMenu.add(this.duplicateMenuItem);
            this.taskPopupMenu.add(this.viewLogMenuItem);
            this.taskPopupMenu.addSeparator();
            this.taskPopupMenu.add(this.resetCountersMenuItem);
            this.taskPopupMenu.addSeparator();
            this.taskPopupMenu.add(this.enableMenuItem);
            this.taskPopupMenu.add(this.disableMenuItem);
            this.taskPopupMenu.addSeparator();
            this.taskPopupMenu.add(this.removeMenuItem);
            this.taskPopupMenu.addSeparator();
            this.taskPopupMenu.add(this.viewOptionsMenu);
            this.taskPopupMenu.addSeparator();
            this.taskPopupMenu.add(this.importMenu);
            this.taskPopupMenu.add(this.exportMenu);
        }
        this.viewOptionsMenu.add(this.viewAllMenuItem);
        this.viewOptionsMenu.add(this.viewNoneMenuItem);
        this.viewOptionsMenu.addSeparator();
        this.viewOptionsMenu.add(this.showLargeSymbolsMenuItem);
        this.viewOptionsMenu.add(this.showDescriptionMenuItem);
        this.viewOptionsMenu.add(this.showExecutionCountMenuItem);
        this.viewOptionsMenu.add(this.showMaximumExecutionCountMenuItem);
        this.viewOptionsMenu.add(this.showSchedulesMenuItem);
        this.viewOptionsMenu.add(this.showTriggersMenuItem);
        if (!this.isGroupWindow()) {
            this.viewOptionsMenu.addSeparator();
            this.viewOptionsMenu.add(this.showSidebarMenuItem);
        }
        this.importMenu.add(this.importMenuItem);
        this.exportMenu.add(this.exportMenuItem);
        this.exportMenu.add(this.exportSelectedMenuItem);
    }

    private void groupSelectionChanged(String string, boolean bl, boolean bl2) {
        if (!bl && string.equals(this.getSelectedGroup())) {
            return;
        }
        this.logger.log(Level.FINER, "Group selection changed from " + this.getSelectedGroup() + " to " + string);
        if (bl2) {
            this.storeScrollPosition();
        }
        this.selectedGroup = string;
        this.taskListModel.clear();
        this.taskList.clearSelection();
        if (!"Last import".equals(this.getSelectedGroup())) {
            this.taskList.setHint(this.getLocalizedString("window.TaskListFrame.label.dragFilesAndFoldersHere"));
            this.taskList.setHintBackground(TaskTillDawnConstants.BRIGHT_AND_SHINY);
        } else {
            this.taskList.setHint("");
        }
        this.taskList.repaint();
        List<String> list = this.taskGroupManager.listTasksOfGroup(this.getSelectedGroup());
        if (list != null) {
            for (String string2 : list) {
                Task task = this.repository.getTask(string2);
                if (task == null) continue;
                TaskMetadata taskMetadata = this.repository.getTaskMetadata(string2);
                List<ScheduleMetadata> list2 = this.repository.listScheduleMetadata(string2);
                if (taskMetadata == null || list2 == null) continue;
                this.taskListModel.addTask(task, taskMetadata, list2, this.scheduler.getCurrentSchedule(string2), this.scheduler.getCurrentAction(string2), this.scheduler.getCurrentStatusText(string2), this.getRecalculateSchedules(task));
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskListFrame.this.restoreScrollPosition();
            }
        });
    }

    private Set<AbstractSchedule> getRecalculateSchedules(Task task) {
        HashSet<AbstractSchedule> hashSet = new HashSet<AbstractSchedule>();
        for (AbstractSchedule abstractSchedule : task.getSchedules()) {
            if (!this.scheduler.isRecalculating(abstractSchedule.getId())) continue;
            hashSet.add(abstractSchedule);
        }
        return hashSet;
    }

    private void addTransferHandlers() {
        try {
            this.groupList.setDragEnabled(true);
            this.groupList.setTransferHandler(this.getNewGroupListTransferHandler());
            this.taskList.setDragEnabled(true);
            this.taskList.setDropMode(DropMode.INSERT);
            this.taskList.setTransferHandler(this.getNewTaskListTransferHandler());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private TransferHandler getNewGroupListTransferHandler() throws ClassNotFoundException {
        final TaskContainerFlavor taskContainerFlavor = new TaskContainerFlavor();
        return new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                Object object = null;
                Transferable transferable = transferSupport.getTransferable();
                if (transferSupport.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        object = transferable.getTransferData(DataFlavor.stringFlavor);
                    }
                    catch (UnsupportedFlavorException | InvalidDnDOperationException | IOException exception) {
                        return false;
                    }
                }
                if (transferSupport.isDataFlavorSupported(taskContainerFlavor)) {
                    try {
                        object = transferable.getTransferData(taskContainerFlavor);
                    }
                    catch (UnsupportedFlavorException | InvalidDnDOperationException | IOException exception) {
                        return false;
                    }
                }
                if (object != null) {
                    if (object instanceof List) {
                        if (TaskListFrame.this.groupList.getDropMode() != DropMode.USE_SELECTION) {
                            TaskListFrame.this.groupList.setDropMode(DropMode.USE_SELECTION);
                        }
                        return true;
                    }
                    if (object instanceof String) {
                        if (TaskListFrame.this.groupList.getDropMode() != DropMode.INSERT) {
                            TaskListFrame.this.groupList.setDropMode(DropMode.INSERT);
                        }
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                if (!transferSupport.isDrop()) {
                    return false;
                }
                if (!transferSupport.isDataFlavorSupported(taskContainerFlavor) && !transferSupport.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    return false;
                }
                Transferable transferable = transferSupport.getTransferable();
                transferSupport.getDataFlavors();
                if (transferSupport.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        JList.DropLocation dropLocation = (JList.DropLocation)transferSupport.getDropLocation();
                        int n = dropLocation.getIndex();
                        if (n < 0) {
                            n = 0;
                        }
                        TaskListFrame.this.taskGroupManager.moveGroup(string, n);
                        return true;
                    }
                    catch (UnsupportedFlavorException | IOException exception) {
                        exception.printStackTrace();
                    }
                } else if (transferSupport.isDataFlavorSupported(taskContainerFlavor) && !"Last import".equals(TaskListFrame.this.getSelectedGroup())) {
                    try {
                        List list = (List)transferable.getTransferData(taskContainerFlavor);
                        boolean bl = false;
                        for (TaskContainer taskContainer : list) {
                            if (TaskListFrame.this.taskGroupManager.indexOfTask(TaskListFrame.this.getSelectedGroup(), taskContainer.getTask().getId()) != -1) continue;
                            try {
                                TaskListFrame.this.taskGroupManager.addTask(TaskListFrame.this.getSelectedGroup(), taskContainer.getTask().getId());
                                bl = true;
                            }
                            catch (NameTooLongException nameTooLongException) {}
                        }
                        return bl;
                    }
                    catch (UnsupportedFlavorException | IOException exception) {
                        exception.printStackTrace();
                    }
                }
                return false;
            }

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 1;
            }

            @Override
            protected Transferable createTransferable(JComponent jComponent) {
                JList jList = (JList)jComponent;
                return new StringSelection((String)jList.getSelectedValue());
            }
        };
    }

    private TransferHandler getNewTaskListTransferHandler() throws ClassNotFoundException {
        final TaskContainerFlavor taskContainerFlavor = new TaskContainerFlavor();
        return new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                return !TaskListFrame.this.taskPopupMenu.isVisible() && (transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || transferSupport.isDataFlavorSupported(taskContainerFlavor));
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                if (!transferSupport.isDrop()) {
                    return false;
                }
                if (!transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && !transferSupport.isDataFlavorSupported(taskContainerFlavor)) {
                    return false;
                }
                JList.DropLocation dropLocation = (JList.DropLocation)transferSupport.getDropLocation();
                int n = dropLocation.getIndex();
                if (n < 0) {
                    n = 0;
                }
                if (transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    if (!"Last import".equals(TaskListFrame.this.getSelectedGroup())) {
                        Transferable transferable = transferSupport.getTransferable();
                        try {
                            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                            return TaskListFrame.this.importFiles(list, n);
                        }
                        catch (UnsupportedFlavorException | IOException exception) {
                            exception.printStackTrace();
                        }
                    }
                    return false;
                }
                Transferable transferable = transferSupport.getTransferable();
                try {
                    List list = (List)transferable.getTransferData(taskContainerFlavor);
                    return this.moveTasks(list, n);
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    exception.printStackTrace();
                    return false;
                }
            }

            private boolean moveTasks(List<TaskContainer> list, int n) {
                for (TaskContainer taskContainer : list) {
                    if (TaskListFrame.this.taskGroupManager.indexOfTask(TaskListFrame.this.getSelectedGroup(), taskContainer.getTask().getId()) == -1) {
                        if ("Last import".equals(TaskListFrame.this.getSelectedGroup())) {
                            return false;
                        }
                        TaskListFrame.this.taskGroupManager.insertTaskQuietly(TaskListFrame.this.getSelectedGroup(), taskContainer.getTask().getId(), n);
                    } else {
                        TaskListFrame.this.taskGroupManager.moveTask(TaskListFrame.this.getSelectedGroup(), taskContainer.getTask().getId(), n);
                    }
                    if (n > TaskListFrame.this.taskGroupManager.indexOfTask(TaskListFrame.this.getSelectedGroup(), taskContainer.getTask().getId())) continue;
                    ++n;
                }
                return true;
            }

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 2;
            }

            @Override
            protected Transferable createTransferable(JComponent jComponent) {
                JList jList = (JList)jComponent;
                List<TaskContainer> list = jList.getSelectedValuesList();
                return new TransferableTaskWrapper(list);
            }
        };
    }

    private boolean importFiles(List<File> list, int n) {
        HashMap hashMap = new HashMap();
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (File serializable2 : list) {
            if (serializable2.getName().endsWith(".ttdta")) {
                arrayList.add(serializable2);
                continue;
            }
            arrayList2.add(serializable2.getPath());
        }
        if (!arrayList.isEmpty()) {
            ((TaskTillDawnApplicationContext)this.getApplicationContext()).getApplication().handleImportTaskArchives(arrayList);
        }
        if (arrayList2.isEmpty()) {
            return true;
        }
        hashMap.put("files", arrayList2);
        ArrayList arrayList3 = new ArrayList();
        arrayList3.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.SpecifyFilesAction").withOutput(new Action.ActionVariable(this.getLocalizedString("window.TaskListFrame.label.filesAndFoldersToOpen"), List.class.getCanonicalName() + "<" + File.class.getCanonicalName() + ">")).withConfiguration(new ImmutableHashMap<String, Object>(hashMap)).build());
        hashMap = new HashMap();
        arrayList3.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.OpenFilesAction").withInput1(new Action.ConvertibleVariable(this.getLocalizedString("window.TaskListFrame.label.filesAndFoldersToOpen"), List.class.getCanonicalName() + "<" + File.class.getCanonicalName() + ">")).withConfiguration(new ImmutableHashMap<String, Object>(hashMap)).build());
        HashMap hashMap2 = new HashMap();
        hashMap2.put("Start", new ImmutableArrayList(arrayList3));
        ArrayList<ManualSchedule> arrayList4 = new ArrayList<ManualSchedule>();
        arrayList4.add(new ManualSchedule.ManualScheduleBuilder().withId(this.repository.nextId()).withCreationDate(new Date()).withChangeDate(new Date()).build());
        Task.TaskBuilder taskBuilder = new Task.TaskBuilder().withId(this.repository.nextId()).withName(this.getLocalizedString("window.TaskListFrame.label.taskOpeningFiles", new Object[]{list.size()})).withActions(new ImmutableHashMap<String, ImmutableArrayList<Action>>(hashMap2)).withCreated(new Date()).withChanged(new Date()).withSchedules(new ImmutableArrayList<AbstractSchedule>(arrayList4));
        Task task = taskBuilder.build();
        TaskMetadata.TaskMetadataBuilder taskMetadataBuilder = new TaskMetadata.TaskMetadataBuilder().withTaskEnabled(true).withTaskId(task.getId());
        TaskMetadata taskMetadata = taskMetadataBuilder.build();
        this.repository.addTask(task, taskMetadata);
        for (int i = 0; i < 10 && this.taskGroupManager.indexOfTask("All tasks", task.getId()) == -1; ++i) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (this.getSelectedGroup().equals("All tasks")) {
            this.taskGroupManager.moveTask(this.getSelectedGroup(), task.getId(), n);
        } else {
            this.taskGroupManager.insertTaskQuietly(this.getSelectedGroup(), task.getId(), n);
        }
        return true;
    }

    private void addListeners() {
        this.scheduler.addTaskEventListener(this.taskEventListener);
        this.scheduler.addTaskSchedulerListener(this.taskSchedulerListener);
        this.taskGroupManager.addTaskGroupEventListener(this.taskGroupEventListener);
        this.repository.addTaskRepositoryEventListener(this.taskRepositoryEventListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                TaskListFrame.this.validateButtonsAndMenus();
                TaskListFrame.this.restoreScrollPosition();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                TaskListFrame.this.repository.removeTaskRepositoryEventListener(TaskListFrame.this.taskRepositoryEventListener);
                TaskListFrame.this.scheduler.removeTaskEventListener(TaskListFrame.this.taskEventListener);
                TaskListFrame.this.scheduler.removeTaskSchedulerListener(TaskListFrame.this.taskSchedulerListener);
                TaskListFrame.this.taskGroupManager.removeTaskGroupEventListener(TaskListFrame.this.taskGroupEventListener);
                TaskListCellRenderer taskListCellRenderer = (TaskListCellRenderer)TaskListFrame.this.taskList.getCellRenderer();
                taskListCellRenderer.dispose();
                if (!TaskListFrame.this.isGroupWindow() && TaskListFrame.this.showSidebar) {
                    TaskListFrame.this.getApplication().getPreferences().putInt("taskListDividerLocation", (int)((float)TaskListFrame.this.splitPane.getDividerLocation() / TaskListFrame.this.getUIManager().getDPIMultiplier()));
                }
                TaskListFrame.this.storeScrollPosition();
                if (!TaskListFrame.this.isGroupWindow()) {
                    TaskListFrame.this.storeSelectedGroup();
                }
            }
        });
        ActionListener actionListener = actionEvent -> this.runSelectedTasks();
        ActionListener actionListener2 = actionEvent -> this.stopSelectedTasks();
        ActionListener actionListener3 = actionEvent -> ((TaskTillDawnApplicationContext)this.getApplicationContext()).getApplication().handleNewTask();
        ActionListener actionListener4 = actionEvent -> this.editSelectedTasks();
        ActionListener actionListener5 = actionEvent -> this.duplicateSelectedTasks();
        ActionListener actionListener6 = actionEvent -> this.resetCountersOfSelectedTasks();
        ActionListener actionListener7 = actionEvent -> this.enableSelectedTasks();
        ActionListener actionListener8 = actionEvent -> this.disableSelectedTasks();
        ActionListener actionListener9 = actionEvent -> this.showTaskRemovalConfirmationDialog();
        ActionListener actionListener10 = actionEvent -> this.viewLog();
        ActionListener actionListener11 = actionEvent -> ((TaskTillDawnApplicationContext)this.getApplicationContext()).getApplication().handleDonation();
        this.runButton.addActionListener(actionListener);
        this.runMenuItem.addActionListener(actionListener);
        this.stopButton.addActionListener(actionListener2);
        this.stopMenuItem.addActionListener(actionListener2);
        this.addButton.addActionListener(actionListener3);
        this.addMenuItem.addActionListener(actionListener3);
        this.editButton.addActionListener(actionListener4);
        this.editMenuItem.addActionListener(actionListener4);
        this.duplicateButton.addActionListener(actionListener5);
        this.duplicateMenuItem.addActionListener(actionListener5);
        this.viewLogButton.addActionListener(actionListener10);
        this.viewLogMenuItem.addActionListener(actionListener10);
        this.donateButton.addActionListener(actionListener11);
        this.resetCountersMenuItem.addActionListener(actionListener6);
        this.enableMenuItem.addActionListener(actionListener7);
        this.disableMenuItem.addActionListener(actionListener8);
        this.removeButton.addActionListener(actionListener9);
        this.removeMenuItem.addActionListener(actionListener9);
        this.viewAllMenuItem.addActionListener(actionEvent -> this.handleViewAll());
        this.viewNoneMenuItem.addActionListener(actionEvent -> this.handleViewNone());
        this.showLargeSymbolsMenuItem.addActionListener(actionEvent -> this.toggleLargeSymbols());
        this.showDescriptionMenuItem.addActionListener(actionEvent -> this.toggleShowDescription());
        this.showExecutionCountMenuItem.addActionListener(actionEvent -> this.toggleShowExecutionCount());
        this.showMaximumExecutionCountMenuItem.addActionListener(actionEvent -> this.toggleShowMaximumExecutionCount());
        this.showSchedulesMenuItem.addActionListener(actionEvent -> this.toggleShowSchedules());
        this.showTriggersMenuItem.addActionListener(actionEvent -> this.toggleShowTriggers());
        this.showSidebarMenuItem.addActionListener(actionEvent -> this.toggleSidebar());
        this.addGroupButton.addActionListener(actionEvent -> this.addGroup());
        this.editGroupButton.addActionListener(actionEvent -> this.editSelectedGroup());
        this.openInWindowButton.addActionListener(actionEvent -> this.handleOpenSelectedGroupInWindow());
        this.removeGroupButton.addActionListener(actionEvent -> this.removeSelectedGroup());
        this.importMenuItem.addActionListener(actionEvent -> ((TaskTillDawnApplicationContext)this.getApplicationContext()).getApplication().handleImportTaskArchive());
        this.exportMenuItem.addActionListener(actionEvent -> ((TaskTillDawnApplicationContext)this.getApplicationContext()).getApplication().handleExportTaskArchive());
        this.exportSelectedMenuItem.addActionListener(actionEvent -> this.exportSelectedTasks());
        this.groupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TaskListFrame.this.groupList.removeListSelectionListener(this);
                if (TaskListFrame.this.getSelectedGroup() == null || TaskListFrame.this.groupList.getSelectedIndex() == -1 || TaskListFrame.this.groupList.getSelectedIndex() > TaskListFrame.this.groupList.getModel().getSize() || TaskListFrame.this.groupList.getSelectedIndex() >= TaskListFrame.this.groupList.getModel().getSize() || TaskListFrame.this.groupList.getSelectedValue() == null) {
                    TaskListFrame.this.groupSelectionChanged("All tasks", false, false);
                    int n = TaskListFrame.this.groupList.getModel().getSize();
                    for (int i = 0; i < n; ++i) {
                        if (!"All tasks".equals(TaskListFrame.this.groupList.getModel().getElementAt(i))) continue;
                        TaskListFrame.this.groupList.setSelectedIndex(i);
                        break;
                    }
                } else {
                    TaskListFrame.this.groupSelectionChanged((String)TaskListFrame.this.groupList.getSelectedValue(), false, true);
                }
                TaskListFrame.this.validateButtonsAndMenus();
                TaskListFrame.this.updateBottomBar();
                TaskListFrame.this.groupList.addListSelectionListener(this);
            }
        });
        this.groupList.addMouseListener((MouseListener)new JExtendedMouseAdapter(this.getPlatform()){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    TaskListFrame.this.handleOpenSelectedGroupInWindow();
                }
            }
        });
        this.taskList.addListSelectionListener(listSelectionEvent -> {
            this.validateButtonsAndMenus();
            this.updateBottomBar();
        });
        this.taskList.addMouseListener((MouseListener)new JExtendedMouseAdapter(this.getPlatform()){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    int n = TaskListFrame.this.taskList.locationToIndex(mouseEvent.getPoint());
                    if (n != -1) {
                        int[] nArray;
                        boolean bl = false;
                        for (int n2 : nArray = TaskListFrame.this.taskList.getSelectedIndices()) {
                            if (n2 != n) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            TaskListFrame.this.taskList.setSelectedIndex(n);
                        }
                    } else {
                        TaskListFrame.this.taskList.clearSelection();
                    }
                    TaskListFrame.this.taskPopupMenu.show((Component)TaskListFrame.this.taskList, mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 0 && mouseEvent.getClickCount() % 2 == 0 && TaskListFrame.this.taskList.getSelectedIndices().length > 0) {
                    if (TaskListFrame.this.getPreferences().getBoolean("editTaskOnDoubleClick", true)) {
                        TaskListFrame.this.editSelectedTasks();
                    } else {
                        TaskListFrame.this.runSelectedTasks();
                    }
                }
            }
        });
    }

    private void storeSelectedGroup() {
        Preferences preferences = this.getApplication().getPreferences();
        preferences.put("taskListSelectedGroup", this.getSelectedGroup());
    }

    protected void restoreScrollPosition() {
        Preferences preferences = this.getApplication().getPreferences();
        this.taskScrollPane.getHorizontalScrollBar().setValue(preferences.getInt("taskList_scrollPositionHorizontal." + this.getSelectedGroup(), 0) * (int)this.getUIManager().getDPIMultiplier());
        this.taskScrollPane.getVerticalScrollBar().setValue(preferences.getInt("taskList_scrollPositionVertical." + this.getSelectedGroup(), 0) * (int)this.getUIManager().getDPIMultiplier());
    }

    protected void storeScrollPosition() {
        Preferences preferences = this.getApplication().getPreferences();
        preferences.putInt("taskList_scrollPositionHorizontal." + this.getSelectedGroup(), (int)((float)this.taskScrollPane.getHorizontalScrollBar().getValue() / this.getUIManager().getDPIMultiplier()));
        preferences.putInt("taskList_scrollPositionVertical." + this.getSelectedGroup(), (int)((float)this.taskScrollPane.getVerticalScrollBar().getValue() / this.getUIManager().getDPIMultiplier()));
    }

    private void showTaskConfigurationWindow(Task task, boolean bl) {
        TaskConfigurationFrame taskConfigurationFrame2;
        UIManager uIManager = this.getUIManager();
        List list = uIManager.getRegisteredApplicationWindows(TaskConfigurationFrame.class);
        for (TaskConfigurationFrame taskConfigurationFrame2 : list) {
            if (!taskConfigurationFrame2.getTask().getId().equals(task.getId())) continue;
            uIManager.showWindow((AbstractApplicationWindow)taskConfigurationFrame2);
            return;
        }
        AbstractApplicationWindow abstractApplicationWindow = uIManager.getLastRegisteredApplicationWindow(TaskConfigurationFrame.class);
        taskConfigurationFrame2 = new TaskConfigurationFrame((TaskTillDawnApplicationContext)this.getApplicationContext(), task, this.getSelectedGroup(), bl);
        uIManager.registerApplicationWindow((AbstractApplicationWindow)taskConfigurationFrame2);
        if (abstractApplicationWindow == null) {
            uIManager.showWindow((AbstractApplicationWindow)taskConfigurationFrame2);
        } else {
            int n = abstractApplicationWindow.getX();
            int n2 = abstractApplicationWindow.getY();
            int n3 = abstractApplicationWindow.getWidth();
            int n4 = abstractApplicationWindow.getHeight();
            taskConfigurationFrame2.setLocation(n + this.getUIManager().getPixelsForDots(20), n2 + this.getUIManager().getPixelsForDots(20));
            taskConfigurationFrame2.setSize((int)((float)n3 / this.getUIManager().getDPIMultiplier()), (int)((float)n4 / this.getUIManager().getDPIMultiplier()));
            uIManager.showWindow((AbstractApplicationWindow)taskConfigurationFrame2, false);
        }
    }

    private void handleOpenSelectedGroupInWindow() {
        if (this.groupList.getSelectedIndices().length > 0 && !this.getSelectedGroup().equals("All tasks")) {
            ((TaskTillDawnApplicationContext)this.getApplicationContext()).getApplication().handleOpenGroupWindow(this.getSelectedGroup());
        }
    }

    private void validateButtonsAndMenus() {
        UIManager uIManager = this.getUIManager();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        if (this.getSelectedGroup() == null || this.getSelectedGroup().equals("All tasks")) {
            this.editGroupButton.setEnabled(false);
            this.openInWindowButton.setEnabled(false);
            this.removeGroupButton.setEnabled(false);
        } else if (this.getSelectedGroup().equals("Last import")) {
            this.editGroupButton.setEnabled(false);
            this.openInWindowButton.setEnabled(true);
            this.removeGroupButton.setEnabled(true);
        } else {
            this.editGroupButton.setEnabled(true);
            this.openInWindowButton.setEnabled(true);
            this.removeGroupButton.setEnabled(true);
        }
        List<Task> list = this.getSelectedTasks();
        if (!list.isEmpty()) {
            boolean bl12 = true;
            boolean bl13 = false;
            boolean bl14 = true;
            boolean bl15 = true;
            for (Task task : list) {
                TaskMetadata taskMetadata = this.repository.getTaskMetadata(task.getId());
                if (taskMetadata != null) {
                    if (taskMetadata.isTaskEnabled()) {
                        bl14 = false;
                    } else {
                        bl15 = false;
                    }
                }
                if (this.scheduler.isExecuting(task.getId())) {
                    bl13 = true;
                    continue;
                }
                bl12 = false;
            }
            if (bl13) {
                bl2 = true;
            }
            bl = !bl12;
            bl4 = true;
            bl5 = true;
            bl6 = true;
            bl7 = !bl15;
            bl8 = !bl14;
            bl9 = true;
            bl10 = true;
            bl11 = true;
        }
        if (this.getSelectedGroup().equals("Last import")) {
            bl3 = false;
            bl5 = false;
            bl9 = false;
        }
        if (this.isVisible()) {
            if (!this.isGroupWindow()) {
                uIManager.setMenuItemEnabled((MenuContainer)this, "menu.file.newGroup", true);
            }
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.file.export.archiveSelected", bl11);
            this.exportSelectedMenuItem.setEnabled(bl11);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.edit.selectAll", true);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.view.all", true);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.view.none", true);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.view.largeSymbols", true);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.view.showDescription", true);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.view.showExecutionCount", true);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.view.showMaximumExecutionCount", true);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.view.showSchedules", true);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.view.showTriggers", true);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.view.showSidebar", !this.isGroupWindow());
            this.showSidebarMenuItem.setEnabled(!this.isGroupWindow());
            this.showLargeSymbolsMenuItem.setSelected((this.viewOptions & 1) > 0);
            this.showDescriptionMenuItem.setSelected((this.viewOptions & 2) > 0);
            this.showExecutionCountMenuItem.setSelected((this.viewOptions & 4) > 0);
            this.showMaximumExecutionCountMenuItem.setSelected((this.viewOptions & 8) > 0);
            this.showSchedulesMenuItem.setSelected((this.viewOptions & 0x10) > 0);
            this.showTriggersMenuItem.setSelected((this.viewOptions & 0x20) > 0);
            this.showSidebarMenuItem.setSelected(!this.isGroupWindow() && this.showSidebar);
            uIManager.setMenuItemChecked((MenuContainer)this, "menu.view.largeSymbols", (this.viewOptions & 1) > 0);
            uIManager.setMenuItemChecked((MenuContainer)this, "menu.view.showDescription", (this.viewOptions & 2) > 0);
            uIManager.setMenuItemChecked((MenuContainer)this, "menu.view.showExecutionCount", (this.viewOptions & 4) > 0);
            uIManager.setMenuItemChecked((MenuContainer)this, "menu.view.showMaximumExecutionCount", (this.viewOptions & 8) > 0);
            uIManager.setMenuItemChecked((MenuContainer)this, "menu.view.showSchedules", (this.viewOptions & 0x10) > 0);
            uIManager.setMenuItemChecked((MenuContainer)this, "menu.view.showTriggers", (this.viewOptions & 0x20) > 0);
            uIManager.setMenuItemChecked((MenuContainer)this, "menu.view.showSidebar", !this.isGroupWindow() && this.showSidebar);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.task.runSelectedTasks", bl);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.task.stopSelectedTasks", bl2);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.file.newTask", bl3);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.task.editSelectedTasks", bl4);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.task.duplicateSelectedTasks", bl5);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.task.viewLog", bl10);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.task.resetCountersOfSelectedTasks", bl6);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.task.enableSelectedTasks", bl7);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.task.disableSelectedTasks", bl8);
            uIManager.setMenuItemEnabled((MenuContainer)this, "menu.task.removeSelectedTasks", bl9);
        }
        this.runButton.setEnabled(bl);
        this.runMenuItem.setEnabled(bl);
        this.stopButton.setEnabled(bl2);
        this.stopMenuItem.setEnabled(bl2);
        this.addButton.setEnabled(bl3);
        this.addMenuItem.setEnabled(bl3);
        this.editButton.setEnabled(bl4);
        this.editMenuItem.setEnabled(bl4);
        this.duplicateButton.setEnabled(bl5);
        this.duplicateMenuItem.setEnabled(bl5);
        this.viewLogButton.setEnabled(bl10);
        this.viewLogMenuItem.setEnabled(bl10);
        this.resetCountersMenuItem.setEnabled(bl6);
        this.enableMenuItem.setEnabled(bl7);
        this.disableMenuItem.setEnabled(bl8);
        this.removeButton.setEnabled(bl9);
        this.removeMenuItem.setEnabled(bl9);
    }

    private void updateBottomBar() {
        int n = this.taskListModel.getSize();
        int n2 = this.taskList.getSelectedIndices().length;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scheduler.isPaused()) {
            this.bottomBarStatusLabel.setIcon(ImageBuilder.buildFor((String)"/resources/tasklist_warning.png"));
            stringBuilder.append(this.getLocalizedString("window.TaskListFrame.bottomBar.schedulerDisabled"));
            stringBuilder.append(" \u2022 ");
        } else {
            this.bottomBarStatusLabel.setIcon(ImageBuilder.buildFor((String)"/resources/tasklist_none.png"));
        }
        if (n == 0) {
            stringBuilder.append(this.getLocalizedString("window.TaskListFrame.bottomBar.noTasks"));
        } else if (n == 1) {
            stringBuilder.append(this.getLocalizedString("window.TaskListFrame.bottomBar.oneTask", new Object[]{n}));
        } else {
            stringBuilder.append(this.getLocalizedString("window.TaskListFrame.bottomBar.multipleTasks", new Object[]{n}));
        }
        if (n2 > 0) {
            stringBuilder.append(", ");
            if (n2 == 1) {
                stringBuilder.append(this.getLocalizedString("window.TaskListFrame.bottomBar.oneTaskSelected", new Object[]{n2}));
            } else {
                stringBuilder.append(this.getLocalizedString("window.TaskListFrame.bottomBar.multipleTasksSelected", new Object[]{n2}));
            }
        }
        this.bottomBarStatusLabel.setText(stringBuilder.toString());
    }

    public void editSelectedTasks() {
        List<Task> list = this.getSelectedTasks();
        for (Task task : list) {
            this.showTaskConfigurationWindow(task, true);
        }
    }

    public void resetCountersOfSelectedTasks() {
        List<Task> list = this.getSelectedTasks();
        for (Task task : list) {
            this.repository.updateTaskMetadata(task.getId(), new TaskRepository.TaskMetadataUpdater(){

                @Override
                public TaskMetadata updateTaskMetadata(TaskMetadata taskMetadata) {
                    return new TaskMetadata.TaskMetadataBuilder(taskMetadata).withSuccessfulExecutionCount(BigInteger.ZERO).withTotalExecutionCount(BigInteger.ZERO).build();
                }
            });
        }
    }

    public void exportSelectedTasks() {
        ((TaskTillDawnApplicationContext)this.getApplicationContext()).getApplication().handleExportTaskArchive(this.getSelectedTasks());
    }

    public void duplicateSelectedTasks() {
        List<Task> list = this.getSelectedTasks();
        Date date = new Date();
        for (Task task : list) {
            ArrayList<AbstractSchedule> arrayList = new ArrayList<AbstractSchedule>();
            for (AbstractSchedule abstractSchedule : task.getSchedules()) {
                Object object;
                if (abstractSchedule instanceof ManualSchedule) {
                    arrayList.add(new ManualSchedule.ManualScheduleBuilder().withId(this.repository.nextId()).withCreationDate(date).withChangeDate(date).build());
                    continue;
                }
                if (abstractSchedule instanceof IntervalSchedule) {
                    object = new IntervalSchedule.IntervalScheduleBuilder().withId(this.repository.nextId()).withCreationDate(date).withChangeDate(date).withDayOfMonth(((IntervalSchedule)abstractSchedule).getDayOfMonth()).withWeekdays(((IntervalSchedule)abstractSchedule).getWeekdays()).withIntervalInSeconds(((IntervalSchedule)abstractSchedule).getIntervalInSeconds()).withIntervalStart(((IntervalSchedule)abstractSchedule).getIntervalStart()).withIntervalEnd(((IntervalSchedule)abstractSchedule).getIntervalEnd()).withValidFrom(abstractSchedule.getValidFrom()).withValidUntil(abstractSchedule.getValidUntil()).withSkipIfMissed(((IntervalSchedule)abstractSchedule).isSkipIfMissed());
                    arrayList.add(((IntervalSchedule.IntervalScheduleBuilder)object).build());
                    continue;
                }
                if (abstractSchedule instanceof TimeSchedule) {
                    object = new TimeSchedule.TimeScheduleBuilder().withId(this.repository.nextId()).withCreated(date).withChanged(date).withDayOfMonth(((TimeSchedule)abstractSchedule).getDayOfMonth()).withWeekdays(((TimeSchedule)abstractSchedule).getWeekdays()).withSpecifiedTime(((TimeSchedule)abstractSchedule).getSpecifiedTime()).withValidFrom(abstractSchedule.getValidFrom()).withValidUntil(abstractSchedule.getValidUntil()).withSkipIfMissed(((TimeSchedule)abstractSchedule).isSkipIfMissed());
                    arrayList.add(((TimeSchedule.TimeScheduleBuilder)object).build());
                    continue;
                }
                if (abstractSchedule instanceof Trigger) {
                    try {
                        object = abstractSchedule.getClass().getConstructor(String.class, Date.class, Date.class, Date.class, Date.class);
                        arrayList.add((AbstractSchedule)((Constructor)object).newInstance(this.repository.nextId(), date, date, null, null));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                this.logger.log(Level.WARNING, "Schedule with id " + abstractSchedule.getId() + " is of an unknown type!");
                arrayList.add(new UnknownSchedule(abstractSchedule.getId(), abstractSchedule.getCreated(), abstractSchedule.getChanged(), abstractSchedule.getValidFrom(), abstractSchedule.getValidUntil()));
            }
            Task.TaskBuilder taskBuilder = new Task.TaskBuilder(task).withId(this.repository.nextId()).withCreated(date).withChanged(date).withSchedules(new ImmutableArrayList<AbstractSchedule>(arrayList)).withName(task.getName() + " " + this.getLocalizedString("window.TaskListFrame.task.copyTitle"));
            this.showTaskConfigurationWindow(taskBuilder.build(), false);
        }
    }

    public void handleSelectAll() {
        int n = 0;
        int n2 = this.taskList.getModel().getSize() - 1;
        if (n2 >= 0) {
            this.taskList.setSelectionInterval(n, n2);
        }
    }

    public void showTaskRemovalConfirmationDialog() {
        if (this.getSelectedGroup().equals("All tasks")) {
            JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.warning"), (Object)this.getLocalizedString("window.TaskListFrame.message.reallyRemoveSelectedTasks"), 3);
            Object[] objectArray = new Object[]{this.getLocalizedString("common.button.ok"), this.getLocalizedString("common.button.cancel")};
            jExtendedDialog.setOptions(objectArray);
            jExtendedDialog.setInitialValue(objectArray[1]);
            Object object = jExtendedDialog.showDialog((Component)((Object)this));
            if (object != null && object.equals(this.getLocalizedString("common.button.ok"))) {
                this.removeSelectedTasks();
            }
        } else {
            this.removeSelectedTasks();
        }
    }

    private List<Task> getSelectedTasks() {
        int[] nArray = this.taskList.getSelectedIndices();
        ArrayList<Task> arrayList = new ArrayList<Task>(nArray.length);
        for (int n : nArray) {
            TaskContainer taskContainer;
            if (n < 0 || n >= this.taskListModel.getSize() || (taskContainer = this.taskListModel.getElementAt(n)) == null) continue;
            arrayList.add(taskContainer.getTask());
        }
        return arrayList;
    }

    public boolean isGroupWindow() {
        return this instanceof GroupListFrame;
    }

    public String getSelectedGroup() {
        return this.selectedGroup;
    }

    public void enableSelectedTasks() {
        this.setSelectedTasksEnabled(true);
    }

    public void disableSelectedTasks() {
        this.setSelectedTasksEnabled(false);
    }

    public void addGroup() {
        JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("dialog.AddGroupDialog.title"), (Object)this.getLocalizedString("dialog.AddGroupDialog.message"), -1);
        Object object = jExtendedDialog.showInputDialog((Component)((Object)this));
        if (object != null && !object.toString().trim().equals("")) {
            try {
                String string = object.toString().trim();
                if (string.equals("All tasks") || string.equals("Last import")) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    this.taskGroupManager.addGroup(string);
                }
            }
            catch (NameTooLongException nameTooLongException) {
                jExtendedDialog = new JExtendedDialog(this.getLocalizedString("dialog.GroupNameTooLongDialog.title"), (Object)this.getLocalizedString("dialog.GroupNameTooLongDialog.message"), 0);
                jExtendedDialog.showDialog((Component)((Object)this));
                return;
            }
        }
    }

    public void editSelectedGroup() {
        JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("dialog.EditGroupDialog.title"), (Object)this.getLocalizedString("dialog.EditGroupDialog.message"), -1);
        String string = this.groupList.getSelectedValue();
        jExtendedDialog.setInitialSelectionValue((Object)string);
        Object object = jExtendedDialog.showInputDialog((Component)((Object)this));
        if (object != null && !object.toString().trim().equals("")) {
            String string2 = object.toString().trim();
            if (string2.equals("All tasks") || string2.equals("Last import")) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                if (this.taskGroupManager.indexOfGroup(string2) != -1 && !string.equals(string2)) {
                    jExtendedDialog = new JExtendedDialog(this.getLocalizedString("dialog.EditedGroupExistsDialog.title"), (Object)this.getLocalizedString("dialog.EditedGroupExistsDialog.message"), 3);
                    Object[] objectArray = new Object[]{this.getLocalizedString("common.button.ok"), this.getLocalizedString("common.button.cancel")};
                    jExtendedDialog.setOptions(objectArray);
                    jExtendedDialog.setInitialValue(objectArray[1]);
                    Object object2 = jExtendedDialog.showDialog((Component)((Object)this));
                    if (object2 == null || !object2.equals(this.getLocalizedString("common.button.ok"))) {
                        return;
                    }
                }
                if (!string.equals(string2)) {
                    try {
                        this.taskGroupManager.renameGroup(string, string2);
                    }
                    catch (NameTooLongException nameTooLongException) {
                        jExtendedDialog = new JExtendedDialog(this.getLocalizedString("dialog.GroupNameTooLongDialog.title"), (Object)this.getLocalizedString("dialog.GroupNameTooLongDialog.message"), 0);
                        jExtendedDialog.showDialog((Component)((Object)this));
                        return;
                    }
                }
            }
        }
    }

    public void removeSelectedGroup() {
        if (this.getSelectedGroup() != null) {
            this.taskGroupManager.removeGroup(this.groupList.getSelectedValue());
        }
    }

    private void setSelectedTasksEnabled(final boolean bl) {
        List<Task> list = this.getSelectedTasks();
        for (Task task : list) {
            this.repository.updateTaskMetadata(task.getId(), new TaskRepository.TaskMetadataUpdater(){

                @Override
                public TaskMetadata updateTaskMetadata(TaskMetadata taskMetadata) {
                    return new TaskMetadata.TaskMetadataBuilder(taskMetadata).withTaskEnabled(bl).build();
                }
            });
        }
    }

    private void removeSelectedTasks() {
        List<Task> list = this.getSelectedTasks();
        for (Task task : list) {
            if (this.getSelectedGroup().equals("All tasks")) {
                this.repository.removeTask(task.getId());
                continue;
            }
            this.taskGroupManager.removeTask(this.getSelectedGroup(), task.getId());
        }
    }

    public void runSelectedTasks() {
        List<Task> list = this.getSelectedTasks();
        for (Task task : list) {
            this.scheduler.executeTask(task.getId());
        }
    }

    public void stopSelectedTasks() {
        List<Task> list = this.getSelectedTasks();
        for (Task task : list) {
            this.scheduler.cancelTaskExecution(task.getId());
        }
    }

    public void viewLog() {
        final List<Task> list = this.getSelectedTasks();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (Task task : list) {
                    File file = ((TaskTillDawnApplicationContext)TaskListFrame.this.getApplicationContext()).getTaskLogger().getLogFileFor(task);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (TaskListFrame.this.getApplication().getPlatform() == Platform.MACOS) {
                        arrayList.add("open");
                        if (TaskListFrame.this.getApplication().isAgent()) {
                            arrayList.add("-g");
                        }
                        arrayList.add(file.getPath());
                    } else {
                        arrayList.add("rundll32");
                        arrayList.add("SHELL32.DLL,ShellExec_RunDLL");
                        arrayList.add(file.getPath());
                    }
                    ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                    processBuilder.directory(null);
                    processBuilder.redirectErrorStream(true);
                    try {
                        processBuilder.start();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void handleViewAll() {
        this.viewOptions = 63;
        this.viewOptionsUpdated();
    }

    public void toggleSidebar() {
        boolean bl = this.showSidebar = !this.showSidebar;
        if (!this.showSidebar) {
            this.getApplication().getPreferences().putInt("taskListDividerLocation", (int)((float)this.splitPane.getDividerLocation() / this.getUIManager().getDPIMultiplier()));
        }
        this.getApplication().getPreferences().putBoolean("showSidebar", this.showSidebar);
        this.setSidebarVisible(this.showSidebar);
        if (this.showSidebar) {
            this.splitPane.setDividerLocation((int)((float)this.getApplication().getPreferences().getInt("taskListDividerLocation", (int)this.getUIManager().getPixelsForDots(170.0f / this.getUIManager().getDPIMultiplier())) * this.getUIManager().getDPIMultiplier()));
        }
        this.validateButtonsAndMenus();
    }

    private void setSidebarVisible(boolean bl) {
        this.remove((Component)this.splitPane);
        this.remove(this.taskScrollPane);
        if (bl) {
            this.splitPane.setRightComponent((Component)this.taskScrollPane);
            this.add((Component)this.splitPane);
        } else {
            this.add(this.taskScrollPane);
        }
        this.splitPane.revalidate();
        this.taskScrollPane.revalidate();
        this.revalidate();
    }

    public void handleViewNone() {
        this.viewOptions = 0;
        this.viewOptionsUpdated();
    }

    public void toggleLargeSymbols() {
        this.toggleViewOption(1);
    }

    public void toggleShowDescription() {
        this.toggleViewOption(2);
    }

    public void toggleShowExecutionCount() {
        this.toggleViewOption(4);
    }

    public void toggleShowMaximumExecutionCount() {
        this.toggleViewOption(8);
    }

    public void toggleShowSchedules() {
        this.toggleViewOption(16);
    }

    public void toggleShowTriggers() {
        this.toggleViewOption(32);
    }

    private void toggleViewOption(int n) {
        this.viewOptions = (this.viewOptions & n) > 0 ? (this.viewOptions -= n) : (this.viewOptions += n);
        this.viewOptionsUpdated();
    }

    private void viewOptionsUpdated() {
        TaskListCellRenderer taskListCellRenderer = (TaskListCellRenderer)this.taskList.getCellRenderer();
        taskListCellRenderer.dispose();
        this.taskList.setCellRenderer((ListCellRenderer)new TaskListCellRenderer(((TaskTillDawnApplicationContext)this.getApplicationContext()).getActionPackPluginManager(), ((TaskTillDawnApplicationContext)this.getApplicationContext()).getLocalizationProvider(), ((TaskTillDawnApplicationContext)this.getApplicationContext()).getUIManager(), this.viewOptions));
        this.storeViewOptions();
        this.validateButtonsAndMenus();
    }

    private void storeViewOptions() {
        if (this.isGroupWindow()) {
            if (this.getSelectedGroup() != null) {
                this.getApplication().getPreferences().putInt("group_viewOptions." + this.getSelectedGroup(), this.viewOptions);
            }
        } else {
            this.getApplication().getPreferences().putInt("group_viewOptions.All tasks", this.viewOptions);
        }
    }

    private static class TaskContainerFlavor
    extends DataFlavor {
        public TaskContainerFlavor() throws ClassNotFoundException {
            super("application/x-java-jvm-local-objectref; class=de.oliver_matuschin.ttd.ui.model.TaskContainer");
        }
    }

    private static class TransferableTaskWrapper
    implements Transferable {
        private List<TaskContainer> taskContainers;

        public TransferableTaskWrapper(List<TaskContainer> list) {
            this.taskContainers = list;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.taskContainers;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            try {
                return new DataFlavor[]{new TaskContainerFlavor()};
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                return null;
            }
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return false;
        }
    }
}

