/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.frame;

import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.constant.AppConstants;
import de.oliver_matuschin.base.ui.dialog.JExtendedDialog;
import de.oliver_matuschin.base.ui.frame.AbstractApplicationWindow;
import de.oliver_matuschin.base.ui.frame.MenuContainer;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.layout.VerticalFlowLayout;
import de.oliver_matuschin.base.util.UIUtil;
import de.oliver_matuschin.ttd.action.UnknownAction;
import de.oliver_matuschin.ttd.application.TaskTillDawnApplicationContext;
import de.oliver_matuschin.ttd.collect.ImmutableArrayList;
import de.oliver_matuschin.ttd.collect.ImmutableHashMap;
import de.oliver_matuschin.ttd.group.TaskGroupManager;
import de.oliver_matuschin.ttd.group.exception.NameTooLongException;
import de.oliver_matuschin.ttd.manager.exception.UnknownActionException;
import de.oliver_matuschin.ttd.repository.TaskRepository;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.action.Action;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.IntervalSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.ManualSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.TimeSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import de.oliver_matuschin.ttd.scheduler.task.trigger.ApplicationStartedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.GraphicsDevicesAddedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.GraphicsDevicesChangedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.GraphicsDevicesRemovedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.ScreenAboutToSleepTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.ScreenAwokeTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.SystemAwokeTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.SystemLockedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.SystemUnlockedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.TaskExecutionCanceledTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.TaskExecutionStartedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.TaskExecutionStoppedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.TaskTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.UserSessionActivatedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.UserSessionDeactivatedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.VolumesMountedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.VolumesUnmountedTrigger;
import de.oliver_matuschin.ttd.ui.model.ActionConfiguratorContainer;
import de.oliver_matuschin.ttd.ui.panel.ActionConfigurationPanel;
import de.oliver_matuschin.ttd.ui.panel.ScheduleConfigurationPanel;
import de.oliver_matuschin.ttd.ui.panel.TaskMetadataConfigurationPanel;
import de.oliver_matuschin.ttd.ui.panel.TriggerConfigurationPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TaskConfigurationFrame
extends AbstractApplicationWindow<TaskTillDawnApplicationContext> {
    private JButton cancelButton;
    private JButton saveButton;
    private JButton saveAndCloseButton;
    private JButton metadataButton;
    private JButton actionsButton;
    private JButton schedulesButton;
    private JButton triggersButton;
    private TaskMetadataConfigurationPanel taskMetadataConfigurationPanel;
    private ActionConfigurationPanel actionConfigurationPanel;
    private ScheduleConfigurationPanel scheduleConfigurationPanel;
    private TriggerConfigurationPanel triggerConfigurationPanel;
    private JPanel mainPanel;
    private JPanel currentPanel;
    private JPanel groupPanel1;
    private JPanel groupPanel2;
    private JPanel groupPanel3;
    private JPanel groupPanel4;
    private boolean editMode;
    private Task task;
    private TaskMetadata taskMetadata;
    private final TaskRepository repository;
    private final TaskGroupManager taskGroupManager;
    private String group;
    private static int taskCounter = 1;

    public TaskConfigurationFrame(TaskTillDawnApplicationContext taskTillDawnApplicationContext, String string) {
        this(taskTillDawnApplicationContext, null, string, false);
    }

    public TaskConfigurationFrame(TaskTillDawnApplicationContext taskTillDawnApplicationContext, Task task, String string, boolean bl) {
        super((ApplicationContext)taskTillDawnApplicationContext);
        this.repository = taskTillDawnApplicationContext.getApplication().getTaskRepository();
        this.taskGroupManager = taskTillDawnApplicationContext.getApplication().getTaskGroupManager();
        if (task == null) {
            task = new Task.TaskBuilder().withId(taskTillDawnApplicationContext.getApplication().getTaskRepository().nextId()).withName(this.getLocalizedString("window.TaskConfigurationFrame.label.untitledTask") + " " + taskCounter++).withSchedules(new ImmutableArrayList<AbstractSchedule>()).build();
        }
        this.task = task;
        this.group = string;
        TaskMetadata taskMetadata = this.repository.getTaskMetadata(task.getId());
        this.taskMetadata = taskMetadata == null ? new TaskMetadata.TaskMetadataBuilder().withTaskId(task.getId()).withTaskEnabled(true).build() : taskMetadata;
        this.editMode = bl;
        this.setDefaultCloseOperation(0);
        this.setWindowCanFullScreen(true);
        this.initUI();
    }

    public Task getTask() {
        return this.task;
    }

    private void initUI() {
        this.setMinimumSize(new Dimension(700, 600));
        this.setPreferredSize(new Dimension(900, 700));
        this.setSize(new Dimension(900, 700));
        this.updateWindowTitle();
        this.setLayout(new BorderLayout());
        this.metadataButton = new JButton();
        this.metadataButton.setText(this.getLocalizedString("window.TaskConfigurationFrame.tab.metadata"));
        this.metadataButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/tabs/tab_metadata.png"));
        this.metadataButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/tabs/tab_metadata_pressed.png"));
        this.actionsButton = new JButton();
        this.actionsButton.setText(this.getLocalizedString("window.TaskConfigurationFrame.tab.actions"));
        this.actionsButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/tabs/tab_actions.png"));
        this.actionsButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/tabs/tab_actions_pressed.png"));
        this.schedulesButton = new JButton();
        this.schedulesButton.setText(this.getLocalizedString("window.TaskConfigurationFrame.tab.schedule"));
        this.schedulesButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/tabs/tab_schedules.png"));
        this.schedulesButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/tabs/tab_schedules_pressed.png"));
        this.triggersButton = new JButton();
        this.triggersButton.setText(this.getLocalizedString("window.TaskConfigurationFrame.tab.triggers"));
        this.triggersButton.setIcon(ImageBuilder.buildFor((String)"/resources/images/tabs/tab_triggers.png"));
        this.triggersButton.setPressedIcon(ImageBuilder.buildFor((String)"/resources/images/tabs/tab_triggers_pressed.png"));
        UIUtil.addTabToolBar((AbstractApplicationWindow)this, (JButton[])new JButton[]{this.metadataButton, this.actionsButton, this.schedulesButton, this.triggersButton});
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(null);
        this.mainPanel.setBackground(AppConstants.DEFAULT_WINDOW_BACKGROUND_COLOR);
        this.groupPanel1 = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.groupPanel2 = new JPanel(new BorderLayout());
        this.groupPanel3 = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.groupPanel4 = new JPanel(new BorderLayout());
        this.groupPanel1.setOpaque(false);
        this.groupPanel2.setOpaque(false);
        this.groupPanel3.setOpaque(false);
        this.groupPanel4.setOpaque(false);
        this.groupPanel1.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(10), this.getUIManager().getPixelsForDots(20), this.getUIManager().getPixelsForDots(20), this.getUIManager().getPixelsForDots(20)));
        this.groupPanel2.setBorder(null);
        this.groupPanel3.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(10), this.getUIManager().getPixelsForDots(20), this.getUIManager().getPixelsForDots(20), this.getUIManager().getPixelsForDots(20)));
        this.groupPanel4.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(10), this.getUIManager().getPixelsForDots(0), this.getUIManager().getPixelsForDots(0), this.getUIManager().getPixelsForDots(0)));
        this.taskMetadataConfigurationPanel = new TaskMetadataConfigurationPanel((JFrame)((Object)this), this.editMode, this.getApplicationContext(), this.task, this.taskMetadata);
        this.groupPanel1.add(this.taskMetadataConfigurationPanel.getComponent());
        this.actionConfigurationPanel = new ActionConfigurationPanel((JFrame)((Object)this), (TaskTillDawnApplicationContext)this.getApplicationContext(), this.task);
        this.groupPanel2.add(this.actionConfigurationPanel.getComponent(), "Center");
        this.scheduleConfigurationPanel = new ScheduleConfigurationPanel((JFrame)((Object)this), this.getApplicationContext(), this.task);
        this.groupPanel3.add(this.scheduleConfigurationPanel.getComponent());
        this.triggerConfigurationPanel = new TriggerConfigurationPanel((TaskTillDawnApplicationContext)this.getApplicationContext(), this.task);
        this.groupPanel4.add(this.triggerConfigurationPanel.getComponent(), "Center");
        this.addButtons(this.mainPanel);
        this.add(this.mainPanel, "Center");
        this.addActionListeners();
        this.cancelButton.setFocusable(false);
        this.saveButton.setFocusable(false);
        this.saveAndCloseButton.setFocusable(false);
        if (this.editMode) {
            this.actionsButton.doClick();
        } else {
            this.metadataButton.doClick();
        }
        this.validateButtonsAndMenus();
    }

    private void updateWindowTitle() {
        if (this.editMode) {
            this.setTitle(this.getLocalizedString("window.TaskConfigurationFrame.title.edit", new Object[]{this.task.getName()}));
        } else {
            this.setTitle(this.getLocalizedString("window.TaskConfigurationFrame.title.new"));
        }
    }

    private void validateButtonsAndMenus() {
        boolean bl = this.currentPanel != null && this.currentPanel != this.groupPanel4;
        this.getUIManager().setMenuItemEnabled((MenuContainer)this, "menu.edit.cut", bl);
        this.getUIManager().setMenuItemEnabled((MenuContainer)this, "menu.edit.copy", bl);
        this.getUIManager().setMenuItemEnabled((MenuContainer)this, "menu.edit.paste", bl);
        this.getUIManager().setMenuItemEnabled((MenuContainer)this, "menu.edit.selectAll", bl);
        this.getUIManager().setMenuItemEnabled((MenuContainer)this, "menu.file.print", this.currentPanel == this.groupPanel2);
    }

    private boolean showDiscardChangesDialog() {
        Object object = this.getLocalizedString("common.button.ok");
        JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.discardChanges"), (Object)this.getLocalizedString("common.message.discardChanges"), 2);
        Object[] objectArray = new Object[]{this.getLocalizedString("common.button.ok"), this.getLocalizedString("common.button.cancel")};
        jExtendedDialog.setOptions(objectArray);
        jExtendedDialog.setInitialValue(objectArray[1]);
        object = jExtendedDialog.showDialog((Component)((Object)this));
        return object != null && object.equals(this.getLocalizedString("common.button.ok"));
    }

    public void handlePrint() {
        try {
            this.actionConfigurationPanel.handlePrint(this.getTitle());
        }
        catch (PrinterException printerException) {
            JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.error"), (Object)this.getLocalizedString("dialog.PrintJobFailedDialog.message", new Object[]{printerException.getLocalizedMessage()}), 0);
            jExtendedDialog.showDialog((Component)((Object)this));
        }
    }

    private void addActionListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (TaskConfigurationFrame.this.validateAndStoreTask()) {
                    TaskConfigurationFrame.this.dispose();
                }
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                TaskConfigurationFrame.this.actionConfigurationPanel.dispose();
            }
        });
        this.cancelButton.addActionListener(actionEvent -> {
            if (this.showDiscardChangesDialog()) {
                this.dispose();
            }
        });
        this.saveButton.addActionListener(actionEvent -> this.validateAndStoreTask());
        this.saveAndCloseButton.addActionListener(actionEvent -> {
            if (this.validateAndStoreTask()) {
                this.dispose();
            }
        });
        this.metadataButton.addActionListener(actionEvent -> this.switchToTab(0));
        this.actionsButton.addActionListener(actionEvent -> this.switchToTab(1));
        this.schedulesButton.addActionListener(actionEvent -> this.switchToTab(2));
        this.triggersButton.addActionListener(actionEvent -> this.switchToTab(3));
    }

    private void switchToTab(int n) {
        if (this.currentPanel != null) {
            this.mainPanel.remove(this.currentPanel);
        }
        switch (n) {
            default: {
                this.currentPanel = this.groupPanel1;
                break;
            }
            case 1: {
                this.currentPanel = this.groupPanel2;
                break;
            }
            case 2: {
                this.currentPanel = this.groupPanel3;
                break;
            }
            case 3: {
                this.currentPanel = this.groupPanel4;
            }
        }
        this.mainPanel.add((Component)this.currentPanel, "Center");
        this.mainPanel.updateUI();
        this.validateButtonsAndMenus();
    }

    private void addButtons(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.setOpaque(false);
        this.cancelButton = new JButton(this.getLocalizedString("common.button.cancel"));
        this.saveButton = new JButton(this.getLocalizedString("common.button.save"));
        this.saveAndCloseButton = new JButton(this.getLocalizedString("window.TaskConfigurationFrame.button.saveAndClose"));
        jPanel2.add(this.cancelButton);
        jPanel2.add(this.saveButton);
        jPanel2.add(this.saveAndCloseButton);
        jPanel.add((Component)jPanel2, "South");
    }

    private AbstractSchedule getScheduleForTask(Class<? extends AbstractSchedule> clazz) {
        for (AbstractSchedule abstractSchedule : this.task.getSchedules()) {
            if (abstractSchedule.getClass() != clazz) continue;
            return abstractSchedule;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean validateAndStoreTask() {
        void var11_14;
        Object object;
        Object object2;
        ImmutableHashMap<String, Object> immutableHashMap;
        Object object3;
        Object object4;
        Object object6;
        Object[] objectArray;
        Date date;
        if (!this.taskMetadataConfigurationPanel.validate(this.repository.getTaskMetadata(this.task.getId()))) {
            this.metadataButton.doClick();
            this.taskMetadataConfigurationPanel.setTaskNameFocused();
            return false;
        }
        if (!this.actionConfigurationPanel.validate()) {
            this.actionsButton.doClick();
            return false;
        }
        if (!this.scheduleConfigurationPanel.validate()) {
            this.schedulesButton.doClick();
            return false;
        }
        if (!this.triggerConfigurationPanel.validate()) {
            this.triggersButton.doClick();
            return false;
        }
        if (this.editMode && this.repository.getTask(this.task.getId()) == null) {
            date = new JExtendedDialog(this.getLocalizedString("common.title.error"), (Object)this.getLocalizedString("window.TaskConfigurationFrame.message.taskNoLongerExists"), 0);
            objectArray = new Object[]{this.getLocalizedString("common.button.ok"), this.getLocalizedString("common.button.cancel")};
            date.setOptions(objectArray);
            date.setInitialValue(objectArray[1]);
            object6 = date.showDialog((Component)((Object)this));
            if (object6 == null || !object6.equals(this.getLocalizedString("common.button.ok"))) {
                return false;
            }
        }
        date = new Date();
        objectArray = this.repository.nextId();
        object6 = new Task.TaskBuilder(this.task).withId((String)objectArray);
        TimeSchedule.TimeScheduleBuilder timeScheduleBuilder = null;
        IntervalSchedule.IntervalScheduleBuilder intervalScheduleBuilder = null;
        TimeSchedule timeSchedule = (TimeSchedule)this.getScheduleForTask(TimeSchedule.class);
        timeScheduleBuilder = timeSchedule != null ? new TimeSchedule.TimeScheduleBuilder(timeSchedule).withChanged(date) : new TimeSchedule.TimeScheduleBuilder().withId(this.repository.nextId()).withCreated(date).withChanged(date);
        IntervalSchedule intervalSchedule = (IntervalSchedule)this.getScheduleForTask(IntervalSchedule.class);
        intervalScheduleBuilder = intervalSchedule != null ? new IntervalSchedule.IntervalScheduleBuilder(intervalSchedule).withChangeDate(date) : new IntervalSchedule.IntervalScheduleBuilder().withId(this.repository.nextId()).withCreationDate(date).withChangeDate(date);
        if (this.scheduleConfigurationPanel.isIntervalScheduleSelected()) {
            intervalScheduleBuilder.withIntervalStart(this.scheduleConfigurationPanel.getIntervalLimitationStart()).withIntervalEnd(this.scheduleConfigurationPanel.getIntervalLimitationEnd());
            intervalScheduleBuilder.withIntervalInSeconds(this.scheduleConfigurationPanel.getIntervalInSeconds());
            intervalScheduleBuilder.withValidFrom(this.scheduleConfigurationPanel.getScheduleValidFrom());
            intervalScheduleBuilder.withValidUntil(this.scheduleConfigurationPanel.getScheduleValidUntil());
        } else if (this.scheduleConfigurationPanel.isTimeScheduleSelected()) {
            timeScheduleBuilder.withSpecifiedTime(this.scheduleConfigurationPanel.getSpecifiedTime());
            timeScheduleBuilder.withValidFrom(this.scheduleConfigurationPanel.getScheduleValidFrom());
            timeScheduleBuilder.withValidUntil(this.scheduleConfigurationPanel.getScheduleValidUntil());
        }
        timeScheduleBuilder.withSkipIfMissed(this.scheduleConfigurationPanel.isSkipIfMissedSelected());
        intervalScheduleBuilder.withSkipIfMissed(this.scheduleConfigurationPanel.isSkipIfMissedSelected());
        timeScheduleBuilder.withWeekdays(this.scheduleConfigurationPanel.getWeekdays());
        intervalScheduleBuilder.withWeekdays(this.scheduleConfigurationPanel.getWeekdays());
        timeScheduleBuilder.withDayOfMonth(this.scheduleConfigurationPanel.getDayOfMonth());
        intervalScheduleBuilder.withDayOfMonth(this.scheduleConfigurationPanel.getDayOfMonth());
        ((Task.TaskBuilder)object6).withMaximumExecutionCount(this.taskMetadataConfigurationPanel.getMaximumExecutionCount());
        ((Task.TaskBuilder)object6).withDeleteAfterMaximumExecutionsReached(this.taskMetadataConfigurationPanel.isDeleteAfterMaximumExecutionsReached());
        ArrayList<Action> arrayList = new ArrayList<Action>();
        List<ActionConfiguratorContainer> list = this.actionConfigurationPanel.getActionConfiguratorContainers();
        for (ActionConfiguratorContainer object52 : list) {
            object4 = object52.getActionConfigurator();
            try {
                object3 = ((TaskTillDawnApplicationContext)this.getApplicationContext()).getActionPackPluginManager().getActionClassForConfiguratorClass(object4.getClass());
            }
            catch (UnknownActionException unknownActionException) {
                object3 = UnknownAction.class;
            }
            immutableHashMap = object4.getConfiguration() != null ? new ImmutableHashMap<String, Object>(object4.getConfiguration()) : new ImmutableHashMap();
            object2 = new Action.ActionBuilder().withType(((Class)object3).getCanonicalName());
            if (object4.getClass().getCanonicalName().equals("de.oliver_matuschin.ttd.plugin.defaultActions.ui.configurator.LabelActionConfigurator")) {
                object = (String)immutableHashMap.get("label");
                if (object == null) {
                    object = "";
                }
                object = ((String)object).trim();
                ((Action.ActionBuilder)object2).withLabel((String)object).withConfiguration(new ImmutableHashMap<String, Object>());
            } else {
                ((Action.ActionBuilder)object2).withConfiguration(immutableHashMap).withInput1(object52.getInput1()).withInput2(object52.getInput2()).withOutput(object52.getOutput());
            }
            arrayList.add(((Action.ActionBuilder)object2).build());
        }
        HashMap hashMap = new HashMap();
        hashMap.put("Start", new ImmutableArrayList(arrayList));
        ((Task.TaskBuilder)object6).withActions(new ImmutableHashMap<String, ImmutableArrayList<Action>>(hashMap));
        ((Task.TaskBuilder)object6).withName(this.taskMetadataConfigurationPanel.getTaskName());
        ((Task.TaskBuilder)object6).withDescription(this.taskMetadataConfigurationPanel.getTaskDescription());
        ((Task.TaskBuilder)object6).withCreated(date);
        ((Task.TaskBuilder)object6).withChanged(date);
        object4 = (ManualSchedule)this.getScheduleForTask(ManualSchedule.class);
        if (object4 != null) {
            ManualSchedule manualSchedule = new ManualSchedule.ManualScheduleBuilder((ManualSchedule)object4).withChangeDate(date).build();
        } else {
            ManualSchedule manualSchedule = new ManualSchedule.ManualScheduleBuilder().withId(this.repository.nextId()).withCreationDate(date).withChangeDate(date).build();
        }
        object3 = new ArrayList();
        object3.add(var11_14);
        if (this.scheduleConfigurationPanel.isTimeScheduleSelected()) {
            object3.add(timeScheduleBuilder.build());
        }
        if (this.scheduleConfigurationPanel.isIntervalScheduleSelected()) {
            object3.add(intervalScheduleBuilder.build());
        }
        this.setTriggers(date, (List<AbstractSchedule>)object3);
        ((Task.TaskBuilder)object6).withSchedules(new ImmutableArrayList<AbstractSchedule>((Collection<AbstractSchedule>)object3));
        immutableHashMap = ((Task.TaskBuilder)object6).build();
        if (this.editMode && this.repository.getTask(this.task.getId()) != null) {
            this.repository.updateTaskMetadata(this.task.getId(), taskMetadata -> new TaskMetadata.TaskMetadataBuilder(taskMetadata).withTaskEnabled(this.taskMetadataConfigurationPanel.isTaskEnabled()).withNotificationsDisabled(this.taskMetadataConfigurationPanel.isNotificationsDisabled()).build());
            this.repository.updateTask(this.task.getId(), arg_0 -> TaskConfigurationFrame.lambda$validateAndStoreTask$89((Task)((Object)immutableHashMap), arg_0));
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                AbstractSchedule abstractSchedule = (AbstractSchedule)iterator.next();
                this.repository.updateScheduleMetadata(abstractSchedule.getId(), scheduleMetadata -> new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withNextFireTime(null).build());
            }
            object2 = this.repository.getTask(this.task.getId());
            object = this.repository.getTaskMetadata(this.task.getId());
        } else {
            TaskMetadata.TaskMetadataBuilder taskMetadataBuilder = new TaskMetadata.TaskMetadataBuilder(this.taskMetadata).withTaskId(((Task)((Object)immutableHashMap)).getId()).withTaskEnabled(this.taskMetadataConfigurationPanel.isTaskEnabled()).withNotificationsDisabled(this.taskMetadataConfigurationPanel.isNotificationsDisabled());
            TaskMetadata taskMetadata2 = taskMetadataBuilder.build();
            this.repository.addTask((Task)((Object)immutableHashMap), taskMetadata2);
            if (this.group != null && !this.group.equals("All tasks") && this.taskGroupManager.indexOfGroup(this.group) != -1) {
                try {
                    this.taskGroupManager.addTask(this.group, ((Task)((Object)immutableHashMap)).getId());
                }
                catch (NameTooLongException nameTooLongException) {
                    // empty catch block
                }
            }
            this.editMode = true;
            this.taskMetadataConfigurationPanel.setEditMode(true);
            object2 = this.repository.getTask(((Task)((Object)immutableHashMap)).getId());
            object = this.repository.getTaskMetadata(((Task)((Object)immutableHashMap)).getId());
        }
        if (object2 != null && object != null) {
            this.task = object2;
            this.taskMetadata = object;
        }
        this.updateWindowTitle();
        return true;
    }

    private void setTriggers(Date date, List<AbstractSchedule> list) {
        if (this.triggerConfigurationPanel.isOnApplicationStartupSelected()) {
            if (this.getScheduleForTask(ApplicationStartedTrigger.class) != null) {
                list.add(this.getScheduleForTask(ApplicationStartedTrigger.class));
            } else {
                list.add(new ApplicationStartedTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnTriggeredByOtherTaskSelected()) {
            if (this.getScheduleForTask(TaskTrigger.class) != null) {
                list.add(this.getScheduleForTask(TaskTrigger.class));
            } else {
                list.add(new TaskTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnTaskExecutionStartedSelected()) {
            if (this.getScheduleForTask(TaskExecutionStartedTrigger.class) != null) {
                list.add(this.getScheduleForTask(TaskExecutionStartedTrigger.class));
            } else {
                list.add(new TaskExecutionStartedTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnTaskExecutionCanceledSelected()) {
            if (this.getScheduleForTask(TaskExecutionCanceledTrigger.class) != null) {
                list.add(this.getScheduleForTask(TaskExecutionCanceledTrigger.class));
            } else {
                list.add(new TaskExecutionCanceledTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnTaskExecutionStoppedSelected()) {
            if (this.getScheduleForTask(TaskExecutionStoppedTrigger.class) != null) {
                list.add(this.getScheduleForTask(TaskExecutionStoppedTrigger.class));
            } else {
                list.add(new TaskExecutionStoppedTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnSystemWakeSelected()) {
            if (this.getScheduleForTask(SystemAwokeTrigger.class) != null) {
                list.add(this.getScheduleForTask(SystemAwokeTrigger.class));
            } else {
                list.add(new SystemAwokeTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnUserSessionActivatedSelected()) {
            if (this.getScheduleForTask(UserSessionActivatedTrigger.class) != null) {
                list.add(this.getScheduleForTask(UserSessionActivatedTrigger.class));
            } else {
                list.add(new UserSessionActivatedTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnUserSessionDeactivatedSelected()) {
            if (this.getScheduleForTask(UserSessionDeactivatedTrigger.class) != null) {
                list.add(this.getScheduleForTask(UserSessionDeactivatedTrigger.class));
            } else {
                list.add(new UserSessionDeactivatedTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnScreenSleepSelected()) {
            if (this.getScheduleForTask(ScreenAboutToSleepTrigger.class) != null) {
                list.add(this.getScheduleForTask(ScreenAboutToSleepTrigger.class));
            } else {
                list.add(new ScreenAboutToSleepTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnScreenWakeSelected()) {
            if (this.getScheduleForTask(ScreenAwokeTrigger.class) != null) {
                list.add(this.getScheduleForTask(ScreenAwokeTrigger.class));
            } else {
                list.add(new ScreenAwokeTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnSystemLockedSelected()) {
            if (this.getScheduleForTask(SystemLockedTrigger.class) != null) {
                list.add(this.getScheduleForTask(SystemLockedTrigger.class));
            } else {
                list.add(new SystemLockedTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnSystemUnlockedSelected()) {
            if (this.getScheduleForTask(SystemUnlockedTrigger.class) != null) {
                list.add(this.getScheduleForTask(SystemUnlockedTrigger.class));
            } else {
                list.add(new SystemUnlockedTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnVolumeMountedSelected()) {
            if (this.getScheduleForTask(VolumesMountedTrigger.class) != null) {
                list.add(this.getScheduleForTask(VolumesMountedTrigger.class));
            } else {
                list.add(new VolumesMountedTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnVolumeUnmountedSelected()) {
            if (this.getScheduleForTask(VolumesUnmountedTrigger.class) != null) {
                list.add(this.getScheduleForTask(VolumesUnmountedTrigger.class));
            } else {
                list.add(new VolumesUnmountedTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnGraphicsDevicesAddedSelected()) {
            if (this.getScheduleForTask(GraphicsDevicesAddedTrigger.class) != null) {
                list.add(this.getScheduleForTask(GraphicsDevicesAddedTrigger.class));
            } else {
                list.add(new GraphicsDevicesAddedTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnGraphicsDevicesChangedSelected()) {
            if (this.getScheduleForTask(GraphicsDevicesChangedTrigger.class) != null) {
                list.add(this.getScheduleForTask(GraphicsDevicesChangedTrigger.class));
            } else {
                list.add(new GraphicsDevicesChangedTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
        if (this.triggerConfigurationPanel.isOnGraphicsDevicesRemovedSelected()) {
            if (this.getScheduleForTask(GraphicsDevicesRemovedTrigger.class) != null) {
                list.add(this.getScheduleForTask(GraphicsDevicesRemovedTrigger.class));
            } else {
                list.add(new GraphicsDevicesRemovedTrigger(this.repository.nextId(), date, date, null, null));
            }
        }
    }

    private static /* synthetic */ Task lambda$validateAndStoreTask$89(Task task, Task task2) {
        return new Task.TaskBuilder(task2).withName(task.getName()).withDescription(task.getDescription()).withChanged(task.getChanged()).withMaximumExecutionCount(task.getMaximumExecutionCount()).withDeleteAfterMaximumExecutionsReached(task.isDeleteAfterMaximumExecutionsReached()).withActions(task.getActions()).withSchedules(task.getSchedules()).build();
    }
}

