/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.frame;

import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.dialog.JExtendedDialog;
import de.oliver_matuschin.base.ui.layout.VerticalFlowLayout;
import de.oliver_matuschin.base.util.system.AutostartUtil;
import de.oliver_matuschin.base.util.ui.frame.AbstractPreferencesFrame;
import de.oliver_matuschin.base.util.ui.panel.AbstractPreferencesTabPanel;
import de.oliver_matuschin.base.util.ui.panel.ExtensionPreferencesTabPanel;
import de.oliver_matuschin.base.util.ui.panel.UpdatePreferencesTabPanel;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.ttd.application.TaskTillDawnApplication;
import de.oliver_matuschin.ttd.application.TaskTillDawnApplicationContext;
import de.oliver_matuschin.ttd.constant.PrefConstants;
import de.oliver_matuschin.ttd.migrate.MigrationUtil;
import de.oliver_matuschin.ttd.notification.listener.AbstractNotificationListener;
import de.oliver_matuschin.ttd.repository.TaskRepository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Paths;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextPane;

public class PreferencesFrame
extends AbstractPreferencesFrame<TaskTillDawnApplicationContext> {
    private TaskRepository repository;

    public PreferencesFrame(TaskTillDawnApplicationContext taskTillDawnApplicationContext, TaskRepository taskRepository) {
        super((ApplicationContext)taskTillDawnApplicationContext);
        this.repository = taskRepository;
    }

    protected void initTabs(Map<AbstractPreferencesFrame.PreferencesTab, AbstractPreferencesTabPanel> map) {
        boolean bl = ((TaskTillDawnApplication)this.getApplication()).isPortable();
        map.put(Tab.GENERAL, this.getGeneralPreferencesTabPanel(bl));
        map.put(Tab.NOTIFICATIONS, this.getNotificationPreferencesTabPanel());
        map.put(Tab.SCHEDULER, this.getSchedulerPreferencesTabPanel());
        map.put(Tab.UPDATE, (AbstractPreferencesTabPanel)new UpdatePreferencesTabPanel((AbstractPreferencesFrame)this, "checkForUpdatesOnStartup", false));
        map.put(Tab.EXTENSION, (AbstractPreferencesTabPanel)new ExtensionPreferencesTabPanel((LocalizationProvider)this.getApplication(), Paths.get(((TaskTillDawnApplication)this.getApplication()).getPluginDirectory(), new String[0]), ".ttdap"));
        if (!bl && !this.getApplication().getPreferences().getBoolean("legacyTasksMigrated", false) && MigrationUtil.getTaskPropertiesFile() != null) {
            map.put(Tab.IMPORT, this.getTaskMigrationTabPanel());
        }
    }

    private AbstractPreferencesTabPanel getGeneralPreferencesTabPanel(final boolean bl) {
        return new AbstractPreferencesTabPanel(){
            private JCheckBox autoStartupButton;
            private JCheckBox showTasklistOnStartupButton;
            private JCheckBox menuItemEnabledButton;
            private JCheckBox blackWhiteMenuItemButton;
            private JCheckBox showTasksInMenuButton;
            private JCheckBox showGroupsInMenuButton;
            private JCheckBox hideDisabledTasksInMenuButton;
            private JCheckBox hideDockIconButton;
            private JComboBox<String> languageSelectionComboBox;
            private JComboBox<String> doubleClickBehaviorSelectionComboBox;
            {
                this.initUI();
            }

            private void initUI() {
                Object object;
                this.setLayout(new BorderLayout());
                JPanel jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setBorder(null);
                jPanel.setLayout((LayoutManager)new VerticalFlowLayout(false));
                this.add(jPanel, "Center");
                UIManager uIManager = PreferencesFrame.this.getApplication().getUIManager();
                if (!bl) {
                    this.autoStartupButton = new JCheckBox(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.button.autoStartup", new Object[]{PreferencesFrame.this.getApplication().getApplicationName()}));
                    this.autoStartupButton.setOpaque(false);
                }
                this.showTasklistOnStartupButton = new JCheckBox(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.button.showTaskListOnStartup"));
                this.showTasklistOnStartupButton.setOpaque(false);
                if (PreferencesFrame.this.getApplication().getPlatform() == Platform.MACOS) {
                    this.menuItemEnabledButton = new JCheckBox(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.button.displayMenuItem") + " *");
                    this.menuItemEnabledButton.setOpaque(false);
                }
                this.blackWhiteMenuItemButton = new JCheckBox(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.button.useBlackAndWhiteMenuItem"));
                this.blackWhiteMenuItemButton.setOpaque(false);
                this.showTasksInMenuButton = new JCheckBox(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.button.showTasksInMenu"));
                this.showTasksInMenuButton.setOpaque(false);
                this.showGroupsInMenuButton = new JCheckBox(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.button.showGroupsInMenu"));
                this.showGroupsInMenuButton.setOpaque(false);
                this.hideDisabledTasksInMenuButton = new JCheckBox(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.button.hideDisabledTasksInMenu"));
                this.hideDisabledTasksInMenuButton.setOpaque(false);
                this.hideDockIconButton = new JCheckBox(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.button.hideDockIcon") + " *");
                this.hideDockIconButton.setOpaque(false);
                JPanel jPanel2 = new JPanel(new FlowLayout(3));
                jPanel2.setOpaque(false);
                jPanel2.setBorder(BorderFactory.createEmptyBorder(uIManager.getPixelsForDots(10), 0, 0, 0));
                JLabel jLabel = new JLabel(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.label.selectDoubleClickBehavior"));
                jLabel.setOpaque(false);
                jPanel2.add(jLabel);
                this.doubleClickBehaviorSelectionComboBox = new JComboBox();
                jPanel2.add(this.doubleClickBehaviorSelectionComboBox);
                this.doubleClickBehaviorSelectionComboBox.addItem(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.label.editOnDoubleClick"));
                this.doubleClickBehaviorSelectionComboBox.addItem(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.label.executeOnDoubleClick"));
                JPanel jPanel3 = new JPanel(new FlowLayout(3));
                jPanel3.setOpaque(false);
                jPanel3.setBorder(BorderFactory.createEmptyBorder(uIManager.getPixelsForDots(10), 0, uIManager.getPixelsForDots(10), 0));
                JLabel jLabel2 = new JLabel(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.label.selectLanguage") + " *");
                jLabel2.setOpaque(false);
                jPanel3.add(jLabel2);
                this.languageSelectionComboBox = new JComboBox();
                jPanel3.add(this.languageSelectionComboBox);
                this.languageSelectionComboBox.addItem(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.label.defaultLanguage"));
                this.languageSelectionComboBox.addItem("English");
                this.languageSelectionComboBox.addItem("Deutsch");
                this.languageSelectionComboBox.addItem("Fran\u00e7ais");
                this.languageSelectionComboBox.addItem("Espa\u00f1ol");
                JTextPane jTextPane = new JTextPane();
                jTextPane.setText(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.message.mustRestartApplicationForChangesToTakeEffect"));
                jTextPane.setHighlighter(null);
                jTextPane.setOpaque(false);
                jTextPane.setEditable(false);
                jTextPane.setFont(uIManager.getFont(UIManager.FontSize.SMALL));
                this.add(jTextPane, "South");
                jTextPane.setBorder(BorderFactory.createEmptyBorder(0, PreferencesFrame.this.getUIManager().getPixelsForDots(5), PreferencesFrame.this.getUIManager().getPixelsForDots(10), PreferencesFrame.this.getUIManager().getPixelsForDots(5)));
                if (this.autoStartupButton != null) {
                    jPanel.add(this.autoStartupButton);
                }
                jPanel.add(this.showTasklistOnStartupButton);
                jPanel.add(jPanel2);
                if (PreferencesFrame.this.getApplication().getPlatform() == Platform.MACOS) {
                    object = new JPanel((LayoutManager)new VerticalFlowLayout(false));
                    ((JComponent)object).setOpaque(false);
                    ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, uIManager.getPixelsForDots(30), 0, 0));
                    if (this.menuItemEnabledButton != null) {
                        jPanel.add(this.menuItemEnabledButton);
                    }
                    ((Container)object).add(this.blackWhiteMenuItemButton);
                    ((Container)object).add(this.showTasksInMenuButton);
                    JPanel jPanel4 = new JPanel((LayoutManager)new VerticalFlowLayout(false));
                    jPanel4.setOpaque(false);
                    jPanel4.setBorder(BorderFactory.createEmptyBorder(0, uIManager.getPixelsForDots(30), 0, 0));
                    jPanel4.add(this.showGroupsInMenuButton);
                    jPanel4.add(this.hideDisabledTasksInMenuButton);
                    ((Container)object).add(jPanel4);
                    ((Container)object).add(this.hideDockIconButton);
                    jPanel.add((Component)object);
                    jPanel.add(jPanel3);
                } else {
                    jPanel.add(this.blackWhiteMenuItemButton);
                    jPanel.add(this.showTasksInMenuButton);
                    object = new JPanel((LayoutManager)new VerticalFlowLayout(false));
                    ((JComponent)object).setOpaque(false);
                    ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, uIManager.getPixelsForDots(30), 0, 0));
                    ((Container)object).add(this.showGroupsInMenuButton);
                    ((Container)object).add(this.hideDisabledTasksInMenuButton);
                    jPanel.add((Component)object);
                    jPanel.add(jPanel3);
                }
                object = actionEvent -> {
                    this.setDirty();
                    this.checkFormularFields();
                };
                if (this.menuItemEnabledButton != null) {
                    this.menuItemEnabledButton.addActionListener((ActionListener)object);
                }
                this.blackWhiteMenuItemButton.addActionListener((ActionListener)object);
                this.showTasksInMenuButton.addActionListener((ActionListener)object);
                this.showGroupsInMenuButton.addActionListener((ActionListener)object);
                this.hideDisabledTasksInMenuButton.addActionListener((ActionListener)object);
                this.hideDockIconButton.addActionListener((ActionListener)object);
                this.doubleClickBehaviorSelectionComboBox.addActionListener((ActionListener)object);
                this.languageSelectionComboBox.addActionListener((ActionListener)object);
                if (this.autoStartupButton != null) {
                    this.autoStartupButton.addActionListener((ActionListener)object);
                }
                this.showTasklistOnStartupButton.addActionListener((ActionListener)object);
            }

            private void checkFormularFields() {
                if (!(PreferencesFrame.this.getApplication().getPlatform() != Platform.MACOS || this.menuItemEnabledButton != null && this.menuItemEnabledButton.isSelected())) {
                    this.blackWhiteMenuItemButton.setEnabled(false);
                    this.showTasksInMenuButton.setEnabled(false);
                    this.hideDisabledTasksInMenuButton.setEnabled(false);
                    this.showGroupsInMenuButton.setEnabled(false);
                    this.hideDockIconButton.setEnabled(false);
                    this.hideDockIconButton.setSelected(false);
                } else {
                    this.blackWhiteMenuItemButton.setEnabled(true);
                    this.showTasksInMenuButton.setEnabled(true);
                    this.hideDisabledTasksInMenuButton.setEnabled(this.showTasksInMenuButton.isSelected());
                    this.showGroupsInMenuButton.setEnabled(this.showTasksInMenuButton.isSelected());
                    this.hideDockIconButton.setEnabled(true);
                }
            }

            public void savePreferences() {
                Preferences preferences = PreferencesFrame.this.getApplication().getPreferences();
                if (this.autoStartupButton != null && this.autoStartupButton.isEnabled()) {
                    boolean bl2 = this.autoStartupButton.isSelected();
                    Runnable runnable = () -> AutostartUtil.setAutostartEnabled((boolean)bl2);
                    new Thread(runnable).start();
                }
                preferences.putBoolean("showTasklistOnStartup", this.showTasklistOnStartupButton.isSelected());
                preferences.putBoolean("editTaskOnDoubleClick", this.doubleClickBehaviorSelectionComboBox.getSelectedIndex() == 0);
                if (this.menuItemEnabledButton != null) {
                    preferences.putBoolean("menuItemEnabled", this.menuItemEnabledButton.isSelected());
                }
                preferences.putBoolean("useBlackAndWhiteMenuItemEnabled", this.blackWhiteMenuItemButton.isSelected());
                preferences.putBoolean("showTasksInMenu", this.showTasksInMenuButton.isSelected());
                preferences.putBoolean("showGroupsInMenu", this.showGroupsInMenuButton.isSelected());
                preferences.putBoolean("hideDisabledTasksInMenu", this.hideDisabledTasksInMenuButton.isSelected());
                switch (this.languageSelectionComboBox.getSelectedIndex()) {
                    case 1: {
                        preferences.put("language", "en");
                        break;
                    }
                    case 2: {
                        preferences.put("language", "de");
                        break;
                    }
                    case 3: {
                        preferences.put("language", "fr");
                        break;
                    }
                    case 4: {
                        preferences.put("language", "es");
                        break;
                    }
                    default: {
                        preferences.remove("language");
                    }
                }
                if (PreferencesFrame.this.getApplication().getPlatform() == Platform.MACOS) {
                    preferences.putBoolean("hideDockIcon", this.hideDockIconButton.isSelected());
                }
            }

            public void loadPreferences() {
                String string;
                Preferences preferences = PreferencesFrame.this.getApplication().getPreferences();
                this.showTasklistOnStartupButton.setSelected(preferences.getBoolean("showTasklistOnStartup", true));
                this.doubleClickBehaviorSelectionComboBox.setSelectedIndex(preferences.getBoolean("editTaskOnDoubleClick", true) ? 0 : 1);
                if (this.menuItemEnabledButton != null) {
                    this.menuItemEnabledButton.setSelected(preferences.getBoolean("menuItemEnabled", true));
                }
                this.blackWhiteMenuItemButton.setSelected(preferences.getBoolean("useBlackAndWhiteMenuItemEnabled", false));
                this.showTasksInMenuButton.setSelected(preferences.getBoolean("showTasksInMenu", true));
                this.showGroupsInMenuButton.setSelected(preferences.getBoolean("showGroupsInMenu", true));
                this.hideDisabledTasksInMenuButton.setSelected(preferences.getBoolean("hideDisabledTasksInMenu", true));
                if (PreferencesFrame.this.getApplication().getPlatform() == Platform.MACOS) {
                    this.hideDockIconButton.setSelected(preferences.getBoolean("hideDockIcon", false));
                    if (this.hideDockIconButton.isSelected()) {
                        this.menuItemEnabledButton.setSelected(true);
                    }
                }
                if ((string = preferences.get("language", PrefConstants.LANGUAGE_DEFAULT)) != PrefConstants.LANGUAGE_DEFAULT) {
                    switch (string) {
                        default: {
                            break;
                        }
                        case "en": {
                            this.languageSelectionComboBox.setSelectedIndex(1);
                            break;
                        }
                        case "de": {
                            this.languageSelectionComboBox.setSelectedIndex(2);
                            break;
                        }
                        case "fr": {
                            this.languageSelectionComboBox.setSelectedIndex(3);
                            break;
                        }
                        case "es": {
                            this.languageSelectionComboBox.setSelectedIndex(4);
                        }
                    }
                }
                if (this.autoStartupButton != null) {
                    this.autoStartupButton.setEnabled(false);
                    Object object = new Runnable(){

                        @Override
                        public void run() {
                            final boolean bl = AutostartUtil.isAutostartEnabled();
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    autoStartupButton.setSelected(bl);
                                    autoStartupButton.setEnabled(true);
                                    this.checkFormularFields();
                                }
                            });
                        }
                    };
                    new Thread((Runnable)object).start();
                }
                this.checkFormularFields();
            }
        };
    }

    private AbstractPreferencesTabPanel getNotificationPreferencesTabPanel() {
        return new AbstractPreferencesTabPanel(){
            private JCheckBox[] enableListenerButton;
            private AbstractNotificationListener[] listeners;
            {
                this.initUI();
            }

            private void initUI() {
                this.setLayout((LayoutManager)new VerticalFlowLayout(false));
                this.listeners = ((TaskTillDawnApplication)PreferencesFrame.this.getApplication()).getNotificationManager().getListeners();
                ActionListener actionListener = actionEvent -> this.setDirty();
                this.enableListenerButton = new JCheckBox[this.listeners.length];
                for (int i = 0; i < this.listeners.length; ++i) {
                    if (!this.listeners[i].isAvailable()) continue;
                    this.enableListenerButton[i] = new JCheckBox(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.button.enable" + this.listeners[i].getName()));
                    this.enableListenerButton[i].setOpaque(false);
                    if (this.listeners[i].isEditable()) {
                        this.enableListenerButton[i].addActionListener(actionListener);
                    } else {
                        this.enableListenerButton[i].setEnabled(false);
                    }
                    this.add(this.enableListenerButton[i]);
                }
            }

            public void savePreferences() {
                for (int i = 0; i < this.listeners.length; ++i) {
                    if (!this.listeners[i].isAvailable()) continue;
                    PreferencesFrame.this.getApplication().getPreferences().putBoolean("listener." + this.listeners[i].getName(), this.enableListenerButton[i].isSelected());
                    this.listeners[i].setEnabled(this.enableListenerButton[i].isSelected());
                }
            }

            public void loadPreferences() {
                for (int i = 0; i < this.listeners.length; ++i) {
                    if (!this.listeners[i].isAvailable()) continue;
                    if (this.listeners[i].isEditable()) {
                        this.enableListenerButton[i].setSelected(PreferencesFrame.this.getApplication().getPreferences().getBoolean("listener." + this.listeners[i].getName(), this.listeners[i].isDefaultEnabled()));
                        continue;
                    }
                    this.enableListenerButton[i].setSelected(this.listeners[i].isDefaultEnabled());
                }
            }
        };
    }

    private AbstractPreferencesTabPanel getSchedulerPreferencesTabPanel() {
        return new AbstractPreferencesTabPanel(){
            private JSlider gracePeriodSlider;
            private JTextPane informationTextPane;
            {
                this.initUI();
            }

            private void initUI() {
                this.setLayout(new BorderLayout());
                UIManager uIManager = PreferencesFrame.this.getApplication().getUIManager();
                JPanel jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setLayout((LayoutManager)new VerticalFlowLayout());
                jPanel.setBorder(BorderFactory.createEmptyBorder(0, PreferencesFrame.this.getUIManager().getPixelsForDots(5), PreferencesFrame.this.getUIManager().getPixelsForDots(10), PreferencesFrame.this.getUIManager().getPixelsForDots(5)));
                this.add(jPanel, "Center");
                this.gracePeriodSlider = new JSlider(0, 0, 60, 1);
                this.gracePeriodSlider.setOpaque(false);
                this.gracePeriodSlider.setMinorTickSpacing(1);
                this.gracePeriodSlider.setMajorTickSpacing(10);
                this.gracePeriodSlider.setPaintTicks(true);
                this.gracePeriodSlider.setPaintLabels(true);
                this.gracePeriodSlider.setSnapToTicks(true);
                this.gracePeriodSlider.addChangeListener(changeEvent -> {
                    this.setDirty();
                    if (((JSlider)changeEvent.getSource()).getValue() == 0) {
                        ((JSlider)changeEvent.getSource()).setValue(1);
                    }
                    if (this.informationTextPane != null) {
                        this.informationTextPane.setText(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.message.gracePeriodDescription", new Object[]{this.gracePeriodSlider.getValue()}));
                    }
                });
                JPanel jPanel2 = new JPanel(new BorderLayout());
                jPanel2.setOpaque(false);
                jPanel2.setBorder(null);
                this.informationTextPane = new JTextPane();
                this.informationTextPane.setBorder(null);
                this.informationTextPane.setText(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.message.gracePeriodDescription", new Object[]{this.gracePeriodSlider.getValue()}));
                this.informationTextPane.setHighlighter(null);
                this.informationTextPane.setOpaque(false);
                this.informationTextPane.setEditable(false);
                this.informationTextPane.setBorder(BorderFactory.createEmptyBorder(uIManager.getPixelsForDots(5), uIManager.getPixelsForDots(0), uIManager.getPixelsForDots(10), uIManager.getPixelsForDots(0)));
                jPanel2.add((Component)this.informationTextPane, "North");
                jPanel2.add((Component)new JLabel(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.label.gracePeriod")), "West");
                jPanel2.add((Component)this.gracePeriodSlider, "Center");
                jPanel.add(jPanel2);
            }

            public void savePreferences() {
                PreferencesFrame.this.getApplication().getPreferences().putInt("missedSchedulesGracePeriod", this.gracePeriodSlider.getValue() * 1000);
                ((TaskTillDawnApplication)PreferencesFrame.this.getApplication()).getTaskScheduler().setGracePeriod(this.gracePeriodSlider.getValue() * 1000);
            }

            public void loadPreferences() {
                this.gracePeriodSlider.setValue(PreferencesFrame.this.getApplication().getPreferences().getInt("missedSchedulesGracePeriod", 1000) / 1000);
            }
        };
    }

    private AbstractPreferencesTabPanel getTaskMigrationTabPanel() {
        return new AbstractPreferencesTabPanel(){
            {
                this.initUI();
            }

            private void initUI() {
                this.setLayout(new BorderLayout());
                UIManager uIManager = PreferencesFrame.this.getApplication().getUIManager();
                JTextPane jTextPane = new JTextPane();
                jTextPane.setText(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.message.importTasks"));
                jTextPane.setHighlighter(null);
                jTextPane.setOpaque(false);
                jTextPane.setEditable(false);
                jTextPane.setBorder(BorderFactory.createEmptyBorder(uIManager.getPixelsForDots(5), uIManager.getPixelsForDots(5), uIManager.getPixelsForDots(10), uIManager.getPixelsForDots(5)));
                this.add(jTextPane, "North");
                JPanel jPanel = new JPanel();
                jPanel.setOpaque(false);
                this.add(jPanel, "Center");
                JPanel jPanel2 = new JPanel();
                jPanel2.setOpaque(false);
                final JButton jButton = new JButton(PreferencesFrame.this.getLocalizedString("window.PreferencesFrame.button.importTasks"));
                jPanel2.add(jButton);
                jPanel.add(jPanel2);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            MigrationUtil.migrateTasks(PreferencesFrame.this.repository, (LocalizationProvider)PreferencesFrame.this.getApplication());
                            jButton.setEnabled(false);
                            PreferencesFrame.this.getApplication().getPreferences().putBoolean("legacyTasksMigrated", true);
                            JExtendedDialog jExtendedDialog = new JExtendedDialog(PreferencesFrame.this.getLocalizedString("dialog.TasksImportedDialog.title"), (Object)PreferencesFrame.this.getLocalizedString("dialog.TasksImportedDialog.message"), 1);
                            jExtendedDialog.showDialog((Component)((Object)PreferencesFrame.this));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }

            public void savePreferences() {
            }

            public void loadPreferences() {
            }
        };
    }

    protected static enum Tab implements AbstractPreferencesFrame.PreferencesTab
    {
        GENERAL,
        NOTIFICATIONS,
        SCHEDULER,
        UPDATE,
        EXTENSION,
        IMPORT;

    }
}

