/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.dialog;

import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.base.constant.AppConstants;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.dialog.AbstractApplicationDialog;
import de.oliver_matuschin.base.ui.dialog.JExtendedDialog;
import de.oliver_matuschin.base.ui.event.JExtendedMouseAdapter;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.layout.VerticalFlowLayout;
import de.oliver_matuschin.base.util.ApplicationUtilities;
import de.oliver_matuschin.base.util.system.AutostartUtil;
import de.oliver_matuschin.base.util.ui.frame.AboutBoxFrame;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.ttd.application.TaskTillDawnApplication;
import de.oliver_matuschin.ttd.migrate.MigrationUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;

public class SetupDialog<T extends ApplicationContext<?>>
extends AbstractApplicationDialog<T> {
    private static final Logger logger = Logger.getLogger(SetupDialog.class.getName());
    private int currentStep = 0;
    private int licenceStep = -1;
    private boolean licenceAccepted = true;
    private JLabel title;
    private JPanel setupPanel;
    private JPanel stepPanel;
    private List<JComponent> setupPanels = new ArrayList<JComponent>();
    private List<String> setupPanelStepTitles = new ArrayList<String>();
    private List<String> setupPanelTitles = new ArrayList<String>();
    private JLabel currentStepLabel;
    private JButton quitButton;
    private JButton nextButton;
    private JButton previousButton;
    private JRadioButton enableUpdateCheckButton;
    private JRadioButton disableUpdateCheckButton;
    private JRadioButton enableAutoStartupButton;
    private JRadioButton disableAutoStartupButton;
    private JCheckBox importDataButton;

    public SetupDialog(T t, Window window, Dialog.ModalityType modalityType, List<Step> list) {
        super(t, window, modalityType);
        this.getUIManager().setUiBlocked(true);
        this.setDefaultCloseOperation(0);
        this.initUI(list);
    }

    private void initUI(List<Step> list) {
        this.setTitle(this.getLocalizedString("dialog.SetupDialog.title"));
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.getContentPane().setBackground(AppConstants.DEFAULT_WINDOW_BACKGROUND_COLOR);
        this.setMinimumSize(new Dimension(600, 420));
        this.setPreferredSize(new Dimension(600, 420));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(15), this.getUIManager().getPixelsForDots(20), this.getUIManager().getPixelsForDots(7), this.getUIManager().getPixelsForDots(20)));
        this.stepPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.stepPanel.setOpaque(false);
        this.stepPanel.setPreferredSize(new Dimension(this.getUIManager().getPixelsForDots(150), this.stepPanel.getPreferredSize().height));
        this.stepPanel.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(50), 0, 0, this.getUIManager().getPixelsForDots(20)));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.setBorder(null);
        this.setupPanel = new JPanel(new BorderLayout());
        this.setupPanel.setBackground(Color.WHITE);
        this.setupPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.title = new JLabel("");
        jPanel2.add((Component)this.title, "North");
        jPanel2.add((Component)this.setupPanel, "Center");
        this.title.setBorder(BorderFactory.createEmptyBorder(0, this.getUIManager().getPixelsForDots(4), this.getUIManager().getPixelsForDots(10), 0));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setOpaque(false);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(7), 0, 0, 0));
        JPanel jPanel4 = new JPanel(new FlowLayout(3));
        jPanel4.setOpaque(false);
        jPanel4.setBorder(null);
        this.quitButton = new JButton(this.getLocalizedString("common.button.quit"));
        if (this.getApplication().getPlatform() != Platform.MACOS) {
            jPanel4.add(this.quitButton);
        }
        JPanel jPanel5 = new JPanel(new FlowLayout(4));
        jPanel5.setOpaque(false);
        jPanel5.setBorder(null);
        this.nextButton = new JButton();
        this.previousButton = new JButton();
        this.currentStepLabel = new JLabel();
        jPanel5.add(this.currentStepLabel);
        jPanel5.add(this.previousButton);
        jPanel5.add(this.nextButton);
        jPanel3.add((Component)jPanel4, "West");
        jPanel3.add((Component)jPanel5, "East");
        this.setupPanels.add(this.getWelcomeMessage());
        this.setupPanelStepTitles.add(this.getLocalizedString("dialog.SetupDialog.label.stepWelcome"));
        this.setupPanelTitles.add(this.getLocalizedString("dialog.SetupDialog.label.titleWelcome", new Object[]{this.getApplication().getApplicationName()}));
        if (list.contains((Object)Step.ACCEPT_LICENCE)) {
            this.setupPanels.add(this.getLicenceAgreement());
            this.setupPanelStepTitles.add(this.getLocalizedString("dialog.SetupDialog.label.stepLicence"));
            this.setupPanelTitles.add(this.getLocalizedString("dialog.SetupDialog.label.titleLicence"));
            this.licenceStep = this.setupPanels.size() - 1;
            this.licenceAccepted = false;
        }
        if (list.contains((Object)Step.ENABLE_AUTOSTART)) {
            this.setupPanels.add(this.getAutoStartupOption());
            this.setupPanelStepTitles.add(this.getLocalizedString("dialog.SetupDialog.label.stepAutostart"));
            this.setupPanelTitles.add(this.getLocalizedString("dialog.SetupDialog.label.titleAutostart"));
        }
        if (list.contains((Object)Step.ENABLE_UPDATECHECK)) {
            this.setupPanels.add(this.getUpdateCheckOnStartupOption());
            this.setupPanelStepTitles.add(this.getLocalizedString("dialog.SetupDialog.label.stepUpdatecheck"));
            this.setupPanelTitles.add(this.getLocalizedString("dialog.SetupDialog.label.titleUpdatecheck"));
        }
        if (list.contains((Object)Step.IMPORT_TASKS) && !this.getApplication().getPreferences().getBoolean("legacyTasksMigrated", false) && MigrationUtil.getTaskPropertiesFile() != null) {
            this.setupPanels.add(this.getImportDataOption());
            this.setupPanelStepTitles.add(this.getLocalizedString("dialog.SetupDialog.label.stepImportLegacyTasks"));
            this.setupPanelTitles.add(this.getLocalizedString("dialog.SetupDialog.label.titleImportLegacyTasks"));
        }
        jPanel.add((Component)this.stepPanel, "West");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        this.add(jPanel, "Center");
        this.getRootPane().setDefaultButton(this.nextButton);
        this.addActionListeners();
        this.switchStep();
    }

    private void addActionListeners() {
        this.quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!SetupDialog.this.licenceAccepted && SetupDialog.this.currentStep == SetupDialog.this.licenceStep) {
                    JExtendedDialog jExtendedDialog = new JExtendedDialog(SetupDialog.this.getLocalizedString("dialog.LicenceDialog.title"), (Object)SetupDialog.this.getLocalizedString("dialog.LicenceDialog.message"), 2);
                    Object[] objectArray = new Object[]{SetupDialog.this.getLocalizedString("dialog.LicenceDialog.button.agree"), SetupDialog.this.getLocalizedString("dialog.LicenceDialog.button.decline"), SetupDialog.this.getLocalizedString("dialog.LicenceDialog.button.readLicence")};
                    jExtendedDialog.setOptions(objectArray);
                    Object object = jExtendedDialog.showDialog((Component)((Object)SetupDialog.this));
                    if (objectArray[2].equals(object)) {
                        return;
                    }
                    if (objectArray[0].equals(object)) {
                        SetupDialog.this.licenceAccepted = true;
                    } else if (objectArray[1].equals(object)) {
                        System.exit(0);
                    }
                }
                SetupDialog.this.nextStep();
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SetupDialog.this.previousStep();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                SetupDialog.this.saveChanges();
            }
        });
    }

    private void nextStep() {
        ++this.currentStep;
        this.switchStep();
    }

    private void previousStep() {
        --this.currentStep;
        this.switchStep();
    }

    private void switchStep() {
        this.stepPanel.removeAll();
        for (int i = 0; i < this.setupPanelStepTitles.size(); ++i) {
            JLabel jLabel = new JLabel(this.setupPanelStepTitles.get(i));
            jLabel.setOpaque(false);
            jLabel.setIconTextGap(this.getUIManager().getPixelsForDots(8));
            jLabel.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(10), 0, 0, 0));
            if (this.currentStep == i) {
                jLabel.setFont(this.getUIManager().getFont(UIManager.FontSize.DEFAULT, 1));
                jLabel.setForeground(Color.BLACK);
                jLabel.setIcon(ImageBuilder.buildFor((String)"/resources/images/misc/blue_dot.png"));
                this.title.setText(this.setupPanelTitles.get(i));
            } else if (i > this.currentStep) {
                jLabel.setForeground(Color.GRAY);
                jLabel.setIcon(ImageBuilder.buildFor((String)"/resources/images/misc/blue_dot_disabled.png"));
            } else {
                jLabel.setIcon(ImageBuilder.buildFor((String)"/resources/images/misc/dark_dot.png"));
            }
            this.stepPanel.add(jLabel);
        }
        this.setupPanel.removeAll();
        if (this.currentStep >= this.setupPanels.size()) {
            this.getUIManager().setUiBlocked(false);
            this.dispose();
            return;
        }
        this.setupPanel.add((Component)this.setupPanels.get(this.currentStep), "Center");
        this.currentStepLabel.setText(this.getLocalizedString("dialog.SetupDialog.label.stepXofX", new Object[]{String.valueOf(this.currentStep + 1), String.valueOf(this.setupPanels.size())}));
        this.previousButton.setEnabled(this.currentStep > 0);
        this.previousButton.setText("< " + this.getLocalizedString("common.button.back"));
        if (this.currentStep == this.setupPanels.size() - 1) {
            Dimension dimension = this.nextButton.getPreferredSize();
            this.nextButton.setText(this.getLocalizedString("common.button.done"));
            this.nextButton.setMinimumSize(dimension);
            this.nextButton.setSize(dimension);
            this.nextButton.setPreferredSize(dimension);
        } else {
            this.nextButton.setText(this.getLocalizedString("common.button.next") + " >");
        }
        this.setupPanel.updateUI();
    }

    private void saveChanges() {
        this.getApplication().getPreferences().putInt("setupAssistantLastRun", 2);
        if (this.licenceStep != -1) {
            if (this.licenceAccepted) {
                this.getApplication().getPreferences().putLong("licenceAcceptedDate", new Date().getTime());
                this.getApplication().getPreferences().putInt("acceptedLicenceVersion", 1);
            } else {
                this.getApplication().getPreferences().remove("licenceAcceptedDate");
                this.getApplication().getPreferences().remove("acceptedLicenceVersion");
            }
        }
        if (this.enableUpdateCheckButton != null && this.disableUpdateCheckButton != null && (this.enableUpdateCheckButton.isSelected() || this.disableUpdateCheckButton.isSelected())) {
            this.getApplication().getPreferences().putBoolean("checkForUpdatesOnStartup", this.enableUpdateCheckButton.isSelected());
        }
        if (this.enableAutoStartupButton != null && this.disableAutoStartupButton != null && (this.enableAutoStartupButton.isSelected() || this.disableAutoStartupButton.isSelected())) {
            final boolean bl = this.enableAutoStartupButton.isSelected();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AutostartUtil.setAutostartEnabled((boolean)bl);
                }
            };
            new Thread(runnable).start();
        }
        if (this.importDataButton != null && this.importDataButton.isSelected()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        MigrationUtil.migrateTasks(((TaskTillDawnApplication)SetupDialog.this.getApplication()).getTaskRepository(), (LocalizationProvider)SetupDialog.this.getApplication());
                        SetupDialog.this.getApplication().getPreferences().putBoolean("legacyTasksMigrated", true);
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, "Failed to migrate tasks!", exception);
                    }
                }
            };
            new Thread(runnable).start();
        }
    }

    private JScrollPane getWelcomeMessage() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setHighlighter(null);
        jTextPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        AboutBoxFrame.fillTextPane((JTextPane)jTextPane, (String)this.getLocalizedString("dialog.SetupDialog.message.welcomeMessage"));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(null);
        jScrollPane.getViewport().add(jTextPane);
        return jScrollPane;
    }

    private JPanel getAutoStartupOption() {
        this.enableAutoStartupButton = new JRadioButton(this.getLocalizedString("common.button.yes"));
        this.enableAutoStartupButton.setOpaque(false);
        this.disableAutoStartupButton = new JRadioButton(this.getLocalizedString("common.button.no"));
        this.disableAutoStartupButton.setOpaque(false);
        JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.enableAutoStartupButton);
        buttonGroup.add(this.disableAutoStartupButton);
        jPanel2.add(this.enableAutoStartupButton);
        jPanel2.add(this.disableAutoStartupButton);
        this.enableAutoStartupButton.setSelected(true);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setHighlighter(null);
        jTextPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        AboutBoxFrame.fillTextPane((JTextPane)jTextPane, (String)this.getLocalizedString("dialog.SetupDialog.message.enableAutomaticStartup", new Object[]{this.getApplication().getApplicationName()}));
        jPanel.add(jTextPane);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel getUpdateCheckOnStartupOption() {
        this.enableUpdateCheckButton = new JRadioButton(this.getLocalizedString("common.button.yes"));
        this.enableUpdateCheckButton.setOpaque(false);
        this.disableUpdateCheckButton = new JRadioButton(this.getLocalizedString("common.button.no"));
        this.disableUpdateCheckButton.setOpaque(false);
        JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.enableUpdateCheckButton);
        buttonGroup.add(this.disableUpdateCheckButton);
        jPanel2.add(this.enableUpdateCheckButton);
        jPanel2.add(this.disableUpdateCheckButton);
        if (this.getApplication().getPreferences().getBoolean("checkForUpdatesOnStartup", true)) {
            this.enableUpdateCheckButton.setSelected(true);
        } else {
            this.disableUpdateCheckButton.setSelected(true);
        }
        final JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setHighlighter(null);
        jTextPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        AboutBoxFrame.fillTextPane((JTextPane)jTextPane, (String)this.getLocalizedString("dialog.SetupDialog.message.enableUpdateCheckOnStartup", new Object[]{this.getApplication().getApplicationName()}));
        jTextPane.addMouseListener((MouseListener)new JExtendedMouseAdapter(this.getPlatform()){

            public void mouseClicked(MouseEvent mouseEvent) {
                Element element = ((StyledDocument)jTextPane.getDocument()).getCharacterElement(jTextPane.viewToModel(mouseEvent.getPoint()));
                AttributeSet attributeSet = element.getAttributes();
                AbstractAction abstractAction = (AbstractAction)attributeSet.getAttribute("linkAction");
                if (abstractAction != null) {
                    abstractAction.actionPerformed(null);
                }
            }
        });
        jPanel.add(jTextPane);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel getImportDataOption() {
        this.importDataButton = new JCheckBox(this.getLocalizedString("dialog.SetupDialog.label.importOldTasksNow"));
        this.importDataButton.setOpaque(false);
        JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.setOpaque(false);
        jPanel2.add(this.importDataButton);
        this.importDataButton.setSelected(true);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setHighlighter(null);
        jTextPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        AboutBoxFrame.fillTextPane((JTextPane)jTextPane, (String)this.getLocalizedString("dialog.SetupDialog.message.importOldTasks", new Object[]{this.getApplication().getApplicationName()}));
        jPanel.add(jTextPane);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JScrollPane getLicenceAgreement() {
        String string = "/resources/licence_" + this.getLocalizedString("language") + ".txt";
        if (((Object)((Object)this)).getClass().getResource(string) == null) {
            string = "/resources/licence_en.txt";
        }
        JTextPane jTextPane = new JTextPane();
        jTextPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jTextPane.setEditable(false);
        jTextPane.setFont(this.getUIManager().getFont(UIManager.FontSize.DEFAULT));
        AboutBoxFrame.fillTextPane((JTextPane)jTextPane, (String)ApplicationUtilities.getResourceAsString((String)string));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(null);
        jScrollPane.getViewport().add(jTextPane);
        jTextPane.setCaretPosition(0);
        return jScrollPane;
    }

    public boolean isLicenceAccepted() {
        return this.licenceAccepted;
    }

    public static enum Step {
        ACCEPT_LICENCE,
        ENABLE_AUTOSTART,
        ENABLE_UPDATECHECK,
        IMPORT_TASKS;

    }
}

