/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.comboBox;

import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.ttd.collect.ImmutableArrayList;
import de.oliver_matuschin.ttd.group.TaskGroupManager;
import de.oliver_matuschin.ttd.group.listener.TaskGroupEventListener;
import de.oliver_matuschin.ttd.repository.TaskRepository;
import de.oliver_matuschin.ttd.repository.listener.TaskRepositoryEventListener;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import de.oliver_matuschin.ttd.scheduler.task.trigger.TaskTrigger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TaskSelectionComboBox
extends JPanel
implements TaskGroupEventListener,
TaskRepositoryEventListener {
    private JComboBox<TaskWrapper> comboBox;
    private DefaultComboBoxModel<TaskWrapper> comboBoxModel;
    private JLabel noTaskAvailableLabel;
    private TaskGroupManager taskGroupManager;
    private TaskRepository repository;
    private Collection<Task> ignoredTasks;
    private boolean onlyExecutableTasks = false;
    private Runnable refreshTasksComboBoxRunnable = new Runnable(){

        @Override
        public void run() {
            TaskWrapper taskWrapper = (TaskWrapper)TaskSelectionComboBox.this.comboBoxModel.getSelectedItem();
            TaskSelectionComboBox.this.comboBoxModel.removeAllElements();
            boolean bl = false;
            List<String> list = TaskSelectionComboBox.this.taskGroupManager.listTasksOfGroup("All tasks");
            if (list != null) {
                block0: for (String string : list) {
                    Object object;
                    Object object2;
                    if (TaskSelectionComboBox.this.ignoredTasks != null) {
                        object2 = TaskSelectionComboBox.this.ignoredTasks.iterator();
                        while (object2.hasNext()) {
                            object = (Task)object2.next();
                            if (!((Task)object).getId().equals(string)) continue;
                        }
                    }
                    if ((object2 = TaskSelectionComboBox.this.repository.getTask(string)) == null) continue;
                    object = ((Task)object2).getSchedules();
                    Iterator iterator = ((ImmutableArrayList)object).iterator();
                    while (iterator.hasNext()) {
                        AbstractSchedule abstractSchedule = (AbstractSchedule)iterator.next();
                        if (TaskSelectionComboBox.this.onlyExecutableTasks && !(abstractSchedule instanceof TaskTrigger)) continue;
                        TaskWrapper taskWrapper2 = new TaskWrapper((Task)object2);
                        TaskSelectionComboBox.this.comboBoxModel.addElement(taskWrapper2);
                        if (taskWrapper == null || !((Task)object2).getId().equals(taskWrapper.getTaskId())) continue block0;
                        TaskSelectionComboBox.this.comboBoxModel.setSelectedItem(taskWrapper2);
                        bl = true;
                        continue block0;
                    }
                }
            }
            TaskSelectionComboBox.this.removeAll();
            if (TaskSelectionComboBox.this.comboBoxModel.getSize() == 0) {
                TaskSelectionComboBox.this.add((Component)TaskSelectionComboBox.this.noTaskAvailableLabel, "West");
            } else {
                TaskSelectionComboBox.this.add((Component)TaskSelectionComboBox.this.comboBox, "West");
            }
            if (!bl && TaskSelectionComboBox.this.comboBoxModel.getSize() > 0) {
                TaskSelectionComboBox.this.comboBox.setSelectedIndex(0);
            }
        }
    };

    public TaskSelectionComboBox(LocalizationProvider localizationProvider, TaskGroupManager taskGroupManager, TaskRepository taskRepository) {
        this.setOpaque(false);
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.taskGroupManager = taskGroupManager;
        this.repository = taskRepository;
        this.comboBox = new JComboBox();
        this.comboBoxModel = new DefaultComboBoxModel();
        this.comboBox.setModel(this.comboBoxModel);
        this.noTaskAvailableLabel = new JLabel(localizationProvider.getLocalizedString("comboBox.TaskSelectionComboBox.label.noTasksAvailable"));
        this.refreshTasksComboBoxRunnable.run();
    }

    public void setOnlyExecutableTasks(boolean bl) {
        this.onlyExecutableTasks = bl;
        this.refreshTasksComboBoxRunnable.run();
    }

    public void setIgnoredTasks(Collection<Task> collection) {
        this.ignoredTasks = collection;
        this.refreshTasksComboBoxRunnable.run();
    }

    public Task getSelectedTask() {
        if (this.comboBox.getSelectedItem() != null) {
            return ((TaskWrapper)this.comboBox.getSelectedItem()).getTask();
        }
        return null;
    }

    public String getSelectedTaskId() {
        Task task = this.getSelectedTask();
        if (task != null) {
            return task.getId();
        }
        return null;
    }

    public void setSelectedTask(Task task) {
        this.setSelectedTaskId(task.getId());
    }

    public void setSelectedTaskId(String string) {
        for (int i = 0; i < this.comboBoxModel.getSize(); ++i) {
            TaskWrapper taskWrapper = this.comboBoxModel.getElementAt(i);
            if (!taskWrapper.getTaskId().equals(string)) continue;
            this.comboBox.setSelectedIndex(i);
            return;
        }
        this.comboBox.setSelectedIndex(-1);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.comboBox.setEnabled(bl);
        this.noTaskAvailableLabel.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.comboBox.isEnabled();
    }

    @Override
    public void taskRemoved(String string, String string2, int n) {
    }

    @Override
    public void taskMoved(String string, String string2, int n, int n2) {
        EventQueue.invokeLater(this.refreshTasksComboBoxRunnable);
    }

    @Override
    public void taskAdded(String string, String string2, int n) {
    }

    @Override
    public void groupRemoved(String string, int n) {
    }

    @Override
    public void groupMoved(String string, int n, int n2) {
    }

    @Override
    public void groupAdded(String string, int n) {
    }

    @Override
    public void taskUpdated(Task task) {
        EventQueue.invokeLater(this.refreshTasksComboBoxRunnable);
    }

    @Override
    public void taskMetadataUpdated(Task task, TaskMetadata taskMetadata) {
        EventQueue.invokeLater(this.refreshTasksComboBoxRunnable);
    }

    @Override
    public void scheduleMetadataUpdated(Task task, ScheduleMetadata scheduleMetadata) {
        EventQueue.invokeLater(this.refreshTasksComboBoxRunnable);
    }

    @Override
    public void taskAdded(Task task) {
        EventQueue.invokeLater(this.refreshTasksComboBoxRunnable);
    }

    @Override
    public void taskRemoved(Task task) {
        EventQueue.invokeLater(this.refreshTasksComboBoxRunnable);
    }

    private static class TaskWrapper {
        private Task task;

        public TaskWrapper(Task task) {
            this.task = task;
        }

        public String getTaskId() {
            return this.task.getId();
        }

        public Task getTask() {
            return this.task;
        }

        public String toString() {
            if (this.task.getName().length() > 50) {
                return this.task.getName().substring(0, 50) + "...";
            }
            return this.task.getName();
        }
    }
}

