/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.comboBox;

import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.ttd.group.TaskGroupManager;
import de.oliver_matuschin.ttd.group.listener.TaskGroupEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GroupSelectionComboBox
extends JPanel
implements TaskGroupEventListener {
    private JComboBox<String> comboBox;
    private TaskGroupManager taskGroupManager;
    private LocalizationProvider localizationProvider;
    private JLabel noGroupsAvailableLabel;
    private Runnable refreshGroupsComboBoxRunnable = new Runnable(){

        @Override
        public void run() {
            String string = (String)GroupSelectionComboBox.this.comboBox.getSelectedItem();
            GroupSelectionComboBox.this.comboBox.removeAllItems();
            GroupSelectionComboBox.this.comboBox.addItem(GroupSelectionComboBox.this.localizationProvider.getLocalizedString("comboBox.GroupSelectionComboBox.label.noGroupSelected"));
            boolean bl = false;
            List<String> list = GroupSelectionComboBox.this.taskGroupManager.listGroups();
            for (String string2 : list) {
                if (string2.equals("All tasks")) {
                    GroupSelectionComboBox.this.comboBox.addItem(GroupSelectionComboBox.this.localizationProvider.getLocalizedString("application.defaultTaskGroup"));
                } else if (string2.equals("Last import")) {
                    GroupSelectionComboBox.this.comboBox.addItem(GroupSelectionComboBox.this.localizationProvider.getLocalizedString("application.importTaskGroup"));
                } else {
                    GroupSelectionComboBox.this.comboBox.addItem(string2);
                }
                if (!string2.equals(string)) continue;
                GroupSelectionComboBox.this.comboBox.setSelectedItem(string);
                bl = true;
            }
            GroupSelectionComboBox.this.removeAll();
            if (GroupSelectionComboBox.this.comboBox.getItemCount() == 1) {
                GroupSelectionComboBox.this.add((Component)GroupSelectionComboBox.this.noGroupsAvailableLabel, "West");
            } else {
                GroupSelectionComboBox.this.add((Component)GroupSelectionComboBox.this.comboBox, "West");
            }
            if (!bl) {
                GroupSelectionComboBox.this.comboBox.setSelectedIndex(0);
            }
        }
    };

    public GroupSelectionComboBox(LocalizationProvider localizationProvider, TaskGroupManager taskGroupManager) {
        this.setOpaque(false);
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.taskGroupManager = taskGroupManager;
        this.localizationProvider = localizationProvider;
        this.comboBox = new JComboBox();
        this.noGroupsAvailableLabel = new JLabel(localizationProvider.getLocalizedString("comboBox.GroupSelectionComboBox.label.noGroupsAvailable"));
        this.refreshGroupsComboBoxRunnable.run();
    }

    public String getSelectedGroup() {
        if (this.comboBox.getSelectedItem() != null && this.comboBox.getSelectedIndex() > 0) {
            return (String)this.comboBox.getSelectedItem();
        }
        return null;
    }

    public void setSelectedGroup(String string) {
        this.comboBox.setSelectedItem(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.comboBox.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.comboBox.isEnabled();
    }

    @Override
    public void taskRemoved(String string, String string2, int n) {
    }

    @Override
    public void taskMoved(String string, String string2, int n, int n2) {
    }

    @Override
    public void taskAdded(String string, String string2, int n) {
    }

    @Override
    public void groupRemoved(String string, int n) {
        EventQueue.invokeLater(this.refreshGroupsComboBoxRunnable);
    }

    @Override
    public void groupMoved(String string, int n, int n2) {
        EventQueue.invokeLater(this.refreshGroupsComboBoxRunnable);
    }

    @Override
    public void groupAdded(String string, int n) {
        EventQueue.invokeLater(this.refreshGroupsComboBoxRunnable);
    }
}

