/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.comboBox;

import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.ttd.ui.configuration.ConfigurationEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractLabelSelectionComboBox
extends JPanel
implements ConfigurationEventListener {
    private LocalizationProvider localizationProvider;
    private JComboBox<String> comboBox;
    private JLabel noLabelAvailableLabel;
    private Runnable refreshLabelsComboBoxRunnable = new Runnable(){

        @Override
        public void run() {
            String string = (String)AbstractLabelSelectionComboBox.this.comboBox.getSelectedItem();
            AbstractLabelSelectionComboBox.this.comboBox.removeAllItems();
            AbstractLabelSelectionComboBox.this.comboBox.addItem(AbstractLabelSelectionComboBox.this.localizationProvider.getLocalizedString("comboBox.AbstractLabelSelectionComboBox.label.noLabelSelected"));
            boolean bl = false;
            List<String> list = AbstractLabelSelectionComboBox.this.getLabels();
            for (String string2 : list) {
                AbstractLabelSelectionComboBox.this.comboBox.addItem(string2);
                if (!string2.equals(string)) continue;
                AbstractLabelSelectionComboBox.this.comboBox.setSelectedItem(string);
                bl = true;
            }
            AbstractLabelSelectionComboBox.this.removeAll();
            if (AbstractLabelSelectionComboBox.this.comboBox.getItemCount() == 1) {
                AbstractLabelSelectionComboBox.this.add((Component)AbstractLabelSelectionComboBox.this.noLabelAvailableLabel, "West");
            } else {
                AbstractLabelSelectionComboBox.this.add((Component)AbstractLabelSelectionComboBox.this.comboBox, "West");
            }
            if (!bl) {
                AbstractLabelSelectionComboBox.this.comboBox.setSelectedIndex(0);
            }
        }
    };

    public AbstractLabelSelectionComboBox(LocalizationProvider localizationProvider) {
        this.localizationProvider = localizationProvider;
        this.setOpaque(false);
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.comboBox = new JComboBox();
        this.noLabelAvailableLabel = new JLabel(localizationProvider.getLocalizedString("comboBox.AbstractLabelSelectionComboBox.label.noLabelsAvailable"));
        this.refreshLabelsComboBoxRunnable.run();
    }

    public String getSelectedLabel() {
        if (this.comboBox.getSelectedItem() != null && this.comboBox.getSelectedIndex() > 0) {
            return (String)this.comboBox.getSelectedItem();
        }
        return null;
    }

    public void setSelectedLabel(String string) {
        this.comboBox.setSelectedItem(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.comboBox.setEnabled(bl);
        this.noLabelAvailableLabel.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.comboBox.isEnabled();
    }

    @Override
    public void labelsUpdated() {
        EventQueue.invokeLater(this.refreshLabelsComboBoxRunnable);
    }

    protected abstract List<String> getLabels();
}

