/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.cellEditor;

import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.dialog.JExtendedDialog;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.layout.VerticalFlowLayout;
import de.oliver_matuschin.ttd.action.UnknownAction;
import de.oliver_matuschin.ttd.constant.TaskTillDawnConstants;
import de.oliver_matuschin.ttd.manager.ActionPackPluginManager;
import de.oliver_matuschin.ttd.manager.exception.UnknownActionException;
import de.oliver_matuschin.ttd.manager.exception.UnknownTypeConverterException;
import de.oliver_matuschin.ttd.plugin.action.annotation.ActionMetadata;
import de.oliver_matuschin.ttd.plugin.configurator.context.ConfiguratorContext;
import de.oliver_matuschin.ttd.plugin.converter.TypeConverter;
import de.oliver_matuschin.ttd.plugin.ui.configurator.ActionConfigurator;
import de.oliver_matuschin.ttd.plugin.ui.textPane.VariableTextPaneWrapper;
import de.oliver_matuschin.ttd.scheduler.task.action.Action;
import de.oliver_matuschin.ttd.ui.button.PopupButton;
import de.oliver_matuschin.ttd.ui.model.ActionConfiguratorContainer;
import de.oliver_matuschin.ttd.ui.panel.AbstractActionConfiguratorCellEditorPanel;
import de.oliver_matuschin.ttd.ui.panel.ActionConfiguratorCellEditorPanel;
import de.oliver_matuschin.ttd.ui.panel.EmptyActionConfiguratorCellEditorPanel;
import de.oliver_matuschin.ttd.ui.panel.LabelConfiguratorCellEditorPanel;
import de.oliver_matuschin.ttd.ui.popupMenu.VariablePopupMenu;
import de.oliver_matuschin.ttd.ui.type.TypeInformationProvider;
import de.oliver_matuschin.util.TypeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Type;
import java.util.EventObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ConfiguratorTableCellEditor
implements TableCellEditor,
TableCellRenderer {
    private final Logger logger = Logger.getLogger(ConfiguratorTableCellEditor.class.getName());
    private static final Color ACTION_BOX_BORDER_COLOR = new Color(220, 220, 220);
    private ActionConfiguratorContainer currentValue;
    private JFrame parent;
    private ApplicationContext<?> applicationContext;
    private ActionPackPluginManager actionPackPluginManager;
    private TypeInformationProvider typeInformationProvider;
    private List<Action.ActionVariable> variables;
    private ActionConfiguratorCellEditorPanel actionConfiguratorCellEditorPanel;
    private EmptyActionConfiguratorCellEditorPanel emptyActionConfiguratorCellEditorPanel;
    private LabelConfiguratorCellEditorPanel labelConfiguratorCellEditorPanel;
    private EventListenerList cellEditorListeners;
    private RemoveButtonActionListener removeButtonActionListener;
    private JPanel inputPanel;
    private JPanel outputPanel;
    private JPanel noInputPanel;
    private JPanel noOutputPanel;
    private JPanel contentWrapperPanel;
    private JPanel errorsPanel;
    private PopupButton input1VariablesButton;
    private PopupButton input2VariablesButton;
    private PopupButton outputVariablesButton;
    private PopupButton input1ComboButton;
    private PopupButton input2ComboButton;
    private PopupButton outputComboButton;
    private JPanel input1ButtonAndArrowWrapperPanel;
    private JPanel input2ButtonAndArrowWrapperPanel;
    private ImageIcon defaultActionImage = ImageBuilder.buildFor((String)"/resources/images/actions/action_default.png");
    private ImageIcon comboImage = ImageBuilder.buildFor((String)"/resources/images/misc/combo.png");

    public ConfiguratorTableCellEditor(JFrame jFrame, ApplicationContext<?> applicationContext, ActionPackPluginManager actionPackPluginManager, TypeInformationProvider typeInformationProvider, List<Action.ActionVariable> list) {
        this.parent = jFrame;
        this.applicationContext = applicationContext;
        this.actionPackPluginManager = actionPackPluginManager;
        this.typeInformationProvider = typeInformationProvider;
        this.variables = list;
        this.cellEditorListeners = new EventListenerList();
        this.removeButtonActionListener = new RemoveButtonActionListener();
        this.actionConfiguratorCellEditorPanel = new ActionConfiguratorCellEditorPanel(applicationContext, this.removeButtonActionListener);
        this.actionConfiguratorCellEditorPanel.setLineColor(ACTION_BOX_BORDER_COLOR);
        this.emptyActionConfiguratorCellEditorPanel = new EmptyActionConfiguratorCellEditorPanel(applicationContext, this.removeButtonActionListener);
        this.labelConfiguratorCellEditorPanel = new LabelConfiguratorCellEditorPanel(applicationContext, this.removeButtonActionListener);
        JLabel jLabel = new JLabel(ImageBuilder.buildFor((String)"/resources/images/configuratorTableCellEditor/arrow_down.png"));
        this.input1VariablesButton = new PopupButton();
        this.input1VariablesButton.setOffsetX(-applicationContext.getUIManager().getPixelsForDots(32));
        this.setButtonProperties(this.input1VariablesButton, true);
        this.input1ComboButton = new PopupButton();
        this.input1ComboButton.setIcon(this.comboImage);
        this.input1ComboButton.setPressedIcon(this.comboImage);
        this.setButtonProperties(this.input1ComboButton, false);
        JPanel jPanel = new JPanel(new FlowLayout(3, 0, 0));
        jPanel.setOpaque(false);
        jPanel.setBorder(null);
        jPanel.add(this.input1ComboButton);
        jPanel.add(this.input1VariablesButton);
        JLabel jLabel2 = new JLabel(ImageBuilder.buildFor((String)"/resources/images/configuratorTableCellEditor/arrow_down.png"));
        this.input2VariablesButton = new PopupButton();
        this.input2VariablesButton.setOffsetX(-applicationContext.getUIManager().getPixelsForDots(32));
        this.setButtonProperties(this.input2VariablesButton, true);
        this.input2ComboButton = new PopupButton();
        this.input2ComboButton.setIcon(this.comboImage);
        this.input2ComboButton.setPressedIcon(this.comboImage);
        this.setButtonProperties(this.input2ComboButton, false);
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel2.setOpaque(false);
        jPanel2.setBorder(null);
        jPanel2.add(this.input2ComboButton);
        jPanel2.add(this.input2VariablesButton);
        this.outputVariablesButton = new PopupButton();
        this.outputVariablesButton.setOffsetX(-applicationContext.getUIManager().getPixelsForDots(32));
        this.setButtonProperties(this.outputVariablesButton, true);
        this.outputComboButton = new PopupButton();
        this.outputComboButton.setIcon(this.comboImage);
        this.outputComboButton.setPressedIcon(this.comboImage);
        this.setButtonProperties(this.outputComboButton, false);
        JPanel jPanel3 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel3.setOpaque(false);
        jPanel3.setBorder(null);
        jPanel3.add(this.outputComboButton);
        jPanel3.add(this.outputVariablesButton);
        this.input1ButtonAndArrowWrapperPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1));
        this.input1ButtonAndArrowWrapperPanel.setOpaque(false);
        this.input1ButtonAndArrowWrapperPanel.setBorder(null);
        this.input1ButtonAndArrowWrapperPanel.add(jPanel);
        this.input1ButtonAndArrowWrapperPanel.add(jLabel);
        this.input2ButtonAndArrowWrapperPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1));
        this.input2ButtonAndArrowWrapperPanel.setOpaque(false);
        this.input2ButtonAndArrowWrapperPanel.setBorder(BorderFactory.createEmptyBorder(0, applicationContext.getUIManager().getPixelsForDots(32), 0, 0));
        this.input2ButtonAndArrowWrapperPanel.add(jPanel2);
        this.input2ButtonAndArrowWrapperPanel.add(jLabel2);
        this.inputPanel = new JPanel(new FlowLayout(1, 1, 1));
        this.inputPanel.setOpaque(false);
        this.inputPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.inputPanel.add(this.input1ButtonAndArrowWrapperPanel);
        this.inputPanel.add(this.input2ButtonAndArrowWrapperPanel);
        this.noInputPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.noInputPanel.setOpaque(false);
        this.noInputPanel.setBorder(null);
        this.noInputPanel.add(new JLabel(ImageBuilder.buildFor((String)"/resources/images/configuratorTableCellEditor/separator.png")));
        this.outputPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1));
        this.outputPanel.setOpaque(false);
        this.outputPanel.setBorder(null);
        this.outputPanel.add(new JLabel(ImageBuilder.buildFor((String)"/resources/images/configuratorTableCellEditor/arrow_down.png")));
        this.outputPanel.add(jPanel3);
        this.noOutputPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.noOutputPanel.setOpaque(false);
        this.noOutputPanel.setBorder(null);
        this.noOutputPanel.add(new JLabel(ImageBuilder.buildFor((String)"/resources/images/configuratorTableCellEditor/separator.png")));
        this.contentWrapperPanel = new JPanel(new BorderLayout());
        this.contentWrapperPanel.setBorder(null);
        this.contentWrapperPanel.setOpaque(false);
        this.errorsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.errorsPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ACTION_BOX_BORDER_COLOR));
        this.errorsPanel.setBackground(Color.YELLOW);
        this.actionConfiguratorCellEditorPanel.setLineColor(ACTION_BOX_BORDER_COLOR);
    }

    private void setButtonProperties(JButton jButton, boolean bl) {
        jButton.setFocusPainted(false);
        jButton.setContentAreaFilled(false);
        if (bl) {
            jButton.setBorderPainted(true);
            jButton.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 10));
        } else {
            jButton.setBorderPainted(true);
            jButton.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        }
        jButton.setFont(this.applicationContext.getUIManager().getFont(UIManager.FontSize.MEDIUM));
        jButton.setIconTextGap(this.applicationContext.getUIManager().getPixelsForDots(7));
        jButton.setOpaque(true);
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentValue;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.cellEditorListeners.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.cellEditorListeners.remove(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return this.getEditorComponent(jTable, object, bl2, n, n2, false);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        return this.getEditorComponent(jTable, object, true, n, n2, true);
    }

    private Component getEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2, boolean bl2) {
        if (object != null) {
            Class clazz;
            ActionConfiguratorContainer actionConfiguratorContainer = (ActionConfiguratorContainer)object;
            if (bl2) {
                this.currentValue = actionConfiguratorContainer;
                this.removeButtonActionListener.table = jTable;
            }
            try {
                clazz = this.actionPackPluginManager.getActionClassForConfiguratorClass(actionConfiguratorContainer.getActionConfigurator().getClass());
            }
            catch (UnknownActionException unknownActionException) {
                clazz = UnknownAction.class;
            }
            String string = this.actionPackPluginManager.getLocalizedStringForActionClass(clazz, "title", "Untitled action");
            ImageIcon imageIcon = this.actionPackPluginManager.getIconForActionClass(clazz);
            if (imageIcon == null) {
                imageIcon = this.defaultActionImage;
            }
            if (actionConfiguratorContainer.getActionConfigurator().getClass().getCanonicalName().equals("de.oliver_matuschin.ttd.plugin.defaultActions.ui.configurator.LabelActionConfigurator")) {
                this.updateInputOutputOptions(jTable, n, actionConfiguratorContainer, this.labelConfiguratorCellEditorPanel);
                this.labelConfiguratorCellEditorPanel.setContent(imageIcon, actionConfiguratorContainer.getActionConfigurator().getContentPane());
                return this.labelConfiguratorCellEditorPanel.getPanel();
            }
            if (actionConfiguratorContainer.getActionConfigurator().getContentPane().getComponentCount() == 0) {
                if (bl && bl2) {
                    this.addActionListeners(jTable, n, actionConfiguratorContainer, this.emptyActionConfiguratorCellEditorPanel);
                }
                this.updateInputOutputOptions(jTable, n, actionConfiguratorContainer, this.emptyActionConfiguratorCellEditorPanel);
                this.emptyActionConfiguratorCellEditorPanel.setContent(imageIcon, string);
                return this.emptyActionConfiguratorCellEditorPanel.getPanel();
            }
            if (bl && bl2) {
                this.addActionListeners(jTable, n, actionConfiguratorContainer, this.actionConfiguratorCellEditorPanel);
            }
            this.updateInputOutputOptions(jTable, n, actionConfiguratorContainer, this.actionConfiguratorCellEditorPanel);
            this.errorsPanel.removeAll();
            this.contentWrapperPanel.removeAll();
            List<String> list = actionConfiguratorContainer.getActionConfigurator().getValidationErrors();
            if (list != null && list.size() > 0) {
                for (String string2 : list) {
                    JLabel jLabel = new JLabel(string2);
                    jLabel.setIcon(ImageBuilder.buildFor((String)"/resources/task_status_error.png"));
                    jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    this.errorsPanel.add(jLabel);
                }
                this.contentWrapperPanel.add((Component)this.errorsPanel, "North");
            }
            this.contentWrapperPanel.add((Component)actionConfiguratorContainer.getActionConfigurator().getContentPane(), "Center");
            this.actionConfiguratorCellEditorPanel.setContent(imageIcon, string, this.contentWrapperPanel);
            return this.actionConfiguratorCellEditorPanel.getPanel();
        }
        this.logger.log(Level.WARNING, "Cell renderer value was null! Editing: " + bl2);
        return null;
    }

    private void addActionListeners(JTable jTable, int n, ActionConfiguratorContainer actionConfiguratorContainer, AbstractActionConfiguratorCellEditorPanel abstractActionConfiguratorCellEditorPanel) {
        JPopupMenu jPopupMenu = this.createVariablePopupMenu(jTable, n, 0, actionConfiguratorContainer, abstractActionConfiguratorCellEditorPanel);
        JPopupMenu jPopupMenu2 = this.createVariablePopupMenu(jTable, n, 1, actionConfiguratorContainer, abstractActionConfiguratorCellEditorPanel);
        JPopupMenu jPopupMenu3 = this.createVariablePopupMenu(jTable, n, 2, actionConfiguratorContainer, abstractActionConfiguratorCellEditorPanel);
        this.input1ComboButton.setPopupMenu(jPopupMenu);
        this.input2ComboButton.setPopupMenu(jPopupMenu2);
        this.outputComboButton.setPopupMenu(jPopupMenu3);
        this.input1VariablesButton.setPopupMenu(jPopupMenu);
        this.input2VariablesButton.setPopupMenu(jPopupMenu2);
        this.outputVariablesButton.setPopupMenu(jPopupMenu3);
    }

    private JPopupMenu createVariablePopupMenu(final JTable jTable, final int n, final int n2, final ActionConfiguratorContainer actionConfiguratorContainer, final AbstractActionConfiguratorCellEditorPanel abstractActionConfiguratorCellEditorPanel) {
        Class clazz;
        ActionConfigurator actionConfigurator = actionConfiguratorContainer.getActionConfigurator();
        try {
            clazz = this.actionPackPluginManager.getActionClassForConfiguratorClass(actionConfigurator.getClass());
        }
        catch (UnknownActionException unknownActionException) {
            clazz = UnknownAction.class;
        }
        ActionMetadata actionMetadata = clazz.getAnnotation(ActionMetadata.class);
        final Type[] typeArray = this.actionPackPluginManager.getInputOutputTypesForActionClass(clazz);
        VariablePopupMenu variablePopupMenu = new VariablePopupMenu(this.applicationContext.getLocalizationProvider(), this.actionPackPluginManager, this.typeInformationProvider, this.variables, typeArray[n2], actionMetadata.strictInput() || n2 > 1);
        variablePopupMenu.addVariableSelectionListener(new VariablePopupMenu.VariableSelectionListener(){

            @Override
            public void variableSelected(Action.ConvertibleVariable convertibleVariable) {
                switch (n2) {
                    case 0: {
                        actionConfiguratorContainer.setInput1(convertibleVariable);
                        break;
                    }
                    case 1: {
                        actionConfiguratorContainer.setInput2(convertibleVariable);
                        break;
                    }
                    case 2: {
                        actionConfiguratorContainer.setOutput(convertibleVariable);
                    }
                }
                ConfiguratorTableCellEditor.this.updateInputOutputOptions(jTable, n, actionConfiguratorContainer, abstractActionConfiguratorCellEditorPanel);
            }
        });
        JMenuItem jMenuItem = new JMenuItem();
        if (n2 < 2) {
            jMenuItem.setText(this.applicationContext.getLocalizationProvider().getLocalizedString("editor.ConfiguratorTableCellEditor.popupmenu.noInput"));
        } else {
            jMenuItem.setText(this.applicationContext.getLocalizationProvider().getLocalizedString("editor.ConfiguratorTableCellEditor.popupmenu.noOutput"));
        }
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (n2) {
                    case 0: {
                        actionConfiguratorContainer.setInput1(null);
                        break;
                    }
                    case 1: {
                        actionConfiguratorContainer.setInput2(null);
                        break;
                    }
                    case 2: {
                        actionConfiguratorContainer.setOutput(null);
                    }
                }
                ConfiguratorTableCellEditor.this.updateInputOutputOptions(jTable, n, actionConfiguratorContainer, abstractActionConfiguratorCellEditorPanel);
            }
        });
        variablePopupMenu.add(jMenuItem);
        if (n2 == 2) {
            jMenuItem = new JMenuItem(this.applicationContext.getLocalizationProvider().getLocalizedString("editor.ConfiguratorTableCellEditor.popupmenu.newVariable"));
            variablePopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ConfiguratorTableCellEditor.this.triggerNewVariable(actionConfiguratorContainer, typeArray[n2])) {
                        ConfiguratorTableCellEditor.this.updateInputOutputOptions(jTable, n, actionConfiguratorContainer, abstractActionConfiguratorCellEditorPanel);
                    }
                }
            });
        }
        return variablePopupMenu;
    }

    private boolean triggerNewVariable(ActionConfiguratorContainer actionConfiguratorContainer, Type type) {
        JExtendedDialog jExtendedDialog = new JExtendedDialog(this.applicationContext.getLocalizationProvider().getLocalizedString("dialog.AddVariableDialog.title"), (Object)this.applicationContext.getLocalizationProvider().getLocalizedString("dialog.AddVariableDialog.message"), -1);
        Object object = jExtendedDialog.showInputDialog((Component)this.parent);
        if (object != null) {
            object = object.toString().replaceAll("[\u001e,\u001f,\u001e]", "");
        }
        if (object != null && !object.toString().trim().equals("")) {
            object = object.toString().trim();
            Action.ActionVariable actionVariable = null;
            for (Action.ActionVariable actionVariable2 : this.variables) {
                if (!actionVariable2.getName().equals(object)) continue;
                actionVariable = actionVariable2;
                break;
            }
            if (actionVariable != null && !actionVariable.getType().equals(type.getTypeName())) {
                jExtendedDialog = new JExtendedDialog(this.applicationContext.getLocalizationProvider().getLocalizedString("dialog.VariableExistsDialog.title"), (Object)this.applicationContext.getLocalizationProvider().getLocalizedString("dialog.VariableExistsDialog.message"), 0);
                jExtendedDialog.showDialog((Component)this.parent);
            } else {
                actionConfiguratorContainer.setOutput(new Action.ActionVariable(object.toString(), type.getTypeName()));
                if (actionVariable == null) {
                    this.variables.add(actionConfiguratorContainer.getOutput());
                }
                return true;
            }
        }
        return false;
    }

    private void updateInputOutputOptions(JTable jTable, int n, ActionConfiguratorContainer actionConfiguratorContainer, AbstractActionConfiguratorCellEditorPanel abstractActionConfiguratorCellEditorPanel) {
        Type[] typeArray;
        ActionConfigurator actionConfigurator = actionConfiguratorContainer.getActionConfigurator();
        try {
            typeArray = this.actionPackPluginManager.getInputOutputTypesForActionClass(this.actionPackPluginManager.getActionClassForConfiguratorClass(actionConfigurator.getClass()));
        }
        catch (UnknownActionException unknownActionException) {
            typeArray = this.actionPackPluginManager.getInputOutputTypesForActionClass(UnknownAction.class);
        }
        block25: for (int i = 0; i < 3; ++i) {
            Type[] typeArray2;
            Object object;
            Object object2;
            if (typeArray[i].getTypeName().equals(Void.class.getTypeName())) {
                switch (i) {
                    case 0: {
                        this.input1ButtonAndArrowWrapperPanel.setVisible(false);
                        break;
                    }
                    case 1: {
                        this.input2ButtonAndArrowWrapperPanel.setVisible(false);
                        if (!typeArray[i - 1].getTypeName().equals(Void.class.getTypeName())) break;
                        if (n <= 0 || jTable.getValueAt(n - 1, 0) == null) {
                            abstractActionConfiguratorCellEditorPanel.setInput(this.noInputPanel);
                            break;
                        }
                        object2 = (ActionConfiguratorContainer)jTable.getValueAt(n - 1, 0);
                        object = ((ActionConfiguratorContainer)object2).getActionConfigurator();
                        try {
                            typeArray2 = this.actionPackPluginManager.getInputOutputTypesForActionClass(this.actionPackPluginManager.getActionClassForConfiguratorClass(object.getClass()));
                        }
                        catch (UnknownActionException unknownActionException) {
                            typeArray2 = this.actionPackPluginManager.getInputOutputTypesForActionClass(UnknownAction.class);
                        }
                        if (!typeArray2[2].getTypeName().equals(Void.class.getTypeName())) {
                            abstractActionConfiguratorCellEditorPanel.setInput(this.noInputPanel);
                            break;
                        }
                        abstractActionConfiguratorCellEditorPanel.setInput(null);
                        break;
                    }
                    case 2: {
                        abstractActionConfiguratorCellEditorPanel.setOutput(this.noOutputPanel);
                    }
                }
                continue;
            }
            switch (i) {
                case 0: {
                    object2 = actionConfiguratorContainer.getInput1();
                    break;
                }
                case 1: {
                    object2 = actionConfiguratorContainer.getInput2();
                    break;
                }
                case 2: {
                    object2 = actionConfiguratorContainer.getOutput();
                    break;
                }
                default: {
                    object2 = null;
                }
            }
            object = null;
            typeArray2 = null;
            switch (i) {
                case 0: {
                    object = this.input1ComboButton;
                    typeArray2 = this.input1VariablesButton;
                    this.input1ButtonAndArrowWrapperPanel.setVisible(true);
                    break;
                }
                case 1: {
                    object = this.input2ComboButton;
                    typeArray2 = this.input2VariablesButton;
                    this.input2ButtonAndArrowWrapperPanel.setVisible(true);
                    break;
                }
                case 2: {
                    object = this.outputComboButton;
                    typeArray2 = this.outputVariablesButton;
                }
            }
            if (object2 != null) {
                block38: {
                    Action.ActionVariable actionVariable = null;
                    if (object2 instanceof Action.ConvertibleVariable) {
                        actionVariable = object2;
                    }
                    if (actionVariable != null && ((Action.ConvertibleVariable)actionVariable).getConverter() != null && ((Action.ConvertibleVariable)actionVariable).getConfiguration() != null) {
                        try {
                            TypeConverter typeConverter = this.actionPackPluginManager.getTypeConverterForName(((Action.ConvertibleVariable)actionVariable).getConverter());
                            List<TypeConverter.Option> list = typeConverter.getOptions(TypeUtil.getTypeFromString((String)actionVariable.getType()), typeArray[i]);
                            if (list != null && !list.isEmpty()) {
                                for (TypeConverter.Option option : list) {
                                    if (option == null || !((Action.ConvertibleVariable)actionVariable).getConfiguration().equals(option.getConfiguration())) continue;
                                    typeArray2.setText(actionVariable.getName() + ": " + option.getLocalizedDescription());
                                    break block38;
                                }
                                break block38;
                            }
                            typeArray2.setText(actionVariable.getName());
                        }
                        catch (UnknownTypeConverterException unknownTypeConverterException) {
                            typeArray2.setText("<error>");
                        }
                    } else {
                        typeArray2.setText(((Action.ActionVariable)object2).getName());
                    }
                }
                ((JComponent)object).setBackground(TaskTillDawnConstants.VARIABLE_COLOR);
                typeArray2.setBackground(TaskTillDawnConstants.VARIABLE_COLOR);
                typeArray2.setIcon(this.typeInformationProvider.getIconForType(TypeUtil.getTypeFromString((String)((Action.ActionVariable)object2).getType())));
                typeArray2.setPressedIcon(typeArray2.getIcon());
            } else {
                if (i < 2) {
                    typeArray2.setText(this.applicationContext.getLocalizationProvider().getLocalizedString("editor.ConfiguratorTableCellEditor.popupmenu.noInput"));
                } else {
                    typeArray2.setText(this.applicationContext.getLocalizationProvider().getLocalizedString("editor.ConfiguratorTableCellEditor.popupmenu.noOutput"));
                }
                ((JComponent)object).setBackground(Color.LIGHT_GRAY);
                typeArray2.setBackground(Color.LIGHT_GRAY);
                typeArray2.setIcon(this.typeInformationProvider.getIconForType(typeArray[i]));
                typeArray2.setPressedIcon(typeArray2.getIcon());
            }
            switch (i) {
                case 0: 
                case 1: {
                    abstractActionConfiguratorCellEditorPanel.setInput(this.inputPanel);
                    continue block25;
                }
                case 2: {
                    abstractActionConfiguratorCellEditorPanel.setOutput(this.outputPanel);
                }
            }
        }
    }

    private void fireEditingStopped() {
        CellEditorListener[] cellEditorListenerArray;
        for (CellEditorListener cellEditorListener : cellEditorListenerArray = (CellEditorListener[])this.cellEditorListeners.getListeners(CellEditorListener.class)) {
            cellEditorListener.editingStopped(new ChangeEvent(this));
        }
    }

    private void fireEditingCanceled() {
        CellEditorListener[] cellEditorListenerArray;
        for (CellEditorListener cellEditorListener : cellEditorListenerArray = (CellEditorListener[])this.cellEditorListeners.getListeners(CellEditorListener.class)) {
            cellEditorListener.editingCanceled(new ChangeEvent(this));
        }
    }

    private class RemoveButtonActionListener
    implements ActionListener {
        private JTable table;

        private RemoveButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.table.getSelectedRow();
            if (n != -1 && n < this.table.getRowCount()) {
                ConfiguratorTableCellEditor.this.fireEditingStopped();
                ActionConfiguratorContainer actionConfiguratorContainer = (ActionConfiguratorContainer)this.table.getModel().getValueAt(n, 0);
                if (actionConfiguratorContainer != null) {
                    ConfiguratorContext configuratorContext = actionConfiguratorContainer.getActionConfigurator().getConfiguratorContext();
                    List<VariableTextPaneWrapper> list = configuratorContext.getRegisteredVariableTextPaneWrappers();
                    for (VariableTextPaneWrapper variableTextPaneWrapper : list) {
                        variableTextPaneWrapper.dispose();
                    }
                }
                ((DefaultTableModel)this.table.getModel()).removeRow(n);
                this.updateRowHeights(this.table);
            }
        }

        private void updateRowHeights(JTable jTable) {
            if (jTable.isEditing()) {
                jTable.getCellEditor().stopCellEditing();
            }
            for (int i = 0; i < jTable.getRowCount(); ++i) {
                int n = jTable.getRowHeight();
                for (int j = 0; j < jTable.getColumnCount(); ++j) {
                    Component component = jTable.prepareRenderer(jTable.getCellRenderer(i, j), i, j);
                    if (component == null) continue;
                    n = Math.max(n, component.getPreferredSize().height);
                }
                jTable.setRowHeight(i, n);
            }
        }
    }
}

