/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.ui.button;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupButton
extends JButton {
    private JPopupMenu popupMenu = null;
    private long lastVisibility = 0L;
    private boolean showPopup = true;
    private int offsetX;
    private int offsetY;
    private PopupMenuListener popupMenuListener = new PopupMenuListener(){

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            PopupButton.this.lastVisibility = System.currentTimeMillis();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    };

    public PopupButton() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (System.currentTimeMillis() - PopupButton.this.lastVisibility < 200L) {
                    PopupButton.this.showPopup = false;
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PopupButton.this.showPopup && PopupButton.this.popupMenu != null) {
                    JButton jButton = (JButton)actionEvent.getSource();
                    PopupButton.this.popupMenu.show(jButton, PopupButton.this.offsetX, jButton.getHeight() + PopupButton.this.offsetY);
                } else {
                    PopupButton.this.lastVisibility = 0L;
                    PopupButton.this.showPopup = true;
                }
            }
        });
    }

    public PopupButton(Action action) {
        super(action);
        this.addMouseListener(new /* invalid duplicate definition of identical inner class */);
        this.addActionListener(new /* invalid duplicate definition of identical inner class */);
    }

    public PopupButton(Icon icon) {
        super(icon);
        this.addMouseListener(new /* invalid duplicate definition of identical inner class */);
        this.addActionListener(new /* invalid duplicate definition of identical inner class */);
    }

    public PopupButton(String string, Icon icon) {
        super(string, icon);
        this.addMouseListener(new /* invalid duplicate definition of identical inner class */);
        this.addActionListener(new /* invalid duplicate definition of identical inner class */);
    }

    public PopupButton(String string) {
        super(string);
        this.addMouseListener(new /* invalid duplicate definition of identical inner class */);
        this.addActionListener(new /* invalid duplicate definition of identical inner class */);
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        if (this.popupMenu != jPopupMenu) {
            this.showPopup = true;
            if (this.popupMenu != null) {
                this.popupMenu.removePopupMenuListener(this.popupMenuListener);
            }
            if (jPopupMenu != null) {
                jPopupMenu.addPopupMenuListener(this.popupMenuListener);
            }
            this.popupMenu = jPopupMenu;
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void removePopupMenu() {
        this.setPopupMenu(null);
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int n) {
        this.offsetX = n;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int n) {
        this.offsetY = n;
    }
}

