/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.tray;

import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.event.JExtendedMouseAdapter;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.listener.MacOSAdapter;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.ttd.application.TaskTillDawnApplication;
import de.oliver_matuschin.ttd.group.TaskGroupManager;
import de.oliver_matuschin.ttd.repository.TaskRepository;
import de.oliver_matuschin.ttd.scheduler.TaskScheduler;
import de.oliver_matuschin.ttd.scheduler.listener.TaskSchedulerEventListener;
import de.oliver_matuschin.ttd.ui.popupMenu.TaskPopupMenu;
import de.oliver_matuschin.ttd.ui.popupMenu.listener.TaskPopupMenuEventListener;
import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.EventQueue;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class TrayManager {
    private final Logger logger = Logger.getLogger(TrayManager.class.getName());
    private TaskTillDawnApplication application;
    private UIManager uiManager;
    private LocalizationProvider localizationProvider;
    private TaskScheduler scheduler;
    private TaskGroupManager taskGroupManager;
    private TaskRepository taskRepository;

    public TrayManager(ApplicationContext<TaskTillDawnApplication> applicationContext) {
        this.application = (TaskTillDawnApplication)applicationContext.getApplication();
        this.uiManager = applicationContext.getUIManager();
        this.localizationProvider = applicationContext.getLocalizationProvider();
        this.scheduler = this.application.getTaskScheduler();
        this.taskGroupManager = this.application.getTaskGroupManager();
        this.taskRepository = this.application.getTaskRepository();
        this.initTray();
    }

    private void initTray() {
        TaskPopupMenu taskPopupMenu;
        TaskPopupMenuEventListener taskPopupMenuEventListener = new TaskPopupMenuEventListener(){

            @Override
            public void taskSelected(String string) {
                TrayManager.this.scheduler.executeTask(string);
            }

            @Override
            public void groupSelected(String string) {
                if (string.equals("All tasks")) {
                    TrayManager.this.application.handleOpenTaskListWindow();
                } else {
                    TrayManager.this.application.handleOpenGroupWindow(string);
                }
            }
        };
        boolean bl = this.application.getPreferences().getBoolean("showTasksInMenu", true);
        boolean bl2 = this.application.getPreferences().getBoolean("hideDisabledTasksInMenu", true);
        boolean bl3 = this.application.getPreferences().getBoolean("showGroupsInMenu", true);
        if (this.application.getPlatform() == Platform.MACOS && !this.application.isAgent()) {
            taskPopupMenu = new TaskPopupMenu(this.taskRepository, this.taskGroupManager, this.localizationProvider, 2, true, true, true);
            taskPopupMenu.addTaskPopupMenuActionListener(taskPopupMenuEventListener);
            this.populatePopupMenu(taskPopupMenu, false);
            MacOSAdapter.setDockMenu((PopupMenu)taskPopupMenu);
        }
        if (SystemTray.isSupported() && (this.application.getPlatform() != Platform.MACOS || this.application.isAgent() || this.application.getPreferences().getBoolean("menuItemEnabled", true))) {
            taskPopupMenu = new TaskPopupMenu(this.taskRepository, this.taskGroupManager, this.localizationProvider, 2, bl, bl3, !bl2);
            taskPopupMenu.addTaskPopupMenuActionListener(taskPopupMenuEventListener);
            this.populatePopupMenu(taskPopupMenu, this.application.getPlatform() != Platform.MACOS || this.application.isAgent());
            if (this.uiManager.getDPIMultiplier() > 1.0f && taskPopupMenu.getFont() == null) {
                taskPopupMenu.setFont(new JLabel().getFont());
            }
            TrayIcon trayIcon = this.updateTrayIcon(taskPopupMenu);
            if (this.application.getPlatform() != Platform.MACOS) {
                trayIcon.addMouseListener((MouseListener)new JExtendedMouseAdapter(this.application.getPlatform()){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 0 && mouseEvent.getClickCount() % 2 == 0) {
                            TrayManager.this.application.handleOpenTaskListWindow();
                        }
                    }
                });
            }
            this.application.getPreferences().addPreferenceChangeListener(preferenceChangeEvent -> {
                if ("showTasksInMenu".equals(preferenceChangeEvent.getKey())) {
                    EventQueue.invokeLater(() -> taskPopupMenu.setShowTasks(Boolean.parseBoolean(preferenceChangeEvent.getNewValue())));
                } else if ("hideDisabledTasksInMenu".equals(preferenceChangeEvent.getKey())) {
                    EventQueue.invokeLater(() -> taskPopupMenu.setShowDisabledTasks(!Boolean.parseBoolean(preferenceChangeEvent.getNewValue())));
                } else if ("showGroupsInMenu".equals(preferenceChangeEvent.getKey())) {
                    EventQueue.invokeLater(() -> taskPopupMenu.setShowGroups(Boolean.parseBoolean(preferenceChangeEvent.getNewValue())));
                } else if ("useBlackAndWhiteMenuItemEnabled".equals(preferenceChangeEvent.getKey())) {
                    EventQueue.invokeLater(this::updateTrayIcon);
                }
            });
        }
    }

    private TrayIcon updateTrayIcon() {
        return this.updateTrayIcon(null);
    }

    private TrayIcon updateTrayIcon(PopupMenu popupMenu) {
        boolean bl = this.application.getPreferences().getBoolean("useBlackAndWhiteMenuItemEnabled", false);
        String string = bl ? "tray_icon.png" : "tray_icon_color.png";
        String string2 = null;
        if (this.application.getPlatform() != Platform.MACOS) {
            string2 = this.application.getApplicationName();
        }
        TrayIcon trayIcon = null;
        SystemTray systemTray = SystemTray.getSystemTray();
        try {
            TrayIcon[] trayIconArray = systemTray.getTrayIcons();
            ImageIcon imageIcon = ImageBuilder.buildFor((String)("/resources/" + string));
            if (trayIconArray.length == 0) {
                trayIcon = popupMenu != null ? new TrayIcon(imageIcon.getImage(), string2, popupMenu) : new TrayIcon(imageIcon.getImage(), string2);
                trayIcon.setImageAutoSize(true);
                systemTray.add(trayIcon);
            } else {
                trayIcon = trayIconArray[0];
                trayIcon.setImage(imageIcon.getImage());
            }
        }
        catch (AWTException aWTException) {
            this.logger.log(Level.INFO, "Could not set tray icon!", aWTException);
        }
        return trayIcon;
    }

    private void populatePopupMenu(PopupMenu popupMenu, boolean bl) {
        MenuItem menuItem = new MenuItem(this.localizationProvider.getLocalizedString("application.popupMenu.showTaskList"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrayManager.this.application.handleOpenTaskListWindow();
            }
        });
        popupMenu.insert(menuItem, 0);
        popupMenu.insert("-", 1);
        MenuItem menuItem2 = new MenuItem(this.localizationProvider.getLocalizedString("application.popupMenu.newTask"));
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrayManager.this.application.handleNewTask();
            }
        });
        popupMenu.add(menuItem2);
        popupMenu.addSeparator();
        Menu menu = new Menu(this.localizationProvider.getLocalizedString("application.popupMenu.import"));
        MenuItem menuItem3 = new MenuItem(this.localizationProvider.getLocalizedString("application.popupMenu.import.archive"));
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrayManager.this.application.handleImportTaskArchive();
            }
        });
        menu.add(menuItem3);
        popupMenu.add(menu);
        Menu menu2 = new Menu(this.localizationProvider.getLocalizedString("application.popupMenu.export"));
        MenuItem menuItem4 = new MenuItem(this.localizationProvider.getLocalizedString("application.popupMenu.export.archive"));
        menuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrayManager.this.application.handleExportTaskArchive();
            }
        });
        menu2.add(menuItem4);
        popupMenu.add(menu2);
        popupMenu.addSeparator();
        MenuItem menuItem5 = new MenuItem(this.localizationProvider.getLocalizedString("application.popupMenu.about") + " ...");
        menuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrayManager.this.application.handleAbout();
            }
        });
        popupMenu.add(menuItem5);
        MenuItem menuItem6 = new MenuItem(this.localizationProvider.getLocalizedString("application.popupMenu.sendFeedback"));
        menuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrayManager.this.application.handleFeedback();
            }
        });
        popupMenu.add(menuItem6);
        MenuItem menuItem7 = new MenuItem(this.localizationProvider.getLocalizedString("menu.help.donate"));
        menuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrayManager.this.application.handleDonation();
            }
        });
        popupMenu.add(menuItem7);
        MenuItem menuItem8 = new MenuItem(this.localizationProvider.getLocalizedString("application.popupMenu.checkForUpdates") + " ...");
        menuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrayManager.this.application.handleUpdateCheck();
            }
        });
        popupMenu.add(menuItem8);
        MenuItem menuItem9 = new MenuItem(this.localizationProvider.getLocalizedString("application.popupMenu.preferences"));
        menuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrayManager.this.application.handlePreferences();
            }
        });
        popupMenu.add(menuItem9);
        popupMenu.addSeparator();
        final CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(this.localizationProvider.getLocalizedString("menu.file.pauseTaskManager"));
        checkboxMenuItem.setState(this.application.getPreferences().getBoolean("pauseTaskManager", false));
        checkboxMenuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                checkboxMenuItem.setState(!checkboxMenuItem.getState());
                TrayManager.this.application.handlePauseTaskManager();
            }
        });
        this.scheduler.addTaskSchedulerListener(new TaskSchedulerEventListener(){

            @Override
            public void schedulingPaused() {
                checkboxMenuItem.setState(true);
            }

            @Override
            public void schedulingResumed() {
                checkboxMenuItem.setState(false);
            }
        });
        popupMenu.add(checkboxMenuItem);
        if (bl) {
            popupMenu.addSeparator();
            MenuItem menuItem10 = new MenuItem(this.localizationProvider.getLocalizedString("menu.application.quit"));
            menuItem10.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TrayManager.this.logger.fine("Application shutdown initiated by user using menuitem / dock-menu / tray-menu action.");
                    if (TrayManager.this.application.handleQuit()) {
                        System.exit(0);
                    }
                }
            });
            popupMenu.add(menuItem10);
        }
    }
}

