/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.oliver_matuschin.ttd.collect.ImmutableArrayList;
import de.oliver_matuschin.ttd.gson.ScheduleDeserializer;
import de.oliver_matuschin.ttd.gson.UTCDateAdapter;
import de.oliver_matuschin.ttd.repository.TaskRepository;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSONTaskStorageProvider
implements TaskRepository.TaskStorageProvider {
    private static final String TASK_FILE_EXTENSION = ".task";
    private static final String TASK_METADATA_FILE_EXTENSION = ".tmdata";
    private static final String SCHEDULE_METADATA_FILE_EXTENSION = ".smdata";
    private final Logger logger = Logger.getLogger(JSONTaskStorageProvider.class.getName());
    private List<String> lastUUIDs;
    private String storageDirectory;

    public JSONTaskStorageProvider(String string) {
        this.storageDirectory = string;
    }

    @Override
    public synchronized String nextId() {
        if (this.lastUUIDs == null) {
            this.lastUUIDs = new ArrayList<String>();
        }
        String string = UUID.randomUUID().toString();
        new File(this.storageDirectory).mkdirs();
        while (this.lastUUIDs.contains(string) || new File(this.storageDirectory + File.separator + string + TASK_METADATA_FILE_EXTENSION).exists() || new File(this.storageDirectory + File.separator + string + TASK_FILE_EXTENSION).exists() || new File(this.storageDirectory + File.separator + string + SCHEDULE_METADATA_FILE_EXTENSION).exists()) {
            string = UUID.randomUUID().toString();
        }
        this.lastUUIDs.add(string);
        if (this.lastUUIDs.size() > 500) {
            this.lastUUIDs.remove(0);
        }
        return string;
    }

    @Override
    public List<Task> loadTasks() {
        File file = new File(this.storageDirectory);
        file.mkdirs();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new UTCDateAdapter());
        gsonBuilder.registerTypeAdapter(AbstractSchedule.class, (Object)new ScheduleDeserializer());
        Gson gson = gsonBuilder.create();
        ArrayList<Task> arrayList = new ArrayList<Task>();
        File[] fileArray = file.listFiles();
        for (File file2 : fileArray) {
            if (!file2.getName().endsWith(TASK_FILE_EXTENSION)) continue;
            String string = file2.getName().substring(0, file2.getName().lastIndexOf(TASK_FILE_EXTENSION));
            try (FileReader fileReader = new FileReader(file2);){
                Task task = (Task)gson.fromJson((Reader)fileReader, Task.class);
                Field field = task.getClass().getDeclaredField("id");
                field.setAccessible(true);
                field.set(task, string);
                arrayList.add(task);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (task.getSchedules() == null) {
                this.logger.log(Level.WARNING, "Schedules are missing in task with id: " + task.getId() + "! Skipping task...");
                iterator.remove();
                continue;
            }
            if (task.getActions() != null) continue;
            this.logger.log(Level.WARNING, "Actions are missing in task of task with id: " + task.getId() + "! Skipping task...");
            iterator.remove();
        }
        return arrayList;
    }

    @Override
    public List<ScheduleMetadata> loadScheduleMetadatas() {
        File[] fileArray;
        File file = new File(this.storageDirectory);
        file.mkdirs();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new UTCDateAdapter());
        Gson gson = gsonBuilder.create();
        ArrayList<ScheduleMetadata> arrayList = new ArrayList<ScheduleMetadata>();
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.getName().endsWith(SCHEDULE_METADATA_FILE_EXTENSION)) continue;
            String string = file2.getName().substring(0, file2.getName().lastIndexOf(SCHEDULE_METADATA_FILE_EXTENSION));
            try (FileReader fileReader = new FileReader(file2);){
                arrayList.add(new ScheduleMetadata.ScheduleMetadataBuilder((ScheduleMetadata)gson.fromJson((Reader)fileReader, ScheduleMetadata.class)).withScheduleId(string).build());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    @Override
    public List<TaskMetadata> loadTaskMetadatas() {
        File[] fileArray;
        File file = new File(this.storageDirectory);
        file.mkdirs();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new UTCDateAdapter());
        Gson gson = gsonBuilder.create();
        ArrayList<TaskMetadata> arrayList = new ArrayList<TaskMetadata>();
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.getName().endsWith(TASK_METADATA_FILE_EXTENSION)) continue;
            String string = file2.getName().substring(0, file2.getName().lastIndexOf(TASK_METADATA_FILE_EXTENSION));
            try (FileReader fileReader = new FileReader(file2);){
                arrayList.add(new TaskMetadata.TaskMetadataBuilder((TaskMetadata)gson.fromJson((Reader)fileReader, TaskMetadata.class)).withTaskId(string).build());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    @Override
    public void storeTask(Task task) {
        this.logger.log(Level.FINEST, "Storing task: " + task.getId());
        new File(this.storageDirectory).mkdirs();
        File file = new File(this.storageDirectory + File.separator + task.getId() + TASK_FILE_EXTENSION);
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new UTCDateAdapter());
        Gson gson = gsonBuilder.create();
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(gson.toJson((Object)task));
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, "Failed to store task with id: " + task.getId() + " with task named: " + task.getName(), iOException);
        }
    }

    @Override
    public void storeTaskMetadata(TaskMetadata taskMetadata) {
        this.logger.log(Level.FINEST, "Storing taskMetadata: " + taskMetadata.getTaskId());
        new File(this.storageDirectory).mkdirs();
        File file = new File(this.storageDirectory + File.separator + taskMetadata.getTaskId() + TASK_METADATA_FILE_EXTENSION);
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new UTCDateAdapter());
        Gson gson = gsonBuilder.create();
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(gson.toJson((Object)taskMetadata));
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, "Failed to store taskMetadata of task with id: " + taskMetadata.getTaskId() + "!", iOException);
        }
    }

    @Override
    public void storeScheduleMetadata(ScheduleMetadata scheduleMetadata) {
        this.logger.log(Level.FINEST, "Storing scheduleMetadata: " + scheduleMetadata.getScheduleId());
        new File(this.storageDirectory).mkdirs();
        File file = new File(this.storageDirectory + File.separator + scheduleMetadata.getScheduleId() + SCHEDULE_METADATA_FILE_EXTENSION);
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new UTCDateAdapter());
        Gson gson = gsonBuilder.create();
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(gson.toJson((Object)scheduleMetadata));
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, "Failed to store scheduleMetadata of schedule with id: " + scheduleMetadata.getScheduleId() + "!", iOException);
        }
    }

    @Override
    public void deleteTask(Task task) {
        new File(this.storageDirectory).mkdirs();
        File file = new File(this.storageDirectory + File.separator + task.getId() + TASK_FILE_EXTENSION);
        File file2 = new File(this.storageDirectory + File.separator + task.getId() + TASK_METADATA_FILE_EXTENSION);
        if (file.exists()) {
            file.delete();
        }
        if (file2.exists()) {
            file2.delete();
        }
        ImmutableArrayList<AbstractSchedule> immutableArrayList = task.getSchedules();
        for (AbstractSchedule abstractSchedule : immutableArrayList) {
            this.deleteScheduleMetadata(abstractSchedule.getId());
        }
    }

    @Override
    public void deleteScheduleMetadata(String string) {
        new File(this.storageDirectory).mkdirs();
        File file = new File(this.storageDirectory + File.separator + string + SCHEDULE_METADATA_FILE_EXTENSION);
        if (file.exists()) {
            file.delete();
        }
    }
}

