/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.scheduler.task.schedule.metadata;

import java.util.Date;

public class ScheduleMetadata {
    private transient String scheduleId;
    private Date start;
    private Date intermediateStart;
    private Date end;
    private Date successfulStart;
    private Date nextFireTime;
    private Date resultTime;
    private ResultType resultType;
    private ResultReason resultReason;
    private String resultDescription;
    private String cause;
    private int flag;

    private ScheduleMetadata(String string, Date date, Date date2, Date date3, Date date4, Date date5, Date date6, ResultType resultType, ResultReason resultReason, String string2, String string3, int n) {
        this.scheduleId = string;
        if (date != null) {
            this.start = new Date(date.getTime());
        }
        if (date2 != null) {
            this.intermediateStart = new Date(date2.getTime());
        }
        if (date3 != null) {
            this.end = new Date(date3.getTime());
        }
        if (date4 != null) {
            this.successfulStart = new Date(date4.getTime());
        }
        if (date5 != null) {
            this.nextFireTime = new Date(date5.getTime());
        }
        if (date6 != null) {
            this.resultTime = new Date(date6.getTime());
        }
        this.resultType = resultType;
        this.resultReason = resultReason;
        this.resultDescription = string2;
        this.cause = string3;
        this.flag = n;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getIntermediateStart() {
        return this.intermediateStart;
    }

    public Date getEnd() {
        return this.end;
    }

    public Date getSuccessfulStart() {
        return this.successfulStart;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public Date getResultTime() {
        return this.resultTime;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public ResultReason getResultReason() {
        return this.resultReason;
    }

    public String getResultDescription() {
        return this.resultDescription;
    }

    public String getCause() {
        return this.cause;
    }

    public int getFlag() {
        return this.flag;
    }

    public static class ScheduleMetadataBuilder {
        private String scheduleId;
        private Date start;
        private Date intermediateStart;
        private Date end;
        private Date successfulStart;
        private Date nextFireTime;
        private Date resultTime;
        private ResultType resultType = ResultType.INFO;
        private ResultReason resultReason = ResultReason.OTHER;
        private String resultDescription;
        private String cause;
        private int flag;

        public ScheduleMetadataBuilder() {
        }

        public ScheduleMetadataBuilder(ScheduleMetadata scheduleMetadata) {
            this.scheduleId = scheduleMetadata.scheduleId;
            this.start = scheduleMetadata.start;
            this.intermediateStart = scheduleMetadata.intermediateStart;
            this.end = scheduleMetadata.end;
            this.successfulStart = scheduleMetadata.successfulStart;
            this.nextFireTime = scheduleMetadata.nextFireTime;
            this.resultTime = scheduleMetadata.resultTime;
            this.resultType = scheduleMetadata.resultType;
            this.resultReason = scheduleMetadata.resultReason;
            this.resultDescription = scheduleMetadata.resultDescription;
            this.cause = scheduleMetadata.cause;
            this.flag = scheduleMetadata.flag;
        }

        public ScheduleMetadataBuilder withScheduleId(String string) {
            this.scheduleId = string;
            return this;
        }

        public ScheduleMetadataBuilder withStart(Date date) {
            this.start = date;
            return this;
        }

        public ScheduleMetadataBuilder withIntermediateStart(Date date) {
            this.intermediateStart = date;
            return this;
        }

        public ScheduleMetadataBuilder withEnd(Date date) {
            this.end = date;
            return this;
        }

        public ScheduleMetadataBuilder withSuccessfulStart(Date date) {
            this.successfulStart = date;
            return this;
        }

        public ScheduleMetadataBuilder withNextFireTime(Date date) {
            this.nextFireTime = date;
            return this;
        }

        public ScheduleMetadataBuilder withResultTime(Date date) {
            this.resultTime = date;
            return this;
        }

        public ScheduleMetadataBuilder withResultType(ResultType resultType) {
            this.resultType = resultType;
            return this;
        }

        public ScheduleMetadataBuilder withResultReason(ResultReason resultReason) {
            this.resultReason = resultReason;
            return this;
        }

        public ScheduleMetadataBuilder withResultDescription(String string) {
            this.resultDescription = string;
            return this;
        }

        public ScheduleMetadataBuilder withCause(String string) {
            this.cause = string;
            return this;
        }

        public ScheduleMetadataBuilder withFlag(int n) {
            this.flag = n;
            return this;
        }

        public ScheduleMetadata build() {
            return new ScheduleMetadata(this.scheduleId, this.start, this.intermediateStart, this.end, this.successfulStart, this.nextFireTime, this.resultTime, this.resultType, this.resultReason, this.resultDescription, this.cause, this.flag);
        }
    }

    public static enum ResultReason {
        SUCCESS,
        SCHEDULE_MISSED,
        EXECUTION_CANCELED,
        JUMP_LABEL_MISSING,
        INTERNAL_ERROR,
        OTHER;

    }

    public static enum ResultType {
        INFO,
        WARNING,
        ERROR;

    }
}

