/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.scheduler.task.schedule;

import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractRestrictedTimeSchedule;
import java.util.Calendar;
import java.util.Date;

public class TimeSchedule
extends AbstractRestrictedTimeSchedule {
    private Date specifiedTime;

    private TimeSchedule(String string, Date date, Date date2, Date date3, Date date4, int n, int n2, Date date5, boolean bl) {
        super(string, date, date2, date3, date4, n, n2, bl);
        if (date5 != null) {
            this.specifiedTime = new Date(date5.getTime());
        }
    }

    public Date getSpecifiedTime() {
        return this.specifiedTime;
    }

    @Override
    public Date getInitialFireTimeFor(Date date) {
        return this.calculateNextFireTime(date, true);
    }

    @Override
    public Date getFireTimeFor(Date date) {
        return this.calculateNextFireTime(date, false);
    }

    private Date calculateNextFireTime(Date date, boolean bl) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        Calendar calendar3 = Calendar.getInstance();
        calendar3.setTime(this.getSpecifiedTime());
        calendar2.set(11, calendar3.get(11));
        calendar2.set(12, calendar3.get(12));
        calendar2.set(13, calendar3.get(13));
        calendar2.set(14, 0);
        if (calendar2.before(calendar) || calendar2.equals(calendar) && !bl) {
            calendar2.add(5, 1);
        }
        if (this.getWeekdays() < 127) {
            int n = 0;
            if (this.getWeekdays() <= 0) {
                return null;
            }
            while (this.getWeekdays() != 127) {
                switch (calendar2.get(7)) {
                    case 2: {
                        n = 1;
                        break;
                    }
                    case 3: {
                        n = 2;
                        break;
                    }
                    case 4: {
                        n = 4;
                        break;
                    }
                    case 5: {
                        n = 8;
                        break;
                    }
                    case 6: {
                        n = 16;
                        break;
                    }
                    case 7: {
                        n = 32;
                        break;
                    }
                    case 1: {
                        n = 64;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if ((this.getWeekdays() & n) != 0) break;
                calendar2.add(5, 1);
            }
        }
        if (this.getDayOfMonth() > 0) {
            if (this.getDayOfMonth() > 31) {
                calendar2.set(5, calendar2.getActualMaximum(5));
            } else {
                while (calendar2.get(5) != this.getDayOfMonth()) {
                    calendar2.set(5, this.getDayOfMonth());
                }
            }
            if (calendar2.before(calendar) || calendar2.equals(calendar) && !bl) {
                calendar2.add(2, 1);
            }
        }
        return calendar2.getTime();
    }

    public static class TimeScheduleBuilder {
        private String id;
        private Date created;
        private Date changed;
        private Date validFrom;
        private Date validUntil;
        private boolean skipIfMissed;
        private int weekdays;
        private int dayOfMonth;
        private Date specifiedTime;

        public TimeScheduleBuilder() {
        }

        public TimeScheduleBuilder(TimeSchedule timeSchedule) {
            this.id = timeSchedule.getId();
            this.created = timeSchedule.getCreated();
            this.changed = timeSchedule.getChanged();
            this.validFrom = timeSchedule.getValidFrom();
            this.validUntil = timeSchedule.getValidUntil();
            this.skipIfMissed = timeSchedule.isSkipIfMissed();
            this.weekdays = timeSchedule.getWeekdays();
            this.dayOfMonth = timeSchedule.getDayOfMonth();
            this.specifiedTime = timeSchedule.specifiedTime;
        }

        public TimeScheduleBuilder withId(String string) {
            this.id = string;
            return this;
        }

        public TimeScheduleBuilder withCreated(Date date) {
            this.created = date;
            return this;
        }

        public TimeScheduleBuilder withChanged(Date date) {
            this.changed = date;
            return this;
        }

        public TimeScheduleBuilder withValidFrom(Date date) {
            this.validFrom = date;
            return this;
        }

        public TimeScheduleBuilder withValidUntil(Date date) {
            this.validUntil = date;
            return this;
        }

        public TimeScheduleBuilder withSkipIfMissed(boolean bl) {
            this.skipIfMissed = bl;
            return this;
        }

        public TimeScheduleBuilder withWeekdays(int n) {
            this.weekdays = n;
            return this;
        }

        public TimeScheduleBuilder withDayOfMonth(int n) {
            this.dayOfMonth = n;
            return this;
        }

        public TimeScheduleBuilder withSpecifiedTime(Date date) {
            this.specifiedTime = date;
            return this;
        }

        public TimeSchedule build() {
            return new TimeSchedule(this.id, this.created, this.changed, this.validFrom, this.validUntil, this.weekdays, this.dayOfMonth, this.specifiedTime, this.skipIfMissed);
        }
    }
}

