/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.scheduler.task.schedule;

import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractRestrictedTimeSchedule;
import java.util.Calendar;
import java.util.Date;

public class IntervalSchedule
extends AbstractRestrictedTimeSchedule {
    private int intervalInSeconds;
    private Date intervalStart;
    private Date intervalEnd;

    private IntervalSchedule(String string, Date date, Date date2, Date date3, Date date4, int n, int n2, int n3, Date date5, Date date6, boolean bl) {
        super(string, date, date2, date3, date4, n, n2, bl);
        this.intervalInSeconds = n3;
        if (date5 != null) {
            this.intervalStart = new Date(date5.getTime());
        }
        if (date6 != null) {
            this.intervalEnd = new Date(date6.getTime());
        }
    }

    public int getIntervalInSeconds() {
        return this.intervalInSeconds;
    }

    public Date getIntervalStart() {
        return this.intervalStart;
    }

    public Date getIntervalEnd() {
        return this.intervalEnd;
    }

    @Override
    public Date getInitialFireTimeFor(Date date) {
        return this.calculateFireTime(date, false);
    }

    @Override
    public Date getFireTimeFor(Date date) {
        return this.calculateFireTime(date, true);
    }

    private Date calculateFireTime(Date date, boolean bl) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        calendar2.set(14, 0);
        if (bl) {
            calendar2.add(13, this.getIntervalInSeconds());
        }
        if (this.getIntervalStart() != null && this.getIntervalEnd() != null) {
            Calendar calendar3 = Calendar.getInstance();
            Calendar calendar4 = Calendar.getInstance();
            calendar3.setTime(this.getIntervalStart());
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar4.setTime(this.getIntervalEnd());
            calendar4.set(13, 0);
            calendar4.set(14, 0);
            calendar3.set(calendar2.get(1), calendar2.get(2), calendar2.get(5));
            calendar4.set(calendar2.get(1), calendar2.get(2), calendar2.get(5));
            if (calendar3.before(calendar4) || calendar3.equals(calendar4)) {
                if (calendar2.before(calendar3)) {
                    calendar2.set(11, calendar3.get(11));
                    calendar2.set(12, calendar3.get(12));
                    calendar2.set(13, 0);
                    calendar2.set(14, 0);
                } else if (calendar2.after(calendar4)) {
                    calendar2.add(5, 1);
                    calendar2.set(11, calendar3.get(11));
                    calendar2.set(12, calendar3.get(12));
                    calendar2.set(13, 0);
                    calendar2.set(14, 0);
                }
            } else if (calendar2.after(calendar4) && calendar2.before(calendar3)) {
                calendar2.set(11, calendar3.get(11));
                calendar2.set(12, calendar3.get(12));
                calendar2.set(13, 0);
                calendar2.set(14, 0);
            }
        }
        if (this.getWeekdays() < 127) {
            int n = 0;
            if (this.getWeekdays() <= 0) {
                return null;
            }
            while (this.getWeekdays() != 127) {
                switch (calendar2.get(7)) {
                    case 2: {
                        n = 1;
                        break;
                    }
                    case 3: {
                        n = 2;
                        break;
                    }
                    case 4: {
                        n = 4;
                        break;
                    }
                    case 5: {
                        n = 8;
                        break;
                    }
                    case 6: {
                        n = 16;
                        break;
                    }
                    case 7: {
                        n = 32;
                        break;
                    }
                    case 1: {
                        n = 64;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if ((this.getWeekdays() & n) != 0) break;
                calendar2.add(5, 1);
                this.resetTime(calendar2);
                this.handleIntervalLimit(this, calendar2);
            }
        }
        if (this.getDayOfMonth() > 0) {
            int n = calendar2.get(5);
            int n2 = calendar2.get(2);
            if (this.getDayOfMonth() > 31) {
                calendar2.set(5, calendar2.getActualMaximum(5));
            } else {
                while (calendar2.get(5) != this.getDayOfMonth()) {
                    calendar2.set(5, this.getDayOfMonth());
                }
                if (calendar2.before(calendar) || calendar2.equals(calendar) && bl) {
                    calendar2.add(2, 1);
                }
            }
            if (n != calendar2.get(5) || n2 != calendar2.get(2)) {
                this.resetTime(calendar2);
                this.handleIntervalLimit(this, calendar2);
            }
        }
        return calendar2.getTime();
    }

    private void resetTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private void handleIntervalLimit(IntervalSchedule intervalSchedule, Calendar calendar) {
        if (intervalSchedule.getIntervalStart() != null && intervalSchedule.getIntervalEnd() != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(intervalSchedule.getIntervalStart());
            calendar2.set(13, 0);
            calendar2.set(14, 0);
            Calendar calendar3 = Calendar.getInstance();
            calendar3.setTime(intervalSchedule.getIntervalEnd());
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar2.set(calendar.get(1), calendar.get(2), calendar.get(5));
            calendar3.set(calendar.get(1), calendar.get(2), calendar.get(5));
            if (calendar2.before(calendar3) || calendar2.equals(calendar3)) {
                calendar.set(11, calendar2.get(11));
                calendar.set(12, calendar2.get(12));
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
            }
        }
    }

    public static class IntervalScheduleBuilder {
        private String id;
        private Date creationDate;
        private Date changeDate;
        private Date validFrom;
        private Date validUntil;
        private boolean skipIfMissed;
        private int weekdays;
        private int dayOfMonth;
        private int intervalInSeconds;
        private Date intervalStart;
        private Date intervalEnd;

        public IntervalScheduleBuilder() {
        }

        public IntervalScheduleBuilder(IntervalSchedule intervalSchedule) {
            this.id = intervalSchedule.getId();
            this.creationDate = intervalSchedule.getCreated();
            this.changeDate = intervalSchedule.getChanged();
            this.validFrom = intervalSchedule.getValidFrom();
            this.validUntil = intervalSchedule.getValidUntil();
            this.skipIfMissed = intervalSchedule.isSkipIfMissed();
            this.weekdays = intervalSchedule.getWeekdays();
            this.dayOfMonth = intervalSchedule.getDayOfMonth();
            this.intervalInSeconds = intervalSchedule.intervalInSeconds;
            this.intervalStart = intervalSchedule.intervalStart;
            this.intervalEnd = intervalSchedule.intervalEnd;
        }

        public IntervalScheduleBuilder withId(String string) {
            this.id = string;
            return this;
        }

        public IntervalScheduleBuilder withCreationDate(Date date) {
            this.creationDate = date;
            return this;
        }

        public IntervalScheduleBuilder withChangeDate(Date date) {
            this.changeDate = date;
            return this;
        }

        public IntervalScheduleBuilder withValidFrom(Date date) {
            this.validFrom = date;
            return this;
        }

        public IntervalScheduleBuilder withValidUntil(Date date) {
            this.validUntil = date;
            return this;
        }

        public IntervalScheduleBuilder withSkipIfMissed(boolean bl) {
            this.skipIfMissed = bl;
            return this;
        }

        public IntervalScheduleBuilder withWeekdays(int n) {
            this.weekdays = n;
            return this;
        }

        public IntervalScheduleBuilder withDayOfMonth(int n) {
            this.dayOfMonth = n;
            return this;
        }

        public IntervalScheduleBuilder withIntervalInSeconds(int n) {
            this.intervalInSeconds = n;
            return this;
        }

        public IntervalScheduleBuilder withIntervalStart(Date date) {
            this.intervalStart = date;
            return this;
        }

        public IntervalScheduleBuilder withIntervalEnd(Date date) {
            this.intervalEnd = date;
            return this;
        }

        public IntervalSchedule build() {
            return new IntervalSchedule(this.id, this.creationDate, this.changeDate, this.validFrom, this.validUntil, this.weekdays, this.dayOfMonth, this.intervalInSeconds, this.intervalStart, this.intervalEnd, this.skipIfMissed);
        }
    }
}

