/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.scheduler.task.metadata;

import java.math.BigInteger;

public class TaskMetadata {
    private transient String taskId;
    private boolean taskEnabled;
    private boolean notificationsDisabled;
    private BigInteger successfulExecutionCount;
    private BigInteger totalExecutionCount;

    private TaskMetadata(String string, boolean bl, boolean bl2, BigInteger bigInteger, BigInteger bigInteger2) {
        this.taskId = string;
        this.taskEnabled = bl;
        this.notificationsDisabled = bl2;
        this.successfulExecutionCount = bigInteger;
        this.totalExecutionCount = bigInteger2;
    }

    public BigInteger getSuccessfulExecutionCount() {
        return this.successfulExecutionCount;
    }

    public BigInteger getTotalExecutionCount() {
        return this.totalExecutionCount;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public boolean isTaskEnabled() {
        return this.taskEnabled;
    }

    public boolean isNotificationsDisabled() {
        return this.notificationsDisabled;
    }

    public static class TaskMetadataBuilder {
        private String taskId;
        private boolean taskEnabled;
        private boolean notificationsDisabled;
        private BigInteger successfulExecutionCount = BigInteger.ZERO;
        private BigInteger totalExecutionCount = BigInteger.ZERO;

        public TaskMetadataBuilder() {
        }

        public TaskMetadataBuilder(TaskMetadata taskMetadata) {
            this.taskId = taskMetadata.taskId;
            this.taskEnabled = taskMetadata.taskEnabled;
            this.notificationsDisabled = taskMetadata.notificationsDisabled;
            this.successfulExecutionCount = taskMetadata.successfulExecutionCount;
            this.totalExecutionCount = taskMetadata.totalExecutionCount;
        }

        public TaskMetadataBuilder withTaskId(String string) {
            this.taskId = string;
            return this;
        }

        public TaskMetadataBuilder withTaskEnabled(boolean bl) {
            this.taskEnabled = bl;
            return this;
        }

        public TaskMetadataBuilder withNotificationsDisabled(boolean bl) {
            this.notificationsDisabled = bl;
            return this;
        }

        public TaskMetadataBuilder withSuccessfulExecutionCount(BigInteger bigInteger) {
            this.successfulExecutionCount = bigInteger;
            return this;
        }

        public TaskMetadataBuilder withTotalExecutionCount(BigInteger bigInteger) {
            this.totalExecutionCount = bigInteger;
            return this;
        }

        public TaskMetadata build() {
            return new TaskMetadata(this.taskId, this.taskEnabled, this.notificationsDisabled, this.successfulExecutionCount, this.totalExecutionCount);
        }
    }
}

