/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.scheduler.task.action;

import de.oliver_matuschin.ttd.collect.ImmutableHashMap;
import java.util.Map;

public class Action {
    private String type;
    private String label;
    private ConvertibleVariable input1;
    private ConvertibleVariable input2;
    private ActionVariable output;
    private Map<String, Object> configuration;
    private transient ImmutableHashMap<String, Object> immutableConfiguration;

    public Action(String string, String string2, ConvertibleVariable convertibleVariable, ConvertibleVariable convertibleVariable2, ActionVariable actionVariable, ImmutableHashMap<String, Object> immutableHashMap) {
        this.type = string;
        this.label = string2;
        this.input1 = convertibleVariable;
        this.input2 = convertibleVariable2;
        this.output = actionVariable;
        if (immutableHashMap != null) {
            this.configuration = immutableHashMap.asMap();
        }
        this.immutableConfiguration = immutableHashMap;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public ActionVariable getOutput() {
        return this.output;
    }

    public ConvertibleVariable getInput1() {
        return this.input1;
    }

    public ConvertibleVariable getInput2() {
        return this.input2;
    }

    public synchronized ImmutableHashMap<String, Object> getConfiguration() {
        if (this.immutableConfiguration == null && this.configuration != null) {
            this.immutableConfiguration = new ImmutableHashMap<String, Object>(this.configuration);
        }
        return this.immutableConfiguration;
    }

    public static class ConvertibleVariable
    extends ActionVariable {
        private String converter;
        private String configuration;

        public ConvertibleVariable(String string, String string2, String string3, String string4) {
            super(string, string2);
            this.converter = string3;
            this.configuration = string4;
        }

        public ConvertibleVariable(String string, String string2, String string3) {
            this(string, string2, string3, null);
        }

        public ConvertibleVariable(String string, String string2) {
            this(string, string2, null, null);
        }

        public String getConverter() {
            return this.converter;
        }

        public String getConfiguration() {
            return this.configuration;
        }
    }

    public static class ActionVariable {
        private String name;
        private String type;

        public ActionVariable(String string, String string2) {
            this.name = string;
            this.type = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class ActionBuilder {
        private String type;
        private String label;
        private ConvertibleVariable input1;
        private ConvertibleVariable input2;
        private ActionVariable output;
        private ImmutableHashMap<String, Object> configuration;

        public ActionBuilder() {
        }

        public ActionBuilder(Action action) {
            this.type = action.type;
            this.label = action.label;
            this.input1 = action.input1;
            this.input2 = action.input2;
            this.output = action.output;
            this.configuration = action.getConfiguration();
        }

        public ActionBuilder withType(String string) {
            this.type = string;
            return this;
        }

        public ActionBuilder withLabel(String string) {
            this.label = string;
            return this;
        }

        public ActionBuilder withInput1(ConvertibleVariable convertibleVariable) {
            this.input1 = convertibleVariable;
            return this;
        }

        public ActionBuilder withInput2(ConvertibleVariable convertibleVariable) {
            this.input2 = convertibleVariable;
            return this;
        }

        public ActionBuilder withOutput(ActionVariable actionVariable) {
            this.output = actionVariable;
            return this;
        }

        public ActionBuilder withConfiguration(ImmutableHashMap<String, Object> immutableHashMap) {
            this.configuration = immutableHashMap;
            return this;
        }

        public Action build() {
            return new Action(this.type, this.label, this.input1, this.input2, this.output, this.configuration);
        }
    }
}

