/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.scheduler.task;

import de.oliver_matuschin.ttd.collect.ImmutableArrayList;
import de.oliver_matuschin.ttd.collect.ImmutableHashMap;
import de.oliver_matuschin.ttd.scheduler.task.action.Action;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Task {
    private transient String id;
    private String name;
    private String description;
    private Date created;
    private Date changed;
    private BigInteger maximumExecutionCount;
    private boolean deleteAfterMaximumExecutionsReached;
    private transient ImmutableArrayList<AbstractSchedule> immutableSchedules;
    private transient ImmutableHashMap<String, ImmutableArrayList<Action>> immutableActions;
    private List<AbstractSchedule> schedules;
    private Map<String, List<Action>> actions;

    private Task(String string, String string2, String string3, Date date, Date date2, BigInteger bigInteger, boolean bl, ImmutableArrayList<AbstractSchedule> immutableArrayList, ImmutableHashMap<String, ImmutableArrayList<Action>> immutableHashMap) {
        this.id = string;
        this.name = string2;
        this.description = string3;
        if (date != null) {
            this.created = new Date(date.getTime());
        }
        if (date2 != null) {
            this.changed = new Date(date2.getTime());
        }
        this.maximumExecutionCount = bigInteger;
        this.deleteAfterMaximumExecutionsReached = bl;
        if (immutableArrayList != null) {
            this.schedules = immutableArrayList.asList();
        }
        this.immutableSchedules = immutableArrayList;
        if (immutableHashMap != null) {
            this.actions = new HashMap<String, List<Action>>();
            for (String string4 : immutableHashMap.keySet()) {
                this.actions.put(string4, immutableHashMap.get(string4).asList());
            }
        }
        this.immutableActions = immutableHashMap;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getChanged() {
        return this.changed;
    }

    public BigInteger getMaximumExecutionCount() {
        return this.maximumExecutionCount;
    }

    public boolean isDeleteAfterMaximumExecutionsReached() {
        return this.deleteAfterMaximumExecutionsReached;
    }

    public synchronized ImmutableArrayList<AbstractSchedule> getSchedules() {
        if (this.immutableSchedules == null && this.schedules != null) {
            this.immutableSchedules = new ImmutableArrayList<AbstractSchedule>(this.schedules);
        }
        return this.immutableSchedules;
    }

    public synchronized ImmutableHashMap<String, ImmutableArrayList<Action>> getActions() {
        if (this.immutableActions == null && this.actions != null) {
            HashMap hashMap = new HashMap();
            for (String string : this.actions.keySet()) {
                hashMap.put(string, new ImmutableArrayList(this.actions.get(string)));
            }
            this.immutableActions = new ImmutableHashMap(hashMap);
        }
        return this.immutableActions;
    }

    public static class TaskBuilder {
        private String id;
        private String name = "";
        private String description = "";
        private Date created;
        private Date changed;
        private BigInteger maximumExecutionCount = BigInteger.ZERO;
        private boolean deleteAfterMaximumExecutionsReached;
        private ImmutableArrayList<AbstractSchedule> schedules = new ImmutableArrayList();
        private ImmutableHashMap<String, ImmutableArrayList<Action>> actions = new ImmutableHashMap();

        public TaskBuilder() {
        }

        public TaskBuilder(Task task) {
            this.id = task.id;
            this.name = task.name;
            this.description = task.description;
            this.created = task.created;
            this.changed = task.changed;
            this.maximumExecutionCount = task.maximumExecutionCount;
            this.deleteAfterMaximumExecutionsReached = task.deleteAfterMaximumExecutionsReached;
            this.schedules = task.getSchedules();
            this.actions = task.getActions();
        }

        public TaskBuilder withId(String string) {
            this.id = string;
            return this;
        }

        public TaskBuilder withName(String string) {
            this.name = string;
            return this;
        }

        public TaskBuilder withDescription(String string) {
            this.description = string;
            return this;
        }

        public TaskBuilder withCreated(Date date) {
            this.created = date;
            return this;
        }

        public TaskBuilder withChanged(Date date) {
            this.changed = date;
            return this;
        }

        public TaskBuilder withMaximumExecutionCount(BigInteger bigInteger) {
            this.maximumExecutionCount = bigInteger;
            return this;
        }

        public TaskBuilder withDeleteAfterMaximumExecutionsReached(boolean bl) {
            this.deleteAfterMaximumExecutionsReached = bl;
            return this;
        }

        public TaskBuilder withSchedules(ImmutableArrayList<AbstractSchedule> immutableArrayList) {
            this.schedules = immutableArrayList;
            return this;
        }

        public TaskBuilder withActions(ImmutableHashMap<String, ImmutableArrayList<Action>> immutableHashMap) {
            this.actions = immutableHashMap;
            return this;
        }

        public Task build() {
            return new Task(this.id, this.name, this.description, this.created, this.changed, this.maximumExecutionCount, this.deleteAfterMaximumExecutionsReached, this.schedules, this.actions);
        }
    }
}

