/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.scheduler.calculator;

import de.oliver_matuschin.ttd.scheduler.calculator.listener.CalculationListener;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractPredictableSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import java.util.Date;

public class ScheduleCalculator {
    private int gracePeriod;

    public ScheduleCalculator() {
        this(1000);
    }

    public ScheduleCalculator(int n) {
        this.gracePeriod = n;
    }

    public int getGracePeriod() {
        return this.gracePeriod;
    }

    public void setGracePeriod(int n) {
        this.gracePeriod = n;
    }

    public Date calculateNextFireTime(AbstractPredictableSchedule abstractPredictableSchedule, ScheduleMetadata scheduleMetadata, Date date) throws InterruptedException {
        return this.calculateNextFireTime(abstractPredictableSchedule, scheduleMetadata, date, null);
    }

    public Date calculateNextFireTime(AbstractPredictableSchedule abstractPredictableSchedule, ScheduleMetadata scheduleMetadata, Date date, CalculationListener calculationListener) throws InterruptedException {
        int n = this.getGracePeriod();
        ScheduleMetadata.ScheduleMetadataBuilder scheduleMetadataBuilder = new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata);
        Date date2 = scheduleMetadata.getNextFireTime();
        while (date2 == null || this.isPastDate(date2, date, n)) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (calculationListener != null && date2 != null) {
                calculationListener.pastFireTimeCalculated(date2);
            }
            if ((date2 = this.getNextFireTime(abstractPredictableSchedule, scheduleMetadataBuilder.build())) == null) break;
            scheduleMetadataBuilder.withIntermediateStart(date2).withNextFireTime(null);
        }
        return date2;
    }

    public boolean isPastDate(Date date, Date date2) {
        return this.isPastDate(date, date2, this.getGracePeriod());
    }

    public boolean isPastDate(Date date, Date date2, int n) {
        if (date == null) {
            return false;
        }
        return date2.getTime() - date.getTime() >= (long)n;
    }

    private Date getNextFireTime(AbstractPredictableSchedule abstractPredictableSchedule, ScheduleMetadata scheduleMetadata) {
        Date date = null;
        if (scheduleMetadata.getIntermediateStart() != null || scheduleMetadata.getNextFireTime() != null) {
            Date date2 = scheduleMetadata.getIntermediateStart();
            if (date2 == null || scheduleMetadata.getNextFireTime() != null && scheduleMetadata.getNextFireTime().after(date2)) {
                date2 = scheduleMetadata.getNextFireTime();
            }
            if (abstractPredictableSchedule.getValidFrom() != null && abstractPredictableSchedule.getValidFrom().after(date2)) {
                date2 = abstractPredictableSchedule.getValidFrom();
                date = abstractPredictableSchedule.getInitialFireTimeFor(date2);
            } else {
                date = abstractPredictableSchedule.getFireTimeFor(date2);
            }
        } else {
            Date date3 = abstractPredictableSchedule.getChanged();
            if (abstractPredictableSchedule.getValidFrom() != null && abstractPredictableSchedule.getValidFrom().compareTo(date3) >= 0) {
                date3 = abstractPredictableSchedule.getValidFrom();
            }
            date = abstractPredictableSchedule.getInitialFireTimeFor(date3);
        }
        if (abstractPredictableSchedule.getValidUntil() != null && date.after(abstractPredictableSchedule.getValidUntil())) {
            date = null;
        }
        return date;
    }
}

