/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.scheduler;

import de.oliver_matuschin.ttd.collect.ImmutableArrayList;
import de.oliver_matuschin.ttd.repository.TaskRepository;
import de.oliver_matuschin.ttd.repository.listener.TaskRepositoryEventListener;
import de.oliver_matuschin.ttd.scheduler.TaskScheduler;
import de.oliver_matuschin.ttd.scheduler.calculator.ScheduleCalculator;
import de.oliver_matuschin.ttd.scheduler.calculator.listener.CalculationListener;
import de.oliver_matuschin.ttd.scheduler.executor.ActionExecutor;
import de.oliver_matuschin.ttd.scheduler.executor.exception.ActionExecutionException;
import de.oliver_matuschin.ttd.scheduler.executor.exception.WorkflowException;
import de.oliver_matuschin.ttd.scheduler.listener.TaskEventListener;
import de.oliver_matuschin.ttd.scheduler.listener.TaskSchedulerEventListener;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.action.Action;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractPredictableSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.ManualSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import de.oliver_matuschin.ttd.scheduler.task.trigger.Trigger;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class DefaultTaskScheduler
implements TaskScheduler {
    private static final Logger logger = Logger.getLogger(TaskScheduler.class.getName());
    private final Map<String, Future<?>> runningTasks;
    private final Map<String, AbstractSchedule> runningTasksSchedules;
    private final Map<String, Action> runningTasksActions;
    private final Map<String, String> runningTasksStatusTexts;
    private final Map<String, Future<?>> scheduleCalculations;
    private final Set<String> expiredSchedules;
    private TaskRepository taskRepository;
    private ScheduleCalculator scheduleCalculator;
    private EventListenerList listeners;
    private ExecutorService eventExecutor;
    private ExecutorService taskExecutor;
    private ActionExecutor actionExecutor;
    private volatile boolean taskListModified;
    private volatile boolean paused = false;
    private TaskRepositoryEventListener taskRepositoryEventListener = new TaskRepositoryEventListener(){

        @Override
        public void taskUpdated(Task task) {
            DefaultTaskScheduler.this.taskListModified = true;
        }

        @Override
        public void taskMetadataUpdated(Task task, TaskMetadata taskMetadata) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scheduleMetadataUpdated(Task task, ScheduleMetadata scheduleMetadata) {
            Set set = DefaultTaskScheduler.this.expiredSchedules;
            synchronized (set) {
                DefaultTaskScheduler.this.expiredSchedules.remove(scheduleMetadata.getScheduleId());
            }
        }

        @Override
        public void taskAdded(Task task) {
            DefaultTaskScheduler.this.taskListModified = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void taskRemoved(Task task) {
            DefaultTaskScheduler.this.cancelTaskExecution(task.getId());
            DefaultTaskScheduler.this.taskListModified = true;
            Set set = DefaultTaskScheduler.this.expiredSchedules;
            synchronized (set) {
                task.getSchedules().asList().forEach(abstractSchedule -> DefaultTaskScheduler.this.expiredSchedules.remove(abstractSchedule.getId()));
            }
        }
    };

    public DefaultTaskScheduler(TaskRepository taskRepository, ActionExecutor actionExecutor) {
        this.taskRepository = taskRepository;
        this.scheduleCalculator = new ScheduleCalculator();
        this.runningTasks = new HashMap();
        this.runningTasksSchedules = new HashMap<String, AbstractSchedule>();
        this.runningTasksActions = new HashMap<String, Action>();
        this.runningTasksStatusTexts = new HashMap<String, String>();
        this.scheduleCalculations = new HashMap();
        this.expiredSchedules = new HashSet<String>();
        this.taskExecutor = Executors.newCachedThreadPool(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setPriority(1);
            return thread;
        });
        this.actionExecutor = actionExecutor;
        this.listeners = new EventListenerList();
        this.eventExecutor = Executors.newSingleThreadExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.log(Level.INFO, "Task scheduler started.");
        this.taskRepository.addTaskRepositoryEventListener(this.taskRepositoryEventListener);
        List<Task> list = null;
        try {
            while (!Thread.interrupted()) {
                try {
                    do {
                        Thread.sleep(100L);
                    } while (this.isPaused());
                }
                catch (InterruptedException interruptedException) {
                    logger.log(Level.FINE, "Got interrupted while processing the task queue.");
                    break;
                }
                if (list == null || this.taskListModified) {
                    this.taskListModified = false;
                    list = this.taskRepository.listTasks();
                    logger.log(Level.FINEST, "Refreshed task cache");
                }
                Date date = new Date();
                for (Task task : list) {
                    TaskMetadata taskMetadata = this.taskRepository.getTaskMetadata(task.getId());
                    if (taskMetadata != null && this.handleMaximumExecution(task, taskMetadata) || taskMetadata == null || !taskMetadata.isTaskEnabled()) continue;
                    ImmutableArrayList<AbstractSchedule> immutableArrayList = task.getSchedules();
                    for (AbstractSchedule abstractSchedule : immutableArrayList) {
                        Object object = this.expiredSchedules;
                        synchronized (object) {
                            if (this.expiredSchedules.contains(abstractSchedule.getId())) {
                                continue;
                            }
                        }
                        object = this.taskRepository.getScheduleMetadata(abstractSchedule.getId());
                        if (object == null || !(abstractSchedule instanceof AbstractPredictableSchedule)) continue;
                        AbstractPredictableSchedule abstractPredictableSchedule = (AbstractPredictableSchedule)abstractSchedule;
                        Map<String, Future<?>> map = this.scheduleCalculations;
                        synchronized (map) {
                            if (!this.scheduleCalculations.containsKey(abstractPredictableSchedule.getId())) {
                                if (((ScheduleMetadata)object).getNextFireTime() == null) {
                                    this.calculateNextFireTime(task, abstractPredictableSchedule, (ScheduleMetadata)object, date);
                                } else if (this.wasScheduleMissed(abstractPredictableSchedule, (ScheduleMetadata)object, date)) {
                                    this.handleMissedSchedule(task, abstractPredictableSchedule, (ScheduleMetadata)object, date);
                                } else if (this.shouldBeExecutedBySchedule(abstractPredictableSchedule, (ScheduleMetadata)object, date)) {
                                    this.executeTask(task, abstractSchedule, Collections.emptyMap());
                                }
                            }
                        }
                    }
                }
            }
            this.shutdownScheduler();
        }
        finally {
            logger.log(Level.INFO, "Task scheduler shut down.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownScheduler() {
        this.taskRepository.removeTaskRepositoryEventListener(this.taskRepositoryEventListener);
        logger.log(Level.INFO, "Shutting down running tasks.");
        Map<String, Future<?>> map = this.runningTasks;
        synchronized (map) {
            for (Future<?> future : this.runningTasks.values()) {
                future.cancel(true);
            }
        }
        logger.log(Level.INFO, "Cancelling schedule recalculation.");
        map = this.scheduleCalculations;
        synchronized (map) {
            for (Future<?> future : this.scheduleCalculations.values()) {
                future.cancel(true);
            }
        }
        try {
            logger.log(Level.FINE, "Waiting for task executor to shut down...");
            this.taskExecutor.shutdown();
            if (!this.taskExecutor.awaitTermination(2L, TimeUnit.SECONDS)) {
                logger.log(Level.FINE, "Killing task executor...");
                this.taskExecutor.shutdownNow();
            }
            logger.log(Level.FINE, "Waiting for event executor to shut down...");
            this.eventExecutor.shutdown();
            if (!this.eventExecutor.awaitTermination(2L, TimeUnit.SECONDS)) {
                logger.log(Level.FINE, "Killing event executor...");
                this.eventExecutor.shutdownNow();
            }
            logger.log(Level.FINE, "All executors shut down!");
        }
        catch (InterruptedException interruptedException) {
            this.taskExecutor.shutdownNow();
            this.eventExecutor.shutdownNow();
        }
    }

    private boolean handleMaximumExecution(Task task, TaskMetadata taskMetadata2) {
        if (this.isMaximumExecutionCountReached(task, taskMetadata2)) {
            if (task.isDeleteAfterMaximumExecutionsReached()) {
                this.taskRepository.removeTask(task.getId());
            } else if (taskMetadata2.isTaskEnabled()) {
                this.taskRepository.updateTaskMetadata(task.getId(), taskMetadata -> new TaskMetadata.TaskMetadataBuilder(taskMetadata).withTaskEnabled(false).build());
            }
        }
        return false;
    }

    private boolean wasScheduleMissed(AbstractPredictableSchedule abstractPredictableSchedule, ScheduleMetadata scheduleMetadata, Date date) {
        if (abstractPredictableSchedule.isSkipIfMissed() && scheduleMetadata.getNextFireTime() != null) {
            return this.scheduleCalculator.isPastDate(scheduleMetadata.getNextFireTime(), date, this.getGracePeriod());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateNextFireTime(Task task, AbstractPredictableSchedule abstractPredictableSchedule, ScheduleMetadata scheduleMetadata, Date date) {
        Map<String, Future<?>> map = this.scheduleCalculations;
        synchronized (map) {
            if (!this.scheduleCalculations.containsKey(abstractPredictableSchedule.getId())) {
                Future<?> future = this.taskExecutor.submit(() -> {
                    Date date2 = null;
                    try {
                        date2 = this.scheduleCalculator.calculateNextFireTime(abstractPredictableSchedule, scheduleMetadata, date);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        Map<String, Future<?>> map;
                        if (date2 != null) {
                            map = date2;
                            this.taskRepository.updateScheduleMetadata(abstractPredictableSchedule.getId(), arg_0 -> DefaultTaskScheduler.lambda$null$22((Date)((Object)map), arg_0));
                        } else {
                            map = this.expiredSchedules;
                            synchronized (map) {
                                this.expiredSchedules.add(abstractPredictableSchedule.getId());
                            }
                        }
                        this.resetNextFireTimeIfScheduleChanged(task, abstractPredictableSchedule);
                        map = this.scheduleCalculations;
                        synchronized (map) {
                            this.scheduleCalculations.remove(abstractPredictableSchedule.getId());
                            this.fireScheduleRecalculationStopped(task.getId(), abstractPredictableSchedule.getId());
                        }
                    }
                });
                this.scheduleCalculations.put(abstractPredictableSchedule.getId(), future);
                this.fireScheduleRecalculationStarted(task.getId(), abstractPredictableSchedule.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMissedSchedule(Task task, AbstractPredictableSchedule abstractPredictableSchedule, ScheduleMetadata scheduleMetadata, Date date) {
        Map<String, Future<?>> map = this.scheduleCalculations;
        synchronized (map) {
            if (!this.scheduleCalculations.containsKey(abstractPredictableSchedule.getId())) {
                Future<?> future = this.taskExecutor.submit(() -> {
                    this.taskRepository.updateScheduleMetadata(abstractPredictableSchedule.getId(), scheduleMetadata -> new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withNextFireTime(null).build());
                    Date date2 = null;
                    MissedScheduleRecalculationListener missedScheduleRecalculationListener = new MissedScheduleRecalculationListener(task, abstractPredictableSchedule);
                    try {
                        date2 = this.scheduleCalculator.calculateNextFireTime(abstractPredictableSchedule, scheduleMetadata, date, missedScheduleRecalculationListener);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        this.taskRepository.updateTaskMetadata(task.getId(), taskMetadata -> new TaskMetadata.TaskMetadataBuilder(taskMetadata).withTotalExecutionCount(taskMetadata.getTotalExecutionCount().add(missedScheduleRecalculationListener.getFailures())).build());
                        if (missedScheduleRecalculationListener.getFailures().compareTo(BigInteger.ZERO) > 0) {
                            this.taskRepository.updateScheduleMetadata(abstractPredictableSchedule.getId(), scheduleMetadata -> new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withStart(missedScheduleRecalculationListener.getLastFireTime()).withEnd(missedScheduleRecalculationListener.getLastFireTime()).withIntermediateStart(missedScheduleRecalculationListener.getLastFireTime()).withResultTime(missedScheduleRecalculationListener.getLastFireTime()).withResultReason(ScheduleMetadata.ResultReason.SCHEDULE_MISSED).withResultType(ScheduleMetadata.ResultType.ERROR).build());
                        }
                        Date date3 = date2;
                        this.taskRepository.updateScheduleMetadata(abstractPredictableSchedule.getId(), scheduleMetadata -> new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withNextFireTime(date3).build());
                        this.resetNextFireTimeIfScheduleChanged(task, abstractPredictableSchedule);
                        Map<String, Future<?>> map = this.scheduleCalculations;
                        synchronized (map) {
                            this.scheduleCalculations.remove(abstractPredictableSchedule.getId());
                            this.fireScheduleRecalculationStopped(task.getId(), abstractPredictableSchedule.getId());
                        }
                    }
                });
                this.scheduleCalculations.put(abstractPredictableSchedule.getId(), future);
                this.fireScheduleRecalculationStarted(task.getId(), abstractPredictableSchedule.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetNextFireTimeIfScheduleChanged(Task task, AbstractPredictableSchedule abstractPredictableSchedule) {
        Optional<AbstractSchedule> optional;
        Task task2 = this.taskRepository.getTask(task.getId());
        if (task2 != null && (optional = task.getSchedules().asList().stream().filter(abstractSchedule -> abstractSchedule.getId().equals(abstractPredictableSchedule.getId())).findFirst()).isPresent() && optional.get().getChanged().after(abstractPredictableSchedule.getChanged())) {
            this.taskRepository.updateScheduleMetadata(abstractPredictableSchedule.getId(), scheduleMetadata -> new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withNextFireTime(null).build());
            Set<String> set = this.expiredSchedules;
            synchronized (set) {
                this.expiredSchedules.remove(abstractPredictableSchedule.getId());
            }
        }
    }

    @Override
    public void setPaused(boolean bl) {
        if (bl && !this.paused) {
            this.fireTaskSchedulingPaused();
        } else if (!bl && this.paused) {
            this.fireTaskSchedulingResumed();
        }
        this.paused = bl;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean trigger(Class<? extends Trigger> clazz, Map<String, Object> map) {
        return this.trigger(clazz, map, Collections.emptyMap());
    }

    @Override
    public boolean trigger(Class<? extends Trigger> clazz, Map<String, Object> map, Map<String, Object> map2) {
        boolean bl = false;
        if (clazz != null) {
            bl = true;
            List<Task> list = this.taskRepository.listTasks();
            for (Task task : list) {
                bl &= this.trigger(task.getId(), clazz, map, map2);
            }
        }
        return bl;
    }

    @Override
    public boolean trigger(String string, Class<? extends Trigger> clazz, Map<String, Object> map) {
        return this.trigger(string, clazz, map, Collections.emptyMap());
    }

    @Override
    public boolean trigger(String string, Class<? extends Trigger> clazz, Map<String, Object> map, Map<String, Object> map2) {
        TaskMetadata taskMetadata;
        Task task;
        if (!this.isPaused() && (task = this.taskRepository.getTask(string)) != null && (taskMetadata = this.taskRepository.getTaskMetadata(string)) != null && taskMetadata.isTaskEnabled()) {
            for (AbstractSchedule abstractSchedule : task.getSchedules()) {
                Trigger trigger;
                if (!(abstractSchedule instanceof Trigger) || abstractSchedule.getClass() != clazz || !(trigger = (Trigger)((Object)abstractSchedule)).accepts(task, map)) continue;
                return this.executeTask(task, abstractSchedule, map2);
            }
        }
        return false;
    }

    @Override
    public boolean executeTask(String string) {
        return this.executeTask(string, Collections.emptyMap());
    }

    @Override
    public boolean executeTask(String string, Map<String, Object> map) {
        Task task = this.taskRepository.getTask(string);
        if (task != null) {
            ImmutableArrayList<AbstractSchedule> immutableArrayList = task.getSchedules();
            for (AbstractSchedule abstractSchedule : immutableArrayList) {
                if (!(abstractSchedule instanceof ManualSchedule)) continue;
                return this.executeTask(task, abstractSchedule, map);
            }
        }
        return false;
    }

    private boolean executeTask(Task task, AbstractSchedule abstractSchedule, Map<String, Object> map) {
        return this.executeTask(task, abstractSchedule, "", map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeTask(Task task, AbstractSchedule abstractSchedule, String string, Map<String, Object> map) {
        Map<String, Future<?>> map2 = this.runningTasks;
        synchronized (map2) {
            Object object;
            ScheduleMetadata scheduleMetadata = this.taskRepository.getScheduleMetadata(abstractSchedule.getId());
            final Date date = scheduleMetadata != null && scheduleMetadata.getNextFireTime() != null ? (abstractSchedule instanceof AbstractPredictableSchedule ? (!((AbstractPredictableSchedule)(object = (AbstractPredictableSchedule)abstractSchedule)).isSkipIfMissed() && this.scheduleCalculator.isPastDate(scheduleMetadata.getNextFireTime(), new Date(), 700) ? new Date() : scheduleMetadata.getNextFireTime()) : scheduleMetadata.getNextFireTime()) : new Date();
            if (!this.runningTasks.containsKey(task.getId())) {
                this.taskRepository.updateScheduleMetadata(abstractSchedule.getId(), new TaskRepository.ScheduleMetadataUpdater(){

                    @Override
                    public ScheduleMetadata updateScheduleMetadata(ScheduleMetadata scheduleMetadata) {
                        return new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withStart(date).withIntermediateStart(date).withNextFireTime(null).withFlag(scheduleMetadata.getFlag() | 1).build();
                    }
                });
                object = this.taskExecutor.submit(() -> {
                    try {
                        this.fireTaskExecutionStarted(task.getId(), abstractSchedule.getId());
                        ImmutableArrayList<Action> immutableArrayList = task.getActions().get("Start");
                        this.incrementTaskTotalExecutionCount(task);
                        if (immutableArrayList != null) {
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            block14: for (int i = 0; i < immutableArrayList.size(); ++i) {
                                Action action = immutableArrayList.get(i);
                                if (Thread.interrupted()) {
                                    throw new InterruptedException("Thread executing task " + task.getId() + " got interrupted!");
                                }
                                ActionExecutor.ActionResult actionResult = this.executeAction(task, action, hashMap, map);
                                if (actionResult == null || !(actionResult instanceof ActionExecutor.JumpResult)) continue;
                                ActionExecutor.JumpResult jumpResult = (ActionExecutor.JumpResult)actionResult;
                                if (ActionExecutor.JumpResult.Target.WORKFLOW_END.equals((Object)jumpResult.getTarget())) break;
                                if (ActionExecutor.JumpResult.Target.WORKFLOW_START.equals((Object)jumpResult.getTarget())) {
                                    i = -1;
                                    continue;
                                }
                                if (jumpResult.getTargetLabel() != null) {
                                    for (int j = 0; j < immutableArrayList.size(); ++j) {
                                        if (!jumpResult.getTargetLabel().equals(((Action)immutableArrayList.get(j)).getLabel())) continue;
                                        i = j - 1;
                                        continue block14;
                                    }
                                }
                                throw new WorkflowException(jumpResult.getTargetLabel());
                            }
                        }
                        this.incrementTaskSuccessfulExecutionCount(task);
                        this.taskRepository.updateScheduleMetadata(abstractSchedule.getId(), scheduleMetadata -> new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withResultTime(new Date()).withResultReason(ScheduleMetadata.ResultReason.SUCCESS).withResultType(ScheduleMetadata.ResultType.INFO).withResultDescription("").withCause(string).withSuccessfulStart(date).build());
                    }
                    catch (Exception exception) {
                        ScheduleMetadata.ResultReason resultReason;
                        ScheduleMetadata.ResultType resultType;
                        String string2 = exception.getLocalizedMessage();
                        if (exception instanceof InterruptedException) {
                            resultType = ScheduleMetadata.ResultType.WARNING;
                            resultReason = ScheduleMetadata.ResultReason.EXECUTION_CANCELED;
                        } else if (exception instanceof ActionExecutionException) {
                            resultType = ScheduleMetadata.ResultType.ERROR;
                            resultReason = ScheduleMetadata.ResultReason.OTHER;
                        } else if (exception instanceof WorkflowException) {
                            resultType = ScheduleMetadata.ResultType.ERROR;
                            resultReason = ScheduleMetadata.ResultReason.JUMP_LABEL_MISSING;
                        } else {
                            logger.log(Level.WARNING, "Task action threw exception!", exception);
                            resultType = ScheduleMetadata.ResultType.ERROR;
                            resultReason = ScheduleMetadata.ResultReason.INTERNAL_ERROR;
                        }
                        this.taskRepository.updateScheduleMetadata(abstractSchedule.getId(), scheduleMetadata -> new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withResultTime(new Date()).withResultType(resultType).withResultReason(resultReason).withResultDescription(string2).build());
                        this.fireTaskExecutionCanceled(task.getId(), abstractSchedule.getId(), resultType, resultReason, string2);
                    }
                    finally {
                        this.taskRepository.updateScheduleMetadata(abstractSchedule.getId(), scheduleMetadata -> new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withEnd(new Date()).withFlag(scheduleMetadata.getFlag() & 0xFFFFFFFE).build());
                        Map<String, Future<?>> map2 = this.runningTasks;
                        synchronized (map2) {
                            this.runningTasks.remove(task.getId());
                            this.runningTasksSchedules.remove(task.getId());
                            this.fireTaskExecutionEnded(task.getId(), abstractSchedule.getId());
                        }
                    }
                });
                this.runningTasks.put(task.getId(), (Future<?>)object);
                this.runningTasksSchedules.put(task.getId(), abstractSchedule);
                return true;
            }
            this.taskRepository.updateScheduleMetadata(abstractSchedule.getId(), new TaskRepository.ScheduleMetadataUpdater(){

                @Override
                public ScheduleMetadata updateScheduleMetadata(ScheduleMetadata scheduleMetadata) {
                    return new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withIntermediateStart(date).withNextFireTime(null).build();
                }
            });
            this.taskRepository.updateTaskMetadata(task.getId(), new TaskRepository.TaskMetadataUpdater(){

                @Override
                public TaskMetadata updateTaskMetadata(TaskMetadata taskMetadata) {
                    return new TaskMetadata.TaskMetadataBuilder(taskMetadata).withTotalExecutionCount(taskMetadata.getTotalExecutionCount().add(BigInteger.ONE)).build();
                }
            });
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionExecutor.ActionResult executeAction(Task task, Action action, Map<String, Object> map, Map<String, Object> map2) throws Exception {
        ActionExecutor.StatusUpdater statusUpdater = string -> {
            Map<String, String> map = this.runningTasksStatusTexts;
            synchronized (map) {
                this.runningTasksStatusTexts.put(task.getId(), string);
            }
            this.fireTaskStatusTextUpdated(task.getId(), action, string);
        };
        Object object = this.runningTasksActions;
        synchronized (object) {
            this.runningTasksActions.put(task.getId(), action);
            this.fireTaskActionStarted(task.getId(), action);
        }
        try {
            object = this.actionExecutor.executeAction(task, action, map, map2, statusUpdater);
            return object;
        }
        finally {
            Map<String, Object> map3 = this.runningTasksStatusTexts;
            synchronized (map3) {
                this.runningTasksStatusTexts.remove(task.getId());
            }
            map3 = this.runningTasksActions;
            synchronized (map3) {
                this.runningTasksActions.remove(task.getId());
                this.fireTaskActionStopped(task.getId(), action);
            }
            this.fireTaskStatusTextUpdated(task.getId(), action, null);
        }
    }

    @Override
    public synchronized void setGracePeriod(int n) {
        this.scheduleCalculator.setGracePeriod(n);
    }

    @Override
    public synchronized int getGracePeriod() {
        return this.scheduleCalculator.getGracePeriod();
    }

    private boolean isMaximumExecutionCountReached(Task task, TaskMetadata taskMetadata) {
        return task.getMaximumExecutionCount().compareTo(BigInteger.ZERO) > 0 && taskMetadata.getSuccessfulExecutionCount().compareTo(task.getMaximumExecutionCount()) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelTaskExecution(String string) {
        Future<?> future;
        Map<String, Future<?>> map = this.runningTasks;
        synchronized (map) {
            future = this.runningTasks.get(string);
        }
        return future != null && future.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExecuting(String string) {
        Future<?> future;
        Map<String, Future<?>> map = this.runningTasks;
        synchronized (map) {
            future = this.runningTasks.get(string);
        }
        return future != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRecalculating(String string) {
        Future<?> future;
        Map<String, Future<?>> map = this.scheduleCalculations;
        synchronized (map) {
            future = this.scheduleCalculations.get(string);
        }
        return future != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractSchedule getCurrentSchedule(String string) {
        Map<String, Future<?>> map = this.runningTasks;
        synchronized (map) {
            return this.runningTasksSchedules.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Action getCurrentAction(String string) {
        Map<String, Action> map = this.runningTasksActions;
        synchronized (map) {
            return this.runningTasksActions.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentStatusText(String string) {
        Map<String, String> map = this.runningTasksStatusTexts;
        synchronized (map) {
            return this.runningTasksStatusTexts.get(string);
        }
    }

    private void incrementTaskSuccessfulExecutionCount(Task task) {
        this.taskRepository.updateTaskMetadata(task.getId(), taskMetadata -> {
            BigInteger bigInteger = taskMetadata.getSuccessfulExecutionCount().add(BigInteger.ONE);
            BigInteger bigInteger2 = taskMetadata.getTotalExecutionCount();
            if (bigInteger2.compareTo(bigInteger) < 0) {
                bigInteger2 = bigInteger;
            }
            return new TaskMetadata.TaskMetadataBuilder(taskMetadata).withSuccessfulExecutionCount(bigInteger).withTotalExecutionCount(bigInteger2).build();
        });
    }

    private void incrementTaskTotalExecutionCount(Task task) {
        this.taskRepository.updateTaskMetadata(task.getId(), taskMetadata -> new TaskMetadata.TaskMetadataBuilder(taskMetadata).withTotalExecutionCount(taskMetadata.getTotalExecutionCount().add(BigInteger.ONE)).build());
    }

    private boolean shouldBeExecutedBySchedule(AbstractPredictableSchedule abstractPredictableSchedule, ScheduleMetadata scheduleMetadata, Date date) {
        if (scheduleMetadata.getNextFireTime() != null) {
            return date.compareTo(scheduleMetadata.getNextFireTime()) >= 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaskEventListener(TaskEventListener taskEventListener) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            this.listeners.add(TaskEventListener.class, taskEventListener);
        }
        logger.fine("Added TaskEventListener: " + taskEventListener.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaskSchedulerListener(TaskSchedulerEventListener taskSchedulerEventListener) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            this.listeners.add(TaskSchedulerEventListener.class, taskSchedulerEventListener);
        }
        logger.fine("Added TaskSchedulerEventListener: " + taskSchedulerEventListener.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTaskEventListener(TaskEventListener taskEventListener) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            this.listeners.remove(TaskEventListener.class, taskEventListener);
        }
        logger.fine("Removed TaskEventListener: " + taskEventListener.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTaskSchedulerListener(TaskSchedulerEventListener taskSchedulerEventListener) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            this.listeners.remove(TaskSchedulerEventListener.class, taskSchedulerEventListener);
        }
        logger.fine("Removed TaskSchedulerEventListener: " + taskSchedulerEventListener.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskSchedulingPaused() {
        TaskSchedulerEventListener[] taskSchedulerEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskSchedulerEventListenerArray = (TaskSchedulerEventListener[])this.listeners.getListeners(TaskSchedulerEventListener.class);
        }
        this.eventExecutor.submit(() -> {
            for (TaskSchedulerEventListener taskSchedulerEventListener : taskSchedulerEventListenerArray) {
                taskSchedulerEventListener.schedulingPaused();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskSchedulingResumed() {
        TaskSchedulerEventListener[] taskSchedulerEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskSchedulerEventListenerArray = (TaskSchedulerEventListener[])this.listeners.getListeners(TaskSchedulerEventListener.class);
        }
        this.eventExecutor.submit(() -> {
            for (TaskSchedulerEventListener taskSchedulerEventListener : taskSchedulerEventListenerArray) {
                taskSchedulerEventListener.schedulingResumed();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskExecutionStarted(String string, String string2) {
        TaskEventListener[] taskEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskEventListenerArray = (TaskEventListener[])this.listeners.getListeners(TaskEventListener.class);
        }
        this.eventExecutor.submit(() -> {
            for (TaskEventListener taskEventListener : taskEventListenerArray) {
                taskEventListener.executionStarted(string, string2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskExecutionCanceled(String string, String string2, ScheduleMetadata.ResultType resultType, ScheduleMetadata.ResultReason resultReason, String string3) {
        TaskEventListener[] taskEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskEventListenerArray = (TaskEventListener[])this.listeners.getListeners(TaskEventListener.class);
        }
        this.eventExecutor.submit(() -> {
            for (TaskEventListener taskEventListener : taskEventListenerArray) {
                taskEventListener.executionCanceled(string, string2, resultType, resultReason, string3);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskExecutionEnded(String string, String string2) {
        TaskEventListener[] taskEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskEventListenerArray = (TaskEventListener[])this.listeners.getListeners(TaskEventListener.class);
        }
        this.eventExecutor.submit(() -> {
            for (TaskEventListener taskEventListener : taskEventListenerArray) {
                taskEventListener.executionEnded(string, string2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskStatusTextUpdated(String string, Action action, String string2) {
        TaskEventListener[] taskEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskEventListenerArray = (TaskEventListener[])this.listeners.getListeners(TaskEventListener.class);
        }
        this.eventExecutor.submit(() -> {
            for (TaskEventListener taskEventListener : taskEventListenerArray) {
                taskEventListener.statusTextUpdated(string, action, string2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskActionStarted(String string, Action action) {
        TaskEventListener[] taskEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskEventListenerArray = (TaskEventListener[])this.listeners.getListeners(TaskEventListener.class);
        }
        this.eventExecutor.submit(() -> {
            for (TaskEventListener taskEventListener : taskEventListenerArray) {
                taskEventListener.actionStarted(string, action);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskActionStopped(String string, Action action) {
        TaskEventListener[] taskEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskEventListenerArray = (TaskEventListener[])this.listeners.getListeners(TaskEventListener.class);
        }
        this.eventExecutor.submit(() -> {
            for (TaskEventListener taskEventListener : taskEventListenerArray) {
                taskEventListener.actionStopped(string, action);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireScheduleRecalculationStarted(String string, String string2) {
        TaskEventListener[] taskEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskEventListenerArray = (TaskEventListener[])this.listeners.getListeners(TaskEventListener.class);
        }
        this.eventExecutor.submit(() -> {
            for (TaskEventListener taskEventListener : taskEventListenerArray) {
                taskEventListener.scheduleRecalculationStarted(string, string2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireScheduleMissed(String string, String string2, Date date) {
        TaskEventListener[] taskEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskEventListenerArray = (TaskEventListener[])this.listeners.getListeners(TaskEventListener.class);
        }
        this.eventExecutor.submit(() -> {
            for (TaskEventListener taskEventListener : taskEventListenerArray) {
                taskEventListener.scheduleMissed(string, string2, date);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireScheduleRecalculationStopped(String string, String string2) {
        TaskEventListener[] taskEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskEventListenerArray = (TaskEventListener[])this.listeners.getListeners(TaskEventListener.class);
        }
        this.eventExecutor.submit(() -> {
            for (TaskEventListener taskEventListener : taskEventListenerArray) {
                taskEventListener.scheduleRecalculationStopped(string, string2);
            }
        });
    }

    private static /* synthetic */ ScheduleMetadata lambda$null$22(Date date, ScheduleMetadata scheduleMetadata) {
        return new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withNextFireTime(date).build();
    }

    private class MissedScheduleRecalculationListener
    implements CalculationListener {
        private Task task;
        private AbstractPredictableSchedule predictableSchedule;
        private BigInteger failures = BigInteger.ZERO;
        private Date lastFireTime;

        public MissedScheduleRecalculationListener(Task task, AbstractPredictableSchedule abstractPredictableSchedule) {
            this.task = task;
            this.predictableSchedule = abstractPredictableSchedule;
        }

        @Override
        public void pastFireTimeCalculated(Date date) {
            this.failures = this.failures.add(BigInteger.ONE);
            this.lastFireTime = date;
            DefaultTaskScheduler.this.fireScheduleMissed(this.task.getId(), this.predictableSchedule.getId(), date);
        }

        public BigInteger getFailures() {
            return this.failures;
        }

        public Date getLastFireTime() {
            return this.lastFireTime;
        }
    }
}

