/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.repository;

import de.oliver_matuschin.ttd.collect.ImmutableArrayList;
import de.oliver_matuschin.ttd.repository.AbstractTaskRepository;
import de.oliver_matuschin.ttd.repository.TaskRepository;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CachedTaskRepository
extends AbstractTaskRepository {
    private final Logger logger = Logger.getLogger(CachedTaskRepository.class.getName());
    private Map<String, Task> tasks;
    private Map<String, TaskMetadata> taskMetadatas;
    private Map<String, ScheduleMetadata> scheduleMetadatas;
    private TaskRepository.TaskStorageProvider taskStorageProvider;

    public CachedTaskRepository(TaskRepository.TaskStorageProvider taskStorageProvider) {
        this.taskStorageProvider = taskStorageProvider;
        this.tasks = new HashMap<String, Task>();
        this.taskMetadatas = new HashMap<String, TaskMetadata>();
        this.scheduleMetadatas = new HashMap<String, ScheduleMetadata>();
        List<Task> list = taskStorageProvider.loadTasks();
        List<TaskMetadata> list2 = taskStorageProvider.loadTaskMetadatas();
        List<ScheduleMetadata> list3 = taskStorageProvider.loadScheduleMetadatas();
        for (Task task : list) {
            TaskMetadata object2 = null;
            for (TaskMetadata taskMetadata : list2) {
                if (!task.getId().equals(taskMetadata.getTaskId())) continue;
                object2 = taskMetadata;
                break;
            }
            ArrayList arrayList = new ArrayList();
            block2: for (AbstractSchedule abstractSchedule : task.getSchedules()) {
                for (ScheduleMetadata scheduleMetadata : list3) {
                    if (!abstractSchedule.getId().equals(scheduleMetadata.getScheduleId())) continue;
                    arrayList.add(scheduleMetadata);
                    continue block2;
                }
            }
            if (object2 != null) {
                this.addTask(task, object2, arrayList, false);
                continue;
            }
            this.addTask(task, arrayList, false);
        }
    }

    @Override
    public boolean addTask(Task task) {
        return this.addTask(task, new ArrayList<ScheduleMetadata>());
    }

    @Override
    public boolean addTask(Task task, TaskMetadata taskMetadata) {
        return this.addTask(task, taskMetadata, new ArrayList<ScheduleMetadata>());
    }

    @Override
    public boolean addTask(Task task, List<ScheduleMetadata> list) {
        return this.addTask(task, list, true);
    }

    private boolean addTask(Task task, List<ScheduleMetadata> list, boolean bl) {
        return this.addTask(task, new TaskMetadata.TaskMetadataBuilder().withTaskId(task.getId()).withTaskEnabled(false).withSuccessfulExecutionCount(BigInteger.ZERO).withTotalExecutionCount(BigInteger.ZERO).build(), list, bl);
    }

    @Override
    public boolean addTask(Task task, TaskMetadata taskMetadata, List<ScheduleMetadata> list) {
        return this.addTask(task, taskMetadata, list, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addTask(Task task, TaskMetadata taskMetadata, List<ScheduleMetadata> list, boolean bl) {
        if (task.getId() == null) {
            this.logger.log(Level.WARNING, "Skipped creation of task with name: " + task.getName() + " because it had no id!");
            return false;
        }
        if (!task.getId().equals(taskMetadata.getTaskId())) {
            this.logger.log(Level.WARNING, "Skipped creation of task with id: " + task.getId() + " because " + "provided taskMetadata contained the wrong task id: " + taskMetadata.getTaskId());
            return false;
        }
        Map<String, Task> map = this.tasks;
        synchronized (map) {
            if (!this.tasks.containsKey(task.getId())) {
                this.tasks.put(task.getId(), task);
                if (bl) {
                    this.taskStorageProvider.storeTask(task);
                }
                this.taskMetadatas.put(task.getId(), taskMetadata);
                if (bl) {
                    this.taskStorageProvider.storeTaskMetadata(taskMetadata);
                }
                ArrayList<ScheduleMetadata> arrayList = new ArrayList<ScheduleMetadata>();
                for (ScheduleMetadata object : list) {
                    if (!this.addScheduleMetadata(object)) continue;
                    arrayList.add(object);
                    if (!bl) continue;
                    this.taskStorageProvider.storeScheduleMetadata(object);
                }
                for (AbstractSchedule abstractSchedule : task.getSchedules()) {
                    if (this.scheduleMetadatas.containsKey(abstractSchedule.getId())) continue;
                    ScheduleMetadata scheduleMetadata = new ScheduleMetadata.ScheduleMetadataBuilder().withScheduleId(abstractSchedule.getId()).build();
                    this.addScheduleMetadata(scheduleMetadata);
                    arrayList.add(scheduleMetadata);
                    if (!bl) continue;
                    this.taskStorageProvider.storeScheduleMetadata(scheduleMetadata);
                }
                this.fireTaskAdded(task);
                this.fireTaskMetadataUpdated(task, taskMetadata);
                for (ScheduleMetadata scheduleMetadata : arrayList) {
                    this.fireScheduleMetadataUpdated(task, scheduleMetadata);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addScheduleMetadata(ScheduleMetadata scheduleMetadata) {
        Map<String, Task> map = this.tasks;
        synchronized (map) {
            Collection<Task> collection = this.tasks.values();
            for (Task task : collection) {
                ImmutableArrayList<AbstractSchedule> immutableArrayList = task.getSchedules();
                for (AbstractSchedule abstractSchedule : immutableArrayList) {
                    if (!abstractSchedule.getId().equals(scheduleMetadata.getScheduleId())) continue;
                    this.scheduleMetadatas.put(scheduleMetadata.getScheduleId(), scheduleMetadata);
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTask(String string) {
        Map<String, Task> map = this.tasks;
        synchronized (map) {
            if (this.tasks.containsKey(string)) {
                Task task = this.getTask(string);
                this.tasks.remove(string);
                this.taskMetadatas.remove(string);
                for (AbstractSchedule abstractSchedule : task.getSchedules()) {
                    this.scheduleMetadatas.remove(abstractSchedule.getId());
                }
                this.taskStorageProvider.deleteTask(task);
                this.fireTaskRemoved(task);
                return true;
            }
        }
        return false;
    }

    @Override
    public String nextId() {
        return this.taskStorageProvider.nextId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task getTask(String string) {
        Map<String, Task> map = this.tasks;
        synchronized (map) {
            return this.tasks.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Task> listTasks() {
        Map<String, Task> map = this.tasks;
        synchronized (map) {
            ArrayList<Task> arrayList = new ArrayList<Task>();
            arrayList.addAll(this.tasks.values());
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskMetadata getTaskMetadata(String string) {
        Map<String, Task> map = this.tasks;
        synchronized (map) {
            return this.taskMetadatas.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScheduleMetadata> listScheduleMetadata(String string) {
        Map<String, Task> map = this.tasks;
        synchronized (map) {
            ArrayList<ScheduleMetadata> arrayList = new ArrayList<ScheduleMetadata>();
            Task task = this.getTask(string);
            if (task != null) {
                for (AbstractSchedule abstractSchedule : task.getSchedules()) {
                    ScheduleMetadata scheduleMetadata = this.scheduleMetadatas.get(abstractSchedule.getId());
                    if (scheduleMetadata == null) continue;
                    arrayList.add(scheduleMetadata);
                }
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduleMetadata getScheduleMetadata(String string) {
        Map<String, Task> map = this.tasks;
        synchronized (map) {
            return this.scheduleMetadatas.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTask(String string, TaskRepository.TaskUpdater taskUpdater) {
        Map<String, Task> map = this.tasks;
        synchronized (map) {
            Task task = this.getTask(string);
            if (task != null) {
                Task task2 = taskUpdater.updateTask(task);
                if (string.equals(task2.getId())) {
                    this.logger.log(Level.FINE, "Updating task with id: " + string + " ...");
                    List<ScheduleMetadata> list = this.listScheduleMetadata(string);
                    for (ScheduleMetadata iterator2 : list) {
                        this.logger.log(Level.FINE, "Temporarily removing schedule metadata for schedule: " + iterator2.getScheduleId());
                        this.scheduleMetadatas.remove(iterator2.getScheduleId());
                    }
                    this.tasks.put(string, task2);
                    this.taskStorageProvider.storeTask(task2);
                    ArrayList arrayList = new ArrayList();
                    for (AbstractSchedule abstractSchedule : task2.getSchedules()) {
                        ScheduleMetadata scheduleMetadata;
                        boolean bl = false;
                        Iterator<ScheduleMetadata> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            scheduleMetadata = iterator.next();
                            if (!abstractSchedule.getId().equals(scheduleMetadata.getScheduleId())) continue;
                            this.scheduleMetadatas.put(abstractSchedule.getId(), scheduleMetadata);
                            iterator.remove();
                            bl = true;
                            this.logger.log(Level.FINE, "Restored schedule metadata for schedule: " + scheduleMetadata.getScheduleId());
                            break;
                        }
                        if (bl) continue;
                        scheduleMetadata = new ScheduleMetadata.ScheduleMetadataBuilder().withScheduleId(abstractSchedule.getId()).build();
                        this.addScheduleMetadata(scheduleMetadata);
                        arrayList.add(scheduleMetadata);
                        this.taskStorageProvider.storeScheduleMetadata(scheduleMetadata);
                        this.logger.log(Level.FINE, "Added new schedule metadata for schedule: " + scheduleMetadata.getScheduleId());
                    }
                    for (ScheduleMetadata scheduleMetadata : list) {
                        this.taskStorageProvider.deleteScheduleMetadata(scheduleMetadata.getScheduleId());
                        this.logger.log(Level.FINE, "Deleted obsolete schedule metadata for schedule: " + scheduleMetadata.getScheduleId());
                    }
                    this.fireTaskUpdated(task2);
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        ScheduleMetadata scheduleMetadata = (ScheduleMetadata)iterator.next();
                        this.fireScheduleMetadataUpdated(task2, scheduleMetadata);
                    }
                } else {
                    this.logger.log(Level.WARNING, "Updated task with original taskId " + string + " had a different taskId after update: " + task2.getId() + "!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTaskMetadata(String string, TaskRepository.TaskMetadataUpdater taskMetadataUpdater) {
        Map<String, Task> map = this.tasks;
        synchronized (map) {
            TaskMetadata taskMetadata = this.getTaskMetadata(string);
            if (taskMetadata != null) {
                TaskMetadata taskMetadata2 = taskMetadataUpdater.updateTaskMetadata(taskMetadata);
                this.taskMetadatas.put(string, taskMetadata2);
                this.taskStorageProvider.storeTaskMetadata(taskMetadata2);
                this.fireTaskMetadataUpdated(this.getTask(string), taskMetadata2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateScheduleMetadata(String string, TaskRepository.ScheduleMetadataUpdater scheduleMetadataUpdater) {
        Map<String, Task> map = this.tasks;
        synchronized (map) {
            Task object = null;
            block3: for (Task object2 : this.tasks.values()) {
                for (AbstractSchedule abstractSchedule : object2.getSchedules()) {
                    if (!abstractSchedule.getId().equals(string)) continue;
                    object = object2;
                    continue block3;
                }
            }
            if (object != null) {
                ScheduleMetadata scheduleMetadata = this.getScheduleMetadata(string);
                if (scheduleMetadata != null) {
                    ScheduleMetadata scheduleMetadata2 = scheduleMetadataUpdater.updateScheduleMetadata(scheduleMetadata);
                    if (string.equals(scheduleMetadata2.getScheduleId())) {
                        this.scheduleMetadatas.put(string, scheduleMetadata2);
                        this.taskStorageProvider.storeScheduleMetadata(scheduleMetadata2);
                        this.fireScheduleMetadataUpdated(object, scheduleMetadata2);
                    } else {
                        this.logger.log(Level.WARNING, "Updated scheduleMetadata with original scheduleId " + string + "" + " had a different scheduleId after update: " + scheduleMetadata2.getScheduleId() + "!");
                    }
                } else {
                    this.logger.log(Level.WARNING, "Failed to update schedule with scheduleId " + string + "" + " because it does not exist!");
                }
            } else {
                this.logger.log(Level.WARNING, "Failed to update schedule with scheduleId " + string + "" + " because it does not belong to any task!");
            }
        }
    }
}

