/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.repository;

import de.oliver_matuschin.ttd.repository.TaskRepository;
import de.oliver_matuschin.ttd.repository.listener.TaskRepositoryEventListener;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.event.EventListenerList;

public abstract class AbstractTaskRepository
implements TaskRepository {
    private EventListenerList listeners;
    private ExecutorService eventExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "TaskRepositoryEventExecutor");
            thread.setDaemon(true);
            return thread;
        }
    });

    public AbstractTaskRepository() {
        this.listeners = new EventListenerList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaskRepositoryEventListener(TaskRepositoryEventListener taskRepositoryEventListener) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            this.listeners.add(TaskRepositoryEventListener.class, taskRepositoryEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTaskRepositoryEventListener(TaskRepositoryEventListener taskRepositoryEventListener) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            this.listeners.remove(TaskRepositoryEventListener.class, taskRepositoryEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTaskAdded(final Task task) {
        TaskRepositoryEventListener[] taskRepositoryEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskRepositoryEventListenerArray = (TaskRepositoryEventListener[])this.listeners.getListeners(TaskRepositoryEventListener.class);
        }
        this.eventExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (TaskRepositoryEventListener taskRepositoryEventListener : taskRepositoryEventListenerArray) {
                    taskRepositoryEventListener.taskAdded(task);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTaskUpdated(final Task task) {
        TaskRepositoryEventListener[] taskRepositoryEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskRepositoryEventListenerArray = (TaskRepositoryEventListener[])this.listeners.getListeners(TaskRepositoryEventListener.class);
        }
        this.eventExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (TaskRepositoryEventListener taskRepositoryEventListener : taskRepositoryEventListenerArray) {
                    taskRepositoryEventListener.taskUpdated(task);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTaskRemoved(final Task task) {
        TaskRepositoryEventListener[] taskRepositoryEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskRepositoryEventListenerArray = (TaskRepositoryEventListener[])this.listeners.getListeners(TaskRepositoryEventListener.class);
        }
        this.eventExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (TaskRepositoryEventListener taskRepositoryEventListener : taskRepositoryEventListenerArray) {
                    taskRepositoryEventListener.taskRemoved(task);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTaskMetadataUpdated(final Task task, final TaskMetadata taskMetadata) {
        TaskRepositoryEventListener[] taskRepositoryEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskRepositoryEventListenerArray = (TaskRepositoryEventListener[])this.listeners.getListeners(TaskRepositoryEventListener.class);
        }
        this.eventExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (TaskRepositoryEventListener taskRepositoryEventListener : taskRepositoryEventListenerArray) {
                    taskRepositoryEventListener.taskMetadataUpdated(task, taskMetadata);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireScheduleMetadataUpdated(final Task task, final ScheduleMetadata scheduleMetadata) {
        TaskRepositoryEventListener[] taskRepositoryEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskRepositoryEventListenerArray = (TaskRepositoryEventListener[])this.listeners.getListeners(TaskRepositoryEventListener.class);
        }
        this.eventExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (TaskRepositoryEventListener taskRepositoryEventListener : taskRepositoryEventListenerArray) {
                    taskRepositoryEventListener.scheduleMetadataUpdated(task, scheduleMetadata);
                }
            }
        });
    }
}

