/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.preferences;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.EventListenerList;

public class PortablePreferences
extends Preferences {
    private File portablePreferencesFile;
    private Properties preferences;
    private EventListenerList listeners = new EventListenerList();

    public PortablePreferences() {
        this.preferences = new Properties();
    }

    public PortablePreferences(File file) throws FileNotFoundException, IOException {
        this();
        this.portablePreferencesFile = file;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            this.preferences.load(bufferedInputStream);
        }
    }

    private void writeOut() {
        if (this.portablePreferencesFile != null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.portablePreferencesFile);){
                this.preferences.store(fileOutputStream, "Portable preferences");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void put(String string, String string2) {
        this.preferences.put(string, string2);
        this.firePreferenceChange(string, string2);
        this.writeOut();
    }

    @Override
    public String get(String string, String string2) {
        return this.preferences.getProperty(string, string2);
    }

    @Override
    public void remove(String string) {
        this.preferences.remove(string);
        this.firePreferenceChange(string, null);
        this.writeOut();
    }

    @Override
    public void clear() throws BackingStoreException {
        for (Map.Entry<Object, Object> entry : this.preferences.entrySet()) {
            this.firePreferenceChange(entry.getKey().toString(), null);
        }
        this.preferences.clear();
        this.writeOut();
    }

    @Override
    public void putInt(String string, int n) {
        this.preferences.put(string, String.valueOf(n));
        this.firePreferenceChange(string, String.valueOf(n));
        this.writeOut();
    }

    @Override
    public int getInt(String string, int n) {
        if (this.preferences.containsKey(string)) {
            return Integer.parseInt(this.preferences.getProperty(string));
        }
        return n;
    }

    @Override
    public void putLong(String string, long l) {
        this.preferences.put(string, String.valueOf(l));
        this.firePreferenceChange(string, String.valueOf(l));
        this.writeOut();
    }

    @Override
    public long getLong(String string, long l) {
        if (this.preferences.containsKey(string)) {
            return Long.parseLong(this.preferences.getProperty(string));
        }
        return l;
    }

    @Override
    public void putBoolean(String string, boolean bl) {
        this.preferences.put(string, String.valueOf(bl));
        this.firePreferenceChange(string, String.valueOf(bl));
        this.writeOut();
    }

    @Override
    public boolean getBoolean(String string, boolean bl) {
        if (this.preferences.containsKey(string)) {
            return Boolean.parseBoolean(this.preferences.getProperty(string));
        }
        return bl;
    }

    @Override
    public void putFloat(String string, float f) {
        this.preferences.put(string, String.valueOf(f));
        this.firePreferenceChange(string, String.valueOf(f));
        this.writeOut();
    }

    @Override
    public float getFloat(String string, float f) {
        if (this.preferences.containsKey(string)) {
            return Float.parseFloat(this.preferences.getProperty(string));
        }
        return f;
    }

    @Override
    public void putDouble(String string, double d) {
        this.preferences.put(string, String.valueOf(d));
        this.firePreferenceChange(string, String.valueOf(d));
        this.writeOut();
    }

    @Override
    public double getDouble(String string, double d) {
        if (this.preferences.containsKey(string)) {
            return Double.parseDouble(this.preferences.getProperty(string));
        }
        return d;
    }

    @Override
    public void putByteArray(String string, byte[] byArray) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public byte[] getByteArray(String string, byte[] byArray) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public String[] keys() throws BackingStoreException {
        return this.preferences.keySet().toArray(new String[0]);
    }

    @Override
    public String[] childrenNames() throws BackingStoreException {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public Preferences parent() {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public Preferences node(String string) {
        return null;
    }

    @Override
    public boolean nodeExists(String string) throws BackingStoreException {
        return false;
    }

    @Override
    public void removeNode() throws BackingStoreException {
    }

    @Override
    public String name() {
        return null;
    }

    @Override
    public String absolutePath() {
        return null;
    }

    @Override
    public boolean isUserNode() {
        return false;
    }

    @Override
    public String toString() {
        return this.preferences.toString();
    }

    @Override
    public void flush() throws BackingStoreException {
        this.writeOut();
    }

    @Override
    public void sync() throws BackingStoreException {
        if (this.portablePreferencesFile != null) {
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.portablePreferencesFile));){
                this.preferences.load(bufferedInputStream);
            }
            catch (IOException iOException) {
                throw new BackingStoreException(iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            this.listeners.add(PreferenceChangeListener.class, preferenceChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            this.listeners.remove(PreferenceChangeListener.class, preferenceChangeListener);
        }
    }

    @Override
    public void addNodeChangeListener(NodeChangeListener nodeChangeListener) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public void removeNodeChangeListener(NodeChangeListener nodeChangeListener) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public void exportNode(OutputStream outputStream) throws IOException, BackingStoreException {
    }

    @Override
    public void exportSubtree(OutputStream outputStream) throws IOException, BackingStoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePreferenceChange(String string, String string2) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            PreferenceChangeListener[] preferenceChangeListenerArray;
            for (PreferenceChangeListener preferenceChangeListener : preferenceChangeListenerArray = (PreferenceChangeListener[])this.listeners.getListeners(PreferenceChangeListener.class)) {
                preferenceChangeListener.preferenceChange(new PreferenceChangeEvent(this, string, string2));
            }
        }
    }
}

