/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.plugin.bridge.executor;

import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.ttd.action.UnknownAction;
import de.oliver_matuschin.ttd.manager.ActionPackPluginManager;
import de.oliver_matuschin.ttd.manager.exception.UnknownActionException;
import de.oliver_matuschin.ttd.plugin.action.Action;
import de.oliver_matuschin.ttd.plugin.action.context.ActionContext;
import de.oliver_matuschin.ttd.plugin.action.exception.ActionExecutionException;
import de.oliver_matuschin.ttd.plugin.bridge.executor.PluginActionContextFactory;
import de.oliver_matuschin.ttd.scheduler.executor.ActionExecutor;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class PluginActionExecutor
implements ActionExecutor {
    private LocalizationProvider localizationProvider;
    private ActionPackPluginManager actionPackPluginManager;
    private PluginActionContextFactory actionContextFactory;

    public PluginActionExecutor(LocalizationProvider localizationProvider, ActionPackPluginManager actionPackPluginManager, PluginActionContextFactory pluginActionContextFactory) {
        this.localizationProvider = localizationProvider;
        this.actionPackPluginManager = actionPackPluginManager;
        this.actionContextFactory = pluginActionContextFactory;
    }

    @Override
    public ActionExecutor.ActionResult executeAction(Task task, de.oliver_matuschin.ttd.scheduler.task.action.Action action, Map<String, Object> map, Map<String, Object> map2, ActionExecutor.StatusUpdater statusUpdater) throws Exception {
        Object object;
        Object object2;
        ActionContext actionContext = this.actionContextFactory.newContext(task, action, map, map2, statusUpdater);
        Class clazz = null;
        try {
            clazz = this.actionPackPluginManager.getActionClassForName(action.getType());
        }
        catch (UnknownActionException unknownActionException) {
            clazz = UnknownAction.class;
        }
        Action.ActionResult actionResult = null;
        Action action2 = (Action)clazz.newInstance();
        Object object3 = null;
        Object object4 = null;
        if (clazz != UnknownAction.class) {
            if (action.getInput1() != null && (object3 = map.get(action.getInput1().getName())) != null && action.getInput1().getConverter() != null && (object2 = this.actionPackPluginManager.getTypeConverterForName(action.getInput1().getConverter())) != null) {
                object3 = object2.convert(object3, action.getInput1().getConfiguration());
            }
            if (action.getInput2() != null && (object4 = map.get(action.getInput2().getName())) != null && action.getInput2().getConverter() != null && (object2 = this.actionPackPluginManager.getTypeConverterForName(action.getInput2().getConverter())) != null) {
                object4 = object2.convert(object4, action.getInput2().getConfiguration());
            }
        }
        object2 = this.actionPackPluginManager.getLocalizedStringForActionClass(clazz, "title", "Untitled action");
        try {
            object = action.getConfiguration() != null ? action.getConfiguration().asMap() : new HashMap<String, Object>();
            Method method = clazz.getMethod("run", ActionContext.class, Map.class, Object.class, Object.class);
            actionResult = (Action.ActionResult)method.invoke((Object)action2, actionContext, object, object3, object4);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof InterruptedException) {
                throw new InterruptedException();
            }
            if (invocationTargetException.getCause() instanceof ActionExecutionException) {
                throw new de.oliver_matuschin.ttd.scheduler.executor.exception.ActionExecutionException((String)object2 + ": " + invocationTargetException.getCause().getLocalizedMessage());
            }
            if (invocationTargetException.getCause() instanceof NullPointerException) {
                throw new de.oliver_matuschin.ttd.scheduler.executor.exception.ActionExecutionException((String)object2 + ": " + this.localizationProvider.getLocalizedString("executor.PluginActionExecutor.error.nullPointerException"));
            }
            if (invocationTargetException.getCause() instanceof OutOfMemoryError) {
                throw new de.oliver_matuschin.ttd.scheduler.executor.exception.ActionExecutionException((String)object2 + ": " + this.localizationProvider.getLocalizedString("executor.PluginActionExecutor.error.heapSpace"));
            }
            String string = invocationTargetException.getCause().getLocalizedMessage();
            if (string == null) {
                string = invocationTargetException.getCause().toString();
            }
            throw new de.oliver_matuschin.ttd.scheduler.executor.exception.ActionExecutionException((String)object2 + ": " + string);
        }
        if (action.getOutput() != null) {
            if (actionResult != null) {
                map.put(action.getOutput().getName(), actionResult.getReturnValue());
            } else {
                map.remove(action.getOutput().getName());
            }
        }
        if (actionResult == null) {
            return new ActionExecutor.ActionResult();
        }
        if (actionResult instanceof Action.JumpResult) {
            object = (Action.JumpResult)actionResult;
            if (((Action.JumpResult)object).getTarget() != null) {
                switch (((Action.JumpResult)object).getTarget()) {
                    case WORKFLOW_END: {
                        return new ActionExecutor.JumpResult(((Action.ActionResult)object).getReturnValue(), ActionExecutor.JumpResult.Target.WORKFLOW_END);
                    }
                    case WORKFLOW_START: {
                        return new ActionExecutor.JumpResult(((Action.ActionResult)object).getReturnValue(), ActionExecutor.JumpResult.Target.WORKFLOW_START);
                    }
                }
                throw new de.oliver_matuschin.ttd.scheduler.executor.exception.ActionExecutionException((String)object2 + ": Action returned unknown target.");
            }
            return new ActionExecutor.JumpResult(((Action.ActionResult)object).getReturnValue(), ((Action.JumpResult)object).getTargetLabel());
        }
        return new ActionExecutor.ActionResult(actionResult.getReturnValue());
    }
}

