/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.notification.listener;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.ttd.notification.NotificationManager;
import de.oliver_matuschin.ttd.notification.listener.AbstractNotificationListener;
import java.io.IOException;
import java.util.ArrayList;

public class TextToSpeechNotificationListener
extends AbstractNotificationListener {
    private Process process;
    private Boolean powerShellAvailable;

    public TextToSpeechNotificationListener() {
        if (Starter.getApplication().getPlatform() == Platform.WINDOWS) {
            try {
                ProcessBuilder processBuilder = new ProcessBuilder("PowerShell", "-Command", "[Environment]::Exit(1);");
                processBuilder.start();
                this.powerShellAvailable = true;
            }
            catch (Exception exception) {
                this.powerShellAvailable = false;
            }
        }
    }

    @Override
    public String getName() {
        return "TextToSpeechNotificationListener";
    }

    @Override
    public boolean isAvailable() {
        if (Starter.getApplication().getPlatform() == Platform.MACOS) {
            return true;
        }
        if (Starter.getApplication().getPlatform() == Platform.WINDOWS) {
            return this.powerShellAvailable;
        }
        return false;
    }

    @Override
    public void notifyOf(String string, String string2, String string3, NotificationManager.NotificationType notificationType) {
        if (this.process != null && this.process.isAlive()) {
            this.process.destroy();
        }
        if (Starter.getApplication().getPlatform() == Platform.MACOS) {
            try {
                this.process = Runtime.getRuntime().exec(new String[]{"env", "LANG=UTF-8", "say", string3});
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (Starter.getApplication().getPlatform() == Platform.WINDOWS && this.powerShellAvailable.booleanValue()) {
            string3 = string3.replace('\"', ' ').replace('\'', ' ').replace('\r', ' ').replace('\n', ' ');
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("PowerShell");
            arrayList.add("-NonInteractive");
            arrayList.add("-NoProfile");
            arrayList.add("-Command");
            arrayList.add("Add-Type -AssemblyName System.Speech; (New-Object System.Speech.Synthesis.SpeechSynthesizer).Speak('" + string3 + "'); [Environment]::Exit(1);");
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            try {
                this.process = processBuilder.start();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

