/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.notification.listener;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.ttd.notification.NotificationManager;
import de.oliver_matuschin.ttd.notification.listener.AbstractNotificationListener;
import java.awt.EventQueue;
import java.awt.SystemTray;
import java.awt.TrayIcon;

public class SystemTrayNotificationListener
extends AbstractNotificationListener {
    private boolean available = false;

    public SystemTrayNotificationListener() {
        if (SystemTray.isSupported() && Starter.getApplication().getPlatform() != Platform.MACOS && System.getProperty("os.version") != null) {
            try {
                float f = Float.parseFloat(System.getProperty("os.version"));
                if (f < 10.0f) {
                    this.available = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getName() {
        return "SystemTrayNotificationListener";
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public void notifyOf(String string, final String string2, final String string3, final NotificationManager.NotificationType notificationType) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TrayIcon.MessageType messageType = TrayIcon.MessageType.INFO;
                if (notificationType.equals((Object)NotificationManager.NotificationType.ERROR)) {
                    messageType = TrayIcon.MessageType.ERROR;
                } else if (notificationType.equals((Object)NotificationManager.NotificationType.WARN)) {
                    messageType = TrayIcon.MessageType.WARNING;
                }
                SystemTray systemTray = SystemTray.getSystemTray();
                TrayIcon[] trayIconArray = systemTray.getTrayIcons();
                if (trayIconArray != null && trayIconArray.length > 0) {
                    trayIconArray[0].displayMessage(string2, string3, messageType);
                }
            }
        });
    }

    @Override
    public boolean isDefaultEnabled() {
        return false;
    }

    @Override
    public boolean isEditable() {
        return true;
    }
}

