/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.notification.listener;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.ttd.notification.NotificationManager;
import de.oliver_matuschin.ttd.notification.listener.AbstractNotificationListener;
import de.oliver_matuschin.util.SystemUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NotificationCenterNotificationListener
extends AbstractNotificationListener {
    private static final Logger logger = Logger.getLogger(NotificationCenterNotificationListener.class.getName());
    private boolean available = false;

    private native void sendNotification(String var1, String var2, String var3, long var4);

    public NotificationCenterNotificationListener() {
        if (Starter.getApplication().getPlatform() == Platform.MACOS) {
            String string = System.getProperty("os.version");
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Checking OS-version: " + string);
            }
            int[] nArray = SystemUtil.getMajorMinor();
            int n = nArray[0];
            int n2 = nArray[1];
            if (n > 10 || n == 10 && n2 > 7) {
                try {
                    System.loadLibrary("NotificationCenterNotification");
                    this.available = true;
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Failed to load Notification Center library!", exception);
                }
            }
        }
    }

    @Override
    public String getName() {
        return "NotificationCenterNotificationListener";
    }

    @Override
    public void notifyOf(String string, String string2, String string3, NotificationManager.NotificationType notificationType) {
        this.sendNotification(Starter.getApplication().getApplicationName(), string2, string3, 0L);
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isDefaultEnabled() {
        return Starter.getApplication().getPlatform() == Platform.MACOS;
    }
}

