/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.notification;

import de.oliver_matuschin.ttd.notification.listener.AbstractNotificationListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NotificationManager {
    private static final Logger logger = Logger.getLogger(NotificationManager.class.getName());
    private List<AbstractNotificationListener> listeners = new ArrayList<AbstractNotificationListener>();
    private LinkedList<Runnable> queue = new LinkedList();

    public NotificationManager() {
        NotificationWorker notificationWorker = new NotificationWorker();
        notificationWorker.setDaemon(true);
        notificationWorker.setName("NotificationWorker");
        notificationWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AbstractNotificationListener abstractNotificationListener) {
        List<AbstractNotificationListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(abstractNotificationListener)) {
                this.listeners.add(abstractNotificationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNotificationListener[] getListeners() {
        List<AbstractNotificationListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(new AbstractNotificationListener[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AbstractNotificationListener abstractNotificationListener) {
        List<AbstractNotificationListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(abstractNotificationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        List<AbstractNotificationListener> list = this.listeners;
        synchronized (list) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNotification(final String string, final String string2, final String string3, final NotificationType notificationType) {
        List<AbstractNotificationListener> list = this.listeners;
        synchronized (list) {
            for (final AbstractNotificationListener abstractNotificationListener : this.listeners) {
                boolean bl = false;
                if (abstractNotificationListener.isAvailable()) {
                    bl = abstractNotificationListener.isEditable() ? abstractNotificationListener.isEnabled() : abstractNotificationListener.isDefaultEnabled();
                }
                if (!bl) continue;
                LinkedList<Runnable> linkedList = this.queue;
                synchronized (linkedList) {
                    this.queue.addLast(new Runnable(){

                        @Override
                        public void run() {
                            abstractNotificationListener.notifyOf(string, string2, string3, notificationType);
                        }
                    });
                    this.queue.notify();
                }
            }
        }
    }

    private class NotificationWorker
    extends Thread {
        private NotificationWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable runnable = null;
            while (true) {
                LinkedList linkedList = NotificationManager.this.queue;
                synchronized (linkedList) {
                    while (NotificationManager.this.queue.isEmpty()) {
                        try {
                            NotificationManager.this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            logger.log(Level.INFO, "An error occured while processing notification queue!", interruptedException);
                        }
                    }
                    runnable = (Runnable)NotificationManager.this.queue.removeFirst();
                }
                try {
                    runnable.run();
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    logger.log(Level.INFO, "A runtime exception occured during notification.", runtimeException);
                    continue;
                }
                break;
            }
        }
    }

    public static enum NotificationType {
        INFO,
        WARN,
        ERROR;

    }
}

