/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.migrate;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.ttd.collect.ImmutableArrayList;
import de.oliver_matuschin.ttd.collect.ImmutableHashMap;
import de.oliver_matuschin.ttd.plugin.task.Task;
import de.oliver_matuschin.ttd.repository.TaskRepository;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.action.Action;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.IntervalSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.ManualSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.TimeSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import de.oliver_matuschin.ttd.scheduler.task.trigger.ApplicationStartedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.TaskTrigger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MigrationUtil {
    private static final Logger logger = Logger.getLogger(MigrationUtil.class.getName());

    public static void migrateTasks(TaskRepository taskRepository, LocalizationProvider localizationProvider) {
        MigrationUtil.migrateTasksBeforeTTD2(taskRepository, localizationProvider);
    }

    private static void migrateTasksBeforeTTD2(TaskRepository taskRepository, LocalizationProvider localizationProvider) {
        MigrationUtil.migrate_V2();
        MigrationUtil.migrate_V3(taskRepository, localizationProvider);
    }

    private static void migrate_V3(TaskRepository taskRepository, LocalizationProvider localizationProvider) {
        LegacyTask[] legacyTaskArray;
        for (LegacyTask legacyTask : legacyTaskArray = MigrationUtil.loadTasks()) {
            try {
                Object object;
                Cloneable cloneable;
                Date date = legacyTask.getCreationDate();
                Date date2 = legacyTask.getChangeDate();
                String string = legacyTask.getId();
                if (string == null) {
                    string = taskRepository.nextId();
                }
                TaskMetadata.TaskMetadataBuilder taskMetadataBuilder = new TaskMetadata.TaskMetadataBuilder().withTaskId(string).withTaskEnabled(legacyTask.isEnabled()).withSuccessfulExecutionCount(BigInteger.valueOf(legacyTask.getSuccessfulExecutionCount())).withTotalExecutionCount(BigInteger.valueOf(legacyTask.getExecutionCount()));
                Task.TaskBuilder taskBuilder = new Task.TaskBuilder().withId(string).withName(legacyTask.getName()).withDescription(legacyTask.getDescription()).withCreated(date).withChanged(date2);
                if (legacyTask.isLimitTaskExecutions()) {
                    taskBuilder.withMaximumExecutionCount(BigInteger.valueOf(legacyTask.getMaximumExecutionCount()));
                    if (legacyTask.isDeleteOnMaximumExecutionCount()) {
                        taskBuilder.withDeleteAfterMaximumExecutionsReached(true);
                    } else {
                        taskBuilder.withDeleteAfterMaximumExecutionsReached(false);
                    }
                }
                ArrayList<Action> arrayList = new ArrayList<Action>();
                if (legacyTask.isDependsOnTask()) {
                    cloneable = new HashMap<String, String>();
                    cloneable.put("task", legacyTask.getDependsOnTaskId());
                    arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.SpecifyTaskAction").withConfiguration(new ImmutableHashMap<String, Object>((Map<String, Object>)((Object)cloneable))).withOutput(new Action.ActionVariable(localizationProvider.getLocalizedString("migration.label.taskToCheck"), Task.class.getCanonicalName())).build());
                    cloneable = new HashMap();
                    cloneable.put("jumpToLabel", localizationProvider.getLocalizedString("migration.label.labelTaskIsRunning"));
                    cloneable.put("condition", "all");
                    arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.CheckForRunningTasksAction").withConfiguration(new ImmutableHashMap<String, Object>((Map<String, Object>)((Object)cloneable))).withInput1(new Action.ConvertibleVariable(localizationProvider.getLocalizedString("migration.label.taskToCheck"), Task.class.getCanonicalName(), "de.oliver_matuschin.ttd.plugin.defaultActions.converter.SingleObjectToListConverter")).build());
                    arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.FinishAction").build());
                    arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.LabelAction").withLabel(localizationProvider.getLocalizedString("migration.label.labelTaskIsRunning")).build());
                }
                if (legacyTask.isDelayedExecution()) {
                    cloneable = new HashMap();
                    cloneable.put("delay", String.valueOf(legacyTask.getExecutionDelay()));
                    arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.PauseAction").withConfiguration(new ImmutableHashMap<String, Object>((Map<String, Object>)((Object)cloneable))).build());
                }
                cloneable = new ArrayList();
                cloneable.add(legacyTask.getExecutableFile().getPath());
                HashMap<String, String> hashMap = new HashMap<String, Object>();
                hashMap.put("files", (String)((Object)cloneable));
                arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.SpecifyFilesAction").withConfiguration(new ImmutableHashMap<String, Object>(hashMap)).withOutput(new Action.ActionVariable(localizationProvider.getLocalizedString("migration.label.filesToOpen"), List.class.getCanonicalName() + "<" + File.class.getCanonicalName() + ">")).build());
                hashMap = new HashMap();
                hashMap.put("openFilesSequentially", "true");
                if (legacyTask.hasErrorHandler()) {
                    hashMap.put("onErrorJumpToLabel", localizationProvider.getLocalizedString("migration.label.labelErrorOccured"));
                }
                if (legacyTask.getExecutionOptions().contains((Object)LegacyTask.ExecutionOptions.WAIT_FOR_TASK_TO_FINISH)) {
                    hashMap.put("waitForApplicationsToFinish", "true");
                }
                if (legacyTask.getExecutionOptions().contains((Object)LegacyTask.ExecutionOptions.OPEN_TASK_IN_BACKGROUND)) {
                    hashMap.put("openFilesInBackground", "true");
                }
                if (legacyTask.getExecutionOptions().contains((Object)LegacyTask.ExecutionOptions.OPEN_ANOTHER_INSTANCE)) {
                    hashMap.put("openNewInstances", "true");
                }
                arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.OpenFilesAction").withConfiguration(new ImmutableHashMap<String, Object>(hashMap)).withInput1(new Action.ConvertibleVariable(localizationProvider.getLocalizedString("migration.label.filesToOpen"), List.class.getCanonicalName() + "<" + File.class.getCanonicalName() + ">")).build());
                if (legacyTask.hasSuccessHandler()) {
                    hashMap = new HashMap();
                    hashMap.put("task", legacyTask.getSuccessTaskId());
                    arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.SpecifyTaskAction").withConfiguration(new ImmutableHashMap<String, Object>(hashMap)).withOutput(new Action.ActionVariable(localizationProvider.getLocalizedString("migration.label.taskToRun"), Task.class.getCanonicalName())).build());
                    arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.ExecuteTasksAction").withInput1(new Action.ConvertibleVariable(localizationProvider.getLocalizedString("migration.label.taskToRun"), Task.class.getCanonicalName(), "de.oliver_matuschin.ttd.plugin.defaultActions.converter.SingleObjectToListConverter")).build());
                }
                if (legacyTask.hasErrorHandler()) {
                    arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.FinishAction").build());
                    arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.LabelAction").withLabel(localizationProvider.getLocalizedString("migration.label.labelErrorOccured")).build());
                    hashMap = new HashMap();
                    hashMap.put("task", legacyTask.getErrorTaskId());
                    arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.SpecifyTaskAction").withConfiguration(new ImmutableHashMap<String, Object>(hashMap)).withOutput(new Action.ActionVariable(localizationProvider.getLocalizedString("migration.label.taskToRun"), Task.class.getCanonicalName())).build());
                    arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.ExecuteTasksAction").withInput1(new Action.ConvertibleVariable(localizationProvider.getLocalizedString("migration.label.taskToRun"), Task.class.getCanonicalName(), "de.oliver_matuschin.ttd.plugin.defaultActions.converter.SingleObjectToListConverter")).build());
                    hashMap = new HashMap<String, String>();
                    hashMap.put("message", localizationProvider.getLocalizedString("migration.label.failedToOpenFileOrFolder"));
                    arrayList.add(new Action.ActionBuilder().withType("de.oliver_matuschin.ttd.plugin.defaultActions.action.StopAction").withConfiguration(new ImmutableHashMap<String, Object>(hashMap)).build());
                }
                cloneable = new HashMap();
                cloneable.put("Start", new ImmutableArrayList(arrayList));
                taskBuilder.withActions(new ImmutableHashMap<String, ImmutableArrayList<Action>>((Map<String, ImmutableArrayList<Action>>)((Object)cloneable)));
                ArrayList<AbstractSchedule> arrayList2 = new ArrayList<AbstractSchedule>();
                hashMap = taskRepository.nextId();
                ManualSchedule.ManualScheduleBuilder manualScheduleBuilder = new ManualSchedule.ManualScheduleBuilder().withId((String)((Object)hashMap)).withCreationDate(date).withChangeDate(date2);
                arrayList2.add(manualScheduleBuilder.build());
                if (legacyTask.getInterval() == LegacyTask.Interval.INTERVAL_IN_SECONDS) {
                    hashMap = taskRepository.nextId();
                    object = new IntervalSchedule.IntervalScheduleBuilder().withId((String)((Object)hashMap)).withCreationDate(date).withChangeDate(date2).withIntervalInSeconds(legacyTask.getIntervalInSeconds()).withSkipIfMissed(legacyTask.isSkipIfMissed());
                    if (legacyTask.isLimitIntervalExecution()) {
                        ((IntervalSchedule.IntervalScheduleBuilder)object).withIntervalStart(legacyTask.getIntervalLimit()[0]).withIntervalEnd(legacyTask.getIntervalLimit()[1]);
                    } else {
                        ((IntervalSchedule.IntervalScheduleBuilder)object).withIntervalStart(null).withIntervalEnd(null);
                    }
                    ((IntervalSchedule.IntervalScheduleBuilder)object).withWeekdays(127);
                    if (legacyTask.getExecutionTimeFrame() == LegacyTask.ExecutionTimeFrame.WEEKDAYS) {
                        ((IntervalSchedule.IntervalScheduleBuilder)object).withWeekdays(legacyTask.getTimeFrameWeekdays());
                    } else if (legacyTask.getExecutionTimeFrame() == LegacyTask.ExecutionTimeFrame.DAY_OF_MONTH) {
                        ((IntervalSchedule.IntervalScheduleBuilder)object).withDayOfMonth(legacyTask.getTimeFrameDayOfMonth());
                    }
                    arrayList2.add(((IntervalSchedule.IntervalScheduleBuilder)object).build());
                } else if (legacyTask.getInterval() == LegacyTask.Interval.SPECIFIED_TIME_INTERVAL) {
                    hashMap = taskRepository.nextId();
                    object = new TimeSchedule.TimeScheduleBuilder().withId((String)((Object)hashMap)).withCreated(date).withChanged(date2).withSpecifiedTime(legacyTask.getExecutionTime()).withSkipIfMissed(legacyTask.isSkipIfMissed());
                    ((TimeSchedule.TimeScheduleBuilder)object).withWeekdays(127);
                    if (legacyTask.getExecutionTimeFrame() == LegacyTask.ExecutionTimeFrame.WEEKDAYS) {
                        ((TimeSchedule.TimeScheduleBuilder)object).withWeekdays(legacyTask.getTimeFrameWeekdays());
                    } else if (legacyTask.getExecutionTimeFrame() == LegacyTask.ExecutionTimeFrame.DAY_OF_MONTH) {
                        ((TimeSchedule.TimeScheduleBuilder)object).withDayOfMonth(legacyTask.getTimeFrameDayOfMonth());
                    }
                    arrayList2.add(((TimeSchedule.TimeScheduleBuilder)object).build());
                }
                if (legacyTask.isExecuteOnStartup()) {
                    arrayList2.add(new ApplicationStartedTrigger(taskRepository.nextId(), date, date2, null, null));
                }
                arrayList2.add(new TaskTrigger(taskRepository.nextId(), date, date2, null, null));
                object = ScheduleMetadata.ResultType.INFO;
                if (legacyTask.getLastResultType() != null) {
                    if (legacyTask.getLastResultType() == LegacyTask.ResultType.NOTIFICATION) {
                        object = ScheduleMetadata.ResultType.WARNING;
                    } else if (legacyTask.getLastResultType() == LegacyTask.ResultType.ERROR) {
                        object = ScheduleMetadata.ResultType.ERROR;
                    }
                }
                ScheduleMetadata.ScheduleMetadataBuilder scheduleMetadataBuilder = new ScheduleMetadata.ScheduleMetadataBuilder().withScheduleId((String)((Object)hashMap)).withSuccessfulStart(legacyTask.getLastExecutionDate()).withStart(legacyTask.getLastExecutionDate()).withEnd(legacyTask.getLastResultDate()).withIntermediateStart(legacyTask.getLastResultDate()).withResultTime(legacyTask.getLastResultDate()).withResultDescription(legacyTask.getLastResultDescription()).withResultReason(ScheduleMetadata.ResultReason.OTHER).withResultType((ScheduleMetadata.ResultType)((Object)object));
                ArrayList<ScheduleMetadata> arrayList3 = new ArrayList<ScheduleMetadata>();
                arrayList3.add(scheduleMetadataBuilder.build());
                taskBuilder.withSchedules(new ImmutableArrayList<AbstractSchedule>(arrayList2));
                taskRepository.addTask(taskBuilder.build(), taskMetadataBuilder.build(), arrayList3);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Failed to migrate task: " + legacyTask.getName(), exception);
            }
        }
    }

    private static void migrate_V2() {
        try {
            boolean bl = false;
            File file = MigrationUtil.getTaskPropertiesFile();
            if (file != null) {
                bl = MigrationUtil.migrate_V2(file);
            }
            if (!bl) {
                file = new File(MigrationUtil.getTaskPropertiesFileNameAndPath() + ".previous");
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                if (file.exists()) {
                    MigrationUtil.migrate_V2(file);
                }
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Error in migrate V2!", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean migrate_V2(File file) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Trying to migrate \"" + file.getPath() + "\" (migrate V2) ...");
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (file != null) {
                fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.loadFromXML(fileInputStream);
                fileInputStream.close();
                fileInputStream = null;
                boolean bl = false;
                int n = 0;
                while (properties.getProperty("taskName[" + n + "]") != null) {
                    String string;
                    String string2 = properties.getProperty("taskExecuteOnce[" + n + "]", null);
                    if (string2 != null && Boolean.valueOf(string2).booleanValue()) {
                        properties.setProperty("taskMaximumExecutionCount[" + n + "]", "1");
                        properties.setProperty("taskDeleteOnMaximumExecutionCount[" + n + "]", "true");
                        properties.setProperty("taskLimitTaskExecutions[" + n + "]", "true");
                        bl = true;
                    }
                    if ((string = properties.getProperty("taskOccurrence[" + n + "]", null)) != null) {
                        if (string.equals("WEEKENDS")) {
                            properties.setProperty("taskTimeFrameWeekdays[" + n + "]", "" + (LegacyTask.SATURDAY + LegacyTask.SUNDAY));
                            properties.setProperty("taskExecutionTimeFrame[" + n + "]", String.valueOf((Object)LegacyTask.ExecutionTimeFrame.WEEKDAYS));
                            bl = true;
                        } else if (string.equals("WORKDAYS")) {
                            properties.setProperty("taskTimeFrameWeekdays[" + n + "]", "" + (LegacyTask.MONDAY + LegacyTask.TUESDAY + LegacyTask.WEDNESDAY + LegacyTask.THURSDAY + LegacyTask.FRIDAY));
                            properties.setProperty("taskExecutionTimeFrame[" + n + "]", String.valueOf((Object)LegacyTask.ExecutionTimeFrame.WEEKDAYS));
                            bl = true;
                        } else if (string.equals("EVERY_DAY")) {
                            properties.setProperty("taskTimeFrameWeekdays[" + n + "]", "" + LegacyTask.EVERY_DAY);
                            bl = true;
                        }
                        if (bl) {
                            properties.remove("taskOccurrence[" + n + "]");
                        }
                    }
                    ++n;
                }
                if (bl) {
                    fileOutputStream = new FileOutputStream(file);
                    properties.storeToXML(fileOutputStream, Starter.getApplication().getApplicationName() + " " + Starter.getApplication().getApplicationVersion() + " - converted task properties (v1.4 / v1.6)");
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                n = 1;
                return n != 0;
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Could not migrate task properties (migrate V2)!", iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "Could not close input stream (migrate V2)!", iOException);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "Could not close output stream (migrate V2)!", iOException);
                }
            }
        }
        return false;
    }

    private static String getTaskPropertiesFileNameAndPath() throws FileNotFoundException {
        String string;
        String string2 = "";
        if (Starter.getApplication().getPlatform() == Platform.MACOS) {
            string2 = System.getProperty("user.home") + File.separator + "Library" + File.separator + "Application Support" + File.separator + Starter.getApplication().getApplicationName() + File.separator;
        } else if (Starter.getApplication().getPlatform() == Platform.WINDOWS && (string = System.getenv("APPDATA")) != null) {
            string2 = string + File.separator + Starter.getApplication().getApplicationName() + File.separator;
        }
        return string2 + "tasks.properties";
    }

    public static File getTaskPropertiesFile() {
        try {
            File file = new File(MigrationUtil.getTaskPropertiesFileNameAndPath());
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                return null;
            }
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static LegacyTask[] loadTasks() {
        File file;
        LegacyTask[] legacyTaskArray = null;
        File file2 = MigrationUtil.getTaskPropertiesFile();
        if (file2 != null) {
            legacyTaskArray = MigrationUtil.loadTasks(file2);
        }
        if (legacyTaskArray == null && (file = MigrationUtil.getTaskPropertiesFile()) != null && (file = new File(file.getPath() + ".previous")) != null) {
            legacyTaskArray = MigrationUtil.loadTasks(file);
        }
        if (legacyTaskArray == null) {
            legacyTaskArray = new LegacyTask[]{};
        }
        return legacyTaskArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LegacyTask[] loadTasks(File file) {
        block59: {
            if (logger.isLoggable(Level.FINE)) {
                if (file != null) {
                    logger.log(Level.FINE, "Loading tasks from file \"" + file.getPath() + "\"...");
                } else {
                    logger.log(Level.FINE, "Cannot load tasks, no taskfile provided!");
                }
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            ArrayList<LegacyTask> arrayList = new ArrayList<LegacyTask>();
            FileInputStream fileInputStream = null;
            try {
                if (file == null) break block59;
                fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.loadFromXML(fileInputStream);
                int n = 0;
                while (properties.getProperty("taskName[" + n + "]") != null) {
                    try {
                        Cloneable cloneable;
                        Object object;
                        LegacyTask legacyTask = new LegacyTask();
                        legacyTask.setName(properties.getProperty("taskName[" + n + "]"));
                        legacyTask.setDescription(properties.getProperty("taskDescription[" + n + "]"));
                        if (properties.getProperty("taskId[" + n + "]") != null) {
                            legacyTask.setId(properties.getProperty("taskId[" + n + "]"));
                        }
                        legacyTask.setExecutableFile(new File(properties.getProperty("taskFile[" + n + "]")));
                        legacyTask.setInterval(LegacyTask.Interval.valueOf(properties.getProperty("taskInterval[" + n + "]")));
                        if (properties.getProperty("taskExecuteOnStartup[" + n + "]") != null) {
                            legacyTask.setExecuteOnStartup(Boolean.parseBoolean(properties.getProperty("taskExecuteOnStartup[" + n + "]")));
                        }
                        legacyTask.setIntervalInSeconds(Integer.parseInt(properties.getProperty("taskIntervalInSeconds[" + n + "]")));
                        if (properties.getProperty("taskTimeFrameWeekdays[" + n + "]") != null) {
                            legacyTask.setTimeFrameWeekdays(Integer.parseInt(properties.getProperty("taskTimeFrameWeekdays[" + n + "]")));
                        }
                        if (properties.getProperty("taskTimeFrameDayOfMonth[" + n + "]") != null) {
                            legacyTask.setTimeFrameDayOfMonth(Integer.parseInt(properties.getProperty("taskTimeFrameDayOfMonth[" + n + "]")));
                        }
                        if (properties.getProperty("taskExecutionTimeFrame[" + n + "]") != null) {
                            legacyTask.setExecutionTimeFrame(LegacyTask.ExecutionTimeFrame.valueOf(properties.getProperty("taskExecutionTimeFrame[" + n + "]")));
                        }
                        if (properties.getProperty("taskMaximumExecutionCount[" + n + "]") != null) {
                            legacyTask.setMaximumExecutionCount(Integer.parseInt(properties.getProperty("taskMaximumExecutionCount[" + n + "]")));
                        }
                        if (properties.getProperty("taskLimitTaskExecutions[" + n + "]") != null) {
                            legacyTask.setLimitTaskExecutions(Boolean.parseBoolean(properties.getProperty("taskLimitTaskExecutions[" + n + "]")));
                        }
                        if (properties.getProperty("taskDeleteOnMaximumExecutionCount[" + n + "]") != null) {
                            legacyTask.setDeleteOnMaximumExecutionCount(Boolean.parseBoolean(properties.getProperty("taskDeleteOnMaximumExecutionCount[" + n + "]")));
                        }
                        if (properties.getProperty("taskSuccessfulExecutionCount[" + n + "]") != null) {
                            legacyTask.setSuccessfulExecutionCount(Integer.parseInt(properties.getProperty("taskSuccessfulExecutionCount[" + n + "]")));
                        }
                        if (properties.getProperty("taskExecutionCount[" + n + "]") != null) {
                            legacyTask.setExecutionCount(Integer.parseInt(properties.getProperty("taskExecutionCount[" + n + "]")));
                        }
                        if (properties.getProperty("taskExecutionDelay[" + n + "]") != null) {
                            legacyTask.setExecutionDelay(Integer.parseInt(properties.getProperty("taskExecutionDelay[" + n + "]")));
                        }
                        if (properties.getProperty("taskDelayedExecution[" + n + "]") != null) {
                            legacyTask.setDelayedExecution(Boolean.parseBoolean(properties.getProperty("taskDelayedExecution[" + n + "]")));
                        }
                        if (properties.getProperty("taskSkipIfMissed[" + n + "]") != null) {
                            legacyTask.setSkipIfMissed(Boolean.parseBoolean(properties.getProperty("taskSkipIfMissed[" + n + "]")));
                        }
                        if (properties.getProperty("taskEnabled[" + n + "]") != null) {
                            legacyTask.setEnabled(Boolean.parseBoolean(properties.getProperty("taskEnabled[" + n + "]")));
                        }
                        if (properties.getProperty("taskLastResultDescription[" + n + "]") != null) {
                            legacyTask.setLastResultDescription(properties.getProperty("taskLastResultDescription[" + n + "]"), LegacyTask.ResultType.valueOf(properties.getProperty("taskLastResultType[" + n + "]", String.valueOf((Object)LegacyTask.ResultType.ERROR))));
                        }
                        if (properties.getProperty("taskChangeDate[" + n + "]") != null) {
                            legacyTask.setChangeDate(simpleDateFormat.parse(properties.getProperty("taskChangeDate[" + n + "]")));
                        }
                        if (properties.getProperty("taskCreationDate[" + n + "]") != null) {
                            legacyTask.setCreationDate(simpleDateFormat.parse(properties.getProperty("taskCreationDate[" + n + "]")));
                        }
                        if (properties.getProperty("taskExecutionTime[" + n + "]") != null) {
                            legacyTask.setExecutionTime(simpleDateFormat.parse(properties.getProperty("taskExecutionTime[" + n + "]")));
                        }
                        if (properties.getProperty("taskLastExecutionDate[" + n + "]") != null) {
                            legacyTask.setLastExecutionDate(simpleDateFormat.parse(properties.getProperty("taskLastExecutionDate[" + n + "]")));
                        }
                        if (properties.getProperty("taskLastResultDate[" + n + "]") != null) {
                            legacyTask.setLastResultDate(simpleDateFormat.parse(properties.getProperty("taskLastResultDate[" + n + "]")));
                        }
                        if (properties.getProperty("taskExecutionOptions[" + n + "]") != null) {
                            object = properties.getProperty("taskExecutionOptions[" + n + "]").split("\\,");
                            cloneable = EnumSet.noneOf(LegacyTask.ExecutionOptions.class);
                            for (String string : object) {
                                if (string.trim().equals("")) continue;
                                cloneable.add(LegacyTask.ExecutionOptions.valueOf(string));
                            }
                            legacyTask.setExecutionOptions((EnumSet<LegacyTask.ExecutionOptions>)cloneable);
                        }
                        if (properties.getProperty("taskErrorHandler[" + n + "]") != null) {
                            legacyTask.setHasErrorHandler(Boolean.parseBoolean(properties.getProperty("taskErrorHandler[" + n + "]")));
                        }
                        if (properties.getProperty("taskErrorTaskId[" + n + "]") != null) {
                            legacyTask.setErrorTaskId(properties.getProperty("taskErrorTaskId[" + n + "]"));
                        }
                        if (properties.getProperty("taskSuccessHandler[" + n + "]") != null) {
                            legacyTask.setHasSuccessHandler(Boolean.parseBoolean(properties.getProperty("taskSuccessHandler[" + n + "]")));
                        }
                        if (properties.getProperty("taskSuccessTaskId[" + n + "]") != null) {
                            legacyTask.setSuccessTaskId(properties.getProperty("taskSuccessTaskId[" + n + "]"));
                        }
                        if (properties.getProperty("taskDependsOnTask[" + n + "]") != null) {
                            legacyTask.setDependsOnTask(Boolean.parseBoolean(properties.getProperty("taskDependsOnTask[" + n + "]")));
                        }
                        if (properties.getProperty("taskDependsOnTaskId[" + n + "]") != null) {
                            legacyTask.setDependsOnTaskId(properties.getProperty("taskDependsOnTaskId[" + n + "]"));
                        }
                        if (properties.getProperty("taskLimitIntervalExecution[" + n + "]") != null) {
                            legacyTask.setLimitIntervalExecution(Boolean.parseBoolean(properties.getProperty("taskLimitIntervalExecution[" + n + "]")));
                            if (properties.getProperty("taskIntervalLimitStart[" + n + "]") != null && properties.getProperty("taskIntervalLimitEnd[" + n + "]") != null) {
                                object = simpleDateFormat.parse(properties.getProperty("taskIntervalLimitStart[" + n + "]"));
                                cloneable = simpleDateFormat.parse(properties.getProperty("taskIntervalLimitEnd[" + n + "]"));
                                legacyTask.setIntervalLimit((Date)object, (Date)cloneable);
                            } else {
                                legacyTask.setLimitIntervalExecution(false);
                            }
                        }
                        arrayList.add(legacyTask);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n;
                }
                LegacyTask[] legacyTaskArray = arrayList.toArray(new LegacyTask[0]);
                return legacyTaskArray;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
                invalidPropertiesFormatException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    private static class LegacyTask {
        public static int MONDAY = 1;
        public static int TUESDAY = 2;
        public static int WEDNESDAY = 4;
        public static int THURSDAY = 8;
        public static int FRIDAY = 16;
        public static int SATURDAY = 32;
        public static int SUNDAY = 64;
        public static int EVERY_DAY = 127;
        private String name = "";
        private String description = "";
        private String id;
        private boolean enabled = true;
        private File executableFile;
        private Date creationDate = new Date();
        private Date changeDate = (Date)this.creationDate.clone();
        private Date lastExecutionDate;
        private String lastResultDescription;
        private Date lastResultDate;
        private ResultType lastResultType;
        private Interval interval;
        private boolean executeOnStartup = false;
        private ExecutionTimeFrame executiomTimeFrame = ExecutionTimeFrame.DEFAULT;
        private int timeFrameWeekdays;
        private int timeFrameDayOfMonth = 1;
        private int intervalInSeconds = 3600;
        private boolean limitIntervalExecution = false;
        private Date limitIntervalBetweenStart;
        private Date limitIntervalBetweenEnd;
        private Date executionTime;
        private int maximumExecutionCount = 0;
        private boolean limitTaskExecutions = false;
        private boolean deleteOnMaximumExecutionCount = false;
        private int successfulExecutionCount = 0;
        private int executionCount = 0;
        private int executionDelay;
        private boolean delayedExecution;
        private boolean skipIfMissed;
        private EnumSet<ExecutionOptions> executionOptions;
        private boolean onErrorHandler;
        private String onErrorTaskId;
        private boolean onSuccessHandler;
        private String onSuccessTaskId;
        private boolean dependsOnTask;
        private String dependsOnTaskId;

        public LegacyTask() {
            this.interval = Interval.SPECIFIED_TIME_INTERVAL;
            this.timeFrameWeekdays = EVERY_DAY;
            this.executionTime = new Date();
            this.limitIntervalBetweenStart = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.limitIntervalBetweenStart);
            calendar.add(11, 1);
            calendar.getTime();
            this.limitIntervalBetweenEnd = calendar.getTime();
            this.delayedExecution = false;
            this.executionDelay = 0;
            this.skipIfMissed = false;
            this.onErrorHandler = false;
            this.onSuccessHandler = false;
            this.dependsOnTask = false;
            this.lastResultDescription = null;
            this.lastResultDate = null;
            this.lastResultType = ResultType.OK;
            this.executionOptions = EnumSet.noneOf(ExecutionOptions.class);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public File getExecutableFile() {
            return this.executableFile;
        }

        public void setExecutableFile(File file) {
            this.executableFile = file;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public void setInterval(Interval interval) {
            this.interval = interval;
        }

        public boolean isExecuteOnStartup() {
            return this.executeOnStartup;
        }

        public void setExecuteOnStartup(boolean bl) {
            this.executeOnStartup = bl;
        }

        public int getTimeFrameWeekdays() {
            return this.timeFrameWeekdays;
        }

        public void setTimeFrameWeekdays(int n) {
            this.timeFrameWeekdays = n;
        }

        public ExecutionTimeFrame getExecutionTimeFrame() {
            return this.executiomTimeFrame;
        }

        public void setExecutionTimeFrame(ExecutionTimeFrame executionTimeFrame) {
            this.executiomTimeFrame = executionTimeFrame;
        }

        public int getTimeFrameDayOfMonth() {
            return this.timeFrameDayOfMonth;
        }

        public void setTimeFrameDayOfMonth(int n) {
            this.timeFrameDayOfMonth = n;
        }

        public Date getCreationDate() {
            return this.creationDate;
        }

        public void setCreationDate(Date date) {
            this.creationDate = date;
        }

        public Date getChangeDate() {
            return this.changeDate;
        }

        public void setChangeDate(Date date) {
            this.changeDate = date;
        }

        public Date getLastExecutionDate() {
            return this.lastExecutionDate;
        }

        public void setLastExecutionDate(Date date) {
            this.lastExecutionDate = date;
        }

        public String getLastResultDescription() {
            return this.lastResultDescription;
        }

        public void setLastResultDescription(String string, ResultType resultType) {
            this.lastResultDescription = string;
            this.lastResultType = resultType;
        }

        public Date getLastResultDate() {
            return this.lastResultDate;
        }

        public void setLastResultDate(Date date) {
            this.lastResultDate = date;
        }

        public ResultType getLastResultType() {
            return this.lastResultType;
        }

        public int getIntervalInSeconds() {
            return this.intervalInSeconds;
        }

        public void setIntervalInSeconds(int n) {
            this.intervalInSeconds = n;
        }

        public Date getExecutionTime() {
            return this.executionTime;
        }

        public void setExecutionTime(Date date) {
            this.executionTime = date;
        }

        public int getMaximumExecutionCount() {
            return this.maximumExecutionCount;
        }

        public void setMaximumExecutionCount(int n) {
            this.maximumExecutionCount = n;
        }

        public boolean isLimitTaskExecutions() {
            return this.limitTaskExecutions;
        }

        public void setLimitTaskExecutions(boolean bl) {
            this.limitTaskExecutions = bl;
        }

        public boolean isDeleteOnMaximumExecutionCount() {
            return this.deleteOnMaximumExecutionCount;
        }

        public void setDeleteOnMaximumExecutionCount(boolean bl) {
            this.deleteOnMaximumExecutionCount = bl;
        }

        public int getSuccessfulExecutionCount() {
            return this.successfulExecutionCount;
        }

        public void setSuccessfulExecutionCount(int n) {
            this.successfulExecutionCount = n;
        }

        public int getExecutionCount() {
            return this.executionCount;
        }

        public void setExecutionCount(int n) {
            this.executionCount = n;
        }

        public int getExecutionDelay() {
            return this.executionDelay;
        }

        public void setExecutionDelay(int n) {
            this.executionDelay = n;
        }

        public boolean isDelayedExecution() {
            return this.delayedExecution;
        }

        public void setDelayedExecution(boolean bl) {
            this.delayedExecution = bl;
        }

        public boolean isSkipIfMissed() {
            return this.skipIfMissed;
        }

        public void setSkipIfMissed(boolean bl) {
            this.skipIfMissed = bl;
        }

        public EnumSet<ExecutionOptions> getExecutionOptions() {
            return this.executionOptions;
        }

        public void setExecutionOptions(EnumSet<ExecutionOptions> enumSet) {
            this.executionOptions = enumSet;
        }

        public boolean hasErrorHandler() {
            return this.onErrorHandler;
        }

        public void setHasErrorHandler(boolean bl) {
            this.onErrorHandler = bl;
        }

        public boolean hasSuccessHandler() {
            return this.onSuccessHandler;
        }

        public void setHasSuccessHandler(boolean bl) {
            this.onSuccessHandler = bl;
        }

        public boolean isDependsOnTask() {
            return this.dependsOnTask;
        }

        public void setDependsOnTask(boolean bl) {
            this.dependsOnTask = bl;
        }

        public String getErrorTaskId() {
            return this.onErrorTaskId;
        }

        public void setErrorTaskId(String string) {
            this.onErrorTaskId = string;
        }

        public String getSuccessTaskId() {
            return this.onSuccessTaskId;
        }

        public void setSuccessTaskId(String string) {
            this.onSuccessTaskId = string;
        }

        public String getDependsOnTaskId() {
            return this.dependsOnTaskId;
        }

        public void setDependsOnTaskId(String string) {
            this.dependsOnTaskId = string;
        }

        public boolean isLimitIntervalExecution() {
            return this.limitIntervalExecution;
        }

        public void setLimitIntervalExecution(boolean bl) {
            this.limitIntervalExecution = bl;
        }

        public Date[] getIntervalLimit() {
            return new Date[]{this.limitIntervalBetweenStart, this.limitIntervalBetweenEnd};
        }

        public void setIntervalLimit(Date date, Date date2) {
            this.limitIntervalBetweenStart = date;
            this.limitIntervalBetweenEnd = date2;
        }

        public static enum ExecutionOptions {
            WAIT_FOR_TASK_TO_FINISH,
            OPEN_TASK_IN_BACKGROUND,
            OPEN_ANOTHER_INSTANCE;

        }

        public static enum ResultType {
            NOTIFICATION,
            ERROR,
            OK;

        }

        public static enum ExecutionTimeFrame {
            WEEKDAYS,
            DAY_OF_MONTH,
            DATE,
            DEFAULT;

        }

        public static enum Interval {
            INTERVAL_IN_SECONDS,
            SPECIFIED_TIME_INTERVAL,
            MANUAL_EXECUTION;

        }
    }
}

