/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.manager;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.platform.win32.Wtsapi32;
import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.base.ui.listener.MacOSAdapter;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.ttd.plugin.bridge.task.PluginTaskWrapper;
import de.oliver_matuschin.ttd.repository.TaskRepository;
import de.oliver_matuschin.ttd.scheduler.TaskScheduler;
import de.oliver_matuschin.ttd.scheduler.listener.TaskEventAdapter;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import de.oliver_matuschin.ttd.scheduler.task.trigger.ApplicationStartedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.GraphicsDevicesAddedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.GraphicsDevicesChangedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.GraphicsDevicesRemovedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.ScreenAboutToSleepTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.ScreenAwokeTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.SystemAboutToSleepTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.SystemAwokeTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.SystemLockedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.SystemUnlockedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.TaskExecutionCanceledTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.TaskExecutionStartedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.TaskExecutionStoppedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.Trigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.UserSessionActivatedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.UserSessionDeactivatedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.VolumesMountedTrigger;
import de.oliver_matuschin.ttd.scheduler.task.trigger.VolumesUnmountedTrigger;
import de.oliver_matuschin.ttd.util.TaskResultUtil;
import de.oliver_matuschin.util.FileSystemUtils;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TriggerEventManager {
    private static final Logger logger = Logger.getLogger(TriggerEventManager.class.getName());
    private Platform platform;
    private LocalizationProvider localizationProvider;
    private TaskScheduler scheduler;
    private TaskRepository repository;
    private final List<File> volumeListCache;
    private final Map<GraphicsDevice, Rectangle> deviceCache;

    public TriggerEventManager(Platform platform, LocalizationProvider localizationProvider, TaskScheduler taskScheduler, TaskRepository taskRepository) {
        this.platform = platform;
        this.localizationProvider = localizationProvider;
        this.scheduler = taskScheduler;
        this.repository = taskRepository;
        this.volumeListCache = FileSystemUtils.getAvailableVolumes((Platform)platform, (boolean)true);
        this.deviceCache = new HashMap<GraphicsDevice, Rectangle>();
        this.refreshDeviceCache(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()));
        this.initializeListeners(platform, taskScheduler);
        taskScheduler.trigger(ApplicationStartedTrigger.class, Collections.emptyMap());
    }

    private void initializeListeners(Platform platform, final TaskScheduler taskScheduler) {
        if (platform == Platform.MACOS) {
            this.setupMacEventListeners();
        } else {
            this.startSystemSleepMonitor();
            this.setupWindowsEventListeners();
        }
        this.startVolumeMonitor(platform);
        this.startGraphicsDeviceMonitor();
        taskScheduler.addTaskEventListener(new TaskEventAdapter(){

            @Override
            public void executionStarted(String string, String string2) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("sourceTask", string);
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap2.put("SourceTask", new PluginTaskWrapper(TriggerEventManager.this.repository.getTask(string), TriggerEventManager.this.repository));
                taskScheduler.trigger(TaskExecutionStartedTrigger.class, hashMap, hashMap2);
            }

            @Override
            public void executionCanceled(String string, String string2, ScheduleMetadata.ResultType resultType, ScheduleMetadata.ResultReason resultReason, String string3) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("sourceTask", string);
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap2.put("SourceTask", new PluginTaskWrapper(TriggerEventManager.this.repository.getTask(string), TriggerEventManager.this.repository));
                hashMap2.put("TaskCancellationDescription", TaskResultUtil.getLocalizedTextForResult(TriggerEventManager.this.localizationProvider, resultReason, string3));
                taskScheduler.trigger(TaskExecutionCanceledTrigger.class, hashMap, hashMap2);
            }

            @Override
            public void executionEnded(String string, String string2) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("sourceTask", string);
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap2.put("SourceTask", new PluginTaskWrapper(TriggerEventManager.this.repository.getTask(string), TriggerEventManager.this.repository));
                taskScheduler.trigger(TaskExecutionStoppedTrigger.class, hashMap, hashMap2);
            }
        });
    }

    private void setupMacEventListeners() {
        try {
            MacOSAdapter.setScreenAboutToSleepListener((Object)this, (Method)TriggerEventManager.class.getMethod("handleScreenAboutToSleep", new Class[0]));
            MacOSAdapter.setScreenAwokeListener((Object)this, (Method)TriggerEventManager.class.getMethod("handleScreenAwoke", new Class[0]));
            MacOSAdapter.setSystemAboutToSleepListener((Object)this, (Method)TriggerEventManager.class.getMethod("handleSystemAboutToSleep", new Class[0]));
            MacOSAdapter.setSystemAwokeListener((Object)this, (Method)TriggerEventManager.class.getMethod("handleSystemAwoke", new Class[0]));
            MacOSAdapter.setUserSessionActivatedListener((Object)this, (Method)TriggerEventManager.class.getMethod("handleUserSessionActivated", new Class[0]));
            MacOSAdapter.setUserSessionDeactivatedListener((Object)this, (Method)TriggerEventManager.class.getMethod("handleUserSessionDeactivated", new Class[0]));
        }
        catch (NoSuchMethodException | SecurityException exception) {
            logger.log(Level.SEVERE, "Failed to create trigger event listeners!", exception);
        }
    }

    private void startVolumeMonitor(Platform platform) {
        Runnable runnable = () -> {
            HashSet<File> hashSet = new HashSet<File>();
            HashSet<File> hashSet2 = new HashSet<File>();
            HashSet<File> hashSet3 = new HashSet<File>();
            HashSet<File> hashSet4 = new HashSet<File>();
            while (!Thread.interrupted()) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                List list = FileSystemUtils.getAvailableVolumes((Platform)platform, (boolean)true);
                hashSet3.clear();
                for (File file : list) {
                    if (this.volumeListCache.contains(file)) continue;
                    hashSet3.add(file);
                }
                if (!hashSet.isEmpty() && hashSet3.isEmpty()) {
                    this.handleVolumeMounted(hashSet);
                    hashSet = new HashSet();
                } else {
                    hashSet.addAll(hashSet3);
                }
                hashSet4.clear();
                for (File file : this.volumeListCache) {
                    if (list.contains(file)) continue;
                    hashSet4.add(file);
                }
                if (!hashSet2.isEmpty() && hashSet4.isEmpty()) {
                    this.handleVolumeUnmounted(hashSet2);
                    hashSet2 = new HashSet();
                } else {
                    hashSet2.addAll(hashSet4);
                }
                this.volumeListCache.clear();
                this.volumeListCache.addAll(list);
            }
        };
        Thread thread = new Thread(runnable);
        thread.setName("VolumeAndDriveMonitor");
        thread.setDaemon(true);
        thread.start();
    }

    private void startGraphicsDeviceMonitor() {
        Runnable runnable = () -> {
            HashSet<GraphicsDevice> hashSet = new HashSet<GraphicsDevice>();
            HashSet<GraphicsDevice> hashSet2 = new HashSet<GraphicsDevice>();
            HashSet<GraphicsDevice> hashSet3 = new HashSet<GraphicsDevice>();
            HashSet<GraphicsDevice> hashSet4 = new HashSet<GraphicsDevice>();
            HashSet hashSet5 = new HashSet();
            HashSet hashSet6 = new HashSet();
            while (!Thread.interrupted()) {
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                ArrayList<GraphicsDevice> arrayList = new ArrayList<GraphicsDevice>(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()));
                hashSet4.clear();
                for (GraphicsDevice graphicsDevice : arrayList) {
                    if (this.deviceCache.containsKey(graphicsDevice)) continue;
                    hashSet4.add(graphicsDevice);
                }
                if (!hashSet.isEmpty() && hashSet4.isEmpty()) {
                    this.handleGraphicsDevicesAdded(hashSet);
                    hashSet = new HashSet();
                } else {
                    hashSet.addAll(hashSet4);
                }
                hashSet5.clear();
                for (Map.Entry entry : this.deviceCache.entrySet()) {
                    if (arrayList.contains(entry.getKey())) continue;
                    hashSet5.add(entry.getKey());
                }
                if (!hashSet2.isEmpty() && hashSet5.isEmpty()) {
                    this.handleGraphicsDevicesRemoved(hashSet2);
                    hashSet2 = new HashSet();
                } else {
                    hashSet2.addAll(hashSet5);
                }
                hashSet6.clear();
                for (Map.Entry entry : this.deviceCache.entrySet()) {
                    if (((GraphicsDevice)entry.getKey()).getDefaultConfiguration().getBounds().equals(entry.getValue()) || hashSet2.contains(entry.getKey()) || hashSet5.contains(entry.getKey())) continue;
                    hashSet6.add(entry.getKey());
                }
                if (!hashSet3.isEmpty() && hashSet6.isEmpty()) {
                    this.handleGraphicsDevicesChanged(hashSet3);
                    hashSet3 = new HashSet();
                } else {
                    hashSet3.addAll(hashSet6);
                }
                this.refreshDeviceCache(arrayList);
            }
        };
        Thread thread = new Thread(runnable);
        thread.setName("GraphicsDeviceMonitor");
        thread.setDaemon(true);
        thread.start();
    }

    private void refreshDeviceCache(List<GraphicsDevice> list) {
        this.deviceCache.clear();
        for (GraphicsDevice graphicsDevice : list) {
            this.deviceCache.put(graphicsDevice, graphicsDevice.getDefaultConfiguration().getBounds());
        }
    }

    private void startSystemSleepMonitor() {
        Runnable runnable = () -> {
            while (!Thread.interrupted()) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(13, 3);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                Date date = new Date();
                if (!calendar.getTime().before(date)) continue;
                this.handleSystemAwoke();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setName("SystemSleepMonitor");
        thread.setDaemon(true);
        thread.start();
    }

    private void setupWindowsEventListeners() {
        Runnable runnable = () -> new WindowsSessionEventsListener();
        Thread thread = new Thread(runnable);
        thread.setName("SessionEventsMonitor");
        thread.setDaemon(true);
        thread.start();
    }

    public boolean canHandleEvent(Class<? extends Trigger> clazz) {
        if (this.platform == Platform.MACOS) {
            return clazz != SystemLockedTrigger.class && clazz != SystemUnlockedTrigger.class;
        }
        if (this.platform == Platform.WINDOWS) {
            return clazz != ScreenAboutToSleepTrigger.class && clazz != ScreenAwokeTrigger.class;
        }
        return true;
    }

    public void handleScreenAboutToSleep() {
        this.scheduler.trigger(ScreenAboutToSleepTrigger.class, Collections.emptyMap());
    }

    public void handleScreenAwoke() {
        this.scheduler.trigger(ScreenAwokeTrigger.class, Collections.emptyMap());
    }

    public void handleSystemLocked() {
        this.scheduler.trigger(SystemLockedTrigger.class, Collections.emptyMap());
    }

    public void handleSystemUnlocked() {
        this.scheduler.trigger(SystemUnlockedTrigger.class, Collections.emptyMap());
    }

    public void handleSystemAboutToSleep() {
        this.scheduler.trigger(SystemAboutToSleepTrigger.class, Collections.emptyMap());
    }

    public void handleSystemAwoke() {
        this.scheduler.trigger(SystemAwokeTrigger.class, Collections.emptyMap());
    }

    public void handleUserSessionActivated() {
        this.scheduler.trigger(UserSessionActivatedTrigger.class, Collections.emptyMap());
    }

    public void handleUserSessionDeactivated() {
        this.scheduler.trigger(UserSessionDeactivatedTrigger.class, Collections.emptyMap());
    }

    public void handleVolumeMounted(Set<File> set) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("MountedVolumes", new ArrayList<File>(set));
        this.scheduler.trigger(VolumesMountedTrigger.class, Collections.emptyMap(), hashMap);
    }

    public void handleVolumeUnmounted(Set<File> set) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("UnmountedVolumes", new ArrayList<File>(set));
        this.scheduler.trigger(VolumesUnmountedTrigger.class, Collections.emptyMap(), hashMap);
    }

    public void handleGraphicsDevicesAdded(Set<GraphicsDevice> set) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("AddedDevices", new ArrayList<GraphicsDevice>(set));
        this.scheduler.trigger(GraphicsDevicesAddedTrigger.class, Collections.emptyMap(), hashMap);
    }

    public void handleGraphicsDevicesChanged(Set<GraphicsDevice> set) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ChangedDevices", new ArrayList<GraphicsDevice>(set));
        this.scheduler.trigger(GraphicsDevicesChangedTrigger.class, Collections.emptyMap(), hashMap);
    }

    public void handleGraphicsDevicesRemoved(Set<GraphicsDevice> set) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("RemovedDevices", new ArrayList<GraphicsDevice>(set));
        this.scheduler.trigger(GraphicsDevicesRemovedTrigger.class, Collections.emptyMap(), hashMap);
    }

    private class WindowsSessionEventsListener
    implements WinUser.WindowProc {
        private static final int WM_ENDSESSION = 22;
        private static final int WM_QUERYENDSESSION = 17;

        public WindowsSessionEventsListener() {
            WinDef.HMODULE hMODULE = Kernel32.INSTANCE.GetModuleHandle("");
            WinUser.WNDCLASSEX wNDCLASSEX = new WinUser.WNDCLASSEX();
            wNDCLASSEX.hInstance = hMODULE;
            wNDCLASSEX.lpfnWndProc = this;
            wNDCLASSEX.lpszClassName = "Task Till Dawn hidden helper window";
            User32.INSTANCE.RegisterClassEx(wNDCLASSEX);
            this.getLastError();
            WinDef.HWND hWND = User32.INSTANCE.CreateWindowEx(8, "Task Till Dawn hidden helper window", "'Task Till Dawn hidden helper window", 0, 0, 0, 0, 0, null, null, (WinDef.HINSTANCE)hMODULE, null);
            this.getLastError();
            Wtsapi32.INSTANCE.WTSRegisterSessionNotification(hWND, 0);
            WinUser.MSG mSG = new WinUser.MSG();
            while (User32.INSTANCE.GetMessage(mSG, hWND, 0, 0) != 0) {
                User32.INSTANCE.TranslateMessage(mSG);
                User32.INSTANCE.DispatchMessage(mSG);
            }
            Wtsapi32.INSTANCE.WTSUnRegisterSessionNotification(hWND);
            User32.INSTANCE.UnregisterClass("Task Till Dawn hidden helper window", (WinDef.HINSTANCE)hMODULE);
            User32.INSTANCE.DestroyWindow(hWND);
        }

        public WinDef.LRESULT callback(WinDef.HWND hWND, int n, WinDef.WPARAM wPARAM, WinDef.LPARAM lPARAM) {
            switch (n) {
                case 2: {
                    User32.INSTANCE.PostQuitMessage(0);
                    return new WinDef.LRESULT(0L);
                }
                case 689: {
                    this.onSessionChange(wPARAM, lPARAM);
                    return new WinDef.LRESULT(0L);
                }
                case 17: 
                case 22: {
                    EventQueue.invokeLater(() -> {
                        logger.fine("Application shutdown initiated by WM_QUERYENDSESSION event.");
                        if (Starter.getApplication().handleQuit()) {
                            System.exit(0);
                        }
                    });
                }
            }
            return User32.INSTANCE.DefWindowProc(hWND, n, wPARAM, lPARAM);
        }

        public int getLastError() {
            int n = Kernel32.INSTANCE.GetLastError();
            return n;
        }

        protected void onSessionChange(WinDef.WPARAM wPARAM, WinDef.LPARAM lPARAM) {
            switch (wPARAM.intValue()) {
                case 7: {
                    TriggerEventManager.this.handleSystemLocked();
                    break;
                }
                case 8: {
                    TriggerEventManager.this.handleSystemUnlocked();
                    break;
                }
                case 1: {
                    TriggerEventManager.this.handleUserSessionActivated();
                    break;
                }
                case 2: {
                    TriggerEventManager.this.handleUserSessionDeactivated();
                    break;
                }
            }
        }
    }
}

