/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.manager;

import de.oliver_matuschin.base.classloader.JarClassLoader;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.ttd.manager.ActionPackPluginManager;
import de.oliver_matuschin.ttd.manager.exception.UnknownActionConfiguratorException;
import de.oliver_matuschin.ttd.manager.exception.UnknownActionException;
import de.oliver_matuschin.ttd.manager.exception.UnknownTypeConverterException;
import de.oliver_matuschin.ttd.plugin.action.Action;
import de.oliver_matuschin.ttd.plugin.action.annotation.ActionMetadata;
import de.oliver_matuschin.ttd.plugin.converter.TypeConverter;
import de.oliver_matuschin.ttd.plugin.ui.configurator.ActionConfigurator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.ImageIcon;

public class JarActionPackPluginManager
implements ActionPackPluginManager {
    private JarClassLoader jarClassLoader;
    private List<File> loadedActionPacks;
    private List<Class<Action<?, ?, ?>>> loadedActionClasses;
    private List<Class<ActionConfigurator>> loadedActionConfiguratorClasses;
    private List<TypeConverter> typeConverters;
    private Object mutex = new Object();
    private Platform platform;

    public JarActionPackPluginManager(Platform platform) {
        this.platform = platform;
        this.loadedActionPacks = new ArrayList<File>();
        this.loadedActionClasses = new ArrayList();
        this.loadedActionConfiguratorClasses = new ArrayList<Class<ActionConfigurator>>();
        this.typeConverters = new ArrayList<TypeConverter>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadActionPack(File file) {
        Object object = this.mutex;
        synchronized (object) {
            try {
                URL uRL = file.toURI().toURL();
                if (this.jarClassLoader == null) {
                    this.jarClassLoader = new JarClassLoader(new URL[]{uRL}, this.getClass().getClassLoader());
                } else {
                    this.jarClassLoader.addURL(uRL);
                }
                this.extractLibrariesFromJar(file.toPath());
                List<String> list = this.getClassNamesFromJar(uRL);
                for (String string : list) {
                    try {
                        Class clazz = this.jarClassLoader.loadClass(string);
                        if (clazz.isInterface() || clazz.isSynthetic() || clazz.isAnonymousClass() || Modifier.isAbstract(clazz.getModifiers())) continue;
                        if (Action.class.isAssignableFrom(clazz) && clazz.getAnnotation(ActionMetadata.class) != null) {
                            this.loadedActionClasses.add(clazz);
                        }
                        if (ActionConfigurator.class.isAssignableFrom(clazz)) {
                            this.loadedActionConfiguratorClasses.add(clazz);
                        }
                        if (!TypeConverter.class.isAssignableFrom(clazz)) continue;
                        try {
                            this.typeConverters.add((TypeConverter)clazz.newInstance());
                        }
                        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                            reflectiveOperationException.printStackTrace();
                        }
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                        throwable.printStackTrace();
                    }
                }
                this.loadedActionPacks.add(file);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
    }

    private void extractLibrariesFromJar(Path path) {
        File file = path.getParent() != null ? path.getParent().resolve("temp").toFile() : Paths.get("temp", new String[0]).toFile();
        if (file.mkdirs() || file.exists() && file.isDirectory()) {
            try (JarFile jarFile = new JarFile(path.toFile());){
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".jar")) continue;
                    String string = jarEntry.getName().indexOf(47) != -1 ? jarEntry.getName().substring(jarEntry.getName().lastIndexOf(47) + 1) : jarEntry.getName();
                    File file2 = new File(file.getPath() + File.separator + string);
                    if (!file2.exists()) {
                        try (InputStream inputStream = jarFile.getInputStream(jarEntry);
                             FileOutputStream fileOutputStream = new FileOutputStream(file2);
                             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                            while (inputStream.available() > 0) {
                                bufferedOutputStream.write(inputStream.read());
                            }
                        }
                    }
                    this.jarClassLoader.addURL(file2.toURI().toURL());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadActionPack(File file) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.loadedActionPacks.remove(file)) {
                ArrayList<File> arrayList = new ArrayList<File>(this.loadedActionPacks);
                this.loadedActionPacks.clear();
                this.loadedActionClasses.clear();
                this.loadedActionConfiguratorClasses.clear();
                this.typeConverters.clear();
                try {
                    this.jarClassLoader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.jarClassLoader = null;
                for (File file2 : arrayList) {
                    this.loadActionPack(file2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> listLoadedActionPacks() {
        Object object = this.mutex;
        synchronized (object) {
            return new ArrayList<File>(this.loadedActionPacks);
        }
    }

    public Class<Action<?, ?, ?>> getActionClassForName(String string) throws UnknownActionException {
        List<Class<Action<?, ?, ?>>> list = this.listActionClasses();
        for (Class<Action<?, ?, ?>> clazz : list) {
            if (!clazz.getCanonicalName().equals(string)) continue;
            return clazz;
        }
        throw new UnknownActionException("Unknown action of type \"" + string + "\"!");
    }

    @Override
    public Class<Action<?, ?, ?>> getActionClassForConfiguratorClass(Class<? extends ActionConfigurator> clazz) throws UnknownActionException {
        List<Class<Action<?, ?, ?>>> list = this.listActionClasses();
        for (Class<Action<?, ?, ?>> clazz2 : list) {
            ActionMetadata actionMetadata = clazz2.getAnnotation(ActionMetadata.class);
            if (actionMetadata == null || !actionMetadata.configurator().equals(clazz.getCanonicalName())) continue;
            return clazz2;
        }
        throw new UnknownActionException("Failed to find action for configurator \"" + (clazz != null ? clazz.getCanonicalName() : null) + "\"!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Class<Action<?, ?, ?>>> listActionClasses() {
        Object object = this.mutex;
        synchronized (object) {
            return new ArrayList(this.loadedActionClasses);
        }
    }

    @Override
    public Class<ActionConfigurator> getConfiguratorClassForActionClass(Class<? extends Action<?, ?, ?>> clazz) throws UnknownActionConfiguratorException {
        ActionMetadata actionMetadata = clazz.getAnnotation(ActionMetadata.class);
        if (actionMetadata != null) {
            return this.getConfiguratorClassForName(actionMetadata.configurator());
        }
        throw new UnknownActionConfiguratorException("Failed to find action configurator for action \"" + clazz.getCanonicalName() + "\"!");
    }

    @Override
    public Class<ActionConfigurator> getConfiguratorClassForName(String string) throws UnknownActionConfiguratorException {
        List<Class<ActionConfigurator>> list = this.listConfiguratorClasses();
        for (Class<ActionConfigurator> clazz : list) {
            if (!clazz.getCanonicalName().equals(string)) continue;
            return clazz;
        }
        throw new UnknownActionConfiguratorException("Unknown action configurator for action \"" + string + "\"!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Class<ActionConfigurator>> listConfiguratorClasses() {
        Object object = this.mutex;
        synchronized (object) {
            return new ArrayList<Class<ActionConfigurator>>(this.loadedActionConfiguratorClasses);
        }
    }

    @Override
    public String getLocalizedStringForActionClass(Class<? extends Action<?, ?, ?>> clazz, String string, String string2) {
        if (clazz != null && string != null) {
            ResourceBundle resourceBundle = null;
            ActionMetadata actionMetadata = clazz.getAnnotation(ActionMetadata.class);
            if (actionMetadata != null && !actionMetadata.properties().equals("")) {
                try {
                    resourceBundle = ResourceBundle.getBundle(actionMetadata.properties(), Locale.getDefault(), (ClassLoader)this.jarClassLoader);
                }
                catch (NullPointerException nullPointerException) {
                    resourceBundle = ResourceBundle.getBundle(actionMetadata.properties(), Locale.getDefault());
                }
            }
            if (resourceBundle != null && resourceBundle.containsKey(string)) {
                String string3 = "_win";
                if (this.platform == Platform.MACOS) {
                    string3 = "_mac";
                }
                String string4 = resourceBundle.containsKey(string + string3) ? resourceBundle.getString(string + string3) : resourceBundle.getString(string);
                return MessageFormat.format(string4, "");
            }
        }
        return string2;
    }

    @Override
    public ImageIcon getIconForActionClass(Class<? extends Action<?, ?, ?>> clazz) {
        ActionMetadata actionMetadata = clazz.getAnnotation(ActionMetadata.class);
        if (actionMetadata != null && !actionMetadata.icon().equals("")) {
            return ImageBuilder.buildFor(clazz, (String)actionMetadata.icon());
        }
        return null;
    }

    private List<String> getClassNamesFromJar(URL uRL) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (JarFile jarFile = new JarFile(new File(uRL.toURI()));){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().getName();
                if (!string.endsWith(".class")) continue;
                string = string.replaceAll("/", ".").replaceAll("\\\\", ".").substring(0, string.lastIndexOf(46));
                arrayList.add(string);
            }
        }
        catch (IOException | URISyntaxException exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public Type[] getInputOutputTypesForActionClass(Class<? extends Action<?, ?, ?>> clazz) {
        Type[] typeArray = null;
        if (clazz != null) {
            Type[] typeArray2 = clazz.getGenericInterfaces();
            if (typeArray2.length > 0) {
                for (Type type : typeArray2) {
                    if (!(type instanceof ParameterizedType)) continue;
                    typeArray = ((ParameterizedType)type).getActualTypeArguments();
                }
            } else if (clazz.getGenericSuperclass() instanceof ParameterizedType) {
                typeArray = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
            }
        }
        if (typeArray == null || typeArray.length != 2 && typeArray.length != 3) {
            typeArray = new Type[]{Void.class, Void.class, Void.class};
        } else if (typeArray.length == 2) {
            typeArray = new Type[]{typeArray[0], Void.class, typeArray[1]};
        }
        return typeArray;
    }

    @Override
    public TypeConverter getTypeConverterForName(String string) throws UnknownTypeConverterException {
        List<TypeConverter> list = this.listTypeConverters();
        for (TypeConverter typeConverter : list) {
            if (!typeConverter.getClass().getCanonicalName().equals(string)) continue;
            return typeConverter;
        }
        throw new UnknownTypeConverterException("Unknown type converter \"" + string + "\"!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TypeConverter> listTypeConverters() {
        Object object = this.mutex;
        synchronized (object) {
            return new ArrayList<TypeConverter>(this.typeConverters);
        }
    }
}

