/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.logging;

import de.oliver_matuschin.ttd.logging.TaskLogger;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SimpleTaskLogger
implements TaskLogger {
    private DateFormat timestampFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private String storagePath;
    protected Object mutex = new Object();

    public SimpleTaskLogger(String string) {
        this.storagePath = string;
    }

    @Override
    public void log(Task task, String string) {
        this.log(new Date(), task, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(Date date, Task task, String string) {
        Object object = this.mutex;
        synchronized (object) {
            File file = this.getLogFileFor(task);
            try (FileWriter fileWriter = new FileWriter(file, true);
                 BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                 PrintWriter printWriter = new PrintWriter(bufferedWriter);){
                StringBuilder stringBuilder = new StringBuilder().append(this.timestampFormat.format(date)).append(": ").append(string);
                printWriter.println(stringBuilder.toString());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getLogFileFor(Task task) {
        Object object = this.mutex;
        synchronized (object) {
            Object object2;
            new File(this.storagePath).mkdirs();
            StringBuffer stringBuffer = new StringBuffer().append(this.storagePath).append(File.separator).append(task.getId()).append(".log");
            File file = new File(stringBuffer.toString());
            if (file.exists() && file.length() > 20000000L) {
                object2 = new Date();
                file.renameTo(new File(file.getPath() + "_" + (int)(((Date)object2).getTime() / 1000L)));
                try {
                    file.createNewFile();
                    this.log(task, "Logfile rolled over");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!file.exists()) {
                try {
                    object2 = new FileWriter(stringBuffer.toString(), true);
                    Throwable throwable = null;
                    try (BufferedWriter bufferedWriter = new BufferedWriter((Writer)object2);
                         PrintWriter printWriter = new PrintWriter(bufferedWriter);){
                        StringBuilder stringBuilder = new StringBuilder().append(this.timestampFormat.format(new Date())).append(": ").append("Logfile created.");
                        printWriter.println(stringBuilder.toString());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object2 != null) {
                            if (throwable != null) {
                                try {
                                    ((OutputStreamWriter)object2).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((OutputStreamWriter)object2).close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return file;
        }
    }
}

