/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.logging;

import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.ttd.logging.SimpleTaskLogger;
import de.oliver_matuschin.ttd.manager.ActionPackPluginManager;
import de.oliver_matuschin.ttd.manager.exception.UnknownActionException;
import de.oliver_matuschin.ttd.repository.TaskRepository;
import de.oliver_matuschin.ttd.repository.listener.TaskRepositoryEventListener;
import de.oliver_matuschin.ttd.scheduler.listener.TaskEventListener;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.action.Action;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import de.oliver_matuschin.ttd.util.TaskResultUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DefaultTaskLogger
extends SimpleTaskLogger
implements TaskEventListener,
TaskRepositoryEventListener {
    private TaskRepository repository;
    private ActionPackPluginManager actionPackPluginManager;
    private DateFormat timestampFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static LocalizationProvider localizationProvider = new DummyLocalizationProvider();

    public DefaultTaskLogger(String string, TaskRepository taskRepository, ActionPackPluginManager actionPackPluginManager) {
        super(string);
        this.repository = taskRepository;
        this.actionPackPluginManager = actionPackPluginManager;
    }

    @Override
    public void executionStarted(String string, String string2) {
        Task task = this.repository.getTask(string);
        if (task != null) {
            this.log(task, "Task execution started.");
        }
    }

    @Override
    public void executionCanceled(String string, String string2, ScheduleMetadata.ResultType resultType, ScheduleMetadata.ResultReason resultReason, String string3) {
        Task task = this.repository.getTask(string);
        if (task != null) {
            string3 = TaskResultUtil.getLocalizedTextForResult(localizationProvider, resultReason, string3);
            StringBuilder stringBuilder = new StringBuilder("Task execution canceled");
            if (string3 != null && !string3.trim().equals("")) {
                stringBuilder.append(": ");
                stringBuilder.append(string3.trim());
            } else {
                stringBuilder.append(".");
            }
            this.log(task, stringBuilder.toString());
        }
    }

    @Override
    public void executionEnded(String string, String string2) {
        Task task = this.repository.getTask(string);
        if (task != null) {
            this.log(task, "Task execution ended.");
        }
    }

    @Override
    public void actionStarted(String string, Action action) {
        Task task = this.repository.getTask(string);
        if (task != null) {
            if (action.getType().equals("de.oliver_matuschin.ttd.plugin.defaultActions.action.LabelAction")) {
                this.log(task, "-> Continuing execution at jump label \"" + action.getLabel() + "\".");
            } else {
                try {
                    this.log(task, "Executing action \"" + this.actionPackPluginManager.getLocalizedStringForActionClass(this.actionPackPluginManager.getActionClassForName(action.getType()), "title", null) + "\".");
                }
                catch (UnknownActionException unknownActionException) {
                    this.log(task, "Failed to execute action.");
                }
            }
        }
    }

    @Override
    public void statusTextUpdated(String string, Action action, String string2) {
    }

    @Override
    public void actionStopped(String string, Action action) {
    }

    @Override
    public void scheduleRecalculationStarted(String string, String string2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleMissed(String string, String string2, Date date) {
        Task task = this.repository.getTask(string);
        if (task != null) {
            String string3;
            DateFormat dateFormat = this.timestampFormat;
            synchronized (dateFormat) {
                string3 = this.timestampFormat.format(date);
            }
            this.log(task, "Failed to start task execution on " + string3 + " because schedule was missed.");
        }
    }

    @Override
    public void scheduleRecalculationStopped(String string, String string2) {
    }

    @Override
    public void taskUpdated(Task task) {
        this.log(task, "Task \"" + task.getName() + "\" updated.");
    }

    @Override
    public void taskMetadataUpdated(Task task, TaskMetadata taskMetadata) {
    }

    @Override
    public void scheduleMetadataUpdated(Task task, ScheduleMetadata scheduleMetadata) {
    }

    @Override
    public void taskAdded(Task task) {
        this.log(task, "Task \"" + task.getName() + "\" created.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskRemoved(Task task) {
        this.log(task, "Task removed.");
        Object object = this.mutex;
        synchronized (object) {
            final File file = this.getLogFileFor(task);
            if (file.exists()) {
                if (!file.delete()) {
                    this.log(task, "Failed to delete logfile.");
                }
                if (file.getParentFile() != null) {
                    File[] fileArray;
                    for (File file2 : fileArray = file.getParentFile().listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File file2, String string) {
                            return string.startsWith(file.getName() + "_");
                        }
                    })) {
                        file2.delete();
                    }
                }
            }
        }
    }

    private static class DummyLocalizationProvider
    implements LocalizationProvider {
        private DummyLocalizationProvider() {
        }

        public boolean existsLocalizedString(String string) {
            return TaskResultUtil.ResultReasonTranslationKey.forKey(string).isPresent();
        }

        public String getLocalizedString(String string) {
            return this.getLocalizedString(string, new String[0]);
        }

        public String getLocalizedString(String string, Object ... objectArray) {
            if (TaskResultUtil.ResultReasonTranslationKey.forKey(string).isPresent()) {
                TaskResultUtil.ResultReasonTranslationKey resultReasonTranslationKey = TaskResultUtil.ResultReasonTranslationKey.forKey(string).get();
                switch (resultReasonTranslationKey) {
                    case KEY_EXECUTION_CANCELED: {
                        return "";
                    }
                    case KEY_INTERNAL_ERROR: {
                        return "Internal error occured: " + this.getParam(objectArray);
                    }
                    case KEY_JUMP_LABEL_MISSING: {
                        return "Unknown jump label \"" + this.getParam(objectArray) + "\".";
                    }
                    case KEY_SCHEDULE_MISSED: {
                        return "Schedule time missed.";
                    }
                }
            }
            return "#" + string + "#";
        }

        private String getParam(Object ... objectArray) {
            if (objectArray != null && objectArray.length > 0 && objectArray[0] != null) {
                return (String)objectArray[0];
            }
            return "";
        }
    }
}

