/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.impex;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.oliver_matuschin.ttd.gson.ScheduleDeserializer;
import de.oliver_matuschin.ttd.gson.UTCDateAdapter;
import de.oliver_matuschin.ttd.impex.TaskArchive;
import de.oliver_matuschin.ttd.impex.exception.UnsupportedArchiveVersionException;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;

public class TaskArchiver {
    public static void archive(TaskArchive taskArchive, File file) throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new UTCDateAdapter());
        gsonBuilder.addSerializationExclusionStrategy((ExclusionStrategy)new ArchiveExclusionStrategy());
        Gson gson = gsonBuilder.create();
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(gson.toJson((Object)taskArchive));
        }
    }

    public static TaskArchive unarchive(File file) throws IOException, UnsupportedArchiveVersionException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new UTCDateAdapter());
        gsonBuilder.registerTypeAdapter(AbstractSchedule.class, (Object)new ScheduleDeserializer());
        gsonBuilder.addDeserializationExclusionStrategy((ExclusionStrategy)new ArchiveExclusionStrategy());
        Gson gson = gsonBuilder.create();
        try (FileReader fileReader = new FileReader(file);){
            TaskArchive taskArchive = (TaskArchive)gson.fromJson((Reader)fileReader, TaskArchive.class);
            if (taskArchive.getArchiveVersion() > 1) {
                throw new UnsupportedArchiveVersionException();
            }
            TaskArchive taskArchive2 = taskArchive;
            return taskArchive2;
        }
    }

    private static class ArchiveExclusionStrategy
    implements ExclusionStrategy {
        private ArchiveExclusionStrategy() {
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getDeclaringClass() == ScheduleMetadata.class && fieldAttributes.getName().equals("flag");
        }
    }
}

