/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class UTCDateAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);

    public UTCDateAdapter() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public synchronized JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive(this.dateFormat.format(date));
    }

    public synchronized Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        try {
            return this.dateFormat.parse(jsonElement.getAsString());
        }
        catch (ParseException parseException) {
            throw new JsonParseException((Throwable)parseException);
        }
    }
}

