/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.group;

import de.oliver_matuschin.ttd.group.exception.NameTooLongException;
import de.oliver_matuschin.ttd.group.listener.TaskGroupEventListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class TaskGroupManager {
    private final Logger logger = Logger.getLogger(TaskGroupManager.class.getName());
    private static final int MAX_GROUPNAME_LENGTH = 35;
    private Map<String, List<String>> groups = new LinkedHashMap<String, List<String>>();
    private EventListenerList listeners = new EventListenerList();
    private ExecutorService eventExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "TaskGroupManagerEventExecutor");
            thread.setDaemon(true);
            return thread;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskGroupEventListener(TaskGroupEventListener taskGroupEventListener) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            this.listeners.add(TaskGroupEventListener.class, taskGroupEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskGroupEventListener(TaskGroupEventListener taskGroupEventListener) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            this.listeners.remove(TaskGroupEventListener.class, taskGroupEventListener);
        }
    }

    public void addTaskQuietly(String string, String string2) {
        try {
            this.addTask(string, string2);
        }
        catch (NameTooLongException nameTooLongException) {
            this.logger.log(Level.FINEST, "Adding task quietly failed for group with name \"" + string + "\"!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(String string, String string2) throws NameTooLongException {
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            int n = 0;
            List<String> list = this.groups.get(string);
            if (list != null) {
                n = list.size();
            }
            this.insertTask(string, string2, n);
        }
    }

    public void addGroupQuietly(String string) {
        try {
            this.addGroup(string);
        }
        catch (NameTooLongException nameTooLongException) {
            this.logger.log(Level.FINEST, "Adding group quietly failed for group with name \"" + string + "\"!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(String string) throws NameTooLongException {
        if (string != null && string.length() > 35) {
            throw new NameTooLongException();
        }
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            if (!this.groups.containsKey(string)) {
                this.groups.put(string, new ArrayList());
                this.fireGroupAdded(string, this.groups.size() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameGroup(String string, String string2) throws NameTooLongException {
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            if (!string.equals(string2) && this.groups.containsKey(string)) {
                int n = this.indexOfGroup(string2);
                if (n == -1) {
                    this.addGroup(string2);
                    n = this.indexOfGroup(string);
                }
                for (String string3 : this.groups.get(string)) {
                    this.addTask(string2, string3);
                }
                this.removeGroup(string);
                this.moveGroup(string2, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveGroup(String string, int n) {
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            if (this.groups.containsKey(string)) {
                int n2 = -1;
                Iterator<String> iterator = this.groups.keySet().iterator();
                int n3 = 0;
                while (iterator.hasNext()) {
                    if (string.equals(iterator.next())) {
                        n2 = n3;
                        break;
                    }
                    ++n3;
                }
                if ((n3 = n) > this.groups.size()) {
                    n3 = this.groups.size();
                }
                if (n3 > this.indexOfGroup(string)) {
                    --n3;
                }
                ArrayList<String> arrayList = new ArrayList<String>(this.groups.keySet());
                arrayList.remove(string);
                arrayList.add(n3, string);
                LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
                for (String string2 : arrayList) {
                    linkedHashMap.put(string2, this.groups.get(string2));
                }
                this.groups.clear();
                for (String string2 : linkedHashMap.keySet()) {
                    this.groups.put(string2, (List<String>)linkedHashMap.get(string2));
                }
                this.fireGroupMoved(string, n2, n);
            }
        }
    }

    public void insertTaskQuietly(String string, String string2, int n) {
        try {
            this.insertTask(string, string2, n);
        }
        catch (NameTooLongException nameTooLongException) {
            this.logger.log(Level.FINEST, "Inserting task quietly failed for group with name \"" + string + "\"!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTask(String string, String string2, int n) throws NameTooLongException {
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            List<String> list;
            if (!this.groups.containsKey(string)) {
                this.addGroup(string);
            }
            if (!(list = this.groups.get(string)).contains(string2)) {
                if (n > list.size()) {
                    n = list.size();
                } else if (n < 0) {
                    n = 0;
                }
                list.add(n, string2);
                this.fireTaskAdded(string, string2, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTask(String string, String string2, int n) {
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            int n2;
            List<String> list = this.groups.get(string);
            if (list != null && (n2 = list.indexOf(string2)) != -1) {
                if (n > list.size()) {
                    n = list.size();
                }
                int n3 = n;
                if (n > n2) {
                    --n3;
                }
                list.remove(string2);
                list.add(n3, string2);
                this.fireTaskMoved(string, string2, n2, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOfTask(String string, String string2) {
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            List<String> list = this.groups.get(string);
            if (list != null) {
                return list.indexOf(string2);
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOfGroup(String string) {
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            Iterator<String> iterator = this.groups.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                if (iterator.next().equals(string)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listGroups() {
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            ArrayList<String> arrayList = new ArrayList<String>(this.groups.size());
            for (String string : this.groups.keySet()) {
                arrayList.add(string);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listTasksOfGroup(String string) {
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            List<String> list = this.groups.get(string);
            if (list != null) {
                return new ArrayList<String>(list);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> groupsMap() {
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            return new LinkedHashMap<String, List<String>>(this.groups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String string) {
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            int n = new ArrayList<String>(this.groups.keySet()).indexOf(string);
            this.groups.remove(string);
            this.fireGroupRemoved(string, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(String string, String string2) {
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            if (this.groups.containsKey(string)) {
                List<String> list = this.groups.get(string);
                int n = list.indexOf(string2);
                if (list.remove(string2)) {
                    this.fireTaskRemoved(string, string2, n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(String string) {
        Map<String, List<String>> map = this.groups;
        synchronized (map) {
            for (String string2 : this.groups.keySet()) {
                this.removeTask(string2, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskAdded(final String string, final String string2, final int n) {
        TaskGroupEventListener[] taskGroupEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskGroupEventListenerArray = (TaskGroupEventListener[])this.listeners.getListeners(TaskGroupEventListener.class);
        }
        this.eventExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (TaskGroupEventListener taskGroupEventListener : taskGroupEventListenerArray) {
                    taskGroupEventListener.taskAdded(string, string2, n);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskMoved(final String string, final String string2, final int n, final int n2) {
        TaskGroupEventListener[] taskGroupEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskGroupEventListenerArray = (TaskGroupEventListener[])this.listeners.getListeners(TaskGroupEventListener.class);
        }
        this.eventExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (TaskGroupEventListener taskGroupEventListener : taskGroupEventListenerArray) {
                    taskGroupEventListener.taskMoved(string, string2, n, n2);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskRemoved(final String string, final String string2, final int n) {
        TaskGroupEventListener[] taskGroupEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskGroupEventListenerArray = (TaskGroupEventListener[])this.listeners.getListeners(TaskGroupEventListener.class);
        }
        this.eventExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (TaskGroupEventListener taskGroupEventListener : taskGroupEventListenerArray) {
                    taskGroupEventListener.taskRemoved(string, string2, n);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireGroupAdded(final String string, final int n) {
        TaskGroupEventListener[] taskGroupEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskGroupEventListenerArray = (TaskGroupEventListener[])this.listeners.getListeners(TaskGroupEventListener.class);
        }
        this.eventExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (TaskGroupEventListener taskGroupEventListener : taskGroupEventListenerArray) {
                    taskGroupEventListener.groupAdded(string, n);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireGroupMoved(final String string, final int n, final int n2) {
        TaskGroupEventListener[] taskGroupEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskGroupEventListenerArray = (TaskGroupEventListener[])this.listeners.getListeners(TaskGroupEventListener.class);
        }
        this.eventExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (TaskGroupEventListener taskGroupEventListener : taskGroupEventListenerArray) {
                    taskGroupEventListener.groupMoved(string, n, n2);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireGroupRemoved(final String string, final int n) {
        TaskGroupEventListener[] taskGroupEventListenerArray;
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            taskGroupEventListenerArray = (TaskGroupEventListener[])this.listeners.getListeners(TaskGroupEventListener.class);
        }
        this.eventExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (TaskGroupEventListener taskGroupEventListener : taskGroupEventListenerArray) {
                    taskGroupEventListener.groupRemoved(string, n);
                }
            }
        });
    }
}

