/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.ttd.application;

import ca.weblite.objc.Proxy;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import de.oliver_matuschin.base.application.AbstractApplication;
import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.base.ui.dialog.JExtendedDialog;
import de.oliver_matuschin.base.ui.dialog.JExtendedOpenDialog;
import de.oliver_matuschin.base.ui.dialog.JExtendedSaveDialog;
import de.oliver_matuschin.base.ui.frame.AbstractApplicationWindow;
import de.oliver_matuschin.base.util.ApplicationUtilities;
import de.oliver_matuschin.base.util.ui.frame.AboutBoxFrame;
import de.oliver_matuschin.base.util.ui.frame.AbstractPreferencesFrame;
import de.oliver_matuschin.system.Platform;
import de.oliver_matuschin.ttd.application.TaskTillDawnApplicationContext;
import de.oliver_matuschin.ttd.collect.ImmutableArrayList;
import de.oliver_matuschin.ttd.group.TaskGroupManager;
import de.oliver_matuschin.ttd.group.listener.TaskGroupEventListener;
import de.oliver_matuschin.ttd.impex.TaskArchive;
import de.oliver_matuschin.ttd.impex.TaskArchiver;
import de.oliver_matuschin.ttd.impex.exception.UnsupportedArchiveVersionException;
import de.oliver_matuschin.ttd.logging.DefaultTaskLogger;
import de.oliver_matuschin.ttd.logging.TaskLogger;
import de.oliver_matuschin.ttd.manager.ActionPackPluginManager;
import de.oliver_matuschin.ttd.manager.JarActionPackPluginManager;
import de.oliver_matuschin.ttd.manager.TriggerEventManager;
import de.oliver_matuschin.ttd.notification.NotificationManager;
import de.oliver_matuschin.ttd.notification.listener.AbstractNotificationListener;
import de.oliver_matuschin.ttd.notification.listener.BeepNotificationListener;
import de.oliver_matuschin.ttd.notification.listener.NotificationCenterNotificationListener;
import de.oliver_matuschin.ttd.notification.listener.SystemLoggerNotificationListener;
import de.oliver_matuschin.ttd.notification.listener.SystemTrayNotificationListener;
import de.oliver_matuschin.ttd.notification.listener.SystemTrayTooltipNotificationListener;
import de.oliver_matuschin.ttd.notification.listener.TextToSpeechNotificationListener;
import de.oliver_matuschin.ttd.notification.listener.WindowsActionCenterNotificationListener;
import de.oliver_matuschin.ttd.plugin.bridge.executor.PluginActionContextFactoryImpl;
import de.oliver_matuschin.ttd.plugin.bridge.executor.PluginActionExecutor;
import de.oliver_matuschin.ttd.preferences.PortablePreferences;
import de.oliver_matuschin.ttd.repository.CachedTaskRepository;
import de.oliver_matuschin.ttd.repository.TaskRepository;
import de.oliver_matuschin.ttd.repository.listener.TaskRepositoryEventListener;
import de.oliver_matuschin.ttd.scheduler.DefaultTaskScheduler;
import de.oliver_matuschin.ttd.scheduler.TaskScheduler;
import de.oliver_matuschin.ttd.scheduler.listener.TaskEventAdapter;
import de.oliver_matuschin.ttd.scheduler.listener.TaskSchedulerEventListener;
import de.oliver_matuschin.ttd.scheduler.task.Task;
import de.oliver_matuschin.ttd.scheduler.task.metadata.TaskMetadata;
import de.oliver_matuschin.ttd.scheduler.task.schedule.AbstractSchedule;
import de.oliver_matuschin.ttd.scheduler.task.schedule.metadata.ScheduleMetadata;
import de.oliver_matuschin.ttd.scheduler.task.trigger.Trigger;
import de.oliver_matuschin.ttd.storage.JSONTaskStorageProvider;
import de.oliver_matuschin.ttd.tray.TrayManager;
import de.oliver_matuschin.ttd.ui.dialog.SetupDialog;
import de.oliver_matuschin.ttd.ui.frame.GroupListFrame;
import de.oliver_matuschin.ttd.ui.frame.PreferencesFrame;
import de.oliver_matuschin.ttd.ui.frame.TaskConfigurationFrame;
import de.oliver_matuschin.ttd.ui.frame.TaskListFrame;
import de.oliver_matuschin.ttd.util.ProcessInfoUtils;
import de.oliver_matuschin.util.SystemUtil;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public class TaskTillDawnApplication
extends AbstractApplication<TaskTillDawnApplicationContext> {
    private final Logger logger = Logger.getLogger(TaskTillDawnApplication.class.getName());
    private DefaultTaskLogger taskLogger;
    private static final double APPLICATION_VERSION = 2.21;
    private static final AbstractApplication.VersionType VERSION_TYPE = AbstractApplication.VersionType.FINAL;
    private static final String APPLICATION_NAME = "Task Till Dawn";
    private final CountDownLatch startupLatch = new CountDownLatch(2);
    private NotificationManager notificationManager;
    private TaskScheduler scheduler;
    private Thread schedulerThread;
    private TaskRepository taskRepository;
    private ActionPackPluginManager actionPackPluginManager;
    private TaskGroupManager taskGroupManager;
    private TriggerEventManager triggerEventManager;
    private TrayManager trayManager;
    private TaskTillDawnApplicationContext applicationContext;
    private File defaultActionPackFile = null;
    private Boolean portable = null;
    private Preferences portablePreferences = null;
    private BlockingQueue<File> filesToOpen = new LinkedBlockingQueue<File>();
    private Thread fileHandlerThread;
    private Proxy activity;

    public static TaskTillDawnApplication getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private TaskTillDawnApplication() {
    }

    public void init() {
        super.init();
        this.notificationManager = new NotificationManager();
        this.taskGroupManager = new TaskGroupManager();
    }

    public void run(String[] stringArray) {
        boolean bl;
        this.logger.info("Application " + this.getApplicationName() + " " + this.getApplicationVersion() + " started!");
        this.applicationContext = new TaskTillDawnApplicationContext(this);
        this.removeOutdatedTempFiles();
        this.taskRepository = new CachedTaskRepository(new JSONTaskStorageProvider(this.getStorageDirectory() + File.separator + "Tasks"));
        boolean bl2 = this.getPreferences().getLong("licenceAcceptedDate", 0L) != 0L && this.getPreferences().getInt("acceptedLicenceVersion", 0) == 1;
        boolean bl3 = bl = this.getPreferences().getInt("setupAssistantLastRun", 0) != 2;
        if (!bl2 || bl) {
            EventQueue.invokeLater(() -> {
                ArrayList<SetupDialog.Step> arrayList = new ArrayList<SetupDialog.Step>();
                if (!bl2) {
                    arrayList.add(SetupDialog.Step.ACCEPT_LICENCE);
                }
                if (!this.isPortable()) {
                    arrayList.add(SetupDialog.Step.ENABLE_AUTOSTART);
                    arrayList.add(SetupDialog.Step.IMPORT_TASKS);
                }
                arrayList.add(SetupDialog.Step.ENABLE_UPDATECHECK);
                SetupDialog<TaskTillDawnApplicationContext> setupDialog = new SetupDialog<TaskTillDawnApplicationContext>(this.applicationContext, null, Dialog.ModalityType.APPLICATION_MODAL, arrayList);
                setupDialog.setLocationRelativeTo(null);
                setupDialog.setVisible(true);
                if (setupDialog.isLicenceAccepted()) {
                    this.continueStartup(stringArray);
                } else {
                    System.exit(0);
                }
            });
        } else {
            this.continueStartup(stringArray);
        }
    }

    private void continueStartup(String[] stringArray) {
        this.startupLatch.countDown();
        this.actionPackPluginManager = new JarActionPackPluginManager(this.getPlatform());
        this.loadPlugIns();
        List<Task> list = this.taskRepository.listTasks();
        try {
            Map<String, List<String>> map = this.loadTaskGroupsConfiguration();
            for (String string : map.keySet()) {
                this.taskGroupManager.addGroupQuietly(string);
                List list2 = (List)map.get(string);
                block3: for (String string2 : list2) {
                    for (Task task : list) {
                        if (!task.getId().equals(string2)) continue;
                        this.taskGroupManager.addTaskQuietly(string, string2);
                        continue block3;
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.logger.log(Level.WARNING, "Failed to load task list configuration!", iOException);
        }
        this.taskGroupManager.addGroupQuietly("All tasks");
        for (Task task : list) {
            this.taskGroupManager.addTaskQuietly("All tasks", task.getId());
        }
        this.taskLogger = new DefaultTaskLogger(this.getStorageDirectory() + File.separator + "Logs", this.taskRepository, this.actionPackPluginManager);
        this.checkIncompleteShutdown(list);
        this.scheduler = new DefaultTaskScheduler(this.taskRepository, new PluginActionExecutor((LocalizationProvider)this, this.actionPackPluginManager, new PluginActionContextFactoryImpl(this.applicationContext)));
        this.initNotificationListeners();
        this.addSchedulerEventListener();
        this.addTaskGroupManagerEventListener();
        this.addTaskRepositoryEventListener();
        boolean bl = this.getPreferences().getBoolean("pauseTaskManager", false);
        EventQueue.invokeLater(() -> {
            this.getUIManager().setMenuItemChecked("menu.file.pauseTaskManager", bl);
            this.trayManager = new TrayManager(this.applicationContext);
            this.scheduler.setPaused(bl);
            if (!bl) {
                this.disableAppNap("Task Till Dawn task scheduler is running.");
            }
            this.scheduler.setGracePeriod(this.getPreferences().getInt("missedSchedulesGracePeriod", 1000));
            this.schedulerThread = new Thread((Runnable)this.scheduler, "TaskScheduler");
            this.schedulerThread.start();
            this.triggerEventManager = new TriggerEventManager(this.getPlatform(), (LocalizationProvider)this, this.scheduler, this.taskRepository);
            this.fileHandlerThread = new Thread(() -> {
                try {
                    while (!Thread.interrupted()) {
                        File file = this.filesToOpen.take();
                        this.handleOpenFile(file);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            });
            this.fileHandlerThread.setDaemon(true);
            this.fileHandlerThread.start();
            this.startupLatch.countDown();
            this.getUIManager().setUiBlocked(false);
            this.getNotificationManager().fireNotification(this.getLocalizedString("notification.applicationStarted.name"), this.getLocalizedString("notification.applicationStarted.title"), this.getLocalizedString("notification.applicationStarted.message", new Object[]{this.getApplicationName() + " " + this.getApplicationVersion()}), NotificationManager.NotificationType.INFO);
            if (this.getPreferences().getBoolean("showTasklistOnStartup", true)) {
                this.handleOpenTaskListWindow();
            }
            this.handleStartupUserInteraction();
            if (this.getPreferences().getBoolean("checkForUpdatesOnStartup", false)) {
                ApplicationUtilities.checkForUpdates((ApplicationContext)this.applicationContext, (boolean)false);
            }
        });
    }

    private void checkIncompleteShutdown(List<Task> list) {
        Optional<Date> optional = this.readShutdownTimestampFile();
        for (Task task : list) {
            List<ScheduleMetadata> list2 = this.taskRepository.listScheduleMetadata(task.getId());
            for (ScheduleMetadata scheduleMetadata2 : list2) {
                if ((scheduleMetadata2.getFlag() & 1) <= 0) continue;
                this.taskRepository.updateScheduleMetadata(scheduleMetadata2.getScheduleId(), scheduleMetadata -> new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withFlag(scheduleMetadata.getFlag() & 0xFFFFFFFE).build());
                if (optional.isPresent()) {
                    this.taskRepository.updateScheduleMetadata(scheduleMetadata2.getScheduleId(), scheduleMetadata -> new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withEnd((Date)optional.get()).withResultTime((Date)optional.get()).withResultType(ScheduleMetadata.ResultType.WARNING).withResultReason(ScheduleMetadata.ResultReason.EXECUTION_CANCELED).withResultDescription(null).build());
                    this.taskLogger.log(task, "The task execution was canceled by turning off or restarting the computer.");
                    continue;
                }
                Date date = new Date();
                this.taskRepository.updateScheduleMetadata(scheduleMetadata2.getScheduleId(), scheduleMetadata -> new ScheduleMetadata.ScheduleMetadataBuilder(scheduleMetadata).withResultTime(date).withResultType(ScheduleMetadata.ResultType.ERROR).withResultReason(ScheduleMetadata.ResultReason.INTERNAL_ERROR).withResultDescription(this.getLocalizedString("common.resultReason.applicationCrash")).build());
                this.taskLogger.log(task, "The task execution was interrupted, maybe caused by an application crash.");
            }
        }
        this.deleteShutdownTimestampFile();
    }

    public Preferences getGlobalPreferences() {
        if (this.isPortable()) {
            return this.getPreferences();
        }
        return super.getGlobalPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences getPreferences() {
        if (this.isPortable()) {
            TaskTillDawnApplication taskTillDawnApplication = this;
            synchronized (taskTillDawnApplication) {
                if (this.portablePreferences == null) {
                    try {
                        this.portablePreferences = new PortablePreferences(this.getPreferencesFile());
                    }
                    catch (IOException iOException) {
                        this.logger.log(Level.WARNING, "Failed to create or read preferences file!", iOException);
                        this.portablePreferences = new PortablePreferences();
                    }
                }
                return this.portablePreferences;
            }
        }
        return super.getPreferences();
    }

    private File getPreferencesFile() throws IOException {
        File file = new File(this.getStorageDirectory() + File.separator + "portable.configuration");
        if (!file.exists()) {
            if (file.getParentFile() != null && !file.getParentFile().mkdirs()) {
                throw new IOException("Creating directory structure for the configuration failed for unknown reason.");
            }
            if (!file.createNewFile()) {
                throw new IOException("Creating a new file failed for unknown reason.");
            }
        }
        return file;
    }

    private void handleStartupUserInteraction() {
        int n = this.getApplicationStartupCount();
        if (!(n <= 0 || n != 15 && n % 50 != 0 || this.getPreferences().getBoolean("feedbackSent", false))) {
            ApplicationUtilities.sendFeedback((ApplicationContext)this.applicationContext, (int)85, (boolean)true);
        }
    }

    private void addTaskGroupManagerEventListener() {
        this.taskGroupManager.addTaskGroupEventListener(new TaskGroupEventListener(){

            private void storeConfiguration() {
                try {
                    TaskTillDawnApplication.this.storeTaskGroupsConfiguration(TaskTillDawnApplication.this.taskGroupManager.groupsMap());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }

            private void removeGroupPreferences(String string) {
                TaskTillDawnApplication.this.getUIManager().removeStoredWindowState("GroupListFrame." + string);
                TaskTillDawnApplication.this.getPreferences().remove("group_viewOptions." + string);
                TaskTillDawnApplication.this.getPreferences().remove("group_scrollPositionHorizontal." + string);
                TaskTillDawnApplication.this.getPreferences().remove("group_scrollPositionVertical." + string);
                TaskTillDawnApplication.this.getPreferences().remove("taskList_scrollPositionHorizontal." + string);
                TaskTillDawnApplication.this.getPreferences().remove("taskList_scrollPositionVertical." + string);
                if (TaskTillDawnApplication.this.getPreferences().get("taskListSelectedGroup", "All tasks").equals(string)) {
                    TaskTillDawnApplication.this.getPreferences().remove("taskListSelectedGroup");
                }
            }

            @Override
            public void taskAdded(String string, String string2, int n) {
                this.storeConfiguration();
            }

            @Override
            public void taskMoved(String string, String string2, int n, int n2) {
                this.storeConfiguration();
            }

            @Override
            public void taskRemoved(String string, String string2, int n) {
                this.storeConfiguration();
            }

            @Override
            public void groupAdded(String string, int n) {
                this.storeConfiguration();
            }

            @Override
            public void groupMoved(String string, int n, int n2) {
                this.storeConfiguration();
            }

            @Override
            public void groupRemoved(final String string, int n) {
                this.storeConfiguration();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        List list = TaskTillDawnApplication.this.getUIManager().getRegisteredApplicationWindows(GroupListFrame.class);
                        for (GroupListFrame groupListFrame : list) {
                            if (!groupListFrame.isGroupWindow() || !string.equals(groupListFrame.getSelectedGroup())) continue;
                            groupListFrame.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosed(WindowEvent windowEvent) {
                                    this.removeGroupPreferences(string);
                                }
                            });
                            groupListFrame.dispose();
                        }
                        this.removeGroupPreferences(string);
                    }
                });
            }
        });
    }

    private void addTaskRepositoryEventListener() {
        this.taskRepository.addTaskRepositoryEventListener(this.taskLogger);
        this.taskRepository.addTaskRepositoryEventListener(new TaskRepositoryEventListener(){

            @Override
            public void taskUpdated(Task task) {
            }

            @Override
            public void taskMetadataUpdated(Task task, TaskMetadata taskMetadata) {
            }

            @Override
            public void scheduleMetadataUpdated(Task task, ScheduleMetadata scheduleMetadata) {
            }

            @Override
            public void taskAdded(Task task) {
                TaskTillDawnApplication.this.taskGroupManager.addTaskQuietly("All tasks", task.getId());
            }

            @Override
            public void taskRemoved(Task task) {
                TaskTillDawnApplication.this.taskGroupManager.removeTask(task.getId());
            }
        });
    }

    private void addSchedulerEventListener() {
        this.scheduler.addTaskSchedulerListener(new TaskSchedulerEventListener(){

            @Override
            public void schedulingResumed() {
                TaskTillDawnApplication.this.getPreferences().putBoolean("pauseTaskManager", false);
                TaskTillDawnApplication.this.getUIManager().setMenuItemChecked("menu.file.pauseTaskManager", false);
            }

            @Override
            public void schedulingPaused() {
                TaskTillDawnApplication.this.getPreferences().putBoolean("pauseTaskManager", true);
                TaskTillDawnApplication.this.getUIManager().setMenuItemChecked("menu.file.pauseTaskManager", true);
            }
        });
        this.scheduler.addTaskEventListener(this.taskLogger);
        this.scheduler.addTaskEventListener(new TaskEventAdapter(){

            @Override
            public void executionStarted(String string, String string2) {
                Task task = TaskTillDawnApplication.this.taskRepository.getTask(string);
                TaskMetadata taskMetadata = TaskTillDawnApplication.this.taskRepository.getTaskMetadata(string);
                if (task != null && taskMetadata != null && !taskMetadata.isNotificationsDisabled()) {
                    TaskTillDawnApplication.this.logger.log(Level.FINE, "Task execution started: " + task.getName());
                    TaskTillDawnApplication.this.getNotificationManager().fireNotification(TaskTillDawnApplication.this.getLocalizedString("notification.executionStarted.name"), TaskTillDawnApplication.this.getLocalizedString("notification.executionStarted.title"), TaskTillDawnApplication.this.getLocalizedString("notification.executionStarted.message", new Object[]{task.getName()}), NotificationManager.NotificationType.INFO);
                }
            }

            @Override
            public void executionCanceled(String string, String string2, ScheduleMetadata.ResultType resultType, ScheduleMetadata.ResultReason resultReason, String string3) {
                Task task = TaskTillDawnApplication.this.taskRepository.getTask(string);
                TaskMetadata taskMetadata = TaskTillDawnApplication.this.taskRepository.getTaskMetadata(string);
                if (task != null && taskMetadata != null && !taskMetadata.isNotificationsDisabled()) {
                    TaskTillDawnApplication.this.logger.log(Level.FINE, "Task execution was canceled: " + task.getName());
                    TaskTillDawnApplication.this.getNotificationManager().fireNotification(TaskTillDawnApplication.this.getLocalizedString("notification.executionCanceled.name"), TaskTillDawnApplication.this.getLocalizedString("notification.executionCanceled.title"), TaskTillDawnApplication.this.getLocalizedString("notification.executionCanceled.message", new Object[]{task.getName()}), NotificationManager.NotificationType.WARN);
                }
            }

            @Override
            public void executionEnded(String string, String string2) {
                Task task = TaskTillDawnApplication.this.taskRepository.getTask(string);
                TaskMetadata taskMetadata = TaskTillDawnApplication.this.taskRepository.getTaskMetadata(string);
                if (task != null && taskMetadata != null && !taskMetadata.isNotificationsDisabled()) {
                    TaskTillDawnApplication.this.logger.log(Level.FINE, "Task execution ended: " + task.getName());
                    TaskTillDawnApplication.this.getNotificationManager().fireNotification(TaskTillDawnApplication.this.getLocalizedString("notification.executionStopped.name"), TaskTillDawnApplication.this.getLocalizedString("notification.executionStopped.title"), TaskTillDawnApplication.this.getLocalizedString("notification.executionStopped.message", new Object[]{task.getName()}), NotificationManager.NotificationType.INFO);
                }
            }
        });
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public TaskScheduler getTaskScheduler() {
        return this.scheduler;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public TaskGroupManager getTaskGroupManager() {
        return this.taskGroupManager;
    }

    public TriggerEventManager getTriggerEventManager() {
        return this.triggerEventManager;
    }

    public ActionPackPluginManager getActionPackPluginManager() {
        return this.actionPackPluginManager;
    }

    public TaskLogger getTaskLogger() {
        return this.taskLogger;
    }

    public TrayManager getTrayManager() {
        return this.trayManager;
    }

    private void initNotificationListeners() {
        this.notificationManager.removeAllListeners();
        Runnable runnable = () -> {
            AbstractNotificationListener[] abstractNotificationListenerArray;
            this.notificationManager.addListener(new NotificationCenterNotificationListener());
            this.notificationManager.addListener(new WindowsActionCenterNotificationListener());
            this.notificationManager.addListener(new SystemTrayNotificationListener());
            this.notificationManager.addListener(new TextToSpeechNotificationListener());
            this.notificationManager.addListener(new SystemTrayTooltipNotificationListener());
            this.notificationManager.addListener(new SystemLoggerNotificationListener());
            this.notificationManager.addListener(new BeepNotificationListener());
            for (AbstractNotificationListener abstractNotificationListener : abstractNotificationListenerArray = this.notificationManager.getListeners()) {
                if (!abstractNotificationListener.isAvailable()) continue;
                if (abstractNotificationListener.isEditable()) {
                    abstractNotificationListener.setEnabled(this.getPreferences().getBoolean("listener." + abstractNotificationListener.getName(), abstractNotificationListener.isDefaultEnabled()));
                    continue;
                }
                abstractNotificationListener.setEnabled(abstractNotificationListener.isDefaultEnabled());
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
        try {
            thread.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void handleOpenTaskListWindow() {
        if (!this.getUIManager().hasRegisteredApplicationWindow(TaskListFrame.class)) {
            TaskListFrame taskListFrame = new TaskListFrame(this.applicationContext);
            this.getUIManager().registerApplicationWindow((AbstractApplicationWindow)taskListFrame);
            this.getUIManager().showWindow((AbstractApplicationWindow)taskListFrame);
        } else {
            TaskListFrame taskListFrame = (TaskListFrame)this.getUIManager().getLastRegisteredApplicationWindow(TaskListFrame.class);
            this.getUIManager().showWindow((AbstractApplicationWindow)taskListFrame);
        }
    }

    public void handleOpenGroupWindow(String string) {
        List list = this.getUIManager().getRegisteredApplicationWindows(GroupListFrame.class);
        for (GroupListFrame groupListFrame : list) {
            if (!groupListFrame.isGroupWindow() || !groupListFrame.getSelectedGroup().equals(string)) continue;
            this.getUIManager().showWindow((AbstractApplicationWindow)groupListFrame);
            return;
        }
        Object object = new GroupListFrame(this.applicationContext, string);
        boolean bl = true;
        if (!this.getUIManager().isStoredWindowStateAvailable(object)) {
            AbstractApplicationWindow abstractApplicationWindow = this.getUIManager().getLastRegisteredApplicationWindow(GroupListFrame.class);
            if (abstractApplicationWindow == null) {
                abstractApplicationWindow = this.getUIManager().getLastRegisteredApplicationWindow(TaskListFrame.class);
            }
            if (abstractApplicationWindow != null) {
                int n = abstractApplicationWindow.getX();
                int n2 = abstractApplicationWindow.getY();
                int n3 = abstractApplicationWindow.getWidth();
                int n4 = abstractApplicationWindow.getHeight();
                object.setLocation(n + this.getUIManager().getPixelsForDots(20), n2 + this.getUIManager().getPixelsForDots(20));
                object.setSize((int)((float)n3 / this.getUIManager().getDPIMultiplier()), (int)((float)n4 / this.getUIManager().getDPIMultiplier()));
                bl = false;
            }
        }
        this.getUIManager().registerApplicationWindow(object);
        this.getUIManager().showWindow(object, bl);
    }

    public void handlePreferences() {
        if (!this.getUIManager().isUiBlocked()) {
            if (!this.getUIManager().hasRegisteredApplicationWindow(PreferencesFrame.class)) {
                PreferencesFrame preferencesFrame = new PreferencesFrame(this.applicationContext, this.taskRepository);
                this.getUIManager().registerApplicationWindow((AbstractApplicationWindow)preferencesFrame);
                this.getUIManager().showWindow((AbstractApplicationWindow)preferencesFrame);
            } else {
                PreferencesFrame preferencesFrame = (PreferencesFrame)this.getUIManager().getLastRegisteredApplicationWindow(PreferencesFrame.class);
                this.getUIManager().showWindow((AbstractApplicationWindow)preferencesFrame);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void handleOpenFile(String string) {
        if (string != null) {
            this.filesToOpen.add(new File(string));
        }
    }

    public TaskTillDawnApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    private void handleOpenFile(File file) {
        if (file.exists() && file.getName().endsWith(".ttdta")) {
            EventQueue.invokeLater(() -> this.handleImportTaskArchive(file));
        }
    }

    public void handleExportTaskArchive() {
        this.handleExportTaskArchive(this.taskRepository.listTasks());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExportTaskArchive(List<Task> list) {
        try {
            String string;
            String string2;
            this.getUIManager().setUiBlocked(true);
            String string3 = this.getPreferences().get("application_last_directory.export", null);
            if (string3 != null && !new File(string3).exists()) {
                string3 = null;
            }
            JFrame jFrame = new JFrame();
            jFrame.setVisible(false);
            if (list.size() == 1) {
                string2 = this.getPlatform() == Platform.MACOS ? "[\\\\\\/:\\*\\?]" : "[\\\\\\/:\\*\\?\\\"\\<\\>]";
                string = list.get(0).getName().replaceAll(string2, "");
            } else {
                string = this.getLocalizedString("application.multiTaskFilename", new Object[]{list.size()});
            }
            if (string.trim().equals("")) {
                string = this.getLocalizedString("application.untitledTaskFilename");
            }
            string = string + ".ttdta";
            string2 = new JExtendedSaveDialog(this.getLocalizedString("dialog.SaveDialog.title.archive"));
            File file = string2.showSaveDialog((Component)jFrame, null, string, string3, ".ttdta");
            jFrame.dispose();
            if (file != null) {
                TaskArchive taskArchive;
                if (file.getParent() != null) {
                    this.getPreferences().put("application_last_directory.export", file.getParent());
                }
                boolean bl = false;
                if (!file.getName().endsWith(".ttdta")) {
                    file = new File(file.getPath() + ".ttdta");
                    bl = true;
                }
                if (file.exists() && bl) {
                    taskArchive = new JExtendedDialog(this.getLocalizedString("dialog.FileExistsDialog.title"), (Object)this.getLocalizedString("dialog.FileExistsDialog.message"), 2);
                    Object[] objectArray = new Object[]{this.getLocalizedString("common.button.ok"), this.getLocalizedString("common.button.cancel")};
                    taskArchive.setOptions(objectArray);
                    taskArchive.setInitialValue(objectArray[1]);
                    Object object2 = taskArchive.showDialog();
                    if (object2 == null || !object2.equals(this.getLocalizedString("common.button.ok"))) {
                        return;
                    }
                }
                taskArchive = new TaskArchive(this.getApplicationVersion(), this.getPlatform());
                for (Task task : list) {
                    taskArchive.getTasks().put(task.getId(), task);
                    taskArchive.getTaskMetadata().put(task.getId(), this.taskRepository.getTaskMetadata(task.getId()));
                    for (AbstractSchedule abstractSchedule : task.getSchedules()) {
                        taskArchive.getScheduleMetadata().put(abstractSchedule.getId(), this.taskRepository.getScheduleMetadata(abstractSchedule.getId()));
                    }
                }
                try {
                    TaskArchiver.archive(taskArchive, file);
                }
                catch (IOException iOException) {
                    this.logger.log(Level.WARNING, "Failed to archive task-archive!", iOException);
                    JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("dialog.ExportFailedDialog.title"), (Object)this.getLocalizedString("dialog.ExportFailedDialog.message", new Object[]{iOException.getLocalizedMessage()}), 0);
                    jExtendedDialog.showDialog();
                }
            }
        }
        finally {
            this.getUIManager().setUiBlocked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleImportTaskArchive() {
        try {
            this.getUIManager().setUiBlocked(true);
            String string = this.getPreferences().get("application_last_directory.import", null);
            if (string != null && !new File(string).exists()) {
                string = null;
            }
            JFrame jFrame = new JFrame();
            jFrame.setVisible(false);
            JExtendedOpenDialog jExtendedOpenDialog = new JExtendedOpenDialog(this.getLocalizedString("dialog.OpenDialog.title.archive"));
            File[] fileArray = jExtendedOpenDialog.showOpenDialog((Component)jFrame, null, string, ".ttdta", true);
            jFrame.dispose();
            File file = null;
            if (fileArray != null && fileArray.length > 0) {
                file = fileArray[0];
            }
            if (file != null && file.exists() && file.isFile()) {
                if (file.getParent() != null) {
                    this.getPreferences().put("application_last_directory.import", file.getParent());
                }
                this.handleImportTaskArchives(Arrays.asList(fileArray));
            }
        }
        finally {
            this.getUIManager().setUiBlocked(false);
        }
    }

    private void handleImportTaskArchive(File file) {
        this.handleImportTaskArchives(Collections.singletonList(file));
    }

    public void handleImportTaskArchives(List<File> list) {
        try {
            int n = 0;
            for (File file : list) {
                n += this.importArchiveFile(file);
            }
            JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("dialog.ImportSuccessDialog.title"), (Object)this.getLocalizedString("dialog.ImportSuccessDialog.message", new Object[]{n}), 1);
            jExtendedDialog.showDialog();
        }
        catch (JsonSyntaxException | IOException | IllegalAccessException | IllegalArgumentException | IllegalStateException | NoSuchFieldException | NullPointerException | SecurityException throwable) {
            this.logger.log(Level.WARNING, "Failed to unarchive task-archive!", throwable);
            JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("dialog.ImportFailedDialog.title"), (Object)this.getLocalizedString("dialog.ImportFailedDialog.message", new Object[]{throwable.getLocalizedMessage()}), 0);
            jExtendedDialog.showDialog();
        }
        catch (UnsupportedArchiveVersionException unsupportedArchiveVersionException) {
            JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("dialog.VersionConflictDialog.title"), (Object)this.getLocalizedString("dialog.VersionConflictDialog.message", new Object[]{unsupportedArchiveVersionException.getLocalizedMessage()}), 0);
            jExtendedDialog.showDialog();
        }
    }

    private int importArchiveFile(File file) throws IOException, UnsupportedArchiveVersionException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        TaskArchive taskArchive = TaskArchiver.unarchive(file);
        List<String> list = this.taskGroupManager.listTasksOfGroup("Last import");
        if (list != null) {
            for (String string : list) {
                this.taskGroupManager.removeTask("Last import", string);
            }
        }
        List<Task> list2 = this.taskRepository.listTasks();
        int n = 0;
        for (String string : taskArchive.getTasks().keySet()) {
            Object object2;
            Object object3;
            boolean bl;
            boolean bl2 = false;
            if (this.taskRepository.getTask(string) != null) {
                bl2 = true;
            }
            Task task = taskArchive.getTasks().get(string);
            Field field = task.getClass().getDeclaredField("id");
            field.setAccessible(true);
            if (bl2) {
                field.set(task, this.taskRepository.nextId());
            } else {
                field.set(task, string);
            }
            block2: do {
                bl = false;
                object3 = list2.iterator();
                while (object3.hasNext()) {
                    object2 = (Task)object3.next();
                    if (!((Task)object2).getName().trim().equals(task.getName().trim())) continue;
                    task = new Task.TaskBuilder(task).withName(task.getName() + " " + this.getLocalizedString("application.importedCopy")).build();
                    bl = true;
                    continue block2;
                }
            } while (bl);
            object3 = new TaskMetadata.TaskMetadataBuilder(taskArchive.getTaskMetadata().get(string)).withTaskEnabled(false).build();
            object2 = object3.getClass().getDeclaredField("taskId");
            ((Field)object2).setAccessible(true);
            ((Field)object2).set(object3, task.getId());
            ArrayList<AbstractSchedule> arrayList = new ArrayList<AbstractSchedule>();
            for (AbstractSchedule abstractSchedule : task.getSchedules()) {
                if (abstractSchedule instanceof Trigger && !this.getTriggerEventManager().canHandleEvent(((Trigger)((Object)abstractSchedule)).getClass())) continue;
                arrayList.add(abstractSchedule);
            }
            task = new Task.TaskBuilder(task).withSchedules(new ImmutableArrayList<AbstractSchedule>(arrayList)).build();
            ArrayList arrayList2 = new ArrayList();
            for (AbstractSchedule abstractSchedule : task.getSchedules()) {
                String string2 = abstractSchedule.getId();
                if (bl2) {
                    field = AbstractSchedule.class.getDeclaredField("id");
                    field.setAccessible(true);
                    field.set(abstractSchedule, this.taskRepository.nextId());
                }
                if (taskArchive.getScheduleMetadata().get(string2) == null) continue;
                ScheduleMetadata scheduleMetadata = taskArchive.getScheduleMetadata().get(string2);
                Field field2 = scheduleMetadata.getClass().getDeclaredField("scheduleId");
                field2.setAccessible(true);
                field2.set(scheduleMetadata, abstractSchedule.getId());
                arrayList2.add(scheduleMetadata);
            }
            this.taskRepository.addTask(task, (TaskMetadata)object3, arrayList2);
            this.taskGroupManager.addTaskQuietly("Last import", task.getId());
            ++n;
        }
        return n;
    }

    public void handleNewTask() {
        String string = null;
        AbstractApplicationWindow abstractApplicationWindow = this.getUIManager().getFrontmostWindow();
        if (abstractApplicationWindow != null && abstractApplicationWindow instanceof TaskListFrame) {
            string = ((TaskListFrame)abstractApplicationWindow).getSelectedGroup();
        }
        AbstractApplicationWindow abstractApplicationWindow2 = this.getUIManager().getLastRegisteredApplicationWindow(TaskConfigurationFrame.class);
        TaskConfigurationFrame taskConfigurationFrame = new TaskConfigurationFrame(this.applicationContext, string);
        this.getUIManager().registerApplicationWindow((AbstractApplicationWindow)taskConfigurationFrame);
        if (abstractApplicationWindow2 == null) {
            this.getUIManager().showWindow((AbstractApplicationWindow)taskConfigurationFrame);
        } else {
            int n = abstractApplicationWindow2.getX();
            int n2 = abstractApplicationWindow2.getY();
            int n3 = abstractApplicationWindow2.getWidth();
            int n4 = abstractApplicationWindow2.getHeight();
            taskConfigurationFrame.setLocation(n + this.getUIManager().getPixelsForDots(20), n2 + this.getUIManager().getPixelsForDots(20));
            taskConfigurationFrame.setSize((int)((float)n3 / this.getUIManager().getDPIMultiplier()), (int)((float)n4 / this.getUIManager().getDPIMultiplier()));
            this.getUIManager().showWindow((AbstractApplicationWindow)taskConfigurationFrame, false);
        }
    }

    public void handleFeedback() {
        ApplicationUtilities.sendFeedback((ApplicationContext)this.applicationContext, (int)85, (boolean)false);
    }

    public void handleDonation() {
        try {
            this.openURL(this.getLocalizedString("application.url.donateUrl"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleAbout() {
        if (!this.getUIManager().isUiBlocked()) {
            if (!this.getUIManager().hasRegisteredApplicationWindow(AboutBoxFrame.class)) {
                String string = null;
                if (this.isPortable()) {
                    string = this.getLocalizedString("application.mode.portableMode");
                }
                AboutBoxFrame aboutBoxFrame = new AboutBoxFrame((ApplicationContext)this.applicationContext, 85, string);
                this.getUIManager().registerApplicationWindow((AbstractApplicationWindow)aboutBoxFrame);
                this.getUIManager().showWindow((AbstractApplicationWindow)aboutBoxFrame);
            } else {
                AboutBoxFrame aboutBoxFrame = (AboutBoxFrame)this.getUIManager().getLastRegisteredApplicationWindow(AboutBoxFrame.class);
                this.getUIManager().showWindow((AbstractApplicationWindow)aboutBoxFrame);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public boolean openURL(String string) throws IOException {
        if (Desktop.isDesktopSupported()) {
            try {
                if (string.startsWith("mailto:")) {
                    Desktop.getDesktop().mail(new URI(string));
                }
                Desktop.getDesktop().browse(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                this.logger.log(Level.INFO, "Could not open url \"" + string + "\"!", uRISyntaxException);
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public void handlePauseTaskManager() {
        boolean bl;
        boolean bl2 = bl = !this.getPreferences().getBoolean("pauseTaskManager", false);
        if (bl) {
            AbstractApplicationWindow abstractApplicationWindow = this.getUIManager().getLastRegisteredApplicationWindow(TaskListFrame.class);
            JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("dialog.PauseTaskScheduler.title"), (Object)this.getLocalizedString("dialog.PauseTaskScheduler.message"), 3);
            Object[] objectArray = new Object[]{this.getLocalizedString("common.button.ok"), this.getLocalizedString("common.button.cancel")};
            jExtendedDialog.setOptions(objectArray);
            jExtendedDialog.setInitialValue(objectArray[1]);
            Object object = jExtendedDialog.showDialog((Component)abstractApplicationWindow);
            if (!objectArray[0].equals(object)) {
                this.getUIManager().setMenuItemChecked("menu.file.pauseTaskManager", false);
                return;
            }
        }
        this.handlePauseTaskManager(Optional.empty());
    }

    public void handlePauseTaskManager(Optional<Boolean> optional) {
        boolean bl;
        boolean bl2 = bl = !this.getPreferences().getBoolean("pauseTaskManager", false);
        if (!optional.isPresent() || optional.get() == bl) {
            this.getUIManager().setMenuItemChecked("menu.file.pauseTaskManager", bl);
            this.scheduler.setPaused(bl);
            if (bl) {
                this.enableAppNap();
            } else {
                this.disableAppNap("Task Till Dawn task scheduler is running.");
            }
        }
    }

    public double getApplicationVersion() {
        return 2.21;
    }

    public AbstractApplication.VersionType getApplicationVersionType() {
        return VERSION_TYPE;
    }

    public String getApplicationName() {
        if (TaskTillDawnApplication.isDebug()) {
            return "Task Till Dawn.debug";
        }
        return APPLICATION_NAME;
    }

    protected void processShutdown() {
        this.logger.info("Application shutting down.");
        this.writeShutdownTimestampFile();
        if (this.startupLatch.getCount() == 0L) {
            this.schedulerThread.interrupt();
            this.logger.fine("Waiting for scheduler to shut down...");
            for (int i = 0; i < 100 && this.schedulerThread.isAlive(); ++i) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (this.schedulerThread.isAlive()) {
                this.logger.warning("Failed to gracefully shutdown scheduler.");
            }
            this.logger.fine("Shutting down notification listeners...");
            AbstractNotificationListener[] abstractNotificationListenerArray = this.getNotificationManager().getListeners();
            for (AbstractNotificationListener abstractNotificationListener : abstractNotificationListenerArray) {
                abstractNotificationListener.setEnabled(false);
            }
            File file = this.getDefaultActionPackFile();
            if (file != null) {
                this.actionPackPluginManager.unloadActionPack(file);
                if (!file.delete()) {
                    this.logger.fine("Failed to delete temporary default action pack file: " + file.getPath());
                }
            }
        } else {
            this.logger.fine("Skipped shutdown procedure because application startup was not finished. Startup latch: " + this.startupLatch.getCount());
        }
        this.deleteShutdownTimestampFile();
        this.logger.info("Shutdown complete.");
    }

    private File getShutdownTimestampFile() {
        return new File(this.getStorageDirectory() + File.separator + "shutdown.ts");
    }

    private void writeShutdownTimestampFile() {
        try (FileWriter fileWriter = new FileWriter(this.getShutdownTimestampFile());){
            fileWriter.write(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Date> readShutdownTimestampFile() {
        File file = this.getShutdownTimestampFile();
        if (!file.exists()) return Optional.empty();
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String string = bufferedReader.readLine();
            if (string == null) return Optional.empty();
            Optional<Date> optional = Optional.of(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(string));
            return optional;
        }
        catch (IOException | ParseException exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    private void deleteShutdownTimestampFile() {
        this.getShutdownTimestampFile().delete();
    }

    public boolean handleQuit(String string) {
        this.logger.fine("Application shutdown initiated by user using application menu or application quit event.");
        if (this.handleQuit() && this.getPlatform() != Platform.MACOS) {
            System.exit(0);
        }
        return true;
    }

    public boolean handleQuit() {
        if (this.startupLatch.getCount() == 0L) {
            this.getNotificationManager().fireNotification(this.getLocalizedString("notification.applicationExiting.name"), this.getLocalizedString("notification.applicationExiting.title"), this.getLocalizedString("notification.applicationExiting.message", new Object[]{this.getApplicationName() + " " + this.getApplicationVersion()}), NotificationManager.NotificationType.INFO);
            this.logger.fine("Saving application state.");
            int n = 0;
            List list = this.getUIManager().getRegisteredApplicationWindows();
            for (AbstractApplicationWindow abstractApplicationWindow : list) {
                WindowListener[] windowListenerArray;
                if (abstractApplicationWindow instanceof AbstractPreferencesFrame) {
                    ((AbstractPreferencesFrame)abstractApplicationWindow).saveChanges();
                }
                for (WindowListener windowListener : windowListenerArray = abstractApplicationWindow.getWindowListeners()) {
                    windowListener.windowClosed(new WindowEvent((Window)abstractApplicationWindow, n++));
                }
            }
        }
        this.flushPreferences();
        return true;
    }

    private void removeOutdatedTempFiles() {
        File file2 = new File(this.getStorageDirectory() + File.separator + "Action Packs");
        if (file2.exists()) {
            File[] fileArray;
            for (File file3 : fileArray = file2.listFiles(file -> file.getName().endsWith(".tmp") || file.getName().equals("obsolete"))) {
                if (file3.delete()) continue;
                this.logger.fine("Failed to delete file \"" + file3.getPath() + "\" for unknown reason.");
            }
        }
    }

    public synchronized void setPortable(boolean bl) {
        if (this.portable == null) {
            this.portable = bl;
            return;
        }
        throw new IllegalStateException("Portable state cannot be modified after application start.");
    }

    public synchronized boolean isPortable() {
        if (this.portable != null) {
            return this.portable;
        }
        this.portable = new File(this.getCurrentWorkingDirectory() + File.separator + "portable").exists() || new File(this.getCurrentWorkingDirectory() + File.separator + ".portable").exists();
        return this.portable;
    }

    public boolean isAgent() {
        return "true".equals(System.getProperty("apple.awt.UIElement"));
    }

    private String getCurrentWorkingDirectory() {
        String string = null;
        if (this.getPlatform() == Platform.WINDOWS) {
            string = System.getProperty("launch4j.exedir");
        } else if (this.getPlatform() == Platform.MACOS) {
            try {
                string = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                if (string.contains(this.getApplicationName() + ".app")) {
                    string = string.substring(0, string.lastIndexOf(this.getApplicationName() + ".app"));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                this.logger.log(Level.WARNING, "Failed to determine bundle path!", uRISyntaxException);
            }
        }
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String getStorageDirectory() {
        String string = "";
        if (this.isPortable()) {
            string = this.getCurrentWorkingDirectory() + File.separator + this.getApplicationName() + " data";
        } else if (this.getPlatform() == Platform.MACOS) {
            string = System.getProperty("user.home") + File.separator + "Library" + File.separator + "Application Support" + File.separator + this.getApplicationName();
        } else if (this.getPlatform() == Platform.WINDOWS) {
            String string2 = System.getenv("APPDATA");
            string = string2 != null ? string2 + File.separator + this.getApplicationName() : this.getApplicationName();
        }
        return string;
    }

    public String getPluginDirectory() {
        return this.getStorageDirectory() + File.separator + "Action Packs";
    }

    private synchronized File getDefaultActionPackFile() {
        return this.defaultActionPackFile;
    }

    private synchronized void setDefaultActionPackFile(File file) {
        this.defaultActionPackFile = file;
    }

    private void loadPlugIns() {
        File[] fileArray;
        File file = new File(this.getPluginDirectory());
        file.mkdirs();
        try {
            fileArray = ((Object)((Object)this)).getClass().getResourceAsStream("/resources/actionPacks/de.oliver_matuschin.ttd.plugin.DefaultActions.ttdap");
            File[] fileArray2 = null;
            try {
                File file2 = File.createTempFile("DefaultActionPack", ".tmp");
                file2.deleteOnExit();
                Files.copy((InputStream)fileArray, file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.actionPackPluginManager.loadActionPack(file2);
                this.setDefaultActionPackFile(file2);
            }
            catch (Throwable object) {
                fileArray2 = object;
                throw object;
            }
            finally {
                if (fileArray != null) {
                    if (fileArray2 != null) {
                        try {
                            fileArray.close();
                        }
                        catch (Throwable throwable) {
                            fileArray2.addSuppressed(throwable);
                        }
                    } else {
                        fileArray.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.logger.log(Level.SEVERE, "Failed to write default action pack!", iOException);
            System.exit(1);
        }
        this.manageExtensions(file.toPath(), ".ttdap");
        for (File file3 : fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".ttdap");
            }
        })) {
            this.actionPackPluginManager.loadActionPack(file3);
        }
    }

    private synchronized Map<String, List<String>> loadTaskGroupsConfiguration() throws IOException {
        String string = this.getStorageDirectory();
        File file = new File(string);
        file.mkdirs();
        File file2 = new File(string + File.separator + "groups.configuration");
        if (file2.exists()) {
            try (FileReader fileReader = new FileReader(file2);){
                Map map = (Map)new Gson().fromJson((Reader)fileReader, new TypeToken<LinkedHashMap<String, List<String>>>(){}.getType());
                return map;
            }
        }
        return new LinkedHashMap<String, List<String>>();
    }

    private synchronized void storeTaskGroupsConfiguration(Map<String, List<String>> map) throws IOException {
        String string = this.getStorageDirectory();
        File file = new File(string);
        file.mkdirs();
        File file2 = new File(string + File.separator + "groups.configuration");
        try (FileWriter fileWriter = new FileWriter(file2);){
            fileWriter.write(new Gson().toJson(map));
        }
    }

    public synchronized void disableAppNap(String string) {
        if (this.getPlatform() == Platform.MACOS && this.activity == null) {
            int[] nArray = SystemUtil.getMajorMinor();
            int n = nArray[0];
            int n2 = nArray[1];
            if (n > 10 || n == 10 && n2 >= 9) {
                this.activity = ProcessInfoUtils.beginActivityWithOptions(ProcessInfoUtils.ActivityOption.NSActivityUserInitiatedAllowingIdleSystemSleep, string);
            }
        }
    }

    public synchronized void enableAppNap() {
        if (this.getPlatform() == Platform.MACOS && this.activity != null) {
            int[] nArray = SystemUtil.getMajorMinor();
            int n = nArray[0];
            int n2 = nArray[1];
            if (n > 10 || n == 10 && n2 >= 9) {
                ProcessInfoUtils.endActivity(this.activity);
                this.activity = null;
            }
        }
    }

    private static class SingletonHolder {
        private static final TaskTillDawnApplication INSTANCE = new TaskTillDawnApplication();

        private SingletonHolder() {
        }
    }
}

