/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.util.ui.panel;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.layout.VerticalFlowLayout;
import de.oliver_matuschin.base.util.ApplicationUtilities;
import de.oliver_matuschin.base.util.ui.frame.AbstractPreferencesFrame;
import de.oliver_matuschin.base.util.ui.panel.AbstractPreferencesTabPanel;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UpdatePreferencesTabPanel
extends AbstractPreferencesTabPanel {
    private JCheckBox checkForUpdatesOnStartupButton;
    private JButton checkForUpdatesButton;
    private String checkForUpdatesOnStartup;
    private boolean checkForUpdatesOnStartupDefault;
    private AbstractPreferencesFrame<?> parentFrame;

    public UpdatePreferencesTabPanel(AbstractPreferencesFrame<?> abstractPreferencesFrame, String string, boolean bl) {
        this.parentFrame = abstractPreferencesFrame;
        this.checkForUpdatesOnStartup = string;
        this.checkForUpdatesOnStartupDefault = bl;
        this.initUI();
    }

    private void initUI() {
        VerticalFlowLayout verticalFlowLayout = new VerticalFlowLayout(false);
        this.setLayout(verticalFlowLayout);
        UIManager uIManager = Starter.getApplication().getUIManager();
        this.checkForUpdatesOnStartupButton = new JCheckBox(Starter.getApplication().getLocalizedString("panel.UpdatePreferencesTabPanel.button.checkForUpdatesOnStartup"));
        this.checkForUpdatesOnStartupButton.setOpaque(false);
        this.checkForUpdatesButton = new JButton(Starter.getApplication().getLocalizedString("panel.UpdatePreferencesTabPanel.button.checkNow"));
        JLabel jLabel = new JLabel();
        jLabel.setSize(uIManager.getPixelsForDots(20), uIManager.getPixelsForDots(20));
        jLabel.setPreferredSize(uIManager.getPixelsForDots(new Dimension(20, 20)));
        JLabel jLabel2 = new JLabel();
        jLabel2.setSize(uIManager.getPixelsForDots(20), uIManager.getPixelsForDots(20));
        jLabel2.setPreferredSize(uIManager.getPixelsForDots(new Dimension(20, 20)));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(uIManager.getPixelsForDots(5), 0, 0, 0));
        jPanel.add(jLabel2);
        jPanel.add(this.checkForUpdatesButton);
        jPanel.add(jLabel);
        jPanel.setOpaque(false);
        verticalFlowLayout.addLayoutComponent(null, jPanel);
        this.add(this.checkForUpdatesOnStartupButton);
        this.add(jPanel);
        Runnable runnable = () -> EventQueue.invokeLater(() -> {
            jLabel.setIcon(null);
            this.enableUI();
        });
        this.checkForUpdatesButton.addActionListener(actionEvent -> {
            ImageIcon imageIcon = ImageBuilder.buildFor("/resources/_progress.gif");
            jLabel.setIcon(imageIcon);
            imageIcon.setImageObserver(jLabel);
            this.disableUI();
            ApplicationUtilities.checkForUpdates(this.parentFrame.getApplicationContext(), this.parentFrame, true, runnable);
        });
        ActionListener actionListener = actionEvent -> this.setDirty();
        this.checkForUpdatesOnStartupButton.addActionListener(actionListener);
    }

    private void enableUI() {
        this.parentFrame.enableUI();
        this.checkForUpdatesOnStartupButton.setEnabled(true);
        this.checkForUpdatesButton.setEnabled(true);
    }

    private void disableUI() {
        this.parentFrame.disableUI();
        this.checkForUpdatesOnStartupButton.setEnabled(false);
        this.checkForUpdatesButton.setEnabled(false);
    }

    @Override
    public void savePreferences() {
        Preferences preferences = Starter.getApplication().getPreferences();
        preferences.putBoolean(this.checkForUpdatesOnStartup, this.checkForUpdatesOnStartupButton.isSelected());
    }

    @Override
    public void loadPreferences() {
        Preferences preferences = Starter.getApplication().getPreferences();
        this.checkForUpdatesOnStartupButton.setSelected(preferences.getBoolean(this.checkForUpdatesOnStartup, this.checkForUpdatesOnStartupDefault));
    }
}

