/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.util.ui.panel;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.application.LocalizationProvider;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.dialog.JExtendedDialog;
import de.oliver_matuschin.base.ui.dialog.JExtendedOpenDialog;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.list.JExtendedList;
import de.oliver_matuschin.base.util.UIUtil;
import de.oliver_matuschin.base.util.ui.panel.AbstractPreferencesTabPanel;
import de.oliver_matuschin.system.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;

public class ExtensionPreferencesTabPanel
extends AbstractPreferencesTabPanel {
    private LocalizationProvider localizationProvider;
    private Path extensionDirectoryPath;
    private String fileExtension;
    private JList<String> extensionList;
    private JButton addButton;
    private JButton removeButton;
    private List<String> extensionsToRemove;

    public ExtensionPreferencesTabPanel(LocalizationProvider localizationProvider, Path path, String string) {
        this.localizationProvider = localizationProvider;
        this.extensionDirectoryPath = path;
        this.fileExtension = string;
        this.extensionsToRemove = new ArrayList<String>();
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        UIManager uIManager = Starter.getApplication().getUIManager();
        Insets insets = javax.swing.UIManager.getInsets("CheckBox.margin");
        Insets insets2 = new Insets(insets.top + uIManager.getPixelsForDots(10), insets.left, insets.bottom, insets.right);
        this.extensionList = new JExtendedList<String>(new DefaultListModel());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(null);
        jScrollPane.getViewport().setBackground(Color.WHITE);
        jScrollPane.getViewport().add(this.extensionList);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        jPanel.add((Component)jScrollPane, "Center");
        this.addButton = new JButton();
        this.addButton.setIcon(ImageBuilder.buildFor("/resources/images/buttons/small_action_add.png"));
        this.addButton.setPressedIcon(ImageBuilder.buildFor("/resources/images/buttons/small_action_add_pressed.png"));
        this.addButton.setDisabledIcon(ImageBuilder.buildFor("/resources/images/buttons/small_action_add_disabled.png"));
        this.addButton.setToolTipText(this.localizationProvider.getLocalizedString("panel.ExtensionPreferencesTabPanel.button.addExtension"));
        this.removeButton = new JButton();
        this.removeButton.setIcon(ImageBuilder.buildFor("/resources/images/buttons/small_action_remove.png"));
        this.removeButton.setPressedIcon(ImageBuilder.buildFor("/resources/images/buttons/small_action_remove_pressed.png"));
        this.removeButton.setDisabledIcon(ImageBuilder.buildFor("/resources/images/buttons/small_action_remove_disabled.png"));
        this.removeButton.setToolTipText(this.localizationProvider.getLocalizedString("panel.ExtensionPreferencesTabPanel.button.removeExtension"));
        JToolBar jToolBar = UIUtil.createMiniToolbar(this.addButton, this.removeButton);
        jPanel.add((Component)jToolBar, "South");
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(this.localizationProvider.getLocalizedString("panel.ExtensionPreferencesTabPanel.label.extensionDescriptionLabel", Starter.getApplication().getApplicationName()));
        jTextPane.setHighlighter(null);
        jTextPane.setOpaque(false);
        jTextPane.setEditable(false);
        if (Starter.getApplication().getPlatform() == Platform.MACOS) {
            jTextPane.setBorder(BorderFactory.createEmptyBorder(0, uIManager.getPixelsForDots(5), uIManager.getPixelsForDots(10), uIManager.getPixelsForDots(5)));
        } else {
            jTextPane.setMargin(insets2);
        }
        this.add((Component)jTextPane, "North");
        this.add((Component)jPanel, "Center");
        this.addActionListeners();
        this.validateButtons();
    }

    private void addActionListeners() {
        this.addButton.addActionListener(actionEvent -> this.handleAddExtensions());
        this.removeButton.addActionListener(actionEvent -> this.handleRemoveExtensions());
        this.extensionList.addListSelectionListener(listSelectionEvent -> this.validateButtons());
    }

    private void handleAddExtensions() {
        JExtendedOpenDialog jExtendedOpenDialog;
        File[] fileArray;
        String string = Starter.getApplication().getPreferences().get("lastExtensionDirectory", null);
        if (string != null && !new File(string).exists()) {
            string = null;
        }
        if ((fileArray = (jExtendedOpenDialog = new JExtendedOpenDialog(this.localizationProvider.getLocalizedString("panel.ExtensionPreferencesTabPanel.label.chooseOneOrMoreExtensions"))).showOpenDialog(this, null, string, this.fileExtension, true)) != null && fileArray.length > 0) {
            Path path = this.extensionDirectoryPath.resolve("staged");
            if (path.toFile().exists() && path.toFile().isDirectory()) {
                for (File file : fileArray) {
                    if (!file.getName().endsWith(this.fileExtension) || !file.exists() || !file.isFile() || ((DefaultListModel)this.extensionList.getModel()).contains(file.getName()) && !this.showOverwriteFileDialog(file.getName())) continue;
                    try {
                        Files.copy(file.toPath(), path.resolve(file.getName()), StandardCopyOption.REPLACE_EXISTING);
                        this.extensionsToRemove.remove(file.getName());
                        this.setDirty();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            if (fileArray[0].getParent() != null) {
                Starter.getApplication().getPreferences().put("lastExtensionDirectory", fileArray[0].getParent());
            }
            this.populateExtensionList();
        }
    }

    private boolean showOverwriteFileDialog(String string) {
        JExtendedDialog jExtendedDialog = new JExtendedDialog(this.localizationProvider.getLocalizedString("dialog.OverwriteExtensionDialog.title"), this.localizationProvider.getLocalizedString("dialog.OverwriteExtensionDialog.message", string), 2);
        Object[] objectArray = new Object[]{this.localizationProvider.getLocalizedString("common.button.ok"), this.localizationProvider.getLocalizedString("common.button.cancel")};
        jExtendedDialog.setOptions(objectArray);
        jExtendedDialog.setInitialValue(objectArray[1]);
        return this.localizationProvider.getLocalizedString("common.button.ok").equals(jExtendedDialog.showDialog(this));
    }

    private void handleRemoveExtensions() {
        int[] nArray = this.extensionList.getSelectedIndices();
        if (nArray.length > 0) {
            this.setDirty();
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = nArray[i];
                String string = this.extensionList.getModel().getElementAt(n);
                this.extensionsToRemove.add(string);
                ((DefaultListModel)this.extensionList.getModel()).remove(n);
            }
        }
    }

    private void validateButtons() {
        this.removeButton.setEnabled(this.extensionList.getSelectedIndices().length > 0);
    }

    private List<String> getInstalledExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.extensionDirectoryPath.toFile().exists() && this.extensionDirectoryPath.toFile().isDirectory()) {
            try (Stream<Path> stream = Files.list(this.extensionDirectoryPath);){
                List list = stream.filter(path -> path.toFile().isFile() && path.getFileName().toString().endsWith(this.fileExtension)).collect(Collectors.toList());
                for (Path path2 : list) {
                    arrayList.add(path2.getFileName().toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private List<Path> getExtensionsToInstall() {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        Path path2 = this.extensionDirectoryPath.resolve("install");
        if (path2.toFile().exists() && path2.toFile().isDirectory()) {
            try (Stream<Path> stream = Files.list(path2);){
                List list = stream.filter(path -> path.toFile().isFile() && path.getFileName().toString().endsWith(this.fileExtension)).collect(Collectors.toList());
                for (Path path3 : list) {
                    arrayList.add(path3);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private List<Path> getStagedExtensions() {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        Path path2 = this.extensionDirectoryPath.resolve("staged");
        if (path2.toFile().exists() && path2.toFile().isDirectory()) {
            try (Stream<Path> stream = Files.list(path2);){
                List list = stream.filter(path -> path.toFile().isFile() && path.getFileName().toString().endsWith(this.fileExtension)).collect(Collectors.toList());
                for (Path path3 : list) {
                    arrayList.add(path3);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private List<String> getExtensionsToRemove() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = Starter.getApplication().getPreferences().getInt("removeExtensionCount" + this.fileExtension, 0);
        for (int i = 0; i < n; ++i) {
            String string = Starter.getApplication().getPreferences().get("removeExtension" + this.fileExtension + "." + i, null);
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public void savePreferences() {
        int n = 0;
        for (String string : this.extensionsToRemove) {
            Starter.getApplication().getPreferences().put("removeExtension" + this.fileExtension + "." + n, string);
            ++n;
        }
        Starter.getApplication().getPreferences().putInt("removeExtensionCount" + this.fileExtension, n);
        this.moveStagedExtensions();
    }

    @Override
    public void loadPreferences() {
        this.createDirectories();
        this.deleteStagedExtensions();
        this.extensionsToRemove = this.getExtensionsToRemove();
        this.populateExtensionList();
    }

    private void deleteStagedExtensions() {
        for (Path path : this.getStagedExtensions()) {
            try {
                if (!path.toFile().exists()) continue;
                Files.delete(path);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void moveStagedExtensions() {
        Path path = this.extensionDirectoryPath.resolve("install");
        if (path.toFile().exists() && path.toFile().isDirectory()) {
            for (Path path2 : this.getStagedExtensions()) {
                try {
                    if (!path2.toFile().exists()) continue;
                    Files.move(path2, path.resolve(path2.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private void populateExtensionList() {
        List<String> list = this.getInstalledExtensions();
        for (Path object : this.getExtensionsToInstall()) {
            if (list.contains(object.getFileName().toString())) continue;
            list.add(object.getFileName().toString());
        }
        for (Path path : this.getStagedExtensions()) {
            if (list.contains(path.getFileName().toString())) continue;
            list.add(path.getFileName().toString());
        }
        list.removeAll(this.extensionsToRemove);
        Collections.sort(list);
        DefaultListModel defaultListModel = (DefaultListModel)this.extensionList.getModel();
        defaultListModel.clear();
        for (String string : list) {
            defaultListModel.addElement(string);
        }
    }

    private void createDirectories() {
        try {
            Path path;
            Path path2 = this.extensionDirectoryPath.resolve("install");
            if (!path2.toFile().exists()) {
                Files.createDirectories(path2, new FileAttribute[0]);
            }
            if (!(path = this.extensionDirectoryPath.resolve("staged")).toFile().exists()) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

