/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.util.ui.frame;

import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.constant.AppConstants;
import de.oliver_matuschin.base.ui.dialog.JExtendedDialog;
import de.oliver_matuschin.base.ui.frame.AbstractApplicationWindow;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.util.UIUtil;
import de.oliver_matuschin.base.util.ui.panel.AbstractPreferencesTabPanel;
import de.oliver_matuschin.system.Platform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class AbstractPreferencesFrame<T extends ApplicationContext<?>>
extends AbstractApplicationWindow<T> {
    private JButton cancelButton;
    private JButton saveButton;
    private JPanel currentTab;
    private JPanel contentPanel;
    private List<JButton> toolBarButtons;
    private Map<PreferencesTab, AbstractPreferencesTabPanel> tabs = new LinkedHashMap<PreferencesTab, AbstractPreferencesTabPanel>();

    public AbstractPreferencesFrame(T t) {
        super(t);
        this.setDefaultCloseOperation(2);
        this.setAllowEscapeToExecuteAction(true, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AbstractPreferencesFrame.this.getDefaultCloseOperation() == 0) {
                    return;
                }
                if (AbstractPreferencesFrame.this.showDiscardChangesDialog() || !AbstractPreferencesFrame.this.isDirty()) {
                    AbstractPreferencesFrame.this.cancelChanges();
                }
            }
        });
        this.initTabs(this.tabs);
        this.initUI();
    }

    public void disableUI() {
        if (this.getApplication().getPlatform() != Platform.MACOS) {
            this.cancelButton.setEnabled(false);
            this.saveButton.setEnabled(false);
        }
        for (JButton jButton : this.toolBarButtons) {
            jButton.setEnabled(false);
        }
        this.setDefaultCloseOperation(0);
    }

    public void enableUI() {
        if (this.getApplication().getPlatform() != Platform.MACOS) {
            this.cancelButton.setEnabled(true);
            this.saveButton.setEnabled(true);
        }
        for (JButton jButton : this.toolBarButtons) {
            jButton.setEnabled(true);
        }
        this.setDefaultCloseOperation(2);
    }

    private void initUI() {
        Object object;
        this.setTitle(this.getLocalizedString("window.AbstractPreferencesFrame.title"));
        this.setLayout(new BorderLayout());
        if (this.getApplication().getPlatform() == Platform.WINDOWS) {
            object = new ArrayList<Image>();
            object.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/preferences_window_icon_win_128x128.png")));
            object.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/preferences_window_icon_win_64x64.png")));
            object.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/preferences_window_icon_win_32x32.png")));
            object.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/preferences_window_icon_win_16x16.png")));
            this.setIconImages((List<? extends Image>)object);
        }
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setBackground(AppConstants.DEFAULT_WINDOW_BACKGROUND_COLOR);
        this.add((Component)this.contentPanel, "Center");
        this.toolBarButtons = new ArrayList<JButton>();
        for (PreferencesTab preferencesTab : this.tabs.keySet()) {
            String string = preferencesTab instanceof LocalizedPreferencesTab ? ((LocalizedPreferencesTab)preferencesTab).getLocalizedName() : this.getLocalizedString("window.AbstractPreferencesFrame.button.preferences" + preferencesTab.name().substring(0, 1).toUpperCase() + preferencesTab.name().substring(1).toLowerCase());
            JButton jButton = new JButton();
            jButton.setText(string);
            jButton.setIcon(ImageBuilder.buildFor(this.tabs.get(preferencesTab).getClass(), "/resources/images/tabs/tab_" + preferencesTab.name().toLowerCase() + ".png"));
            jButton.setPressedIcon(ImageBuilder.buildFor(this.tabs.get(preferencesTab).getClass(), "/resources/images/tabs/tab_" + preferencesTab.name().toLowerCase() + "_pressed.png"));
            jButton.setDisabledIcon(ImageBuilder.buildFor(this.tabs.get(preferencesTab).getClass(), "/resources/images/tabs/tab_" + preferencesTab.name().toLowerCase() + "_disabled.png"));
            jButton.addActionListener(actionEvent -> this.switchToTab(preferencesTab));
            this.toolBarButtons.add(jButton);
        }
        UIUtil.addTabToolBar(this, this.toolBarButtons.toArray(new JButton[0]));
        this.toolBarButtons.get(0).doClick();
        if (this.getApplication().getPlatform() != Platform.MACOS) {
            object = new JPanel();
            ((JComponent)object).setBackground(AppConstants.DEFAULT_WINDOW_BACKGROUND_COLOR);
            this.saveButton = new JButton();
            this.saveButton.setText(this.getLocalizedString("common.button.save"));
            this.saveButton.addActionListener(actionEvent -> {
                if (this.getDefaultCloseOperation() == 0) {
                    return;
                }
                this.saveChanges();
                this.dispose();
            });
            this.cancelButton = new JButton();
            this.cancelButton.setText(this.getLocalizedString("common.button.cancel"));
            this.cancelButton.addActionListener(actionEvent -> {
                if (this.getDefaultCloseOperation() == 0) {
                    return;
                }
                if (!this.isDirty() || this.showDiscardChangesDialog()) {
                    this.cancelChanges();
                }
            });
            ((Container)object).add(this.cancelButton);
            ((Container)object).add(this.saveButton);
            this.getRootPane().setDefaultButton(this.saveButton);
            this.add((Component)object, "South");
        }
        this.setMinimumSize(new Dimension(550, 400));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                AbstractPreferencesFrame.this.pack();
                AbstractPreferencesFrame.this.setResizable(false);
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (AbstractPreferencesFrame.this.getDefaultCloseOperation() == 0) {
                    return;
                }
                AbstractPreferencesFrame.this.saveChanges();
            }
        });
        this.loadPreferences();
        this.pack();
    }

    protected abstract void initTabs(Map<PreferencesTab, AbstractPreferencesTabPanel> var1);

    private void cancelChanges() {
        this.loadPreferences();
        this.dispose();
    }

    public void saveChanges() {
        Iterator<AbstractPreferencesTabPanel> iterator = this.tabs.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().savePreferences();
        }
        this.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
    }

    private void loadPreferences() {
        for (AbstractPreferencesTabPanel abstractPreferencesTabPanel : this.tabs.values()) {
            abstractPreferencesTabPanel.loadPreferences();
        }
        this.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
    }

    private void switchToTab(PreferencesTab preferencesTab) {
        if (this.currentTab != null) {
            this.contentPanel.remove(this.currentTab);
        }
        this.currentTab = this.tabs.get(preferencesTab);
        this.contentPanel.add((Component)this.currentTab, "Center");
        if (this.currentTab != null) {
            this.currentTab.setBorder(BorderFactory.createEmptyBorder());
            this.currentTab.setBackground(this.contentPanel.getBackground());
        }
        this.contentPanel.repaint();
    }

    private boolean showDiscardChangesDialog() {
        Object object = this.getLocalizedString("common.button.ok");
        if (this.isDirty()) {
            JExtendedDialog jExtendedDialog = new JExtendedDialog(this.getLocalizedString("common.title.discardChanges"), this.getLocalizedString("common.message.discardChanges"), 2);
            Object[] objectArray = new Object[]{this.getLocalizedString("common.button.ok"), this.getLocalizedString("common.button.cancel")};
            jExtendedDialog.setOptions(objectArray);
            jExtendedDialog.setInitialValue(objectArray[1]);
            object = jExtendedDialog.showDialog(this);
            if (object != null && object.equals(this.getLocalizedString("common.button.ok"))) {
                return true;
            }
        }
        return false;
    }

    public boolean isDirty() {
        return this.getRootPane().getClientProperty("Window.documentModified") != null ? (Boolean)this.getRootPane().getClientProperty("Window.documentModified") : false;
    }

    protected static interface LocalizedPreferencesTab
    extends PreferencesTab {
        public String getLocalizedName();
    }

    protected static interface PreferencesTab {
        public String name();
    }
}

