/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.util.ui.frame;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.application.AbstractApplication;
import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.constant.AppConstants;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.event.JExtendedMouseAdapter;
import de.oliver_matuschin.base.ui.frame.AbstractApplicationWindow;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.layout.VerticalFlowLayout;
import de.oliver_matuschin.base.util.ApplicationUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class AboutBoxFrame
extends AbstractApplicationWindow<ApplicationContext<?>> {
    private JTextPane aboutTextArea;
    private JButton visitWebpageButton;
    private JButton sendFeedbackButton;
    private JButton viewChangeButton;
    private boolean isViewingEula = false;
    private final int feedbackArticleID;

    public AboutBoxFrame(ApplicationContext<?> applicationContext, int n) {
        this(applicationContext, n, null);
    }

    public AboutBoxFrame(ApplicationContext<?> applicationContext, int n, String string) {
        super(applicationContext);
        this.feedbackArticleID = n;
        this.setDefaultCloseOperation(2);
        this.setAllowEscapeToCloseWindow(true);
        this.initUI(string);
    }

    private void initUI(String string) {
        Serializable serializable;
        Object object;
        this.setLayout(new BorderLayout());
        this.setTitle(this.getLocalizedString("window.AboutBoxFrame.title", this.getApplication().getApplicationName()));
        this.getContentPane().setBackground(AppConstants.DEFAULT_WINDOW_BACKGROUND_COLOR);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel(new VerticalFlowLayout());
        jPanel2.setOpaque(false);
        jPanel2.setPreferredSize(new Dimension(this.getUIManager().getPixelsForDots(210), 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(50), this.getUIManager().getPixelsForDots(20), this.getUIManager().getPixelsForDots(20), this.getUIManager().getPixelsForDots(20)));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(ImageBuilder.buildFor("/resources/aboutbox_icon.png"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(5), 0, this.getUIManager().getPixelsForDots(10), 0));
        JLabel jLabel2 = new JLabel(this.getApplication().getApplicationName());
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setFont(this.getUIManager().getFont(UIManager.FontSize.LARGE, 1));
        jLabel2.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(5), 0, 0, 0));
        Properties properties = new Properties();
        try {
            object = this.getClass().getResourceAsStream("/resources/build.number");
            serializable = null;
            try {
                properties.load((InputStream)object);
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (serializable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = new JLabel(this.getLocalizedString("window.AboutBoxFrame.label.version") + " " + this.getApplication().getApplicationVersion() + (this.getApplication().getApplicationVersionType() == AbstractApplication.VersionType.ALPHA ? "\u0391" : (this.getApplication().getApplicationVersionType() == AbstractApplication.VersionType.BETA ? "\u0392" : "")) + " (" + properties.getProperty("build.number", "-") + ")");
        ((JLabel)object).setHorizontalAlignment(0);
        serializable = null;
        if (string != null) {
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(5), 0, 0, 0));
            serializable = new JLabel(string);
            ((JLabel)serializable).setHorizontalAlignment(0);
            ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(5), 0, this.getUIManager().getPixelsForDots(30), 0));
        } else {
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(5), 0, this.getUIManager().getPixelsForDots(30), 0));
        }
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel2.add((Component)object);
        if (serializable != null) {
            jPanel2.add((Component)serializable);
        }
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setOpaque(false);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(20), 0, this.getUIManager().getPixelsForDots(20), this.getUIManager().getPixelsForDots(20)));
        this.aboutTextArea = new JTextPane();
        this.aboutTextArea.setEditable(false);
        this.aboutTextArea.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(10), this.getUIManager().getPixelsForDots(10), this.getUIManager().getPixelsForDots(10), this.getUIManager().getPixelsForDots(10)));
        AboutBoxFrame.fillTextPane(this.aboutTextArea, ApplicationUtilities.getResourceAsString("/resources/about.txt"));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.aboutTextArea);
        jScrollPane.setPreferredSize(this.getApplication().getUIManager().getPixelsForDots(new Dimension(500, 400)));
        jScrollPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel3, "Center");
        this.add((Component)jPanel, "Center");
        JPanel jPanel4 = new JPanel(new VerticalFlowLayout(this.getUIManager().getPixelsForDots(5)));
        jPanel4.setOpaque(false);
        jPanel4.setBorder(null);
        this.visitWebpageButton = new JButton(this.getLocalizedString("window.AboutBoxFrame.button.visitWebsite"));
        this.visitWebpageButton.putClientProperty("JButton.buttonType", "gradient");
        this.visitWebpageButton.setFocusPainted(false);
        jPanel4.add(this.visitWebpageButton);
        this.sendFeedbackButton = new JButton(this.getLocalizedString("window.AboutBoxFrame.button.sendFeedback"));
        this.sendFeedbackButton.putClientProperty("JButton.buttonType", "gradient");
        this.sendFeedbackButton.setFocusPainted(false);
        jPanel4.add(this.sendFeedbackButton);
        JPanel jPanel5 = new JPanel();
        jPanel5.setOpaque(false);
        jPanel5.setPreferredSize(new Dimension(1, this.getUIManager().getPixelsForDots(60)));
        jPanel4.add(jPanel5);
        this.viewChangeButton = new JButton(this.getLocalizedString("window.AboutBoxFrame.button.viewLicence"));
        this.viewChangeButton.putClientProperty("JButton.buttonType", "gradient");
        this.viewChangeButton.setFocusPainted(false);
        jPanel4.add(this.viewChangeButton);
        jPanel2.add(jPanel4);
        this.aboutTextArea.setCaretPosition(0);
        this.addActionListeners();
        this.pack();
        this.getUIManager().setMenuItemEnabled(this, "menu.edit.copy", true);
        this.getUIManager().setMenuItemEnabled(this, "menu.edit.selectAll", true);
    }

    private void addActionListeners() {
        this.sendFeedbackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationUtilities.sendFeedback(AboutBoxFrame.this.getApplicationContext(), AboutBoxFrame.this.feedbackArticleID, false);
            }
        });
        this.visitWebpageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AboutBoxFrame.this.getApplication().openURL(AboutBoxFrame.this.getLocalizedString("window.AboutBoxFrame.url.homepageURL"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.viewChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AboutBoxFrame.this.isViewingEula) {
                    AboutBoxFrame.this.viewChangeButton.setText(AboutBoxFrame.this.getLocalizedString("window.AboutBoxFrame.button.viewLicence"));
                    AboutBoxFrame.fillTextPane(AboutBoxFrame.this.aboutTextArea, ApplicationUtilities.getResourceAsString("/resources/about.txt"));
                } else {
                    AboutBoxFrame.this.viewChangeButton.setText(AboutBoxFrame.this.getLocalizedString("window.AboutBoxFrame.button.viewAbout", AboutBoxFrame.this.getApplication().getApplicationName()));
                    String string = "/resources/licence_" + AboutBoxFrame.this.getLocalizedString("language") + ".txt";
                    if (this.getClass().getResource(string) == null) {
                        string = "/resources/licence_en.txt";
                    }
                    if (this.getClass().getResource(string) == null) {
                        string = "/resources/licence.txt";
                    }
                    AboutBoxFrame.fillTextPane(AboutBoxFrame.this.aboutTextArea, ApplicationUtilities.getResourceAsString(string));
                }
                AboutBoxFrame.this.isViewingEula = !AboutBoxFrame.this.isViewingEula;
                AboutBoxFrame.this.aboutTextArea.setCaretPosition(0);
            }
        });
        this.aboutTextArea.addMouseListener(new JExtendedMouseAdapter(this.getPlatform()){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Element element = ((StyledDocument)AboutBoxFrame.this.aboutTextArea.getDocument()).getCharacterElement(AboutBoxFrame.this.aboutTextArea.viewToModel(mouseEvent.getPoint()));
                AttributeSet attributeSet = element.getAttributes();
                AbstractAction abstractAction = (AbstractAction)attributeSet.getAttribute("linkAction");
                if (abstractAction != null) {
                    abstractAction.actionPerformed(null);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                AboutBoxFrame.this.pack();
                AboutBoxFrame.this.setResizable(false);
            }
        });
    }

    public void handleSelectAll() {
        this.aboutTextArea.setSelectionStart(0);
        this.aboutTextArea.setSelectionEnd(this.aboutTextArea.getText().length());
        this.aboutTextArea.requestFocus();
    }

    public static void fillTextPane(JTextPane jTextPane, String string) {
        jTextPane.setText("");
        jTextPane.setFont(Starter.getApplication().getUIManager().getFont(UIManager.FontSize.MEDIUM));
        StyledDocument styledDocument = (StyledDocument)jTextPane.getDocument();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet2, 1);
        StyleConstants.setSpaceBelow(simpleAttributeSet2, 7.0f);
        SimpleAttributeSet simpleAttributeSet3 = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet3, 0);
        StyleConstants.setSpaceAbove(simpleAttributeSet3, 0.0f);
        StyleConstants.setSpaceBelow(simpleAttributeSet3, 0.0f);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        final ArrayList<String> arrayList3 = new ArrayList<String>();
        int n = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
        if (n < 2019) {
            n = 2019;
        }
        String[] stringArray = string.replace("${year}", String.valueOf(n)).replace("${version}", String.valueOf(Starter.getApplication().getApplicationVersion())).replace("\r", "").split("\n");
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray) {
                SimpleAttributeSet simpleAttributeSet4;
                JPanel jPanel;
                while (string2.indexOf(60) != -1 && string2.indexOf(62) > string2.indexOf(60)) {
                    int n2 = string2.indexOf(60) + stringBuilder.length() + styledDocument.getLength();
                    arrayList.add(n2);
                    arrayList2.add(string2.indexOf(62) + stringBuilder.length() + styledDocument.getLength() - n2 - 1);
                    arrayList3.add(string2.substring(string2.indexOf(60) + 1, string2.indexOf(62)));
                    string2 = string2.substring(0, string2.indexOf(60)) + string2.substring(string2.indexOf(60) + 1, string2.indexOf(62)) + string2.substring(string2.indexOf(62) + 1);
                }
                if (string2.startsWith("-") && string2.endsWith("-")) {
                    if (stringBuilder.length() != 0) {
                        styledDocument.setParagraphAttributes(styledDocument.getLength(), stringBuilder.length(), simpleAttributeSet3, false);
                        styledDocument.insertString(styledDocument.getLength(), stringBuilder.toString(), simpleAttributeSet);
                        stringBuilder = new StringBuilder();
                    }
                    String string3 = string2.substring(2, string2.length() - 2);
                    styledDocument.setParagraphAttributes(styledDocument.getLength(), string3.length() + 1, simpleAttributeSet2, false);
                    JLabel jLabel = new JLabel(string3);
                    jLabel.setOpaque(false);
                    jLabel.setFont(Starter.getApplication().getUIManager().getFont(UIManager.FontSize.MEDIUM));
                    jPanel = new JPanel();
                    jPanel.setBackground(new Color(245, 245, 245));
                    jPanel.add(jLabel);
                    jPanel.setOpaque(true);
                    simpleAttributeSet4 = new SimpleAttributeSet();
                    StyleConstants.setComponent(simpleAttributeSet4, jPanel);
                    styledDocument.insertString(styledDocument.getLength(), string3 + "\n", simpleAttributeSet4);
                    continue;
                }
                if (string2.startsWith("\u00c2\u00a7")) {
                    if (stringBuilder.length() != 0) {
                        styledDocument.setParagraphAttributes(styledDocument.getLength(), stringBuilder.length(), simpleAttributeSet3, false);
                        styledDocument.insertString(styledDocument.getLength(), stringBuilder.toString(), simpleAttributeSet);
                        stringBuilder = new StringBuilder();
                    }
                    styledDocument.setParagraphAttributes(styledDocument.getLength(), string2.length() + 1, simpleAttributeSet2, false);
                    JLabel jLabel = new JLabel(string2);
                    jLabel.setOpaque(false);
                    jLabel.setFont(Starter.getApplication().getUIManager().getFont(UIManager.FontSize.MEDIUM));
                    jPanel = new JPanel();
                    jPanel.setBackground(new Color(245, 245, 245));
                    jPanel.add(jLabel);
                    jPanel.setOpaque(true);
                    jPanel.setLayout(new FlowLayout(3));
                    simpleAttributeSet4 = new SimpleAttributeSet();
                    StyleConstants.setComponent(simpleAttributeSet4, jPanel);
                    styledDocument.insertString(styledDocument.getLength(), string2 + "\n", simpleAttributeSet4);
                    continue;
                }
                stringBuilder.append(string2 + "\n");
            }
            if (stringBuilder.length() != 0) {
                styledDocument.setParagraphAttributes(styledDocument.getLength(), stringBuilder.length(), simpleAttributeSet3, false);
                styledDocument.insertString(styledDocument.getLength(), stringBuilder.toString(), simpleAttributeSet);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Style style = styledDocument.addStyle("regularBlue", StyleContext.getDefaultStyleContext().getStyle("default"));
                StyleConstants.setForeground(style, Color.BLUE);
                StyleConstants.setUnderline(style, true);
                StyleConstants.setFontFamily(style, jTextPane.getFont().getFamily());
                StyleConstants.setFontSize(style, jTextPane.getFont().getSize());
                final int n3 = i;
                style.addAttribute("linkAction", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            Desktop.getDesktop().browse(new URI((String)arrayList3.get(n3)));
                        }
                        catch (IOException | URISyntaxException exception) {
                            // empty catch block
                        }
                    }
                });
                styledDocument.setCharacterAttributes((Integer)arrayList.get(i), (Integer)arrayList2.get(i), style, false);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

