/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.util.ui.dialog;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.frame.AbstractApplicationWindow;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class UpdateInformationFrame<T extends ApplicationContext<?>>
extends AbstractApplicationWindow<T> {
    private JButton remindMeLaterButton;
    private JButton downloadButton;
    private String latestVersion;
    private String versionHistory;

    public UpdateInformationFrame(T t, String string, String string2) {
        super(t);
        this.setAllowEscapeToCloseWindow(true);
        this.latestVersion = string;
        this.versionHistory = string2;
        String string3 = null;
        switch (Starter.getApplication().getPlatform()) {
            case MACOS: {
                string3 = "update_dialog_icon_mac.png";
                break;
            }
            default: {
                string3 = "update_dialog_icon_win.png";
            }
        }
        this.initUI();
    }

    private void initUI() {
        this.setTitle(Starter.getApplication().getLocalizedString("window.UpdateInformationFrame.title"));
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addInformationText(jPanel, "North");
        this.addVersionHistory(jPanel, "Center");
        this.addDialogButtons(jPanel, "South");
        this.add((Component)jPanel, "Center");
        this.getRootPane().setDefaultButton(this.downloadButton);
        this.addActionListeners();
        this.setPreferredSize(new Dimension(640, 480));
        this.setMinimumSize(new Dimension(400, 300));
        this.pack();
    }

    private void addActionListeners() {
        this.remindMeLaterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateInformationFrame.this.dispose();
            }
        });
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Starter.getApplication().openURL(Starter.getApplication().getLocalizedString("window.UpdateInformationFrame.url.downloadsUrl"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                UpdateInformationFrame.this.dispose();
            }
        });
    }

    private void addInformationText(JPanel jPanel, String string) {
        JLabel jLabel = new JLabel(this.getLocalizedString("window.UpdateInformationFrame.label.updateAvailable", this.getApplication().getApplicationName(), this.latestVersion));
        jPanel.add((Component)jLabel, string);
    }

    private void addVersionHistory(JPanel jPanel, String string) {
        JList<String> jList = new JList<String>(new DefaultListModel());
        jList.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public boolean isSelectedIndex(int n) {
                return false;
            }

            @Override
            public boolean isSelectionEmpty() {
                return false;
            }
        });
        jList.setCellRenderer(new DefaultListCellRenderer(){
            private JLabel label;
            private final Font headerFont;
            private final Font entryFont;
            private final Icon newIcon;
            private final Icon improvedIcon;
            private final Icon fixedIcon;
            private final String newString;
            private final String improvedString;
            private final String fixedString;
            private final Border headerBorder;
            private final Border entryBorder;
            {
                this.headerFont = UpdateInformationFrame.this.getUIManager().getFont(UIManager.FontSize.DEFAULT);
                this.entryFont = UpdateInformationFrame.this.getUIManager().getFont(UIManager.FontSize.MEDIUM);
                this.newIcon = ImageBuilder.buildFor("/resources/version_history_new.png");
                this.improvedIcon = ImageBuilder.buildFor("/resources/version_history_improved.png");
                this.fixedIcon = ImageBuilder.buildFor("/resources/version_history_fixed.png");
                this.newString = Starter.getApplication().getLocalizedString("window.UpdateInformationFrame.label.new");
                this.improvedString = Starter.getApplication().getLocalizedString("window.UpdateInformationFrame.label.improved");
                this.fixedString = Starter.getApplication().getLocalizedString("window.UpdateInformationFrame.label.fixed");
                this.headerBorder = BorderFactory.createEmptyBorder(3, 3, 3, 1);
                this.entryBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            }

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                this.label = (JLabel)super.getListCellRendererComponent(jList, object, n, false, bl2);
                if (object != null) {
                    this.label.setFont(this.entryFont);
                    this.label.setBorder(this.entryBorder);
                    if (object.toString().startsWith("[new]")) {
                        this.label.setText(this.newString + ": " + object.toString().substring(5).trim());
                        this.label.setIcon(this.newIcon);
                    } else if (object.toString().startsWith("[improved]")) {
                        this.label.setText(this.improvedString + ": " + object.toString().substring(10).trim());
                        this.label.setIcon(this.improvedIcon);
                    } else if (object.toString().startsWith("[fixed]")) {
                        this.label.setText(this.fixedString + ": " + object.toString().substring(7).trim());
                        this.label.setIcon(this.fixedIcon);
                    } else {
                        this.label.setText(object.toString());
                        this.label.setFont(this.headerFont);
                        this.label.setBorder(this.headerBorder);
                    }
                }
                return this.label;
            }
        });
        this.fillHistoryList(jList, this.versionHistory);
        jList.setSelectedIndex(0);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jList);
        jPanel.add((Component)jScrollPane, string);
    }

    private void addDialogButtons(JPanel jPanel, String string) {
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        this.remindMeLaterButton = new JButton(Starter.getApplication().getLocalizedString("window.UpdateInformationFrame.button.remindMeLater"));
        this.downloadButton = new JButton(Starter.getApplication().getLocalizedString("window.UpdateInformationFrame.button.downloadNow"));
        jPanel2.add(this.remindMeLaterButton);
        jPanel2.add(this.downloadButton);
        jPanel.add((Component)jPanel2, string);
    }

    private void fillHistoryList(JList<String> jList, String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.replaceAll("\\r", "").split("\n")) {
            ((DefaultListModel)jList.getModel()).addElement(string2.trim());
        }
    }
}

