/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.util.ui.dialog;

import de.oliver_matuschin.base.Starter;
import de.oliver_matuschin.base.application.ApplicationContext;
import de.oliver_matuschin.base.constant.AppConstants;
import de.oliver_matuschin.base.ui.UIManager;
import de.oliver_matuschin.base.ui.event.JExtendedMouseAdapter;
import de.oliver_matuschin.base.ui.frame.AbstractApplicationWindow;
import de.oliver_matuschin.base.ui.imaging.ImageBuilder;
import de.oliver_matuschin.base.ui.layout.VerticalFlowLayout;
import de.oliver_matuschin.base.util.net.NetworkHandler;
import de.oliver_matuschin.base.util.ui.frame.AboutBoxFrame;
import de.oliver_matuschin.system.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;

public class FeedbackFrame<T extends ApplicationContext<?>>
extends AbstractApplicationWindow<T> {
    private JButton sendButton;
    private JButton cancelButton;
    private JCheckBox doNotAskAgainCheckBox;
    private JCheckBox acceptPrivacyPolicyCheckBox;
    private JTextPane commentTextPane;
    private JTextPane privacyProtectionTextPane;
    private JTextField usernameTextField;
    private JTextField webpageTextField;
    private JTextField emailTextField;
    private JLabel sendFeedbackAnimationLabel;
    private final int targetArticleId;

    public FeedbackFrame(T t, int n, boolean bl) {
        super(t);
        this.setAllowEscapeToCloseWindow(true);
        this.targetArticleId = n;
        if (this.getApplication().getPlatform() == Platform.WINDOWS) {
            ArrayList<Image> arrayList = new ArrayList<Image>();
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/feedback_window_icon_win_128x128.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/feedback_window_icon_win_64x64.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/feedback_window_icon_win_32x32.png")));
            arrayList.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/windowIcons/feedback_window_icon_win_16x16.png")));
            this.setIconImages(arrayList);
        }
        this.initUI(bl);
    }

    private void initUI(boolean bl) {
        this.setTitle(this.getLocalizedString("window.FeedbackFrame.title"));
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(10), this.getUIManager().getPixelsForDots(10), this.getUIManager().getPixelsForDots(10), this.getUIManager().getPixelsForDots(10)));
        jPanel.setBackground(AppConstants.DEFAULT_WINDOW_BACKGROUND_COLOR);
        jPanel.add(this.getInformationText(), "North");
        jPanel.add(this.getTextArea(), "Center");
        jPanel.add(this.getDialogButtons(bl), "South");
        this.add((Component)jPanel, "Center");
        this.getRootPane().setDefaultButton(this.sendButton);
        this.addActionListeners();
        this.setPreferredSize(new Dimension(430, 600));
        this.setMinimumSize(new Dimension(430, 600));
        this.setMaximumSize(new Dimension(800, 900));
        this.pack();
        this.validateButtonsAndMenus();
    }

    private void validateButtonsAndMenus() {
        this.getUIManager().setMenuItemEnabled(this, "menu.edit.cut", true);
        this.getUIManager().setMenuItemEnabled(this, "menu.edit.copy", true);
        this.getUIManager().setMenuItemEnabled(this, "menu.edit.paste", true);
        this.getUIManager().setMenuItemEnabled(this, "menu.edit.selectAll", true);
    }

    private void disableUI() {
        this.cancelButton.setEnabled(false);
        this.sendButton.setEnabled(false);
        if (this.doNotAskAgainCheckBox != null) {
            this.doNotAskAgainCheckBox.setEnabled(false);
        }
        this.commentTextPane.setEnabled(false);
        this.webpageTextField.setEnabled(false);
        this.emailTextField.setEnabled(false);
        this.usernameTextField.setEnabled(false);
        this.setDefaultCloseOperation(0);
    }

    private void enableUI() {
        this.cancelButton.setEnabled(true);
        this.sendButton.setEnabled(true);
        if (this.doNotAskAgainCheckBox != null) {
            this.doNotAskAgainCheckBox.setEnabled(true);
        }
        this.commentTextPane.setEnabled(true);
        this.webpageTextField.setEnabled(true);
        this.emailTextField.setEnabled(true);
        this.usernameTextField.setEnabled(true);
        this.setDefaultCloseOperation(2);
    }

    private void addActionListeners() {
        this.privacyProtectionTextPane.addMouseListener(new JExtendedMouseAdapter(this.getPlatform()){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Element element = ((StyledDocument)FeedbackFrame.this.privacyProtectionTextPane.getDocument()).getCharacterElement(FeedbackFrame.this.privacyProtectionTextPane.viewToModel(mouseEvent.getPoint()));
                AttributeSet attributeSet = element.getAttributes();
                AbstractAction abstractAction = (AbstractAction)attributeSet.getAttribute("linkAction");
                if (abstractAction != null) {
                    abstractAction.actionPerformed(null);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                FeedbackFrame.this.usernameTextField.requestFocus();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (FeedbackFrame.this.doNotAskAgainCheckBox != null && FeedbackFrame.this.doNotAskAgainCheckBox.isSelected()) {
                    Starter.getApplication().getPreferences().putBoolean("feedbackSent", true);
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FeedbackFrame.this.dispose();
            }
        });
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageIcon imageIcon = ImageBuilder.buildFor("/resources/_progress.gif");
                FeedbackFrame.this.disableUI();
                FeedbackFrame.this.sendFeedbackAnimationLabel.setIcon(imageIcon);
                imageIcon.setImageObserver(FeedbackFrame.this.sendFeedbackAnimationLabel);
                FeedbackFrame.this.sendFeedbackAnimationLabel.setSize(FeedbackFrame.this.getApplication().getUIManager().getPixelsForDots(new Dimension(16, 16)));
                String string = FeedbackFrame.this.usernameTextField.getText();
                String string2 = FeedbackFrame.this.emailTextField.getText();
                String string3 = FeedbackFrame.this.webpageTextField.getText();
                String string4 = FeedbackFrame.this.commentTextPane.getText();
                boolean bl = FeedbackFrame.this.acceptPrivacyPolicyCheckBox.isSelected();
                Runnable runnable = () -> {
                    try {
                        NetworkHandler.Result result = NetworkHandler.postFeedback(FeedbackFrame.this.targetArticleId, string, string2, string3, string4, bl);
                        EventQueue.invokeLater(() -> {
                            FeedbackFrame.this.sendFeedbackAnimationLabel.setIcon(null);
                            FeedbackFrame.this.enableUI();
                            if (result.getResultCode() == 0) {
                                Starter.getApplication().getPreferences().putBoolean("feedbackSent", true);
                                JOptionPane.showMessageDialog(FeedbackFrame.this, FeedbackFrame.this.getLocalizedString("window.FeedbackFrame.message.thanksForYourFeedback"));
                                FeedbackFrame.this.setVisible(false);
                                FeedbackFrame.this.dispose();
                            } else {
                                JOptionPane.showMessageDialog(FeedbackFrame.this, result.getResultDescription());
                            }
                        });
                    }
                    catch (IOException | ParserConfigurationException exception) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                FeedbackFrame.this.sendFeedbackAnimationLabel.setIcon(null);
                                FeedbackFrame.this.enableUI();
                                JOptionPane.showMessageDialog(FeedbackFrame.this, FeedbackFrame.this.getLocalizedString("window.FeedbackFrame.message.feedbackError"));
                            }
                        });
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setName("SubmitCommentThread");
                thread.start();
            }
        });
    }

    private Component getInformationText() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setHighlighter(null);
        jTextPane.setOpaque(false);
        jTextPane.setText(this.getLocalizedString("window.FeedbackFrame.message.feedbackMessage", this.getApplication().getApplicationName()));
        jTextPane.setBorder(BorderFactory.createEmptyBorder(0, 0, this.getUIManager().getPixelsForDots(10), 0));
        return jTextPane;
    }

    private Component getTextArea() {
        this.commentTextPane = new JTextPane();
        this.commentTextPane.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.commentTextPane);
        JTextField jTextField = new JTextField("");
        if (this.getApplication().getPlatform() == Platform.MACOS) {
            jScrollPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
            this.commentTextPane.setMargin(new Insets(jTextField.getInsets().top / 2 - 1, jTextField.getInsets().left / 2 - 1, jTextField.getInsets().bottom / 2 - -1, jTextField.getInsets().right / 2 - 1));
        } else {
            this.commentTextPane.setMargin(jTextField.getInsets());
        }
        JPanel jPanel = new JPanel(new BorderLayout(0, this.getUIManager().getPixelsForDots(10)));
        jPanel.setOpaque(false);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new VerticalFlowLayout());
        jPanel2.setOpaque(false);
        JPanel jPanel3 = new JPanel(new FlowLayout(3));
        jPanel3.setOpaque(false);
        JLabel jLabel = new JLabel(this.getLocalizedString("window.FeedbackFrame.label.yourName") + "*");
        jPanel3.add(jLabel);
        this.usernameTextField = new JTextField();
        jPanel3.add(this.usernameTextField);
        jLabel.setPreferredSize(new Dimension(this.getApplication().getUIManager().getPixelsForDots(100), jLabel.getPreferredSize().height));
        this.usernameTextField.setPreferredSize(new Dimension(this.getApplication().getUIManager().getPixelsForDots(250), this.usernameTextField.getPreferredSize().height));
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(3));
        jPanel4.setOpaque(false);
        jLabel = new JLabel(this.getLocalizedString("window.FeedbackFrame.label.yourMailAddress"));
        jPanel4.add(jLabel);
        this.emailTextField = new JTextField();
        jPanel4.add(this.emailTextField);
        jLabel.setPreferredSize(new Dimension(this.getApplication().getUIManager().getPixelsForDots(100), jLabel.getPreferredSize().height));
        this.emailTextField.setPreferredSize(new Dimension(this.getApplication().getUIManager().getPixelsForDots(250), this.emailTextField.getPreferredSize().height));
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(3));
        jPanel5.setOpaque(false);
        jLabel = new JLabel(this.getLocalizedString("window.FeedbackFrame.label.yourWebsite"));
        jPanel5.add(jLabel);
        this.webpageTextField = new JTextField();
        jPanel5.add(this.webpageTextField);
        jLabel.setPreferredSize(new Dimension(this.getApplication().getUIManager().getPixelsForDots(100), jLabel.getPreferredSize().height));
        this.webpageTextField.setPreferredSize(new Dimension(this.getApplication().getUIManager().getPixelsForDots(250), this.webpageTextField.getPreferredSize().height));
        jPanel2.add(jPanel5);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setOpaque(false);
        jPanel6.add((Component)jPanel, "Center");
        jPanel6.add(this.getPrivacyInformationPanel(), "South");
        return jPanel6;
    }

    private Component getPrivacyInformationPanel() {
        JPanel jPanel = new JPanel(new VerticalFlowLayout(false));
        jPanel.setOpaque(false);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(this.getLocalizedString("window.FeedbackFrame.message.fieldInformation"));
        jTextPane.setEditable(false);
        jTextPane.setHighlighter(null);
        jTextPane.setOpaque(false);
        jTextPane.setFont(this.getUIManager().getFont(UIManager.FontSize.MEDIUM));
        jTextPane.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(10), 0, this.getUIManager().getPixelsForDots(10), 0));
        jPanel.add(jTextPane);
        this.acceptPrivacyPolicyCheckBox = new JCheckBox(this.getLocalizedString("window.FeedbackFrame.button.acceptPrivacyPolicyButton"));
        this.acceptPrivacyPolicyCheckBox.setOpaque(false);
        jPanel.add(this.acceptPrivacyPolicyCheckBox);
        this.privacyProtectionTextPane = new JTextPane();
        this.privacyProtectionTextPane.setEditable(false);
        this.privacyProtectionTextPane.setOpaque(false);
        this.privacyProtectionTextPane.setBorder(BorderFactory.createEmptyBorder(this.getUIManager().getPixelsForDots(10), 0, this.getUIManager().getPixelsForDots(10), 0));
        AboutBoxFrame.fillTextPane(this.privacyProtectionTextPane, this.getLocalizedString("window.FeedbackFrame.message.privacyProtection"));
        jPanel.add(this.privacyProtectionTextPane);
        return jPanel;
    }

    private Component getDialogButtons(boolean bl) {
        JPanel jPanel;
        VerticalFlowLayout verticalFlowLayout = new VerticalFlowLayout(false);
        JPanel jPanel2 = new JPanel(verticalFlowLayout);
        jPanel2.setOpaque(false);
        if (bl) {
            jPanel = new JPanel(new FlowLayout(3, 0, 0));
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, this.getUIManager().getPixelsForDots(10), 0));
            this.doNotAskAgainCheckBox = new JCheckBox(this.getLocalizedString("window.FeedbackFrame.button.dontAskAgainButton"));
            this.doNotAskAgainCheckBox.setOpaque(false);
            jPanel.add(this.doNotAskAgainCheckBox);
            jPanel2.add(jPanel);
        }
        jPanel = new JPanel(new FlowLayout(4));
        jPanel.setOpaque(false);
        this.cancelButton = new JButton(this.getLocalizedString("common.button.cancel"));
        this.sendButton = new JButton(this.getLocalizedString("window.FeedbackFrame.button.send"));
        jPanel.add(this.cancelButton);
        jPanel.add(this.sendButton);
        this.sendFeedbackAnimationLabel = new JLabel();
        this.sendFeedbackAnimationLabel.setSize(this.getApplication().getUIManager().getPixelsForDots(20), this.getApplication().getUIManager().getPixelsForDots(20));
        this.sendFeedbackAnimationLabel.setPreferredSize(this.getApplication().getUIManager().getPixelsForDots(new Dimension(20, 20)));
        jPanel.add(this.sendFeedbackAnimationLabel);
        verticalFlowLayout.addLayoutComponent(null, jPanel);
        jPanel2.add(jPanel);
        return jPanel2;
    }
}

