/*
 * Decompiled with CFR 0.152.
 */
package de.oliver_matuschin.base.util.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;

public class RegistryUtil {
    private static final int REG_SUCCESS = 0;
    private static final int REG_NOTFOUND = 2;
    private static final int KEY_READ = 131097;
    private static final int REG_ACCESSDENIED = 5;
    private static final int KEY_ALL_ACCESS = 983103;
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final String CLASSES_ROOT = "HKEY_CLASSES_ROOT";
    private static final String CURRENT_USER = "HKEY_CURRENT_USER";
    private static final String LOCAL_MACHINE = "HKEY_LOCAL_MACHINE";
    private static Preferences userRoot = Preferences.userRoot();
    private static Preferences systemRoot = Preferences.systemRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static Method regCreateKeyEx = null;
    private static Method regSetValueEx = null;
    private static Method regDeleteKey = null;
    private static Method regDeleteValue = null;

    public static String valueForKey(int n, String string, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        if (n == -2147483646) {
            return RegistryUtil.valueForKey(systemRoot, n, string, string2);
        }
        if (n == -2147483647) {
            return RegistryUtil.valueForKey(userRoot, n, string, string2);
        }
        return RegistryUtil.valueForKey(null, n, string, string2);
    }

    public static Map<String, String> valuesForPath(int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        if (n == -2147483646) {
            return RegistryUtil.valuesForPath(systemRoot, n, string);
        }
        if (n == -2147483647) {
            return RegistryUtil.valuesForPath(userRoot, n, string);
        }
        return RegistryUtil.valuesForPath(null, n, string);
    }

    public static List<String> subKeysForPath(int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (n == -2147483646) {
            return RegistryUtil.subKeysForPath(systemRoot, n, string);
        }
        if (n == -2147483647) {
            return RegistryUtil.subKeysForPath(userRoot, n, string);
        }
        return RegistryUtil.subKeysForPath(null, n, string);
    }

    public static void createKey(int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] nArray;
        if (n == -2147483646) {
            nArray = RegistryUtil.createKey(systemRoot, n, string);
            regCloseKey.invoke((Object)systemRoot, new Integer(nArray[0]));
        } else if (n == -2147483647) {
            nArray = RegistryUtil.createKey(userRoot, n, string);
            regCloseKey.invoke((Object)userRoot, new Integer(nArray[0]));
        } else {
            throw new IllegalArgumentException("hkey=" + n);
        }
        if (nArray[1] != 0) {
            throw new IllegalArgumentException("rc=" + nArray[1] + "  key=" + string);
        }
    }

    public static void writeStringValue(int n, String string, String string2, String string3) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (n == -2147483646) {
            RegistryUtil.writeStringValue(systemRoot, n, string, string2, string3);
        } else if (n == -2147483647) {
            RegistryUtil.writeStringValue(userRoot, n, string, string2, string3);
        } else {
            throw new IllegalArgumentException("hkey=" + n);
        }
    }

    public static void deleteKey(int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int n2 = -1;
        if (n == -2147483646) {
            n2 = RegistryUtil.deleteKey(systemRoot, n, string);
        } else if (n == -2147483647) {
            n2 = RegistryUtil.deleteKey(userRoot, n, string);
        }
        if (n2 != 0) {
            throw new IllegalArgumentException("rc=" + n2 + "  key=" + string);
        }
    }

    public static void deleteValue(int n, String string, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int n2 = -1;
        if (n == -2147483646) {
            n2 = RegistryUtil.deleteValue(systemRoot, n, string, string2);
        } else if (n == -2147483647) {
            n2 = RegistryUtil.deleteValue(userRoot, n, string, string2);
        }
        if (n2 != 0) {
            throw new IllegalArgumentException("rc=" + n2 + "  key=" + string + "  value=" + string2);
        }
    }

    private static int deleteValue(Preferences preferences, int n, String string, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), RegistryUtil.toCstr(string), new Integer(983103));
        if (nArray[1] != 0) {
            return nArray[1];
        }
        int n2 = (Integer)regDeleteValue.invoke((Object)preferences, new Integer(nArray[0]), RegistryUtil.toCstr(string2));
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return n2;
    }

    private static int deleteKey(Preferences preferences, int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int n2 = (Integer)regDeleteKey.invoke((Object)preferences, new Integer(n), RegistryUtil.toCstr(string));
        return n2;
    }

    private static String valueForKey(Preferences preferences, int n, String string, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), RegistryUtil.toCstr(string), new Integer(131097));
        if (nArray[1] != 0) {
            throw new IllegalArgumentException("The system can not find the specified path: '" + RegistryUtil.getParentKey(n) + "\\" + string + "'");
        }
        byte[] byArray = (byte[])regQueryValueEx.invoke((Object)preferences, new Integer(nArray[0]), RegistryUtil.toCstr(string2));
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return byArray != null ? RegistryUtil.parseValue(byArray) : RegistryUtil.queryValueForKey(n, string, string2);
    }

    private static String queryValueForKey(int n, String string, String string2) throws IOException {
        return RegistryUtil.queryValuesForPath(n, string).get(string2);
    }

    private static Map<String, String> valuesForPath(Preferences preferences, int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), RegistryUtil.toCstr(string), new Integer(131097));
        if (nArray[1] != 0) {
            throw new IllegalArgumentException("The system can not find the specified path: '" + RegistryUtil.getParentKey(n) + "\\" + string + "'");
        }
        int[] nArray2 = (int[])regQueryInfoKey.invoke((Object)preferences, new Integer(nArray[0]));
        int n2 = nArray2[2];
        int n3 = nArray2[4];
        for (int i = 0; i < n2; ++i) {
            byte[] byArray = (byte[])regEnumValue.invoke((Object)preferences, new Integer(nArray[0]), new Integer(i), new Integer(n3 + 1));
            String string2 = RegistryUtil.parseValue(byArray);
            if (byArray == null || string2.isEmpty()) {
                return RegistryUtil.queryValuesForPath(n, string);
            }
            hashMap.put(string2, RegistryUtil.valueForKey(preferences, n, string, string2));
        }
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return hashMap;
    }

    public static String valueForKeyPath(int n, String string, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        String string3;
        try {
            string3 = RegistryUtil.valuesForKeyPath(n, string, string2).get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("The system can not find the key: '" + string2 + "' after " + "searching the specified path: '" + RegistryUtil.getParentKey(n) + "\\" + string + "'");
        }
        return string3;
    }

    public static List<String> valuesForKeyPath(int n, String string, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n == -2147483646) {
            return RegistryUtil.valuesForKeyPath(systemRoot, n, string, string2, arrayList);
        }
        if (n == -2147483647) {
            return RegistryUtil.valuesForKeyPath(userRoot, n, string, string2, arrayList);
        }
        return RegistryUtil.valuesForKeyPath(null, n, string, string2, arrayList);
    }

    private static List<String> valuesForKeyPath(Preferences preferences, int n, String string, String string2, List<String> list) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        if (!RegistryUtil.isDirectory(preferences, n, string)) {
            RegistryUtil.takeValueInListForKey(n, string, string2, list);
        } else {
            List<String> list2 = RegistryUtil.subKeysForPath(preferences, n, string);
            for (String string3 : list2) {
                String string4 = string + "\\" + string3;
                if (RegistryUtil.isDirectory(preferences, n, string4)) {
                    RegistryUtil.valuesForKeyPath(preferences, n, string4, string2, list);
                }
                RegistryUtil.takeValueInListForKey(n, string4, string2, list);
            }
        }
        return list;
    }

    private static void takeValueInListForKey(int n, String string, String string2, List<String> list) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        String string3 = RegistryUtil.valueForKey(n, string, string2);
        if (string3 != null) {
            list.add(string3);
        }
    }

    private static boolean isDirectory(Preferences preferences, int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return !RegistryUtil.subKeysForPath(preferences, n, string).isEmpty();
    }

    private static List<String> subKeysForPath(Preferences preferences, int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), RegistryUtil.toCstr(string), new Integer(131097));
        if (nArray[1] != 0) {
            throw new IllegalArgumentException("The system can not find the specified path: '" + RegistryUtil.getParentKey(n) + "\\" + string + "'");
        }
        int[] nArray2 = (int[])regQueryInfoKey.invoke((Object)preferences, new Integer(nArray[0]));
        int n2 = nArray2[0];
        int n3 = nArray2[3];
        for (int i = 0; i < n2; ++i) {
            byte[] byArray = (byte[])regEnumKeyEx.invoke((Object)preferences, new Integer(nArray[0]), new Integer(i), new Integer(n3 + 1));
            arrayList.add(RegistryUtil.parseValue(byArray));
        }
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return arrayList;
    }

    private static int[] createKey(Preferences preferences, int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (int[])regCreateKeyEx.invoke((Object)preferences, new Integer(n), RegistryUtil.toCstr(string));
    }

    private static void writeStringValue(Preferences preferences, int n, String string, String string2, String string3) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), RegistryUtil.toCstr(string), new Integer(983103));
        regSetValueEx.invoke((Object)preferences, new Integer(nArray[0]), RegistryUtil.toCstr(string2), RegistryUtil.toCstr(string3));
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
    }

    private static Map<String, String> queryValuesForPath(int n, String string) throws IOException {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Process process = Runtime.getRuntime().exec("reg query \"" + RegistryUtil.getParentKey(n) + "\\" + string + "\"");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray;
            if (!string2.contains("REG_")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
            while (stringTokenizer.hasMoreTokens()) {
                stringArray = stringTokenizer.nextToken();
                if (stringArray.startsWith("REG_")) {
                    stringBuilder.append("\t ");
                    continue;
                }
                stringBuilder.append((String)stringArray).append(" ");
            }
            stringArray = stringBuilder.toString().split("\t");
            hashMap.put(stringArray[0].trim(), stringArray[1].trim());
            stringBuilder.setLength(0);
        }
        return hashMap;
    }

    private static String getParentKey(int n) {
        if (n == Integer.MIN_VALUE) {
            return CLASSES_ROOT;
        }
        if (n == -2147483647) {
            return CURRENT_USER;
        }
        if (n == -2147483646) {
            return LOCAL_MACHINE;
        }
        return null;
    }

    private static byte[] toCstr(String string) {
        if (string == null) {
            string = "";
        }
        string = string + "\u0000";
        return string.getBytes();
    }

    private static String parseValue(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = new String(byArray);
        if (string.charAt(string.length() - 1) == '\u0000') {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
            regCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Integer.TYPE, byte[].class);
            regCreateKeyEx.setAccessible(true);
            regSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", Integer.TYPE, byte[].class, byte[].class);
            regSetValueEx.setAccessible(true);
            regDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", Integer.TYPE, byte[].class);
            regDeleteValue.setAccessible(true);
            regDeleteKey = userClass.getDeclaredMethod("WindowsRegDeleteKey", Integer.TYPE, byte[].class);
            regDeleteKey.setAccessible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

